/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.forms;

import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.rcp.model.forms.FormPageInfo;
import org.eclipse.wb.internal.rcp.model.forms.ManagedFormInfo;
import org.eclipse.wb.internal.rcp.model.forms.ScrolledFormInfo;
import org.eclipse.wb.tests.designer.rcp.model.forms.AbstractFormsTest;
import org.junit.Test;

public class FormPageTest
extends AbstractFormsTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_0() throws Exception {
        FormPageInfo page = (FormPageInfo)this.parseJavaInfo("import org.eclipse.ui.forms.editor.*;", "public class Test extends FormPage {", "  /**", "  * @wbp.eval.method.parameter id 'Some id'", "  * @wbp.eval.method.parameter title 'Some title'", "  */", "  public Test(FormEditor editor, String id, String title) {", "    super(editor, id, title);", "  }", "  protected void createFormContent(IManagedForm managedForm) {", "    FormToolkit toolkit = managedForm.getToolkit();", "    ScrolledForm form = managedForm.getForm();", "    form.setText('Empty FormPage');", "  }", "}");
        FormPageTest.assertHierarchy("{this: org.eclipse.ui.forms.editor.FormPage} {this} {}", "  {parameter} {managedForm} {/managedForm.getToolkit()/ /managedForm.getForm()/}", "    {method: public org.eclipse.ui.forms.widgets.ScrolledForm org.eclipse.ui.forms.ManagedForm.getForm()} {property} {/managedForm.getForm()/ /form.setText('Empty FormPage')/}", "      {method: public org.eclipse.swt.widgets.Composite org.eclipse.ui.forms.widgets.ScrolledForm.getBody()} {property} {}", "        {implicit-layout: absolute} {implicit-layout} {}", "    {method: public org.eclipse.ui.forms.widgets.FormToolkit org.eclipse.ui.forms.ManagedForm.getToolkit()} {property} {/managedForm.getToolkit()/}", "  {instance factory container}", "    {method: public org.eclipse.ui.forms.widgets.FormToolkit org.eclipse.ui.forms.ManagedForm.getToolkit()} {property} {/managedForm.getToolkit()/}");
        ManagedFormInfo managedForm = (ManagedFormInfo)page.getChildrenJava().get(0);
        ScrolledFormInfo scrolledForm = (ScrolledFormInfo)managedForm.getChildrenJava().get(0);
        page.refresh();
        FormPageTest.assertEquals((long)page.getBounds().width, (long)600L);
        FormPageTest.assertEquals((long)page.getBounds().height, (long)500L);
        Assertions.assertThat((int)scrolledForm.getBounds().width).isGreaterThanOrEqualTo(590);
        Assertions.assertThat((int)scrolledForm.getBounds().height).isGreaterThanOrEqualTo(450);
    }

    @Test
    public void test_severalConstructors() throws Exception {
        FormPageTest.useStrictEvaluationMode(false);
        FormPageInfo page = (FormPageInfo)this.parseJavaInfo("import org.eclipse.ui.forms.editor.*;", "public class Test extends FormPage {", "  public Test(String id, String title) {", "    super(id, title);", "  }", "  public Test(FormEditor editor, String id, String title) {", "    super(editor, id, title);", "  }", "  protected void createFormContent(IManagedForm managedForm) {", "    ScrolledForm form = managedForm.getForm();", "  }", "}");
        page.refresh();
        FormPageTest.assertNoErrors((JavaInfo)page);
    }

    @Test
    public void test_subclassFormEditor() throws Exception {
        FormPageTest.setFileContentSrc("test/MyFormEditor.java", this.getTestSource("import org.eclipse.ui.forms.editor.*;", "public abstract class MyFormEditor extends FormEditor {", "  public MyFormEditor() {", "  }", "}"));
        FormPageTest.setFileContentSrc("test/MyFormPage.java", this.getTestSource("import org.eclipse.ui.forms.editor.*;", "public abstract class MyFormPage extends FormPage {", "  public MyFormPage(MyFormEditor editor) {", "    super(editor, 'id', 'title');", "  }", "}"));
        FormPageTest.waitForAutoBuild();
        FormPageInfo page = (FormPageInfo)this.parseJavaInfo("import org.eclipse.ui.forms.editor.*;", "public class Test extends MyFormPage {", "  public Test(MyFormEditor editor) {", "    super(editor);", "  }", "  protected void createFormContent(IManagedForm managedForm) {", "    ScrolledForm form = managedForm.getForm();", "  }", "}");
        page.refresh();
        FormPageTest.assertNoErrors((JavaInfo)page);
    }
}

