/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.ui.MenuIntersector;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.eclipse.wb.tests.designer.Expectations;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Ignore;
import org.junit.Test;

public class SurroundSupportTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_emptySelection() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        SurroundSupportTest.assertNoSurroundManager((ObjectInfo)panel, Collections.emptyList());
    }

    @Test
    public void test_notComponent() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        LayoutInfo layout = panel.getLayout();
        SurroundSupportTest.assertNoSurroundManager((ObjectInfo)panel, List.of(layout));
    }

    @Test
    public void test_notSameParent() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "      button.setBounds(10, 20, 100, 50);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SurroundSupportTest.assertNoSurroundManager((ObjectInfo)panel, List.of(panel, button));
    }

    @Test
    public void test_flow_singleComponent() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SurroundSupportTest.runSurround_JPanel(new ObjectInfo[]{button});
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      {", "        JButton button = new JButton();", "        panel.add(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_flow_singleComponent_onTitledJPanel() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SurroundSupportTest.runSurround("javax.swing.JPanel (border)", new ObjectInfo[]{button});
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      panel.setBorder(new TitledBorder(null, 'JPanel title', TitledBorder.LEADING, TitledBorder.TOP, null, null));", "      add(panel);", "      {", "        JButton button = new JButton();", "        panel.add(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_flow_twoComponents() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "    {", "      JButton button_3 = new JButton();", "      add(button_3);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        SurroundSupportTest.runSurround_JPanel(new ObjectInfo[]{button_1, button_2});
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      {", "        JButton button_1 = new JButton();", "        panel.add(button_1);", "      }", "      {", "        JButton button_2 = new JButton();", "        panel.add(button_2);", "      }", "    }", "    {", "      JButton button_3 = new JButton();", "      add(button_3);", "    }", "  }", "}");
    }

    @Test
    public void test_flow_notAdjacentComponents() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "    {", "      JButton button_3 = new JButton();", "      add(button_3);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_3 = (ComponentInfo)panel.getChildrenComponents().get(2);
        SurroundSupportTest.assertNoSurroundManager((ObjectInfo)button_3, List.of(button_1, button_3));
    }

    @Test
    public void test_absolute_singleControl() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton();", "      add(button);", "      button.setBounds(10, 20, 100, 50);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SurroundSupportTest.assertNotNull((Object)button.getPropertyByTitle("Bounds"));
        SurroundSupportTest.runSurround_JPanel(new ObjectInfo[]{button});
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      JPanel panel = new JPanel();", "      panel.setBounds(10, 20, 100, 50);", "      add(panel);", "      panel.setLayout(null);", "      {", "        JButton button = new JButton();", "        button.setBounds(0, 0, 100, 50);", "        panel.add(button);", "      }", "    }", "  }", "}");
        SurroundSupportTest.assertNotNull((Object)button.getPropertyByTitle("Bounds"));
    }

    @Ignore
    @Test
    public void test_absolute_singleControl_onTitledJPanel() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton();", "      add(button);", "      button.setBounds(50, 50, 100, 50);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SurroundSupportTest.runSurround("javax.swing.JPanel (border)", new ObjectInfo[]{button});
        String expectedPanelBounds = Expectations.get("44, 28, 112, 79", new Expectations.StrValue("flanker-windows", "44, 30, 112, 77"), new Expectations.StrValue("scheglov-win", "44, 30, 112, 77"));
        String expectedButtonBounds = Expectations.get("6, 22, 100, 50", new Expectations.StrValue("flanker-windows", "6, 20, 100, 50"), new Expectations.StrValue("scheglov-win", "6, 20, 100, 50"));
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      JPanel panel = new JPanel();", "      panel.setBorder(new TitledBorder(null, 'JPanel title', TitledBorder.LEADING, TitledBorder.TOP, null, null));", "      panel.setBounds(" + expectedPanelBounds + ");", "      add(panel);", "      panel.setLayout(null);", "      {", "        JButton button = new JButton();", "        button.setBounds(" + expectedButtonBounds + ");", "        panel.add(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_absolute_twoControls() throws Exception {
        ContainerInfo shell = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "      button_1.setBounds(150, 50, 100, 20);", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "      button_2.setBounds(10, 10, 100, 20);", "    }", "    {", "      JButton button_3 = new JButton();", "      add(button_3);", "      button_3.setBounds(160, 100, 110, 50);", "    }", "  }", "}");
        shell.refresh();
        ComponentInfo button_1 = (ComponentInfo)shell.getChildrenComponents().get(0);
        ComponentInfo button_3 = (ComponentInfo)shell.getChildrenComponents().get(2);
        SurroundSupportTest.runSurround_JPanel(new ObjectInfo[]{button_1, button_3});
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      JPanel panel = new JPanel();", "      panel.setBounds(150, 50, 120, 100);", "      add(panel);", "      panel.setLayout(null);", "      {", "        JButton button_1 = new JButton();", "        button_1.setBounds(0, 0, 100, 20);", "        panel.add(button_1);", "      }", "      {", "        JButton button_3 = new JButton();", "        button_3.setBounds(10, 50, 110, 50);", "        panel.add(button_3);", "      }", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "      button_2.setBounds(10, 10, 100, 20);", "    }", "  }", "}");
    }

    @Test
    public void test_JSplitPane_oneComponent() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        SurroundSupportTest.runSurround("javax.swing.JSplitPane", new ObjectInfo[]{button_1});
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JSplitPane splitPane = new JSplitPane();", "      add(splitPane);", "      {", "        JButton button_1 = new JButton();", "        splitPane.setLeftComponent(button_1);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_JSplitPane_twoComponents() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        SurroundSupportTest.runSurround("javax.swing.JSplitPane", new ObjectInfo[]{button_1, button_2});
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JSplitPane splitPane = new JSplitPane();", "      add(splitPane);", "      {", "        JButton button_1 = new JButton();", "        splitPane.setLeftComponent(button_1);", "      }", "      {", "        JButton button_2 = new JButton();", "        splitPane.setRightComponent(button_2);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_JSplitPane_threeComponents() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "    {", "      JButton button_3 = new JButton();", "      add(button_3);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        ComponentInfo button_3 = (ComponentInfo)panel.getChildrenComponents().get(2);
        SurroundSupportTest.assertNoSurroundAction("javax.swing.JSplitPane", new ObjectInfo[]{button_1, button_2, button_3});
    }

    @Test
    public void test_JScrollPane_oneComponent() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        SurroundSupportTest.runSurround("javax.swing.JScrollPane", new ObjectInfo[]{button_1});
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JScrollPane scrollPane = new JScrollPane();", "      add(scrollPane);", "      {", "        JButton button_1 = new JButton();", "        scrollPane.setViewportView(button_1);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_JScrollPane_twoComponents() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        SurroundSupportTest.runSurround("javax.swing.JScrollPane", new ObjectInfo[]{button_1, button_2});
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JScrollPane scrollPane = new JScrollPane();", "      add(scrollPane);", "      {", "        JPanel panel = new JPanel();", "        scrollPane.setViewportView(panel);", "        {", "          JButton button_1 = new JButton();", "          panel.add(button_1);", "        }", "        {", "          JButton button_2 = new JButton();", "          panel.add(button_2);", "        }", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_JTabbedPane_twoComponents() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        SurroundSupportTest.runSurround("javax.swing.JTabbedPane", new ObjectInfo[]{button_1, button_2});
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JTabbedPane tabbedPane = new JTabbedPane(JTabbedPane.TOP);", "      add(tabbedPane);", "      {", "        JButton button_1 = new JButton();", "        tabbedPane.addTab('New tab', null, button_1, null);", "      }", "      {", "        JButton button_2 = new JButton();", "        tabbedPane.addTab('New tab', null, button_2, null);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_FormLayout_0() throws Exception {
        ContainerInfo panel = this.parseTestSourceJGFL(new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JButton button_22 = new JButton();", "      add(button_22, \"2, 2\");", "    }", "    {", "      JButton button_BAD = new JButton();", "      add(button_BAD, \"4, 2\");", "    }", "    {", "      JButton button_44 = new JButton();", "      add(button_44, \"4, 4\");", "    }", "  }", "}"});
        panel.refresh();
        ComponentInfo button_22 = SurroundSupportTest.getButtons(panel).get(0);
        ComponentInfo button_44 = SurroundSupportTest.getButtons(panel).get(2);
        SurroundSupportTest.assertNoSurroundManager((ObjectInfo)panel, List.of(button_22, button_44));
    }

    @Test
    public void test_FormLayout_1() throws Exception {
        ContainerInfo panel = this.parseTestSourceJGFL(new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JTable table = new JTable();", "      add(table, \"1, 1\");", "    }", "  }", "}"});
        panel.refresh();
        ComponentInfo table = (ComponentInfo)panel.getChildrenComponents().get(0);
        SurroundSupportTest.runSurround("javax.swing.JScrollPane", new ObjectInfo[]{table});
        SurroundSupportTest.assertEditor(this.getTestSourceJGFL("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JScrollPane scrollPane = new JScrollPane();", "      add(scrollPane, \"1, 1, fill, fill\");", "      {", "        JTable table = new JTable();", "        scrollPane.setViewportView(table);", "      }", "    }", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_FormLayout_2() throws Exception {
        ContainerInfo panel = this.parseTestSourceJGFL(new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.UNRELATED_GAP_COLSPEC,", "        FormSpecs.PREF_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JButton button_22 = new JButton();", "      add(button_22, \"2, 2\");", "    }", "    {", "      JButton button_42 = new JButton();", "      add(button_42, \"4, 2\");", "    }", "  }", "}"});
        panel.refresh();
        ComponentInfo button_22 = SurroundSupportTest.getButtons(panel).get(0);
        ComponentInfo button_42 = SurroundSupportTest.getButtons(panel).get(1);
        SurroundSupportTest.runSurround_JPanel(new ObjectInfo[]{button_22, button_42});
        SurroundSupportTest.assertEditor(this.getTestSourceJGFL("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JPanel panel = new JPanel();", "      add(panel, \"2, 2, fill, fill\");", "      panel.setLayout(new FormLayout(new ColumnSpec[] {", "          FormSpecs.DEFAULT_COLSPEC,", "          FormSpecs.UNRELATED_GAP_COLSPEC,", "          FormSpecs.PREF_COLSPEC,},", "        new RowSpec[] {", "          FormSpecs.DEFAULT_ROWSPEC,}));", "      {", "        JButton button_22 = new JButton();", "        panel.add(button_22, \"1, 1\");", "      }", "      {", "        JButton button_42 = new JButton();", "        panel.add(button_42, \"3, 1\");", "      }", "    }", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_FormLayout_3() throws Exception {
        ContainerInfo panel = this.parseTestSourceJGFL(new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.UNRELATED_GAP_COLSPEC,", "        FormSpecs.PREF_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.UNRELATED_GAP_ROWSPEC,", "        FormSpecs.PREF_ROWSPEC,}));", "    {", "      JButton button_22 = new JButton();", "      add(button_22, \"2, 2\");", "    }", "    {", "      JButton button_44 = new JButton();", "      add(button_44, \"4, 4\");", "    }", "  }", "}"});
        panel.refresh();
        ComponentInfo button_22 = SurroundSupportTest.getButtons(panel).get(0);
        ComponentInfo button_44 = SurroundSupportTest.getButtons(panel).get(1);
        SurroundSupportTest.runSurround_JPanel(new ObjectInfo[]{button_22, button_44});
        SurroundSupportTest.assertEditor(this.getTestSourceJGFL("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JPanel panel = new JPanel();", "      add(panel, \"2, 2, fill, fill\");", "      panel.setLayout(new FormLayout(new ColumnSpec[] {", "          FormSpecs.DEFAULT_COLSPEC,", "          FormSpecs.UNRELATED_GAP_COLSPEC,", "          FormSpecs.PREF_COLSPEC,},", "        new RowSpec[] {", "          FormSpecs.DEFAULT_ROWSPEC,", "          FormSpecs.UNRELATED_GAP_ROWSPEC,", "          FormSpecs.PREF_ROWSPEC,}));", "      {", "        JButton button_22 = new JButton();", "        panel.add(button_22, \"1, 1\");", "      }", "      {", "        JButton button_44 = new JButton();", "        panel.add(button_44, \"3, 3\");", "      }", "    }", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_FormLayout_4() throws Exception {
        ContainerInfo panel = this.parseTestSourceJGFL(new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.UNRELATED_GAP_COLSPEC,", "        FormSpecs.PREF_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.UNRELATED_GAP_ROWSPEC,", "        FormSpecs.PREF_ROWSPEC,}));", "    {", "      JButton button_22 = new JButton();", "      add(button_22, \"2, 2\");", "    }", "    {", "      JButton button_42 = new JButton();", "      add(button_42, \"4, 2\");", "    }", "    {", "      JButton button_24 = new JButton();", "      add(button_24, \"2, 4, 3, 1, fill, bottom\");", "    }", "  }", "}"});
        panel.refresh();
        ComponentInfo button_22 = SurroundSupportTest.getButtons(panel).get(0);
        ComponentInfo button_42 = SurroundSupportTest.getButtons(panel).get(1);
        ComponentInfo button_24 = SurroundSupportTest.getButtons(panel).get(2);
        SurroundSupportTest.runSurround_JPanel(new ObjectInfo[]{button_22, button_42, button_24});
        SurroundSupportTest.assertEditor(this.getTestSourceJGFL("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JPanel panel = new JPanel();", "      add(panel, \"2, 2, fill, fill\");", "      panel.setLayout(new FormLayout(new ColumnSpec[] {", "          FormSpecs.DEFAULT_COLSPEC,", "          FormSpecs.UNRELATED_GAP_COLSPEC,", "          FormSpecs.PREF_COLSPEC,},", "        new RowSpec[] {", "          FormSpecs.DEFAULT_ROWSPEC,", "          FormSpecs.UNRELATED_GAP_ROWSPEC,", "          FormSpecs.PREF_ROWSPEC,}));", "      {", "        JButton button_22 = new JButton();", "        panel.add(button_22, \"1, 1\");", "      }", "      {", "        JButton button_42 = new JButton();", "        panel.add(button_42, \"3, 1\");", "      }", "      {", "        JButton button_24 = new JButton();", "        panel.add(button_24, \"1, 3, 3, 1, fill, bottom\");", "      }", "    }", "  }", "}"), this.m_lastEditor);
    }

    private String getTestSourceJGFL(String ... lines) throws Exception {
        lines = CodeUtils.join((String[])new String[]{"import com.jgoodies.forms.layout.*;", "import com.jgoodies.forms.factories.*;"}, (String[])lines);
        return this.getTestSource(lines);
    }

    private ContainerInfo parseTestSourceJGFL(String[] lines) throws Exception {
        m_testProject.addPlugin("com.jgoodies.common");
        m_testProject.addPlugin("com.jgoodies.forms");
        lines = CodeUtils.join((String[])new String[]{"import com.jgoodies.forms.layout.*;", "import com.jgoodies.forms.factories.*;"}, (String[])lines);
        return this.parseContainer(lines);
    }

    private static List<ComponentInfo> getButtons(ContainerInfo parent) {
        ArrayList<ComponentInfo> buttons = new ArrayList<ComponentInfo>();
        for (ComponentInfo control : parent.getChildrenComponents()) {
            if (!control.getDescription().getComponentClass().getName().equals("javax.swing.JButton")) continue;
            buttons.add(control);
        }
        return buttons;
    }

    private static IMenuManager createSurroundManager(ObjectInfo object, List<? extends ObjectInfo> objects) throws Exception {
        MenuManager resultMenuManager;
        if (objects.size() < 2) {
            resultMenuManager = SurroundSupportTest.getDesignerMenuManager();
            object.getBroadcastObject().addContextMenu(objects, object, (IMenuManager)resultMenuManager);
        } else {
            resultMenuManager = new MenuManager();
            ArrayList<MenuManager> managers = new ArrayList<MenuManager>();
            for (ObjectInfo objectInfo : objects) {
                MenuManager manager = SurroundSupportTest.getDesignerMenuManager();
                object.getBroadcastObject().addContextMenu(objects, objectInfo, (IMenuManager)manager);
                managers.add(manager);
            }
            MenuIntersector.merge((IMenuManager)resultMenuManager, managers);
        }
        return SurroundSupportTest.findChildMenuManager((IContributionManager)resultMenuManager, "Surround with");
    }

    private static IAction getSurroundAction(String actionText, ObjectInfo ... objects) throws Exception {
        SurroundSupportTest.assertFalse((objects.length == 0 ? 1 : 0) != 0);
        IMenuManager surroundManager = SurroundSupportTest.createSurroundManager(objects[0], List.of(objects));
        SurroundSupportTest.assertNotNull((Object)surroundManager);
        return SurroundSupportTest.findChildAction((IContributionManager)surroundManager, actionText);
    }

    public static void assertNoSurroundManager(ObjectInfo object, List<? extends ObjectInfo> objects) throws Exception {
        IMenuManager surroundManager = SurroundSupportTest.createSurroundManager(object, objects);
        SurroundSupportTest.assertNull((Object)surroundManager);
    }

    private static void assertNoSurroundAction(String actionText, ObjectInfo ... objects) throws Exception {
        IAction surroundAction = SurroundSupportTest.getSurroundAction(actionText, objects);
        SurroundSupportTest.assertNull((Object)surroundAction);
    }

    public static void runSurround(String actionText, ObjectInfo ... objects) throws Exception {
        IAction surroundAction = SurroundSupportTest.getSurroundAction(actionText, objects);
        SurroundSupportTest.assertNotNull((Object)surroundAction);
        surroundAction.run();
    }

    public static void runSurround_JPanel(ObjectInfo ... objects) throws Exception {
        SurroundSupportTest.runSurround("javax.swing.JPanel", objects);
    }
}

