/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.layouts.grid;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.editor.constants.CoreImages;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.swt.model.layout.grid.GridDataInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class GridDataTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_modernHorizontalAlignment() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData(-1, -1, false, false);", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}");
        shell.refresh();
        shell.startEdit();
        this.check_modernHorizontalAlignment(shell, 16384, 16384, "SWT.LEFT");
        this.check_modernHorizontalAlignment(shell, 1, 16384, "SWT.LEFT");
        this.check_modernHorizontalAlignment(shell, 1, 16384, "SWT.LEFT");
        this.check_modernHorizontalAlignment(shell, 0x1000000, 0x1000000, "SWT.CENTER");
        this.check_modernHorizontalAlignment(shell, 2, 0x1000000, "SWT.CENTER");
        this.check_modernHorizontalAlignment(shell, 131072, 131072, "SWT.RIGHT");
        this.check_modernHorizontalAlignment(shell, 0x1000008, 131072, "SWT.RIGHT");
        this.check_modernHorizontalAlignment(shell, 3, 131072, "SWT.RIGHT");
        this.check_modernHorizontalAlignment(shell, 4, 4, "SWT.FILL");
        this.check_modernHorizontalAlignment(shell, 4, 4, "SWT.FILL");
    }

    @Test
    public void test_modernVerticalAlignment() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData(-1, -1, false, false);", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}");
        shell.refresh();
        shell.startEdit();
        this.check_modernVerticalAlignment(shell, 128, 128, "SWT.TOP");
        this.check_modernVerticalAlignment(shell, 1, 128, "SWT.TOP");
        this.check_modernVerticalAlignment(shell, 1, 128, "SWT.TOP");
        this.check_modernVerticalAlignment(shell, 0x1000000, 0x1000000, "SWT.CENTER");
        this.check_modernVerticalAlignment(shell, 2, 0x1000000, "SWT.CENTER");
        this.check_modernVerticalAlignment(shell, 1024, 1024, "SWT.BOTTOM");
        this.check_modernVerticalAlignment(shell, 0x1000008, 1024, "SWT.BOTTOM");
        this.check_modernVerticalAlignment(shell, 3, 1024, "SWT.BOTTOM");
        this.check_modernVerticalAlignment(shell, 4, 4, "SWT.FILL");
        this.check_modernVerticalAlignment(shell, 4, 4, "SWT.FILL");
    }

    private void check_modernHorizontalAlignment(CompositeInfo shell, int horizontalAlignment, int horizontalAlignmentEx, String horizontalSourceEx) throws Exception {
        this.check_modernAlignments(shell, horizontalAlignment, horizontalAlignmentEx, horizontalSourceEx, 128, 128, "SWT.TOP");
    }

    private void check_modernVerticalAlignment(CompositeInfo shell, int verticalAlignment, int verticalAlignmentEx, String verticalSourceEx) throws Exception {
        this.check_modernAlignments(shell, 16384, 16384, "SWT.LEFT", verticalAlignment, verticalAlignmentEx, verticalSourceEx);
    }

    private void check_modernAlignments(CompositeInfo shell, int horizontalAlignment, int horizontalAlignmentEx, String horizontalSourceEx, int verticalAlignment, int verticalAlignmentEx, String verticalSourceEx) throws Exception {
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        gridData.setHorizontalAlignment(horizontalAlignment);
        gridData.setVerticalAlignment(verticalAlignment);
        GridDataTest.assertEquals((long)horizontalAlignmentEx, (long)gridData.getHorizontalAlignment());
        GridDataTest.assertEquals((long)verticalAlignmentEx, (long)gridData.getVerticalAlignment());
        String gridDataSource = this.m_lastEditor.getSource(gridData.getCreationSupport().getNode());
        GridDataTest.assertEquals((Object)String.format("new GridData(%s, %s, false, false)", horizontalSourceEx, verticalSourceEx), (Object)gridDataSource);
    }

    @Test
    public void test_setHorizontalAlignment() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        gridData.setHorizontalAlignment(16384);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_setVerticalAlignment() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        gridData.setVerticalAlignment(0x1000000);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_getSmallAlignmentImage() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        shell.refresh();
        try {
            GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
            GridDataTest.check_getSmallAlignmentImage(gridData, true, new int[]{16384, 0x1000000, 131072, 4}, new ImageDescriptor[]{CoreImages.ALIGNMENT_H_SMALL_LEFT, CoreImages.ALIGNMENT_H_SMALL_CENTER, CoreImages.ALIGNMENT_H_SMALL_RIGHT, CoreImages.ALIGNMENT_H_SMALL_FILL});
            GridDataTest.check_getSmallAlignmentImage(gridData, false, new int[]{128, 0x1000000, 1024, 4}, new ImageDescriptor[]{CoreImages.ALIGNMENT_V_SMALL_TOP, CoreImages.ALIGNMENT_V_SMALL_CENTER, CoreImages.ALIGNMENT_V_SMALL_BOTTOM, CoreImages.ALIGNMENT_V_SMALL_FILL});
        }
        finally {
            shell.refresh_dispose();
        }
    }

    private static void check_getSmallAlignmentImage(GridDataInfo gridData, boolean horizontal, int[] alignments, ImageDescriptor[] icons) throws Exception {
        int i = 0;
        while (i < alignments.length) {
            int alignment = alignments[i];
            ImageDescriptor expectedImage = icons[i];
            if (horizontal) {
                gridData.setHorizontalAlignment(alignment);
            } else {
                gridData.setVerticalAlignment(alignment);
            }
            GridDataTest.assertSame((Object)expectedImage, (Object)gridData.getSmallAlignmentImageDescriptor(horizontal));
            ++i;
        }
    }

    @Test
    public void test_getSmallAlignmentImage_invalid() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(-1, -1, false, false));", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        GridDataTest.assertSame(null, (Object)gridData.getSmallAlignmentImageDescriptor(true));
        GridDataTest.assertSame(null, (Object)gridData.getSmallAlignmentImageDescriptor(false));
    }

    @Test
    public void test_sizeHint_width() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        GridDataTest.assertEquals((long)-1L, (long)gridData.getWidthHint());
        gridData.setWidthHint(200);
        GridDataTest.assertEquals((long)200L, (long)gridData.getWidthHint());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);", "        gridData.widthHint = 200;", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}");
        gridData.setWidthHint(-1);
        GridDataTest.assertEquals((long)-1L, (long)gridData.getWidthHint());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_sizeHint_height() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        GridDataTest.assertEquals((long)-1L, (long)gridData.getHeightHint());
        gridData.setHeightHint(200);
        GridDataTest.assertEquals((long)200L, (long)gridData.getHeightHint());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);", "        gridData.heightHint = 200;", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}");
        gridData.setHeightHint(-1);
        GridDataTest.assertEquals((long)-1L, (long)gridData.getHeightHint());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_grabHorizontal() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.grabExcessHorizontalSpace = true;", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        GridDataTest.assertTrue((boolean)gridData.getHorizontalGrab());
        gridData.setHorizontalGrab(false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        GridDataTest.assertFalse((boolean)gridData.getHorizontalGrab());
    }

    @Test
    public void test_grabVertical() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        GridDataTest.assertFalse((boolean)gridData.getVerticalGrab());
        gridData.setVerticalGrab(true);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.grabExcessVerticalSpace = true;", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}");
        gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        GridDataTest.assertTrue((boolean)gridData.getVerticalGrab());
    }

    @Test
    public void test_grab_usingProperty() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.grabExcessHorizontalSpace = true;", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        GridDataTest.assertTrue((boolean)gridData.getHorizontalGrab());
        gridData.getPropertyByTitle("grabExcessHorizontalSpace").setValue((Object)Boolean.FALSE);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        GridDataTest.assertFalse((boolean)gridData.getHorizontalGrab());
    }

    @Test
    public void test_setHorizontalSpan() throws Exception {
        this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        this.refresh();
        ControlInfo button = (ControlInfo)GridDataTest.getJavaInfoByName("button_1");
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        gridData.setHorizontalSpan(2);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 2, 1));", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "    new Label(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_setProperty_horizontalSpan() throws Exception {
        this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        this.refresh();
        ControlInfo button = (ControlInfo)GridDataTest.getJavaInfoByName("button_1");
        Property property = GridLayoutInfo.getGridData((ControlInfo)button).getPropertyByTitle("horizontalSpan");
        String source = this.m_lastEditor.getSource();
        property.setValue((Object)0);
        GridDataTest.assertEditor(source, this.m_lastEditor);
        source = this.m_lastEditor.getSource();
        property.setValue((Object)3);
        GridDataTest.assertEditor(source, this.m_lastEditor);
        property.setValue((Object)2);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 2, 1));", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "    new Label(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_setVerticalSpan() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_4 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)GridDataTest.getJavaInfoByName("button_2");
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        gridData.setVerticalSpan(2);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 2));", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_4 = new Button(this, SWT.NONE);", "    }", "    new Label(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_setProperty_verticalSpan() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_4 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)GridDataTest.getJavaInfoByName("button_2");
        Property property = GridLayoutInfo.getGridData((ControlInfo)button).getPropertyByTitle("verticalSpan");
        String source = this.m_lastEditor.getSource();
        property.setValue((Object)0);
        GridDataTest.assertEditor(source, this.m_lastEditor);
        source = this.m_lastEditor.getSource();
        property.setValue((Object)3);
        GridDataTest.assertEditor(source, this.m_lastEditor);
        property.setValue((Object)2);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 2));", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_4 = new Button(this, SWT.NONE);", "    }", "    new Label(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_contextMenu_horizontal() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        GridDataInfo gridData = (GridDataInfo)button.getChildrenJava().get(0);
        GridDataTest.assertNotNull((Object)gridData);
        shell.refresh();
        try {
            MenuManager manager = GridDataTest.getDesignerMenuManager();
            shell.getBroadcastObject().addContextMenu(null, (ObjectInfo)button, (IMenuManager)manager);
            IMenuManager manager2 = GridDataTest.findChildMenuManager((IContributionManager)manager, "Horizontal alignment");
            GridDataTest.assertNotNull((Object)manager2);
            GridDataTest.assertNotNull((Object)GridDataTest.findChildAction((IContributionManager)manager2, "&Grab excess space"));
            GridDataTest.assertNotNull((Object)GridDataTest.findChildAction((IContributionManager)manager2, "&Left"));
            GridDataTest.assertNotNull((Object)GridDataTest.findChildAction((IContributionManager)manager2, "&Center"));
            GridDataTest.assertNotNull((Object)GridDataTest.findChildAction((IContributionManager)manager2, "&Right"));
            GridDataTest.assertNotNull((Object)GridDataTest.findChildAction((IContributionManager)manager2, "&Fill"));
            GridDataTest.assertTrue((boolean)GridDataTest.findChildAction((IContributionManager)manager2, "&Left").isChecked());
            GridDataTest.assertFalse((boolean)GridDataTest.findChildAction((IContributionManager)manager2, "&Right").isChecked());
            IAction action = GridDataTest.findChildAction((IContributionManager)manager2, "&Right");
            action.setChecked(true);
            action.run();
            this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));", "    }", "  }", "}");
            action = GridDataTest.findChildAction((IContributionManager)manager2, "&Grab excess space");
            action.run();
            this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, true, false, 1, 1));", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_contextMenu_vertical() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        GridDataInfo gridData = (GridDataInfo)button.getChildrenJava().get(0);
        GridDataTest.assertNotNull((Object)gridData);
        shell.refresh();
        try {
            MenuManager manager = GridDataTest.getDesignerMenuManager();
            shell.getBroadcastObject().addContextMenu(null, (ObjectInfo)button, (IMenuManager)manager);
            IMenuManager manager2 = GridDataTest.findChildMenuManager((IContributionManager)manager, "Vertical alignment");
            GridDataTest.assertNotNull((Object)manager2);
            GridDataTest.assertNotNull((Object)GridDataTest.findChildAction((IContributionManager)manager2, "&Grab excess space"));
            GridDataTest.assertNotNull((Object)GridDataTest.findChildAction((IContributionManager)manager2, "&Top"));
            GridDataTest.assertNotNull((Object)GridDataTest.findChildAction((IContributionManager)manager2, "&Center"));
            GridDataTest.assertNotNull((Object)GridDataTest.findChildAction((IContributionManager)manager2, "&Bottom"));
            GridDataTest.assertNotNull((Object)GridDataTest.findChildAction((IContributionManager)manager2, "&Fill"));
            IAction action = GridDataTest.findChildAction((IContributionManager)manager2, "&Bottom");
            action.setChecked(true);
            action.run();
            this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.LEFT, SWT.BOTTOM, false, false, 1, 1));", "    }", "  }", "}");
            action = GridDataTest.findChildAction((IContributionManager)manager2, "&Grab excess space");
            action.run();
            this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.LEFT, SWT.BOTTOM, false, true, 1, 1));", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_contextMenu_horizontalHint() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.widthHint = 200;", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        IAction clearHintAction = this.getClearHintAction(button, true);
        GridDataTest.assertNotNull((Object)clearHintAction);
        clearHintAction.run();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        clearHintAction = this.getClearHintAction(button, true);
        GridDataTest.assertNull((Object)clearHintAction);
    }

    @Test
    public void test_contextMenu_verticalHint() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.heightHint = 200;", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        IAction clearHintAction = this.getClearHintAction(button, false);
        GridDataTest.assertNotNull((Object)clearHintAction);
        clearHintAction.run();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        clearHintAction = this.getClearHintAction(button, false);
        GridDataTest.assertNull((Object)clearHintAction);
    }

    private IAction getClearHintAction(ControlInfo button, boolean horizontal) throws Exception {
        IMenuManager manager = GridDataTest.getContextMenu(new ObjectInfo[]{button});
        IMenuManager alignmentManager = GridDataTest.findChildMenuManager((IContributionManager)manager, horizontal ? "Horizontal alignment" : "Vertical alignment");
        return GridDataTest.findChildAction((IContributionManager)alignmentManager, "Clear hint");
    }

    @Test
    public void test_defaultValues() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        GridDataTest.assertEquals((long)16384L, (long)gridData.getHorizontalAlignment());
        GridDataTest.assertEquals((long)0x1000000L, (long)gridData.getVerticalAlignment());
        GridDataTest.assertEquals((Object)false, (Object)gridData.getHorizontalGrab());
        GridDataTest.assertEquals((Object)false, (Object)gridData.getVerticalGrab());
        GridDataTest.assertEquals((Object)16384, (Object)gridData.getPropertyByTitle("horizontalAlignment").getValue());
        GridDataTest.assertEquals((Object)0x1000000, (Object)gridData.getPropertyByTitle("verticalAlignment").getValue());
    }

    @Test
    public void test_separateValuesFor_GridData_FILL_BOTH() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(GridData.FILL_BOTH));", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        GridDataTest.assertEquals((long)4L, (long)gridData.getHorizontalAlignment());
        GridDataTest.assertEquals((long)4L, (long)gridData.getVerticalAlignment());
        GridDataTest.assertEquals((Object)true, (Object)gridData.getHorizontalGrab());
        GridDataTest.assertEquals((Object)true, (Object)gridData.getVerticalGrab());
        GridDataTest.assertEquals((Object)4, (Object)gridData.getPropertyByTitle("horizontalAlignment").getValue());
        GridDataTest.assertEquals((Object)4, (Object)gridData.getPropertyByTitle("verticalAlignment").getValue());
    }

    @Test
    public void test_deleteIfDefault_emptyConstructor() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData());", "    }", "  }", "}");
        shell.refresh();
        ExecutionUtils.refresh((ObjectInfo)shell);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_deleteIfDefault_constructor4_yes() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));", "    }", "  }", "}");
        shell.refresh();
        ExecutionUtils.refresh((ObjectInfo)shell);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_deleteIfDefault_constructor4_no1() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false));", "    }", "  }", "}");
        shell.refresh();
        ExecutionUtils.refresh((ObjectInfo)shell);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false));", "    }", "  }", "}");
    }

    @Test
    public void test_deleteIfDefault_constructor4_no2() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false));", "    }", "  }", "}");
        shell.refresh();
        ExecutionUtils.refresh((ObjectInfo)shell);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false));", "    }", "  }", "}");
    }

    @Test
    public void test_deleteIfDefault_constructor6_yes() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));", "    }", "  }", "}");
        shell.refresh();
        ExecutionUtils.refresh((ObjectInfo)shell);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_deleteIfDefault_constructor6_no1() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 2, 1));", "    }", "  }", "}");
        shell.refresh();
        ExecutionUtils.refresh((ObjectInfo)shell);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 2, 1));", "    }", "  }", "}");
    }

    @Test
    public void test_hasParentLayout_notCompatible() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    Button button = new Button(this, SWT.NONE);", "    button.setLayoutData(new GridData());", "  }", "}");
        GridDataTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new Button(this, SWT.NONE)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {new: org.eclipse.swt.widgets.Button} {local-unique: button} {/new Button(this, SWT.NONE)/ /button.setLayoutData(new GridData())/}");
        shell.refresh();
        GridDataTest.assertNoErrors((JavaInfo)shell);
    }
}

