/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import junit.framework.AssertionFailedError;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.gef.UIPredicate;
import org.eclipse.wb.tests.gef.UIRunnable;

@Deprecated(forRemoval=true)
public class UiContext {
    private final Display m_display;
    private Shell m_shell;
    private final LinkedList<Shell> m_shells = new LinkedList();

    public UiContext() {
        this.m_display = Display.getCurrent();
    }

    public UiContext(Display display) {
        this.m_display = display;
    }

    public Shell getShell(String text) {
        Shell[] shellArray = this.m_display.getShells();
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            if (text.equals(shell.getText())) {
                return shell;
            }
            ++n2;
        }
        return null;
    }

    public Shell useShell(String text) {
        this.m_shells.addFirst(this.getShell());
        Shell[] shellArray = this.m_display.getShells();
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            if (text.equals(shell.getText())) {
                this.m_shell = shell;
                return this.m_shell;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unable to find Shell: " + text);
    }

    public void popShell() {
        this.m_shell = this.m_shells.removeFirst();
    }

    private Shell getShell() {
        if (this.m_shell != null) {
            if (this.m_shell.isDisposed()) {
                this.m_shell = null;
            } else {
                return this.m_shell;
            }
        }
        return this.getActiveShell();
    }

    public Shell getActiveShell() {
        return this.m_display.getActiveShell();
    }

    public <T extends Widget> T findFirstWidget(Class<T> classToFind) {
        return UiContext.findFirstWidget((Widget)this.getShell(), classToFind);
    }

    public static <T extends Widget> T findFirstWidget(Widget start, Class<T> classToFind) {
        List<T> widgets = UiContext.findWidgets(start, classToFind);
        if (!widgets.isEmpty()) {
            return (T)((Widget)widgets.get(0));
        }
        return null;
    }

    public <T extends Widget> List<T> findWidgets(Class<T> classToFind) {
        Shell shell = this.getShell();
        return UiContext.findWidgets((Widget)shell, classToFind);
    }

    public static <T extends Widget> List<T> findWidgets(Widget start, final Class<T> classToFind) {
        final ArrayList widgets = new ArrayList();
        UiContext.visit(start, new IWidgetsVisitor(){

            @Override
            public void endVisit(Widget widget) {
                if (classToFind.isAssignableFrom(widget.getClass())) {
                    widgets.add(widget);
                }
            }
        });
        return widgets;
    }

    public Button getButtonByText(String text) {
        return this.getButtonByText((Widget)this.getShell(), text);
    }

    public Button getButtonByTextPrefix(String prefix) {
        return this.getButton((Widget)this.getShell(), input -> input != null && input.startsWith(prefix));
    }

    public Button getButtonByText(Widget start, String text) {
        return this.getButton(start, input -> UiContext.isSameText(input, text));
    }

    public Button getButton(Widget start, final Predicate<String> predicate) {
        final Button[] result = new Button[1];
        UiContext.visit(start, new IWidgetsVisitor(){

            @Override
            public void endVisit(Widget widget) {
                Button button;
                if (widget instanceof Button && (predicate.test((button = (Button)widget).getText()) || predicate.test(button.getToolTipText()))) {
                    result[0] = button;
                }
            }
        });
        return result[0];
    }

    public ToolItem getToolItem(final String text) {
        final ToolItem[] result = new ToolItem[1];
        UiContext.visit((Widget)this.getShell(), new IWidgetsVisitor(){

            @Override
            public void endVisit(Widget widget) {
                ToolItem item;
                if (widget instanceof ToolItem && (text.equals((item = (ToolItem)widget).getText()) || text.equals(item.getToolTipText()))) {
                    result[0] = item;
                }
            }
        });
        return result[0];
    }

    public TreeItem getTreeItem(final String text) {
        final TreeItem[] result = new TreeItem[1];
        UiContext.visit((Widget)this.getShell(), new IWidgetsVisitor(){

            @Override
            public void endVisit(Widget widget) {
                TreeItem item;
                if (widget instanceof TreeItem && text.equals((item = (TreeItem)widget).getText())) {
                    result[0] = item;
                }
            }
        });
        return result[0];
    }

    public TabItem getTabItem(final String text) {
        final TabItem[] result = new TabItem[1];
        UiContext.visit((Widget)this.getShell(), new IWidgetsVisitor(){

            @Override
            public void endVisit(Widget widget) {
                TabItem item;
                if (widget instanceof TabItem && text.equals((item = (TabItem)widget).getText())) {
                    result[0] = item;
                }
            }
        });
        return result[0];
    }

    public Text getTextByLabel(final String labelText) {
        final Text[] result = new Text[1];
        UiContext.visit((Widget)this.getShell(), new IWidgetsVisitor(){
            private boolean m_labelFound;

            @Override
            public void endVisit(Widget widget) {
                if (widget instanceof Label) {
                    Label label = (Label)widget;
                    this.m_labelFound = UiContext.isSameText(label.getText(), labelText);
                }
                if (widget instanceof Text && this.m_labelFound) {
                    result[0] = (Text)widget;
                }
            }
        });
        return result[0];
    }

    public Text getTextByText(final String textText) {
        final Text[] result = new Text[1];
        UiContext.visit((Widget)this.getShell(), new IWidgetsVisitor(){

            @Override
            public void endVisit(Widget widget) {
                Text text;
                if (widget instanceof Text && (text = (Text)widget).getText().equals(textText)) {
                    result[0] = (Text)widget;
                }
            }
        });
        return result[0];
    }

    public void click(Widget widget) {
        widget.notifyListeners(13, new Event());
    }

    public void clickButton(String text) {
        Button button = this.getButtonByText(text);
        Assert.isNotNull((Object)button, (String)("Can not find button with text |" + text + "|"));
        this.clickButton(button);
    }

    public void clickButton(Button button) {
        this.click((Widget)button);
    }

    public void selectButton(String text, boolean selection) {
        Button button = this.getButtonByText(text);
        Assert.isNotNull((Object)button, (String)("Can not find button with text |" + text + "|"));
        button.setSelection(selection);
        this.clickButton(button);
    }

    private void selectButton(Button button, boolean selection) {
        button.setSelection(selection);
        this.clickButton(button);
    }

    public void selectButton(Button button) {
        if ((button.getStyle() & 0x10) != 0) {
            Control[] children = button.getParent().getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                if (child instanceof Button) {
                    Button childButton = (Button)child;
                    if ((child.getStyle() & 0x10) != 0 && childButton != button) {
                        this.selectButton(childButton, false);
                    }
                }
                ++i;
            }
        }
        button.setFocus();
        this.selectButton(button, true);
    }

    public void selectButton(String text) {
        Button button = this.getButtonByText(text);
        Assert.isNotNull((Object)button, (String)("Can not find button with text |" + text + "|"));
        this.selectButton(button);
    }

    public void click(ToolItem toolItem, int detail) {
        Event event = new Event();
        event.detail = detail;
        toolItem.notifyListeners(13, event);
    }

    public void selectMenuItem(MenuItem menuItem, boolean selection) {
        menuItem.setSelection(selection);
        this.click((Widget)menuItem);
    }

    public void selectMenuItem(MenuItem menuItem) {
        this.selectMenuItem(menuItem, true);
    }

    public Control getControlAfterLabel(String text) {
        List<Label> labels = this.findWidgets(Label.class);
        for (Label label : labels) {
            String labelText = label.getText().trim();
            if (!UiContext.isSameText(labelText, text)) continue;
            Object[] children = label.getParent().getChildren();
            int index = ArrayUtils.indexOf((Object[])children, (Object)label);
            if (index >= children.length - 1) break;
            return children[index + 1];
        }
        return null;
    }

    public <T> T getControlAfter(Control reference) {
        Object[] children = reference.getParent().getChildren();
        int index = ArrayUtils.indexOf((Object[])children, (Object)reference);
        if (index < children.length - 1) {
            return (T)children[index + 1];
        }
        return null;
    }

    public static void setExpanded(TreeItem treeItem, boolean expanded) {
        treeItem.setExpanded(expanded);
        Event event = new Event();
        event.widget = treeItem.getParent();
        event.item = treeItem;
        treeItem.getParent().notifyListeners(17, event);
    }

    public static void setSelection(TreeItem treeItem) {
        Tree tree = treeItem.getParent();
        tree.setSelection(treeItem);
        treeItem.getParent().notifyListeners(13, null);
    }

    public static void setSelection(org.eclipse.swt.widgets.List list, String item) {
        list.setSelection(new String[]{item});
        list.notifyListeners(13, null);
    }

    public static void setChecked(TreeItem treeItem, boolean checked) {
        treeItem.setChecked(checked);
        Event event = new Event();
        event.detail = 32;
        event.item = treeItem;
        treeItem.getParent().notifyListeners(13, event);
    }

    public Menu getActiveMenu() {
        return (Menu)ReflectionUtils.getFieldObject((Object)this.getShell(), (String)"activeMenu");
    }

    public Menu getLastPopup() {
        Menu menu = null;
        Menu[] popups = (Menu[])ReflectionUtils.getFieldObject((Object)this.m_display, (String)"popups");
        int i = 0;
        while (i < popups.length) {
            if (popups[i] != null) {
                menu = popups[i];
            }
            ++i;
        }
        return menu;
    }

    public MenuItem getMenuItem(Menu menu, final String text) {
        final MenuItem[] result = new MenuItem[1];
        UiContext.visit((Widget)menu, new IWidgetsVisitor(){

            @Override
            public void endVisit(Widget widget) {
                MenuItem item;
                if (widget instanceof MenuItem && UiContext.isSameText((item = (MenuItem)widget).getText(), text)) {
                    result[0] = item;
                }
            }
        });
        return result[0];
    }

    private static boolean isSameText(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        s1 = UiContext.normalizeTextForComparing(s1);
        s2 = UiContext.normalizeTextForComparing(s2);
        return s1.equals(s2);
    }

    private static String normalizeTextForComparing(String s) {
        s = s.trim();
        s = StringUtils.remove((String)s, (char)'&');
        s = StringUtils.substringBefore((String)s, (String)"\t");
        return s;
    }

    public static void visit(Widget widget, IWidgetsVisitor visitor) {
        Control control;
        if (widget instanceof Control && (control = (Control)widget).getParent() != null && control.getParent().getLayout() instanceof StackLayout && !control.isVisible()) {
            return;
        }
        if (visitor.visit(widget)) {
            int n;
            Control control2;
            TabItem tabItem;
            int n2;
            if (widget instanceof Composite) {
                Composite composite = (Composite)widget;
                Control[] children = composite.getChildren();
                int i = 0;
                while (i < children.length) {
                    Control child = children[i];
                    UiContext.visit((Widget)child, visitor);
                    ++i;
                }
            }
            if (widget instanceof ToolBar) {
                ToolBar toolBar = (ToolBar)widget;
                ToolItem[] toolItemArray = toolBar.getItems();
                n2 = toolItemArray.length;
                int child = 0;
                while (child < n2) {
                    ToolItem toolItem = toolItemArray[child];
                    UiContext.visit((Widget)toolItem, visitor);
                    ++child;
                }
            }
            if (widget instanceof TabFolder) {
                TabFolder tabFolder = (TabFolder)widget;
                TabItem[] tabItemArray = tabFolder.getItems();
                int n3 = tabItemArray.length;
                n2 = 0;
                while (n2 < n3) {
                    tabItem = tabItemArray[n2];
                    UiContext.visit((Widget)tabItem, visitor);
                    ++n2;
                }
            }
            if (widget instanceof TabItem && (control2 = (tabItem = (TabItem)widget).getControl()) != null) {
                UiContext.visit((Widget)control2, visitor);
            }
            if (widget instanceof Tree) {
                Tree tree = (Tree)widget;
                TreeItem[] treeItemArray = tree.getItems();
                n = treeItemArray.length;
                int n4 = 0;
                while (n4 < n) {
                    TreeItem treeItem = treeItemArray[n4];
                    UiContext.visit((Widget)treeItem, visitor);
                    ++n4;
                }
            }
            if (widget instanceof TreeItem) {
                TreeItem parent = (TreeItem)widget;
                TreeItem[] treeItemArray = parent.getItems();
                int n5 = treeItemArray.length;
                n = 0;
                while (n < n5) {
                    TreeItem treeItem = treeItemArray[n];
                    UiContext.visit((Widget)treeItem, visitor);
                    ++n;
                }
            }
            if (widget instanceof Menu) {
                Menu menu = (Menu)widget;
                MenuItem[] menuItemArray = menu.getItems();
                int n6 = menuItemArray.length;
                int n7 = 0;
                while (n7 < n6) {
                    MenuItem menuItem = menuItemArray[n7];
                    UiContext.visit((Widget)menuItem, visitor);
                    ++n7;
                }
            }
            if (widget instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)widget;
                UiContext.visit((Widget)menuItem.getMenu(), visitor);
            }
            visitor.endVisit(widget);
        }
    }

    public void executeAndCheck(UIRunnable uiRunnable, final UIRunnable checkRunnable) throws Exception {
        final Throwable[] checkException = new Throwable[1];
        Thread checkThread = new Thread("UIContext_checkThread"){

            @Override
            public void run() {
                UiContext.this.m_display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            checkRunnable.run(UiContext.this);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            checkException[0] = e;
                        }
                    }
                });
            }
        };
        checkThread.start();
        uiRunnable.run(this);
        checkThread.join();
        if (checkException[0] != null) {
            Throwable throwable = checkException[0];
            if (throwable instanceof AssertionFailedError) {
                AssertionFailedError error = (AssertionFailedError)throwable;
                throw error;
            }
            throw new Exception("Exception during running 'check' UIRunnable.", checkException[0]);
        }
    }

    public void waitFor(UIPredicate predicate) throws InterruptedException {
        do {
            this.waitEventLoop(10);
        } while (!predicate.check());
    }

    private void waitEventLoop(int time) throws InterruptedException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < (long)time) {
            Thread.sleep(0L);
            while (this.m_display.readAndDispatch()) {
            }
        }
    }

    public static class IWidgetsVisitor {
        public boolean visit(Widget widget) {
            return true;
        }

        public void endVisit(Widget widget) {
        }
    }
}

