/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.controls;

import java.util.EventListener;
import java.util.Locale;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.wb.core.controls.CImageLabel;

public class CTableCombo
extends Composite {
    protected Button m_arrow;
    protected CImageLabel m_text;
    protected Shell m_popup;
    protected Table m_table;
    protected boolean hasFocus;

    public CTableCombo(Composite parent, int style) {
        style = CTableCombo.checkStyle(style);
        super(parent, style);
        this.init(parent, style);
    }

    static int checkStyle(int style) {
        int mask = 0x800808;
        return style & mask;
    }

    private void init(Composite parent, int style) {
        this.m_arrow = new Button((Composite)this, 525316);
        this.m_text = new CImageLabel(this, style & 0xFFFFF7FF);
        this.m_text.setBackground(Display.getDefault().getSystemColor(25));
        final Shell shell = this.getShell();
        this.m_popup = new Shell(shell, 0);
        this.m_table = new Table((Composite)this.m_popup, 65536);
        new TableColumn(this.m_table, 0);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (CTableCombo.this.m_popup == event.widget) {
                    CTableCombo.this.handlePopupEvent(event);
                    return;
                }
                if (CTableCombo.this.m_text == event.widget) {
                    CTableCombo.this.handleTextEvent(event);
                    return;
                }
                if (CTableCombo.this.m_table == event.widget) {
                    CTableCombo.this.handleTableEvent(event);
                    return;
                }
                if (CTableCombo.this.m_arrow == event.widget) {
                    CTableCombo.this.handleArrowEvent(event);
                    return;
                }
                if (CTableCombo.this == event.widget) {
                    CTableCombo.this.handleComboEvent(event);
                    return;
                }
            }
        };
        final Listener shellListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 10: 
                    case 11: 
                    case 12: {
                        if (CTableCombo.this.isDisposed()) break;
                        CTableCombo.this.dropDown(false);
                    }
                }
            }
        };
        final int[] comboEvents = new int[]{12, 10, 11};
        int i = 0;
        while (i < comboEvents.length) {
            this.addListener(comboEvents[i], listener);
            shell.addListener(comboEvents[i], shellListener);
            ++i;
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                int i = 0;
                while (i < comboEvents.length) {
                    shell.removeListener(comboEvents[i], shellListener);
                    ++i;
                }
            }
        });
        int[] popupEvents = new int[]{21, 9, 27};
        int i2 = 0;
        while (i2 < popupEvents.length) {
            this.m_popup.addListener(popupEvents[i2], listener);
            ++i2;
        }
        int[] textEvents = new int[]{1, 2, 24, 3, 4, 8, 31, 15, 16};
        int i3 = 0;
        while (i3 < textEvents.length) {
            this.m_text.addListener(textEvents[i3], listener);
            ++i3;
        }
        int[] tableEvents = new int[]{4, 13, 31, 1, 2, 15, 16};
        int i4 = 0;
        while (i4 < tableEvents.length) {
            this.m_table.addListener(tableEvents[i4], listener);
            ++i4;
        }
        int[] arrowEvents = new int[]{13, 15, 16};
        int i5 = 0;
        while (i5 < arrowEvents.length) {
            this.m_arrow.addListener(arrowEvents[i5], listener);
            ++i5;
        }
    }

    protected void handleTableEvent(Event event) {
        switch (event.type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                final int time = event.time;
                event.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (CTableCombo.this.isDisposed()) {
                            return;
                        }
                        Control focusControl = CTableCombo.this.getDisplay().getFocusControl();
                        if (focusControl == CTableCombo.this.m_text || focusControl == CTableCombo.this.m_arrow) {
                            return;
                        }
                        CTableCombo.this.hasFocus = false;
                        Event e = new Event();
                        e.time = time;
                        CTableCombo.this.notifyListeners(16, e);
                    }
                });
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                this.dropDown(false);
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(14, e);
                break;
            }
            case 13: {
                int index = this.m_table.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                TableItem item = this.m_table.getItem(index);
                this.m_text.setText(item.getText());
                this.m_text.setImage(item.getImage());
                this.m_table.setSelection(index);
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                this.notifyListeners(13, e);
                event.doit = e.doit;
                this.dropDown(false);
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 16: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 1: {
                Event e;
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if (event.character == '\r' || event.character == '\t') {
                    this.dropDown(false);
                    e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed()) break;
                e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
            }
        }
    }

    protected void handlePopupEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle listRect = this.m_table.getBounds();
                Color black = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(black);
                event.gc.drawRectangle(0, 0, listRect.width + 1, listRect.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
            }
        }
    }

    protected void handleComboEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.m_popup != null && !this.m_popup.isDisposed()) {
                    this.m_popup.dispose();
                }
                this.m_popup = null;
                this.m_text = null;
                this.m_arrow = null;
                break;
            }
            case 10: {
                this.dropDown(false);
                break;
            }
            case 11: {
                this.internalLayout();
            }
        }
    }

    protected void handleArrowEvent(Event event) {
        switch (event.type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(15, e);
                break;
            }
            case 13: {
                boolean wasDropped = this.isDropped();
                this.dropDown(!wasDropped);
                if (!wasDropped) break;
                this.m_text.forceFocus();
            }
        }
    }

    protected void handleTextEvent(Event event) {
        switch (event.type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                final int time = event.time;
                event.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (CTableCombo.this.isDisposed()) {
                            return;
                        }
                        Control focusControl = CTableCombo.this.getDisplay().getFocusControl();
                        if (focusControl == CTableCombo.this.m_table || focusControl == CTableCombo.this.m_arrow || focusControl != null && focusControl.getParent() == CTableCombo.this) {
                            return;
                        }
                        CTableCombo.this.hasFocus = false;
                        Event e = new Event();
                        e.time = time;
                        CTableCombo.this.notifyListeners(16, e);
                    }
                });
                break;
            }
            case 1: {
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if (event.character == '\r') {
                    this.dropDown(false);
                    Event e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed()) break;
                if (event.character == '+') {
                    this.dropDown(true);
                }
                if (this.isDropped() && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
                    int oldIndex = this.getSelectionIndex();
                    if (event.keyCode == 0x1000001) {
                        this.select(Math.max(oldIndex - 1, 0));
                    } else {
                        this.select(Math.min(oldIndex + 1, this.getItemCount() - 1));
                    }
                    if (oldIndex != this.getSelectionIndex()) {
                        Event e = new Event();
                        e.time = event.time;
                        e.stateMask = event.stateMask;
                        this.notifyListeners(13, e);
                    }
                    if (this.isDisposed()) break;
                }
                if (Character.isLetter(event.character)) {
                    int oldIndex = this.getSelectionIndex();
                    int index = -1;
                    int i = 0;
                    while (i < this.getItemCount()) {
                        String item = this.getItem(i).toUpperCase(Locale.ENGLISH);
                        if (item.length() != 0 && item.charAt(0) == Character.toUpperCase(event.character)) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                    if (index != -1) {
                        this.select(Math.max(index, 0));
                        if (oldIndex != this.getSelectionIndex()) {
                            Event e = new Event();
                            e.time = event.time;
                            e.stateMask = event.stateMask;
                            this.notifyListeners(13, e);
                        }
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                if (this.m_text == null || this.m_text.isDisposed()) break;
                this.notifyListeners(1, e);
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 24: {
                this.m_table.deselectAll();
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(24, e);
                break;
            }
            case 3: {
                if (event.button != 1) {
                    return;
                }
                this.m_text.forceFocus();
                boolean dropped = this.isDropped();
                this.dropDown(!dropped);
                if (dropped) break;
                this.m_text.forceFocus();
                break;
            }
            case 8: {
                this.notifyListeners(8, event);
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                        break;
                    }
                    case 8: 
                    case 16: {
                        event.doit = true;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
            }
        }
    }

    private void dropDown(boolean drop) {
        int itemCount;
        if (drop == this.isDropped()) {
            return;
        }
        if (!drop) {
            this.m_popup.setVisible(false);
            this.m_text.setFocus();
            return;
        }
        int index = this.m_table.getSelectionIndex();
        if (index != -1) {
            this.m_table.setTopIndex(index);
            this.m_table.setSelection(index);
        }
        this.m_table.pack();
        Point point = this.getParent().toDisplay(this.getLocation());
        Point comboSize = this.getSize();
        int width = comboSize.x - 1;
        this.m_table.getColumn(0).setWidth(width - 5);
        if (!(this.m_popup.getLayout() instanceof FillLayout)) {
            this.m_popup.setLayout((Layout)new FillLayout());
        }
        if ((itemCount = this.m_table.getItemCount()) > 20) {
            itemCount = 20;
        }
        int height = Math.min(this.m_table.getItemHeight() * itemCount + 5, Display.getCurrent().getClientArea().height - point.y - 20);
        this.m_popup.setBounds(point.x, point.y + comboSize.y, width, height);
        this.m_popup.layout();
        this.m_popup.setVisible(true);
        this.m_text.setFocus();
        if (index != -1) {
            this.m_table.setTopIndex(index);
            this.m_table.setSelection(index);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        Point textSize = this.m_text.computeSize(wHint, -1, changed);
        Point arrowSize = this.m_arrow.computeSize(-1, -1, changed);
        TableColumn column = this.m_table.getColumn(0);
        column.pack();
        int tableWidth = column.getWidth();
        int borderWidth = this.getBorderWidth();
        height = Math.max(hHint, Math.max(textSize.y, arrowSize.y) + 2 * borderWidth);
        width = Math.max(wHint, Math.max(textSize.x + arrowSize.x, tableWidth) + 2 * borderWidth);
        return new Point(width, height);
    }

    private void internalLayout() {
        if (this.isDropped()) {
            this.dropDown(false);
        }
        Rectangle rect = this.getClientArea();
        int width = rect.width;
        int height = rect.height;
        Point arrowSize = this.m_arrow.computeSize(-1, height);
        this.m_text.setBounds(rect.x, rect.y, width - arrowSize.x, height);
        this.m_arrow.setBounds(rect.x + width - arrowSize.x, rect.y, arrowSize.x, arrowSize.y);
    }

    private boolean isDropped() {
        return this.m_popup.isVisible();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if (this.m_text.isFocusControl() || this.m_arrow.isFocusControl() || this.m_table.isFocusControl() || this.m_popup.isFocusControl()) {
            return true;
        }
        return super.isFocusControl();
    }

    public void select(int index) {
        this.checkWidget();
        if (index == -1) {
            this.m_table.deselectAll();
            this.m_text.setText("");
            this.m_text.setImage(null);
            return;
        }
        if (index >= 0 && index < this.m_table.getItemCount() && index != this.getSelectionIndex()) {
            TableItem item = this.m_table.getItem(index);
            this.m_text.setText(item.getText());
            this.m_text.setImage(item.getImage());
            this.m_table.select(index);
            this.m_table.showSelection();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.m_text.setBackground(Display.getDefault().getSystemColor(25));
        } else {
            this.m_text.setBackground(Display.getDefault().getSystemColor(19));
        }
    }

    public String getItem(int index) {
        this.checkWidget();
        return this.m_table.getItem(index).getText();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.m_table.getSelectionIndex();
    }

    public void removeAll() {
        this.checkWidget();
        this.m_text.setText("");
        this.m_text.setImage(null);
        this.m_table.removeAll();
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            return -1;
        }
        TableItem[] items = this.m_table.getItems();
        int i = start;
        while (i < items.length) {
            TableItem item = items[i];
            if (item.getText().equalsIgnoreCase(string)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getText() {
        return this.m_text.getText();
    }

    public int getItemCount() {
        this.checkWidget();
        return this.m_table.getItemCount();
    }

    protected void setText(String string) {
        this.m_text.setText(string);
    }

    protected void setImage(Image image) {
        this.m_text.setImage(image);
    }

    public void add(String text) {
        this.add(text, null);
    }

    public void add(String text, Image image) {
        this.checkWidget();
        TableItem item = new TableItem(this.m_table, 0);
        item.setText(text);
        item.setImage(image);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((EventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }
}

