/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.draw2d;

import org.eclipse.draw2d.DeferredUpdateManager;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.internal.draw2d.EventManager;
import org.eclipse.wb.internal.draw2d.RootFigure;

public class FigureCanvas
extends org.eclipse.draw2d.FigureCanvas {
    private RootFigure m_rootFigure;

    public FigureCanvas(Composite parent, int style) {
        super(parent, style | 0x20000000, FigureCanvas.createLightweightSystem());
        this.createRootFigure();
    }

    private void createRootFigure() {
        this.m_rootFigure = new RootFigure(this);
        this.m_rootFigure.setBackgroundColor(this.getBackground());
        this.m_rootFigure.setForegroundColor(this.getForeground());
        this.m_rootFigure.setFont(this.getFont());
        this.setDefaultEventManager();
        this.setDefaultUpdateManager();
        this.setContents((IFigure)this.m_rootFigure);
    }

    private static LightweightSystem createLightweightSystem() {
        LightweightSystem lws = new LightweightSystem();
        lws.setUpdateManager((UpdateManager)new CachedUpdateManager());
        return lws;
    }

    protected void setDefaultEventManager() {
        this.m_rootFigure.getFigureCanvas().getLightweightSystem().setEventDispatcher((EventDispatcher)new EventManager(this));
    }

    protected void setDefaultUpdateManager() {
        this.getUpdateManager().setControl(this);
    }

    public RootFigure getRootFigure() {
        return this.m_rootFigure;
    }

    public void setDrawCached(boolean value) {
        this.getUpdateManager().m_drawCached = value;
    }

    private CachedUpdateManager getUpdateManager() {
        return (CachedUpdateManager)this.getLightweightSystem().getUpdateManager();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Dimension size = this.m_rootFigure.getPreferredSize().getUnioned(wHint, hHint);
        return new Point(size.width, size.height);
    }

    private static class CachedUpdateManager
    extends DeferredUpdateManager {
        private FigureCanvas m_canvas;
        private boolean m_drawCached;

        private CachedUpdateManager() {
        }

        private void setControl(FigureCanvas canvas) {
            this.m_canvas = canvas;
        }

        public synchronized void performUpdate() {
            if (this.m_drawCached) {
                this.queueWork();
                return;
            }
            super.performUpdate();
        }

        protected void paint(GC gc) {
            if (this.m_drawCached) {
                this.addDirtyRegion((IFigure)this.m_canvas.getRootFigure(), new Rectangle(gc.getClipping()));
                return;
            }
            super.paint(gc);
        }
    }
}

