/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class AbstractComponentTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_disposeImage_whenDeleteModel() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        this.refresh();
        ComponentInfo button = (ComponentInfo)AbstractComponentTest.getJavaInfoByName("button");
        Image image = button.getImage();
        AbstractComponentTest.assertFalse((boolean)image.isDisposed());
        button.delete();
        AbstractComponentTest.assertTrue((boolean)image.isDisposed());
    }

    @Test
    public void test_getComponentObject() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        AbstractComponentTest.assertSame((Object)panel.getObject(), (Object)panel.getComponentObject());
        AbstractComponentTest.assertSame((Object)button.getObject(), (Object)button.getComponentObject());
    }

    @Test
    public void test_getAbsolute_topLevel() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setSize(450, 300);", "  }", "}");
        panel.refresh();
        AbstractComponentTest.assertEquals((Object)new Rectangle(0, 0, 450, 300), (Object)panel.getAbsoluteBounds());
    }

    @Test
    public void test_getAbsolute_innerComponent() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setSize(450, 300);", "    setLayout(null);", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "      innerPanel.setBounds(10, 10, 300, 300);", "      innerPanel.setLayout(null);", "      {", "        JButton button = new JButton();", "        innerPanel.add(button);", "        button.setBounds(1, 2, 100, 50);", "      }", "    }", "  }", "}");
        panel.refresh();
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)innerPanel.getChildrenComponents().get(0);
        AbstractComponentTest.assertEquals((Object)new Rectangle(11, 12, 100, 50), (Object)button.getAbsoluteBounds());
    }
}

