/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.association;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.ImplicitFactoryArgumentAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class ImplicitFactoryArgumentAssociationTest
extends SwingModelTest {
    @Test
    public void test_permissions() throws Exception {
        ContainerInfo panel = this.parseTestCase();
        ContainerInfo bar = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo component = (ComponentInfo)bar.getChildrenJava().get(0);
        ComponentInfo button = (ComponentInfo)component.getChildrenJava().get(0);
        ImplicitFactoryArgumentAssociation association = (ImplicitFactoryArgumentAssociation)button.getAssociation();
        ImplicitFactoryArgumentAssociationTest.assertTrue((boolean)association.canDelete());
        ImplicitFactoryArgumentAssociationTest.assertTrue((boolean)component.canDelete());
        ImplicitFactoryArgumentAssociationTest.assertTrue((boolean)JavaInfoUtils.canMove((JavaInfo)component));
        ImplicitFactoryArgumentAssociationTest.assertFalse((boolean)JavaInfoUtils.canReparent((JavaInfo)component));
        ImplicitFactoryArgumentAssociationTest.assertTrue((boolean)button.canDelete());
        ImplicitFactoryArgumentAssociationTest.assertFalse((boolean)JavaInfoUtils.canMove((JavaInfo)button));
        ImplicitFactoryArgumentAssociationTest.assertTrue((boolean)JavaInfoUtils.canReparent((JavaInfo)button));
    }

    @Test
    public void test_deleteButton() throws Exception {
        ContainerInfo panel = this.parseTestCase();
        ContainerInfo bar = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo component = (ComponentInfo)bar.getChildrenJava().get(0);
        ComponentInfo button = (ComponentInfo)component.getChildrenJava().get(0);
        button.delete();
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    MyBar bar = new MyBar();", "    add(bar);", "  }", "}");
        ImplicitFactoryArgumentAssociationTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(bar)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyBar} {local-unique: bar} {/new MyBar()/ /add(bar)/}");
    }

    @Test
    public void test_deleteFactoryComponent() throws Exception {
        ContainerInfo panel = this.parseTestCase();
        ContainerInfo bar = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo component = (ComponentInfo)bar.getChildrenJava().get(0);
        component.delete();
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    MyBar bar = new MyBar();", "    add(bar);", "  }", "}");
        ImplicitFactoryArgumentAssociationTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(bar)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyBar} {local-unique: bar} {/new MyBar()/ /add(bar)/}");
    }

    @Test
    public void test_reparentButton() throws Exception {
        ContainerInfo panel = this.parseTestCase();
        ContainerInfo bar = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo component = (ComponentInfo)bar.getChildrenJava().get(0);
        ComponentInfo button = (ComponentInfo)component.getChildrenJava().get(0);
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        flowLayout.move(button, null);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    MyBar bar = new MyBar();", "    add(bar);", "    //", "    JButton button = new JButton('my JButton');", "    add(button);", "  }", "}");
        ImplicitFactoryArgumentAssociationTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(bar)/ /add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyBar} {local-unique: bar} {/new MyBar()/ /add(bar)/}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton('my JButton')/ /add(button)/}");
    }

    private ContainerInfo parseTestCase() throws Exception {
        ImplicitFactoryArgumentAssociationTest.setFileContentSrc("test/MyBar.java", this.getTestSource("public class MyBar extends JPanel {", "  public JComponent addItem(Component component) {", "    JPanel wrapper = new JPanel();", "    add(wrapper);", "    wrapper.add(component);", "    return wrapper;", "  }", "}"));
        ImplicitFactoryArgumentAssociationTest.setFileContentSrc("test/MyBar.wbp-component.xml", ImplicitFactoryArgumentAssociationTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='addItem'>", "      <parameter type='java.awt.Component' name='component'>", "        <tag name='implicitFactory.child' value='true'/>", "      </parameter>", "      <tag name='implicitFactory' value='true'/>", "    </method>", "  </methods>", "  <parameters>", "    <parameter name='layout.has'>false</parameter>", "  </parameters>", "</component>"));
        ImplicitFactoryArgumentAssociationTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    MyBar bar = new MyBar();", "    add(bar);", "    //", "    JButton button = new JButton('my JButton');", "    JComponent component = bar.addItem(button);", "    component.setEnabled(false);", "  }", "}");
        ImplicitFactoryArgumentAssociationTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(bar)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyBar} {local-unique: bar} {/new MyBar()/ /add(bar)/ /bar.addItem(button)/}", "    {implicit-factory} {local-unique: component} {/bar.addItem(button)/ /component.setEnabled(false)/}", "      {new: javax.swing.JButton} {local-unique: button} {/new JButton('my JButton')/ /bar.addItem(button)/}");
        return panel;
    }
}

