/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.JavaInfoEventOpen;
import org.eclipse.wb.internal.core.editor.DesignPageSite;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.event.EventsProperty;
import org.eclipse.wb.internal.core.model.property.event.EventsPropertyUtils;
import org.eclipse.wb.internal.core.model.property.event.IPreferenceConstants;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.MenuManagerEx;
import org.eclipse.wb.internal.swing.Activator;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class EventsPropertyTest
extends SwingModelTest
implements IPreferenceConstants {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        EventsPropertyTest.setPreferencesDefaults();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        EventsPropertyTest.waitEventLoop(0);
        EventsPropertyTest.setPreferencesDefaults();
        super.tearDown();
    }

    public static void setPreferencesDefaults() {
        EventsPropertyTest.setPreferencesDefaults(Activator.getDefault().getPreferenceStore());
    }

    private static void setPreferencesDefaults(IPreferenceStore preferences) {
        preferences.setToDefault("property.events.codeType");
        preferences.setToDefault("property.events.innerClassPosition");
        preferences.setToDefault("property.events.stubCreate");
        preferences.setToDefault("stubName");
        preferences.setToDefault("property.events.stubDelete");
        preferences.setToDefault("innerClassName");
        preferences.setToDefault("property.events.finalParameters");
        preferences.setToDefault("property.events.decorateIcon");
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_noListeners() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        EventsProperty eventsProperty = (EventsProperty)panel.getPropertyByTitle("Events");
        EventsPropertyTest.assertFalse((boolean)eventsProperty.isModified());
        EventsPropertyTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)eventsProperty.getValue());
        eventsProperty.setValue(null);
    }

    @Test
    public void test_hasListener() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    addKeyListener(new KeyAdapter() {", "      public void keyPressed(KeyEvent e) {", "        System.out.println('keyPressed!');", "      }", "      public void keyReleased(KeyEvent e) {", "        System.out.println('keyReleased!');", "      }", "    });", "  }", "}");
        EventsProperty eventsProperty = (EventsProperty)panel.getPropertyByTitle("Events");
        EventsPropertyTest.assertNotNull((Object)eventsProperty);
        EventsPropertyTest.assertTrue((boolean)eventsProperty.isModified());
        EventsPropertyTest.assertEquals((Object)"[key]", (Object)EventsPropertyTest.getPropertyText((Property)eventsProperty));
        Property[] listenerProperties = EventsPropertyTest.getSubProperties((Property)eventsProperty);
        EventsPropertyTest.assertEquals((long)13L, (long)listenerProperties.length);
        Property focusProperty = EventsPropertyTest.getPropertyByTitle(listenerProperties, "focus");
        EventsPropertyTest.assertNotNull((Object)focusProperty);
        EventsPropertyTest.assertFalse((boolean)focusProperty.isModified());
        EventsPropertyTest.assertEquals((Object)"[]", (Object)EventsPropertyTest.getPropertyText(focusProperty));
        Property keyProperty = EventsPropertyTest.getPropertyByTitle(listenerProperties, "key");
        EventsPropertyTest.assertNotNull((Object)keyProperty);
        EventsPropertyTest.assertTrue((boolean)keyProperty.isModified());
        EventsPropertyTest.assertEquals((Object)"[pressed, released]", (Object)EventsPropertyTest.getPropertyText(keyProperty));
        Property[] methodProperties = EventsPropertyTest.getSubProperties(keyProperty);
        EventsPropertyTest.assertEquals((long)3L, (long)methodProperties.length);
        EventsPropertyTest.assertEquals((Object)"pressed", (Object)methodProperties[0].getTitle());
        EventsPropertyTest.assertEquals((Object)"released", (Object)methodProperties[1].getTitle());
        EventsPropertyTest.assertEquals((Object)"typed", (Object)methodProperties[2].getTitle());
    }

    @Test
    public void test_listenerInVariable() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    KeyListener listener = new KeyAdapter() {", "      public void keyPressed(KeyEvent e) {", "      }", "    };", "    addKeyListener(listener);", "  }", "}");
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        EventsPropertyTest.assertNotNull((Object)keyPressedProperty);
        EventsPropertyTest.assertTrue((boolean)keyPressedProperty.isModified());
    }

    @Test
    public void test_listenerInnerType() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  private class KeyHandler extends KeyAdapter {", "    public void keyPressed(KeyEvent e) {", "      System.out.println('keyPressed!');", "    }", "    public void keyReleased(KeyEvent e) {", "      System.out.println('keyReleased!');", "    }", "  }", "  Test() {", "    addKeyListener(new KeyHandler());", "  }", "}");
        EventsProperty eventsProperty = (EventsProperty)panel.getPropertyByTitle("Events");
        EventsPropertyTest.assertEquals((Object)"[key]", (Object)EventsPropertyTest.getPropertyText((Property)eventsProperty));
        Property[] listenerProperties = EventsPropertyTest.getSubProperties((Property)eventsProperty);
        Property keyProperty = EventsPropertyTest.getPropertyByTitle(listenerProperties, "key");
        EventsPropertyTest.assertEquals((Object)"[pressed, released]", (Object)EventsPropertyTest.getPropertyText(keyProperty));
    }

    @Test
    public void test_qualifeidListenerNames() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/Listener_1.java", EventsPropertyTest.getSourceDQ("package test;", "public interface Listener_1 {", "  void foo();", "}"));
        EventsPropertyTest.setFileContentSrc("test/Listener_2.java", EventsPropertyTest.getSourceDQ("package test;", "public interface Listener_2 {", "  void bar();", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void addMyListener(Listener_1 listener) {", "  }", "  public void addMyListener(Listener_2 listener) {", "  }", "}"));
        EventsPropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        Property property = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "my(test.Listener_1)", "foo");
        EventsPropertyTest.assertNotNull((Object)property);
        property = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "my(test.Listener_2)", "bar");
        EventsPropertyTest.assertNotNull((Object)property);
        property = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        EventsPropertyTest.assertNotNull((Object)property);
    }

    @Test
    public void test_listenerThis_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel implements KeyListener {", "  Test() {", "    addKeyListener(this);", "  }", "    public void keyPressed(KeyEvent e) {", "      System.out.println('keyPressed!');", "    }", "    public void keyReleased(KeyEvent e) {", "      System.out.println('keyReleased!');", "    }", "    public void keyTyped(KeyEvent e) {", "      System.out.println('keyTyped!');", "    }", "}");
        EventsProperty eventsProperty = (EventsProperty)panel.getPropertyByTitle("Events");
        EventsPropertyTest.assertEquals((Object)"[key]", (Object)EventsPropertyTest.getPropertyText((Property)eventsProperty));
        Property[] listenerProperties = EventsPropertyTest.getSubProperties((Property)eventsProperty);
        Property keyProperty = EventsPropertyTest.getPropertyByTitle(listenerProperties, "key");
        EventsPropertyTest.assertEquals((Object)"[pressed, released, typed]", (Object)EventsPropertyTest.getPropertyText(keyProperty));
    }

    @Test
    public void test_listenerThis_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel implements KeyListener {", "  private final JButton m_button = new JButton();", "  Test() {", "    add(m_button);", "    addKeyListener(this);", "  }", "    public void keyPressed(KeyEvent e) {", "      // valid routing IfStatement", "      if (e.getSource() == this) {", "        onThis_keyPressed(e);", "      }", "    }", "    public void keyReleased(KeyEvent e) {", "      if (e.getSource() == m_button) {", "        // do nothing, we need this only to show EventsProperty", "        // that here we have routing to stubs", "      }", "    }", "    public void keyTyped(KeyEvent e) {", "      // no any statement, so no stubs routing, so is handler", "    }", "    private void onThis_keyPressed(KeyEvent e) {", "    }", "}");
        EventsProperty eventsProperty = (EventsProperty)panel.getPropertyByTitle("Events");
        EventsPropertyTest.assertEquals((Object)"[key]", (Object)EventsPropertyTest.getPropertyText((Property)eventsProperty));
        Property[] listenerProperties = EventsPropertyTest.getSubProperties((Property)eventsProperty);
        Property keyProperty = EventsPropertyTest.getPropertyByTitle(listenerProperties, "key");
        EventsPropertyTest.assertEquals((Object)"[pressed, typed]", (Object)EventsPropertyTest.getPropertyText(keyProperty));
    }

    @Test
    public void test_listenerThis_3() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel implements KeyListener {", "  private final JButton m_button = new JButton();", "  Test() {", "    add(m_button);", "    addKeyListener(this);", "  }", "    public void keyPressed(KeyEvent e) {", "      // valid routing IfStatement, single Statement (not Block) as 'then'", "      if (e.getSource() == this)", "        onThis_keyPressed(e);", "    }", "    public void keyReleased(KeyEvent e) {", "      if (e.getSource() == m_button) {", "        // do nothing, we need this only to show EventsProperty", "        // that here we have routing to stubs", "      }", "    }", "    public void keyTyped(KeyEvent e) {", "      if (e.getSource() == m_button) {", "        // do nothing, we need this only to show EventsProperty", "        // that here we have routing to stubs", "      }", "    }", "    private void onThis_keyPressed(KeyEvent e) {", "    }", "}");
        EventsProperty eventsProperty = (EventsProperty)panel.getPropertyByTitle("Events");
        EventsPropertyTest.assertEquals((Object)"[key]", (Object)EventsPropertyTest.getPropertyText((Property)eventsProperty));
        Property[] listenerProperties = EventsPropertyTest.getSubProperties((Property)eventsProperty);
        Property keyProperty = EventsPropertyTest.getPropertyByTitle(listenerProperties, "key");
        EventsPropertyTest.assertEquals((Object)"[pressed]", (Object)EventsPropertyTest.getPropertyText(keyProperty));
    }

    @Test
    public void test_listenerAndExecutionFlow() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel implements KeyListener {", "  private JButton m_button;", "  Test() {", "    m_button = new JButton();", "    add(m_button);", "    m_button.addKeyListener(this);", "  }", "    public void keyPressed(KeyEvent e) {", "      if (e.getSource() == m_button) {", "        onButton_keyPressed(e);", "      }", "    }", "    public void keyReleased(KeyEvent e) {", "      // no any statement, so no stubs routing, so is handler", "    }", "    public void keyTyped(KeyEvent e) {", "      // no any statement, so no stubs routing, so is handler", "    }", "    private void onButton_keyPressed(KeyEvent e) {", "    }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        EventsProperty eventsProperty = (EventsProperty)button.getPropertyByTitle("Events");
        EventsPropertyTest.assertEquals((Object)"[key]", (Object)EventsPropertyTest.getPropertyText((Property)eventsProperty));
        Property[] listenerProperties = EventsPropertyTest.getSubProperties((Property)eventsProperty);
        Property keyProperty = EventsPropertyTest.getPropertyByTitle(listenerProperties, "key");
        EventsPropertyTest.assertEquals((Object)"[pressed, released, typed]", (Object)EventsPropertyTest.getPropertyText(keyProperty));
    }

    private static void deleteEventPropertyWithGUI(final Property property) throws Exception {
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                property.setValue(Property.UNKNOWN_VALUE);
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("Confirm").bot();
                shell.button("OK").click();
            }
        });
    }

    @Test
    public void test_delete_method_noListener() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Property keyReleasedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "released");
        keyReleasedProperty.setValue(Property.UNKNOWN_VALUE);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_delete_method_noMethod() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    addKeyListener(new KeyAdapter() {", "      public void keyPressed(KeyEvent e) {", "      }", "    });", "  }", "}");
        Property keyReleasedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "released");
        keyReleasedProperty.setValue(Property.UNKNOWN_VALUE);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    addKeyListener(new KeyAdapter() {", "      public void keyPressed(KeyEvent e) {", "      }", "    });", "  }", "}");
    }

    @Test
    public void test_delete_method_Cancel() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    addKeyListener(new KeyAdapter() {", "      public void keyPressed(KeyEvent e) {", "      }", "    });", "  }", "}");
        final Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        String expectedSource = this.m_lastEditor.getSource();
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                keyPressedProperty.setValue(Property.UNKNOWN_VALUE);
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("Confirm").bot();
                shell.button("Cancel").click();
            }
        });
        EventsPropertyTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_delete_method() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    addKeyListener(new KeyAdapter() {", "      public void keyPressed(KeyEvent e) {", "      }", "    });", "  }", "}");
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        EventsPropertyTest.deleteEventPropertyWithGUI(keyPressedProperty);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_delete_methodWithStub() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    addKeyListener(new KeyAdapter() {", "      public void keyPressed(KeyEvent e) {", "        do_keyPressed(e);", "      }", "    });", "  }", "  public void do_keyPressed(KeyEvent e) {", "  }", "}");
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        EventsPropertyTest.deleteEventPropertyWithGUI(keyPressedProperty);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_delete_listener() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    addKeyListener(new KeyAdapter() {", "      public void keyPressed(KeyEvent e) {", "      }", "      public void keyReleased(KeyEvent e) {", "      }", "    });", "  }", "}");
        Property keyProperty = EventsPropertyTest.getEventsListener((JavaInfo)panel, "key");
        EventsPropertyTest.deleteEventPropertyWithGUI(keyProperty);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        EventsPropertyTest.assertEquals((Object)this.m_lastEditor.getSource(), (Object)this.m_lastEditor.getModelUnit().getSource());
    }

    @Test
    public void test_deleteInner_method() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    addKeyListener(new MyKeyListener());", "  }", "  private class MyKeyListener extends KeyAdapter {", "    public void keyPressed(KeyEvent e) {", "    }", "  }", "}");
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        EventsPropertyTest.assertTrue((boolean)keyPressedProperty.isModified());
        EventsPropertyTest.deleteEventPropertyWithGUI(keyPressedProperty);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_deleteInner_listener() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    addKeyListener(new MyKeyListener());", "  }", "  private class MyKeyListener extends KeyAdapter {", "    public void keyPressed(KeyEvent e) {", "    }", "  }", "}");
        Property keyProperty = EventsPropertyTest.getEventsListener((JavaInfo)panel, "key");
        EventsPropertyTest.assertTrue((boolean)keyProperty.isModified());
        EventsPropertyTest.deleteEventPropertyWithGUI(keyProperty);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_deleteInner_componentWithListener() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "    button.addKeyListener(new MyKeyListener());", "  }", "  private class MyKeyListener extends KeyAdapter {", "    public void keyPressed(KeyEvent e) {", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        button.delete();
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_deleteComponent_andOtherListeners() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "      button_1.addKeyListener(new KeyAdapter() {});", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "      button_2.addKeyListener(new KeyAdapter() {});", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        button_1.delete();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "      button_2.addKeyListener(new KeyAdapter() {});", "    }", "  }", "}");
    }

    @Test
    public void test_deleteInner_listener_twoUsages_deleteJavaInfo() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "      button.addKeyListener(new MyKeyListener());", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "      button_2.addKeyListener(new MyKeyListener());", "    }", "  }", "  private class MyKeyListener extends KeyAdapter {", "    public void keyPressed(KeyEvent e) {", "    }", "  }", "}");
        Object button = EventsPropertyTest.getJavaInfoByName("button");
        button.delete();
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "      button_2.addKeyListener(new MyKeyListener());", "    }", "  }", "  private class MyKeyListener extends KeyAdapter {", "    public void keyPressed(KeyEvent e) {", "    }", "  }", "}");
    }

    @Test
    public void test_deleteInner_listener_twoUsages_keepOne() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "      button.addKeyListener(new MyKeyListener());", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "      button_2.addKeyListener(new MyKeyListener());", "    }", "  }", "  private class MyKeyListener extends KeyAdapter {", "    public void keyPressed(KeyEvent e) {", "    }", "  }", "}");
        Object button = EventsPropertyTest.getJavaInfoByName("button");
        Property keyProperty = EventsPropertyTest.getEventsListener(button, "key");
        EventsPropertyTest.assertTrue((boolean)keyProperty.isModified());
        EventsPropertyTest.deleteInnerListener_twoUsages(keyProperty, "&No");
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "      button_2.addKeyListener(new MyKeyListener());", "    }", "  }", "  private class MyKeyListener extends KeyAdapter {", "    public void keyPressed(KeyEvent e) {", "    }", "  }", "}");
    }

    @Test
    public void test_deleteInner_listener_twoUsages_removeAll() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "      button.addKeyListener(new MyKeyListener());", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "      button_2.addKeyListener(new MyKeyListener());", "    }", "  }", "  private class MyKeyListener extends KeyAdapter {", "    public void keyPressed(KeyEvent e) {", "    }", "  }", "}");
        Object button = EventsPropertyTest.getJavaInfoByName("button");
        Property keyProperty = EventsPropertyTest.getEventsListener(button, "key");
        EventsPropertyTest.assertTrue((boolean)keyProperty.isModified());
        EventsPropertyTest.deleteInnerListener_twoUsages(keyProperty, "&Yes");
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "  }", "}");
    }

    private static void deleteInnerListener_twoUsages(final Property property, final String multiButton) throws Exception {
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                property.setValue(Property.UNKNOWN_VALUE);
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("Confirm").bot();
                shell.button("OK").click();
                bot.shell("Confirm").bot().button(multiButton).click();
            }
        });
    }

    @Test
    public void test_deleteThis_listener() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel implements KeyListener {", "  private final JButton m_button = new JButton();", "  Test() {", "    add(m_button);", "    m_button.addKeyListener(this);", "  }", "    public void keyPressed(KeyEvent e) {", "      // valid routing IfStatement", "      if (e.getSource() == m_button) {", "        onButton_keyPressed(e);", "      }", "    }", "    public void keyReleased(KeyEvent e) {", "    }", "    public void keyTyped(KeyEvent e) {", "    }", "    private void onButton_keyPressed(KeyEvent e) {", "    }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        button.delete();
        this.assertEditor("class Test extends JPanel implements KeyListener {", "  Test() {", "  }", "    public void keyPressed(KeyEvent e) {", "    }", "    public void keyReleased(KeyEvent e) {", "    }", "    public void keyTyped(KeyEvent e) {", "    }", "}");
    }

    @Test
    public void test_delete_method_interfaceWithDirectStub() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel implements KeyListener {", "  Test() {", "    addKeyListener(this);", "  }", "    public void keyPressed(KeyEvent e) {", "      onThis_keyPressed(e);", "    }", "    public void keyReleased(KeyEvent e) {", "    }", "    public void keyTyped(KeyEvent e) {", "    }", "    private void onThis_keyPressed(KeyEvent e) {", "    }", "}");
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        keyPressedProperty.setValue(Property.UNKNOWN_VALUE);
        this.assertEditor("class Test extends JPanel implements KeyListener {", "  Test() {", "    addKeyListener(this);", "  }", "    public void keyPressed(KeyEvent e) {", "    }", "    public void keyReleased(KeyEvent e) {", "    }", "    public void keyTyped(KeyEvent e) {", "    }", "}");
    }

    @Test
    public void test_delete_method_interfaceWithConditionalStub_block() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel implements KeyListener {", "  Test() {", "    addKeyListener(this);", "  }", "    public void keyPressed(KeyEvent e) {", "      if (e.getSource() == this) {", "        onThis_keyPressed(e);", "      }", "    }", "    public void keyReleased(KeyEvent e) {", "    }", "    public void keyTyped(KeyEvent e) {", "    }", "    private void onThis_keyPressed(KeyEvent e) {", "    }", "}");
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        keyPressedProperty.setValue(Property.UNKNOWN_VALUE);
        this.assertEditor("class Test extends JPanel implements KeyListener {", "  Test() {", "    addKeyListener(this);", "  }", "    public void keyPressed(KeyEvent e) {", "    }", "    public void keyReleased(KeyEvent e) {", "    }", "    public void keyTyped(KeyEvent e) {", "    }", "}");
    }

    @Test
    public void test_delete_method_interfaceWithConditionalStub_flat() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel implements KeyListener {", "  Test() {", "    addKeyListener(this);", "  }", "    public void keyPressed(KeyEvent e) {", "      if (e.getSource() == this)", "        onThis_keyPressed(e);", "    }", "    public void keyReleased(KeyEvent e) {", "    }", "    public void keyTyped(KeyEvent e) {", "    }", "    private void onThis_keyPressed(KeyEvent e) {", "    }", "}");
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        keyPressedProperty.setValue(Property.UNKNOWN_VALUE);
        this.assertEditor("class Test extends JPanel implements KeyListener {", "  Test() {", "    addKeyListener(this);", "  }", "    public void keyPressed(KeyEvent e) {", "    }", "    public void keyReleased(KeyEvent e) {", "    }", "    public void keyTyped(KeyEvent e) {", "    }", "}");
    }

    @Test
    public void test_delete_method_interfaceWithConditionalStub_plusOtherPlace() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel implements KeyListener {", "  Test() {", "    addKeyListener(this);", "    // not in listener, so ignored", "    onThis_keyPressed(null);", "  }", "    public void keyPressed(KeyEvent e) {", "      if (e.getSource() == this)", "        onThis_keyPressed(e);", "    }", "    public void keyReleased(KeyEvent e) {", "    }", "    public void keyTyped(KeyEvent e) {", "    }", "    private void onThis_keyPressed(KeyEvent e) {", "    }", "}");
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        keyPressedProperty.setValue(Property.UNKNOWN_VALUE);
        this.assertEditor("class Test extends JPanel implements KeyListener {", "  Test() {", "    addKeyListener(this);", "    // not in listener, so ignored", "    onThis_keyPressed(null);", "  }", "    public void keyPressed(KeyEvent e) {", "    }", "    public void keyReleased(KeyEvent e) {", "    }", "    public void keyTyped(KeyEvent e) {", "    }", "    private void onThis_keyPressed(KeyEvent e) {", "    }", "}");
    }

    @Test
    public void test_ensureListenerMethod_addListenerMethod() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    addKeyListener(new KeyAdapter() {", "    });", "  }", "}");
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    addKeyListener(new KeyAdapter() {", "      @Override", "      public void keyPressed(KeyEvent e) {", "      }", "    });", "  }", "}");
    }

    @Test
    public void test_ensureListenerMethod_addListener() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.codeType", 0);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    addKeyListener(new KeyAdapter() {", "      @Override", "      public void keyPressed(KeyEvent e) {", "      }", "    });", "  }", "}");
        keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "released");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    addKeyListener(new KeyAdapter() {", "      @Override", "      public void keyPressed(KeyEvent e) {", "      }", "      @Override", "      public void keyReleased(KeyEvent e) {", "      }", "    });", "  }", "}");
    }

    @Test
    public void test_addListener_deleteListener() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    addKeyListener(new KeyAdapter() {", "      @Override", "      public void keyPressed(KeyEvent e) {", "      }", "    });", "  }", "}");
        EventsPropertyTest.deleteEventPropertyWithGUI(keyPressedProperty);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_ensureListenerMethod_inner_badPosition() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.codeType", 1);
        preferences.setValue("property.events.innerClassPosition", -1);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        try {
            ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
            EventsPropertyTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_ensureListenerMethod_inner_firstInType() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.codeType", 1);
        preferences.setValue("property.events.innerClassPosition", 0);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  private class ThisKeyListener extends KeyAdapter {", "    @Override", "    public void keyPressed(KeyEvent e) {", "    }", "  }", "  public Test() {", "    addKeyListener(new ThisKeyListener());", "  }", "}");
    }

    @Test
    public void test_ensureListenerMethod_inner_lastInType() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "class Test extends JPanel {", "  Test() {", "  }", "}");
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.codeType", 1);
        preferences.setValue("property.events.innerClassPosition", 1);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("// filler filler filler", "class Test extends JPanel {", "  Test() {", "    addKeyListener(new ThisKeyListener());", "  }", "  private class ThisKeyListener extends KeyAdapter {", "    @Override", "    public void keyPressed(KeyEvent e) {", "    }", "  }", "}");
    }

    @Test
    public void test_ensureListenerMethod_inner_beforeExistingListener() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "  }", "  private class ThisMouseListener extends MouseAdapter {}", "}");
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.codeType", 1);
        preferences.setValue("property.events.innerClassPosition", 2);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    addKeyListener(new ThisKeyListener());", "  }", "  private class ThisKeyListener extends KeyAdapter {", "    @Override", "    public void keyPressed(KeyEvent e) {", "    }", "  }", "  private class ThisMouseListener extends MouseAdapter {}", "}");
    }

    @Test
    public void test_ensureListenerMethod_inner_beforeNotExistingListener() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "class Test extends JPanel {", "  Test() {", "  }", "}");
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.codeType", 1);
        preferences.setValue("property.events.innerClassPosition", 2);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("// filler filler filler", "class Test extends JPanel {", "  private class ThisKeyListener extends KeyAdapter {", "    @Override", "    public void keyPressed(KeyEvent e) {", "    }", "  }", "  Test() {", "    addKeyListener(new ThisKeyListener());", "  }", "}");
    }

    @Test
    public void test_ensureListenerMethod_inner_afterExistingListener() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  private class ThisMouseListener extends MouseAdapter {}", "  Test() {", "  }", "}");
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.codeType", 1);
        preferences.setValue("property.events.innerClassPosition", 3);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("class Test extends JPanel {", "  private class ThisMouseListener extends MouseAdapter {}", "  private class ThisKeyListener extends KeyAdapter {", "    @Override", "    public void keyPressed(KeyEvent e) {", "    }", "  }", "  Test() {", "    addKeyListener(new ThisKeyListener());", "  }", "}");
    }

    @Test
    public void test_ensureListenerMethod_inner_noAdapter() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.codeType", 1);
        preferences.setValue("property.events.innerClassPosition", 0);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)button, "action", "performed");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("class Test extends JPanel {", "  private class ButtonActionListener implements ActionListener {", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  Test() {", "    JButton button = new JButton();", "    button.addActionListener(new ButtonActionListener());", "    add(button);", "  }", "}");
    }

    @Test
    public void test_ensureListenerMethod_inner_exposedVariable() throws Exception {
        ContainerInfo frame = this.parseContainer("// filler filler filler", "class Test extends JFrame {", "  Test() {", "  }", "}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        IPreferenceStore preferences = frame.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.codeType", 1);
        preferences.setValue("property.events.innerClassPosition", 0);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)contentPane, "key", "pressed");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("// filler filler filler", "class Test extends JFrame {", "  private class ThisContentPaneKeyListener extends KeyAdapter {", "    @Override", "    public void keyPressed(KeyEvent e) {", "    }", "  }", "  Test() {", "    getContentPane().addKeyListener(new ThisContentPaneKeyListener());", "  }", "}");
    }

    @Test
    public void test_ensureListenerMethod_inner_nameTemplate() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.codeType", 1);
        preferences.setValue("property.events.innerClassPosition", 0);
        preferences.setValue("innerClassName", "${Listener_className}_${component_name}");
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  private class KeyListener_this extends KeyAdapter {", "    @Override", "    public void keyPressed(KeyEvent e) {", "    }", "  }", "  public Test() {", "    addKeyListener(new KeyListener_this());", "  }", "}");
    }

    @Test
    public void test_ensureListenerMethod_interface_1() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.codeType", 2);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel implements KeyListener {", "  public Test() {", "    addKeyListener(this);", "  }", "  public void keyPressed(KeyEvent e) {", "  }", "  public void keyReleased(KeyEvent e) {", "  }", "  public void keyTyped(KeyEvent e) {", "  }", "}");
    }

    @Test
    public void test_ensureStubMethod_interface_2() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.codeType", 2);
        preferences.setValue("property.events.stubCreate", true);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"ensureStubMethod()", (Object[])new Object[0]);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel implements KeyListener {", "  public Test() {", "    addKeyListener(this);", "  }", "  public void keyPressed(KeyEvent e) {", "    if (e.getSource() == this) {", "      do_this_keyPressed(e);", "    }", "  }", "  public void keyReleased(KeyEvent e) {", "  }", "  public void keyTyped(KeyEvent e) {", "  }", "  protected void do_this_keyPressed(KeyEvent e) {", "  }", "}");
    }

    @Test
    public void test_openStubMethod() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.stubCreate", true);
        ArgumentCaptor openSourcePosition = ArgumentCaptor.forClass(Integer.class);
        DesignPageSite pageSite = (DesignPageSite)Mockito.mock(DesignPageSite.class);
        DesignPageSite.Helper.setSite((ObjectInfo)panel, (IDesignPageSite)pageSite);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"openStubMethod()", (Object[])new Object[0]);
        EventsPropertyTest.waitEventLoop(0);
        ((DesignPageSite)Mockito.verify((Object)pageSite)).openSourcePosition(((Integer)openSourcePosition.capture()).intValue());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{pageSite});
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    addKeyListener(new KeyAdapter() {", "      @Override", "      public void keyPressed(KeyEvent e) {", "        do_this_keyPressed(e);", "      }", "    });", "  }", "  protected void do_this_keyPressed(KeyEvent e) {", "  }", "}");
        EventsPropertyTest.assertTrue(((Integer)openSourcePosition.getValue() != 0 ? 1 : 0) != 0);
        MethodDeclaration openMethod = this.m_lastEditor.getEnclosingMethod(((Integer)openSourcePosition.getValue()).intValue());
        EventsPropertyTest.assertEquals((Object)"do_this_keyPressed", (Object)openMethod.getName().getIdentifier());
        String expectedsource = this.m_lastEditor.getSource();
        Mockito.clearInvocations((Object[])new DesignPageSite[]{pageSite});
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"openStubMethod()", (Object[])new Object[0]);
        EventsPropertyTest.waitEventLoop(0);
        ((DesignPageSite)Mockito.verify((Object)pageSite)).openSourcePosition(((Integer)openSourcePosition.capture()).intValue());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{pageSite});
        EventsPropertyTest.assertEquals((Object)expectedsource, (Object)this.m_lastEditor.getSource());
    }

    @Test
    public void test_openStubMethod_whenInnerClass() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private class MyListener extends KeyAdapter {", "  }", "  public Test() {", "    addKeyListener(new MyListener());", "  }", "}");
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.stubCreate", true);
        DesignPageSite.Helper.setSite((ObjectInfo)panel, (IDesignPageSite)DesignPageSite.EMPTY);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"openStubMethod()", (Object[])new Object[0]);
        this.assertEditor("public class Test extends JPanel {", "  private class MyListener extends KeyAdapter {", "    @Override", "    public void keyPressed(KeyEvent e) {", "    }", "  }", "  public Test() {", "    addKeyListener(new MyListener());", "  }", "}");
    }

    @Test
    public void test_openStubMethod_noStub() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        DesignPageSite.Helper.setSite((ObjectInfo)panel, (IDesignPageSite)DesignPageSite.EMPTY);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"openStubMethod()", (Object[])new Object[0]);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    addKeyListener(new KeyAdapter() {", "      @Override", "      public void keyPressed(KeyEvent e) {", "      }", "    });", "  }", "}");
    }

    @Test
    public void test_ensureStubMethod_noStub() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        DesignPageSite.Helper.setSite((ObjectInfo)panel, (IDesignPageSite)DesignPageSite.EMPTY);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        MethodDeclaration listenerMethod = (MethodDeclaration)ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"ensureStubMethod()", (Object[])new Object[0]);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    addKeyListener(new KeyAdapter() {", "      @Override", "      public void keyPressed(KeyEvent e) {", "      }", "    });", "  }", "}");
        EventsPropertyTest.assertEquals((Object)"keyPressed", (Object)listenerMethod.getName().getIdentifier());
    }

    @Test
    public void test_openStubMethod_noStub2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    addKeyListener(new KeyAdapter() {", "      public void keyPressed(KeyEvent e) {", "      }", "    });", "  }", "}");
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.stubCreate", true);
        DesignPageSite.Helper.setSite((ObjectInfo)panel, (IDesignPageSite)DesignPageSite.EMPTY);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"openStubMethod()", (Object[])new Object[0]);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    addKeyListener(new KeyAdapter() {", "      public void keyPressed(KeyEvent e) {", "      }", "    });", "  }", "}");
    }

    @Test
    public void test_openStubMethod_static() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test {", "  public static void main(String [] args) {", "    JPanel panel = new JPanel();", "  }", "}");
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.stubCreate", true);
        DesignPageSite.Helper.setSite((ObjectInfo)panel, (IDesignPageSite)DesignPageSite.EMPTY);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"openStubMethod()", (Object[])new Object[0]);
        this.assertEditor("class Test {", "  public static void main(String [] args) {", "    JPanel panel = new JPanel();", "    panel.addKeyListener(new KeyAdapter() {", "      @Override", "      public void keyPressed(KeyEvent e) {", "        do_panel_keyPressed(e);", "      }", "    });", "  }", "  protected static void do_panel_keyPressed(KeyEvent e) {", "  }", "}");
    }

    @Test
    public void test_openStubMethod_whenLocalClass() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    class MyListener extends KeyAdapter {", "    }", "    addKeyListener(new MyListener());", "  }", "}");
        DesignPageSite.Helper.setSite((ObjectInfo)panel, (IDesignPageSite)DesignPageSite.EMPTY);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"openStubMethod()", (Object[])new Object[0]);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    class MyListener extends KeyAdapter {", "      @Override", "      public void keyPressed(KeyEvent e) {", "      }", "    }", "    addKeyListener(new MyListener());", "  }", "}");
    }

    @Test
    public void test_openStubListenerMethod_valid() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        DesignPageSite pageSite = (DesignPageSite)Mockito.mock(DesignPageSite.class);
        DesignPageSite.Helper.setSite((ObjectInfo)panel, (IDesignPageSite)pageSite);
        EventsProperty eventsProperty = (EventsProperty)panel.getPropertyByTitle("Events");
        eventsProperty.openStubMethod("key/pressed");
        EventsPropertyTest.waitEventLoop(0);
        ((DesignPageSite)Mockito.verify((Object)pageSite)).openSourcePosition(ArgumentMatchers.anyInt());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{pageSite});
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    addKeyListener(new KeyAdapter() {", "      @Override", "      public void keyPressed(KeyEvent e) {", "      }", "    });", "  }", "}");
    }

    @Test
    public void test_openStubListenerMethod_openSource() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)EventsPropertyTest.getJavaInfoByName("button");
        ArgumentCaptor openSourcePosition = ArgumentCaptor.forClass(Integer.class);
        IDesignPageSite pageSite = (IDesignPageSite)Mockito.mock(IDesignPageSite.class);
        DesignPageSite.Helper.setSite((ObjectInfo)button, (IDesignPageSite)pageSite);
        EventsProperty eventsProperty = (EventsProperty)button.getPropertyByTitle("Events");
        eventsProperty.openStubMethod("wbp:openSource");
        EventsPropertyTest.waitEventLoop(0);
        ((IDesignPageSite)Mockito.verify((Object)pageSite)).openSourcePosition(((Integer)openSourcePosition.capture()).intValue());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{pageSite});
        EventsPropertyTest.assertEquals((long)button.getCreationSupport().getNode().getStartPosition(), (long)((Integer)openSourcePosition.getValue()).intValue());
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_openStubListenerMethod_sendBroadcast() throws Exception {
        String name = "wbp:broadcast with parameters";
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        DesignPageSite.Helper.setSite((ObjectInfo)panel, (IDesignPageSite)DesignPageSite.EMPTY);
        final AtomicReference broSpec = new AtomicReference();
        panel.addBroadcastListener((Object)new JavaInfoEventOpen(){

            public void invoke(JavaInfo javaInfo, String spec) throws Exception {
                broSpec.set(spec);
            }
        });
        EventsProperty eventsProperty = (EventsProperty)panel.getPropertyByTitle("Events");
        eventsProperty.openStubMethod(name);
        EventsPropertyTest.waitEventLoop(0);
        EventsPropertyTest.assertEquals((Object)name, broSpec.get());
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_openStubListenerMethod_invalid() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        IDesignPageSite pageSite = (IDesignPageSite)Mockito.mock(IDesignPageSite.class);
        DesignPageSite.Helper.setSite((ObjectInfo)panel, (IDesignPageSite)pageSite);
        EventsProperty eventsProperty = (EventsProperty)panel.getPropertyByTitle("Events");
        eventsProperty.openStubMethod("no-such-listener/no-matter-what-method");
        Mockito.verifyNoInteractions((Object[])new Object[]{pageSite});
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_ensureListenerMethod_customListener() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/MyListener.java", EventsPropertyTest.getSourceDQ("package test;", "public interface MyListener {", "  void click(Object widget, int x, int y);", "  int offset();", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler", "public class MyPanel extends JPanel {", "  public void addMyListener(MyListener listener) {", "  }", "}"));
        EventsPropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        Property clickProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "my", "click");
        ReflectionUtils.invokeMethod((Object)clickProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    addMyListener(new MyListener() {", "      public void click(Object widget, int x, int y) {", "      }", "      public int offset() {", "        return 0;", "      }", "    });", "  }", "}");
    }

    @Test
    public void test_ensureListenerMethod_listenerInConstructor() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(String text, FocusListener listener) {", "  }", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyButton.wbp-component.xml", EventsPropertyTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.lang.String'/>", "      <parameter type='java.awt.event.FocusListener'>", "        <tag name='events: add listener method' value='addFocusListener(java.awt.event.FocusListener)'/>", "      </parameter>", "    </constructor>", "  </constructors>", "</component>"));
        EventsPropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton('text', new FocusAdapter() {", "      public void focusGained(FocusEvent e) {}", "    });", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property focusGainedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)button, "focus", "gained");
        EventsPropertyTest.assertNotNull((Object)focusGainedProperty);
        EventsPropertyTest.assertTrue((boolean)focusGainedProperty.isModified());
    }

    @Test
    public void test_listenerInConstructor_inVariable() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(String text, FocusListener listener) {", "  }", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyButton.wbp-component.xml", EventsPropertyTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.lang.String'/>", "      <parameter type='java.awt.event.FocusListener'>", "        <tag name='events: add listener method' value='addFocusListener(java.awt.event.FocusListener)'/>", "      </parameter>", "    </constructor>", "  </constructors>", "</component>"));
        EventsPropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    FocusListener listener = new FocusAdapter() {", "      public void focusGained(FocusEvent e0) {}", "    };", "    MyButton button = new MyButton('text', listener);", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        String expectedSource = this.m_lastEditor.getSource();
        MethodDeclaration listenerMethod = EventsPropertyTest.ensureListenerMethod((JavaInfo)button, "focus", "gained");
        EventsPropertyTest.assertEditor(expectedSource, this.m_lastEditor);
        EventsPropertyTest.assertEquals((Object)"public void focusGained(FocusEvent e0) {}", (Object)this.m_lastEditor.getSource((ASTNode)listenerMethod));
    }

    @Test
    public void test_ensureListenerMethod_final() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    addKeyListener(new KeyAdapter() {", "    });", "  }", "}");
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.finalParameters", true);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        ReflectionUtils.invokeMethod((Object)keyPressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    addKeyListener(new KeyAdapter() {", "      @Override", "      public void keyPressed(final KeyEvent e) {", "      }", "    });", "  }", "}");
    }

    @Test
    public void test_decorateIcon() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "      button_1.addKeyListener(new KeyAdapter() {", "      });", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        EventsPropertyTest.assertNotSame((Object)button_1.getPresentation().getIcon(), (Object)ObjectInfo.getImageDescriptor((ObjectInfo)button_1));
        EventsPropertyTest.assertSame((Object)button_2.getPresentation().getIcon(), (Object)ObjectInfo.getImageDescriptor((ObjectInfo)button_2));
        panel.getDescription().getToolkit().getPreferences().setValue("property.events.decorateIcon", false);
        EventsPropertyTest.assertSame((Object)button_1.getPresentation().getIcon(), (Object)ObjectInfo.getImageDescriptor((ObjectInfo)button_1));
        EventsPropertyTest.assertSame((Object)button_2.getPresentation().getIcon(), (Object)ObjectInfo.getImageDescriptor((ObjectInfo)button_2));
    }

    @Test
    public void test_ListenerMethodPropertyEditor_doubleClick() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    addKeyListener(new KeyAdapter() {", "      public void keyReleased(KeyEvent e) {", "      }", "    });", "  }", "}");
        DesignPageSite.Helper.setSite((ObjectInfo)panel, (IDesignPageSite)DesignPageSite.EMPTY);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        Property keyReleasedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "released");
        EventsPropertyTest.assertNull((Object)EventsPropertyTest.getPropertyText(keyPressedProperty));
        EventsPropertyTest.assertEquals((Object)"line 8", (Object)EventsPropertyTest.getPropertyText(keyReleasedProperty));
        PropertyEditor keyPressedEditor = keyPressedProperty.getEditor();
        keyPressedEditor.doubleClick(keyPressedProperty, null);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    addKeyListener(new KeyAdapter() {", "      public void keyReleased(KeyEvent e) {", "      }", "      @Override", "      public void keyPressed(KeyEvent e) {", "      }", "    });", "  }", "}");
    }

    @Test
    public void test_ListenerMethodPropertyEditor_activate() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    addKeyListener(new KeyAdapter() {", "    });", "  }", "}");
        DesignPageSite.Helper.setSite((ObjectInfo)panel, (IDesignPageSite)DesignPageSite.EMPTY);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        EventsPropertyTest.assertNull((Object)EventsPropertyTest.getPropertyText(keyPressedProperty));
        PropertyEditor keyPressedEditor = keyPressedProperty.getEditor();
        keyPressedEditor.activate(null, keyPressedProperty, null);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    addKeyListener(new KeyAdapter() {", "      @Override", "      public void keyPressed(KeyEvent e) {", "      }", "    });", "  }", "}");
    }

    @Test
    public void test_addXHandler() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void addMyCoolHandler(KeyListener listener) {", "  }", "}"));
        EventsPropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        EventsProperty eventsProperty = (EventsProperty)panel.getPropertyByTitle("Events");
        Property myCoolProperty = EventsPropertyTest.getPropertyByTitle(EventsPropertyTest.getSubProperties((Property)eventsProperty), "myCool");
        EventsPropertyTest.assertNotNull((Object)myCoolProperty);
    }

    @Test
    public void test_listenerAsClass() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/MyListener.java", this.getTestSource("public abstract class MyListener implements java.util.EventListener {", "  public abstract void handle(KeyEvent event);", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void addMyListener(MyListener listener) {", "  }", "}"));
        EventsPropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        Property listener = EventsPropertyTest.getEventsListener((JavaInfo)panel, "my");
        EventsPropertyTest.assertNotNull((Object)listener);
        Object[] methods = EventsPropertyTest.getSubProperties(listener);
        Assertions.assertThat((Object[])methods).hasSize(1);
        EventsPropertyTest.assertEquals((Object)"handle", (Object)methods[0].getTitle());
        EventsPropertyTest.ensureListenerMethod((JavaInfo)panel, "my", "handle");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    addMyListener(new MyListener() {", "      public void handle(KeyEvent event) {", "      }", "    });", "  }", "}");
    }

    @Test
    public void test_listenerAsClass_innerType() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/MyListener.java", this.getTestSource("public abstract class MyListener implements java.util.EventListener {", "  public abstract void handle(KeyEvent event);", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void addMyListener(MyListener listener) {", "  }", "}"));
        EventsPropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.codeType", 1);
        preferences.setValue("property.events.innerClassPosition", 0);
        EventsPropertyTest.ensureListenerMethod((JavaInfo)panel, "my", "handle");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  private class ThisMyListener extends MyListener {", "    public void handle(KeyEvent event) {", "    }", "  }", "  public Test() {", "    addMyListener(new ThisMyListener());", "  }", "}");
    }

    @Test
    public void test_listenerAsClass_useDeclaredNonAbstractMethods() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/MyListener.java", this.getTestSource("public abstract class MyListener implements java.util.EventListener {", "  public void handle(KeyEvent event) {", "  }", "  public void handle2(KeyEvent event) {", "  }", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void addMyListener(MyListener listener) {", "  }", "}"));
        EventsPropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        Property listener = EventsPropertyTest.getEventsListener((JavaInfo)panel, "my");
        EventsPropertyTest.assertNotNull((Object)listener);
        Object[] methods = EventsPropertyTest.getSubProperties(listener);
        Assertions.assertThat((Object[])methods).hasSize(2);
        EventsPropertyTest.assertEquals((Object)"handle", (Object)methods[0].getTitle());
        EventsPropertyTest.assertEquals((Object)"handle2", (Object)methods[1].getTitle());
        EventsPropertyTest.ensureListenerMethod((JavaInfo)panel, "my", "handle");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    addMyListener(new MyListener() {", "      public void handle(KeyEvent event) {", "      }", "    });", "  }", "}");
    }

    @Test
    public void test_listenerAsClass_implementGenericInterface() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/MyInterface.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public interface MyInterface<E> {", "  void handle(E event);", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyListener.java", this.getTestSource("public abstract class MyListener implements MyInterface<KeyEvent> {", "  public void handle(KeyEvent event) {", "  }", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void addMyListener(MyListener listener) {", "  }", "}"));
        EventsPropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        Property listener = EventsPropertyTest.getEventsListener((JavaInfo)panel, "my");
        EventsPropertyTest.assertNotNull((Object)listener);
        Object[] methods = EventsPropertyTest.getSubProperties(listener);
        Assertions.assertThat((Object[])methods).hasSize(1);
        EventsPropertyTest.assertEquals((Object)"handle", (Object)methods[0].getTitle());
    }

    @Test
    public void test_listenerWithGeneric() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/MyListener.java", this.getTestSource("public abstract class MyListener<E extends java.awt.event.ComponentEvent> {", "  public abstract void handle(E event);", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void addMyListener(MyListener<KeyEvent> listener) {", "  }", "}"));
        EventsPropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        Property listener = EventsPropertyTest.getEventsListener((JavaInfo)panel, "my");
        EventsPropertyTest.assertNotNull((Object)listener);
        Object[] methods = EventsPropertyTest.getSubProperties(listener);
        Assertions.assertThat((Object[])methods).hasSize(1);
        EventsPropertyTest.assertEquals((Object)"handle", (Object)methods[0].getTitle());
        EventsPropertyTest.ensureListenerMethod((JavaInfo)panel, "my", "handle");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    addMyListener(new MyListener<KeyEvent>() {", "      public void handle(KeyEvent event) {", "      }", "    });", "  }", "}");
    }

    @Test
    public void test_listenerWithGeneric_innerType() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/MyListener.java", this.getTestSource("public abstract class MyListener<E extends java.awt.event.ComponentEvent> {", "  public abstract void handle(E event);", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void addMyListener(MyListener<KeyEvent> listener) {", "  }", "}"));
        EventsPropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.codeType", 1);
        preferences.setValue("property.events.innerClassPosition", 0);
        EventsPropertyTest.ensureListenerMethod((JavaInfo)panel, "my", "handle");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  private class ThisMyListener extends MyListener<KeyEvent> {", "    public void handle(KeyEvent event) {", "    }", "  }", "  public Test() {", "    addMyListener(new ThisMyListener());", "  }", "}");
    }

    @Test
    public void test_listenerWithGeneric_parameterizedEvent() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/MyEvent.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public abstract class MyEvent<E> {", "  public E value;", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyListener.java", this.getTestSource("public abstract class MyListener<E> {", "  public abstract void handle(MyEvent<E> event);", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void addMyListener(MyListener<String> listener) {", "  }", "}"));
        EventsPropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        Property listener = EventsPropertyTest.getEventsListener((JavaInfo)panel, "my");
        EventsPropertyTest.assertNotNull((Object)listener);
        Object[] methods = EventsPropertyTest.getSubProperties(listener);
        Assertions.assertThat((Object[])methods).hasSize(1);
        EventsPropertyTest.assertEquals((Object)"handle", (Object)methods[0].getTitle());
        EventsPropertyTest.ensureListenerMethod((JavaInfo)panel, "my", "handle");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    addMyListener(new MyListener<String>() {", "      public void handle(MyEvent<String> event) {", "      }", "    });", "  }", "}");
    }

    @Test
    public void test_listenerWithGeneric_parameterizedEvent_actualInType() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/MyEvent.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public abstract class MyEvent<E> {", "  public E value;", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyListener.java", this.getTestSource("public abstract class MyListener<E> {", "  public abstract void handle(MyEvent<E> event);", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel<D> extends JPanel {", "  public void addMyListener(MyListener<D> listener) {", "  }", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyPanel2.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler", "public class MyPanel2<D2> extends MyPanel<D2> {", "}"));
        EventsPropertyTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      MyPanel2<String> inner = new MyPanel2<String>();", "      add(inner);", "    }", "  }", "}");
        ContainerInfo inner = (ContainerInfo)EventsPropertyTest.getJavaInfoByName("inner");
        Property listener = EventsPropertyTest.getEventsListener((JavaInfo)inner, "my");
        EventsPropertyTest.assertNotNull((Object)listener);
        Object[] methods = EventsPropertyTest.getSubProperties(listener);
        Assertions.assertThat((Object[])methods).hasSize(1);
        EventsPropertyTest.assertEquals((Object)"handle", (Object)methods[0].getTitle());
        EventsPropertyTest.ensureListenerMethod((JavaInfo)inner, "my", "handle");
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      MyPanel2<String> inner = new MyPanel2<String>();", "      inner.addMyListener(new MyListener<String>() {", "        public void handle(MyEvent<String> event) {", "        }", "      });", "      add(inner);", "    }", "  }", "}");
    }

    @Test
    public void test_listenerWithGeneric_parameterizedEvent_actualInSuperclass() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/MyEvent.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public abstract class MyEvent<E> {", "  public E value;", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyListener.java", this.getTestSource("// filler filler filler filler filler", "public abstract class MyListener<E> {", "  public abstract void handle(MyEvent<E> event);", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "public class MyPanel<D> extends JPanel {", "  public void addMyListener(MyListener<D> listener) {", "  }", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyPanel2.java", this.getTestSource("// filler filler filler filler filler", "public class MyPanel2<D2> extends MyPanel<D2> {", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyPanel3.java", this.getTestSource("// filler filler filler filler filler", "public class MyPanel3<D3> extends MyPanel2<D3> {", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyPanel4.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel4 extends MyPanel3<String> {", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyPanel5.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel5 extends MyPanel4 {", "}"));
        EventsPropertyTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      MyPanel5 inner = new MyPanel5();", "      add(inner);", "    }", "  }", "}");
        ContainerInfo inner = (ContainerInfo)EventsPropertyTest.getJavaInfoByName("inner");
        EventsPropertyTest.ensureListenerMethod((JavaInfo)inner, "my", "handle");
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      MyPanel5 inner = new MyPanel5();", "      inner.addMyListener(new MyListener<String>() {", "        public void handle(MyEvent<String> event) {", "        }", "      });", "      add(inner);", "    }", "  }", "}");
    }

    @Test
    public void test_listenerWithGeneric_parameterizedEvent_noTypeArgument() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/MyEvent.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public abstract class MyEvent<E> {", "  public E value;", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyListener.java", this.getTestSource("public abstract class MyListener<E> {", "  public abstract void handle(MyEvent<E> event);", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel<D> extends JPanel {", "  public void addMyListener(MyListener<D> listener) {", "  }", "}"));
        EventsPropertyTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      MyPanel inner = new MyPanel();", "      add(inner);", "    }", "  }", "}");
        ContainerInfo inner = (ContainerInfo)EventsPropertyTest.getJavaInfoByName("inner");
        Property listener = EventsPropertyTest.getEventsListener((JavaInfo)inner, "my");
        EventsPropertyTest.assertNotNull((Object)listener);
        Object[] methods = EventsPropertyTest.getSubProperties(listener);
        Assertions.assertThat((Object[])methods).hasSize(1);
        EventsPropertyTest.assertEquals((Object)"handle", (Object)methods[0].getTitle());
        EventsPropertyTest.ensureListenerMethod((JavaInfo)inner, "my", "handle");
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      MyPanel inner = new MyPanel();", "      inner.addMyListener(new MyListener<Object>() {", "        public void handle(MyEvent<Object> event) {", "        }", "      });", "      add(inner);", "    }", "  }", "}");
    }

    @Test
    public void test_listenerWithGeneric_pureTypeVariable() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/MyListener.java", this.getTestSource("public abstract class MyListener<E> {", "  public abstract void handle(E object);", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel<T> extends JPanel {", "  public void addMyListener(MyListener<T> listener) {", "  }", "}"));
        EventsPropertyTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler filler filler", "public class Test<T> extends JPanel {", "  public Test() {", "    MyPanel<T> myPanel = new MyPanel<T>();", "    add(myPanel);", "  }", "}");
        ContainerInfo myPanel = (ContainerInfo)EventsPropertyTest.getJavaInfoByName("myPanel");
        Property listener = EventsPropertyTest.getEventsListener((JavaInfo)myPanel, "my");
        EventsPropertyTest.assertNotNull((Object)listener);
        Object[] methods = EventsPropertyTest.getSubProperties(listener);
        Assertions.assertThat((Object[])methods).hasSize(1);
        EventsPropertyTest.assertEquals((Object)"handle", (Object)methods[0].getTitle());
        EventsPropertyTest.ensureListenerMethod((JavaInfo)myPanel, "my", "handle");
        this.assertEditor("// filler filler filler filler filler", "public class Test<T> extends JPanel {", "  public Test() {", "    MyPanel<T> myPanel = new MyPanel<T>();", "    myPanel.addMyListener(new MyListener<T>() {", "      public void handle(T object) {", "      }", "    });", "    add(myPanel);", "  }", "}");
    }

    @Test
    public void test_addListener_justSuchName() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void addListener(KeyListener listener) {", "  }", "}"));
        EventsPropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        Property listenerProperty = EventsPropertyTest.getEventsListener((JavaInfo)panel, "addListener");
        EventsPropertyTest.assertNotNull((Object)listenerProperty);
        Property pressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "addListener", "keyPressed");
        ReflectionUtils.invokeMethod((Object)pressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    addListener(new KeyAdapter() {", "      @Override", "      public void keyPressed(KeyEvent e) {", "      }", "    });", "  }", "}");
    }

    @Test
    public void test_addMyListenerAdapter() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/MyListener.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public interface MyListener {", "  void down();", "  void up();", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyListenerAdapter.java", this.getTestSource("public class MyListenerAdapter implements MyListener {", "  public void down() {", "  }", "  public void up() {", "  }", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void addMyListener(MyListener listener) {", "  }", "}"));
        EventsPropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        Property pressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "my", "down");
        ReflectionUtils.invokeMethod((Object)pressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    addMyListener(new MyListenerAdapter() {", "      @Override", "      public void down() {", "      }", "    });", "  }", "}");
    }

    @Test
    public void test_addAdapterInheritance() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/SuperListener.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public interface SuperListener {", "  void foo(int fooValue);", "}"));
        EventsPropertyTest.setFileContentSrc("test/SubListener.java", this.getTestSource("public interface SubListener extends SuperListener {", "  void bar(int barValue);", "}"));
        EventsPropertyTest.setFileContentSrc("test/SuperListenerAdapter.java", this.getTestSource("public class SuperListenerAdapter implements SuperListener {", "  public void foo(int fooValue) {", "  }", "}"));
        EventsPropertyTest.setFileContentSrc("test/SubListenerAdapter.java", this.getTestSource("public class SubListenerAdapter extends SuperListenerAdapter implements SuperListener {", "  public void bar(int barValue) {", "  }", "}"));
        EventsPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void addSubListener(SubListener listener) {", "  }", "}"));
        EventsPropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        Property pressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "sub", "foo");
        ReflectionUtils.invokeMethod((Object)pressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    addSubListener(new SubListenerAdapter() {", "      @Override", "      public void foo(int fooValue) {", "      }", "    });", "  }", "}");
    }

    @Test
    public void test_listenerAsInnerTypeOfComponent_anonymous() throws Exception {
        this.prepare_listenerAsInnerTypeOfComponent();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        Property pressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "my", "handle");
        ReflectionUtils.invokeMethod((Object)pressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("import test.MyPanel.MyListener;", "import test.MyPanel.MyEvent;", "// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    addMyListener(new MyListener() {", "      public void handle(MyEvent event) {", "      }", "    });", "  }", "}");
    }

    @Test
    public void test_listenerAsInnerTypeOfComponent_inner() throws Exception {
        this.prepare_listenerAsInnerTypeOfComponent();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.codeType", 1);
        preferences.setValue("property.events.innerClassPosition", 0);
        Property pressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "my", "handle");
        ReflectionUtils.invokeMethod((Object)pressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("import test.MyPanel.MyListener;", "import test.MyPanel.MyEvent;", "// filler filler filler", "public class Test extends MyPanel {", "  private class ThisMyListener implements MyListener {", "    public void handle(MyEvent event) {", "    }", "  }", "  public Test() {", "    addMyListener(new ThisMyListener());", "  }", "}");
    }

    @Test
    public void test_listenerAsInnerTypeOfComponent_innerAdapter() throws Exception {
        this.prepare_listenerAsInnerTypeOfComponent_withAdapter();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.codeType", 1);
        preferences.setValue("property.events.innerClassPosition", 0);
        Property pressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "my", "handle");
        ReflectionUtils.invokeMethod((Object)pressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("import test.MyPanel.MyAdapter;", "import test.MyPanel.MyEvent;", "// filler filler filler", "public class Test extends MyPanel {", "  private class ThisMyListener extends MyAdapter {", "    public void handle(MyEvent event) {", "    }", "  }", "  public Test() {", "    addMyListener(new ThisMyListener());", "  }", "}");
    }

    @Test
    public void test_listenerAsInnerTypeOfComponent_interface() throws Exception {
        this.prepare_listenerAsInnerTypeOfComponent();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        preferences.setValue("property.events.codeType", 2);
        Property pressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "my", "handle");
        ReflectionUtils.invokeMethod((Object)pressedProperty, (String)"ensureListenerMethod()", (Object[])new Object[0]);
        this.assertEditor("import test.MyPanel.MyListener;", "import test.MyPanel.MyEvent;", "// filler filler filler", "public class Test extends MyPanel implements MyListener {", "  public Test() {", "    addMyListener(this);", "  }", "  public void handle(MyEvent event) {", "  }", "}");
    }

    private void prepare_listenerAsInnerTypeOfComponent() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public class MyEvent {", "  }", "  public interface MyListener {", "    void handle(MyEvent event);", "  }", "  public void addMyListener(MyListener listener) {", "  }", "}"));
        EventsPropertyTest.waitForAutoBuild();
    }

    private void prepare_listenerAsInnerTypeOfComponent_withAdapter() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public class MyEvent {", "  }", "  public interface MyListener {", "    void handle(MyEvent event);", "  }", "  public class MyAdapter implements MyListener {", "    public void handle(MyEvent event) {", "    }", "  }", "  public void addMyListener(MyListener listener) {", "  }", "}"));
        EventsPropertyTest.waitForAutoBuild();
    }

    @Test
    public void test_understand() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    this.addKeyListener(new KeyAdapter() {", "      public void keyReleased(KeyEvent e) {", "      }", "    });", "  }", "}");
        DesignPageSite.Helper.setSite((ObjectInfo)panel, (IDesignPageSite)DesignPageSite.EMPTY);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        Property keyReleasedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "released");
        EventsPropertyTest.assertNull((Object)EventsPropertyTest.getPropertyText(keyPressedProperty));
        EventsPropertyTest.assertEquals((Object)"line 8", (Object)EventsPropertyTest.getPropertyText(keyReleasedProperty));
    }

    @Test
    public void test_understandLambda() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    this.addMouseWheelListener((event) -> {});", "  }", "}");
        DesignPageSite.Helper.setSite((ObjectInfo)panel, (IDesignPageSite)DesignPageSite.EMPTY);
        Property propertyChangeProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "mouseWheel", "moved");
        EventsPropertyTest.assertEquals((Object)"line 7", (Object)EventsPropertyTest.getPropertyText(propertyChangeProperty));
    }

    @Test
    public void test_understandLambda_noBlock() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    this.addMouseWheelListener((event) -> System.out.println(event));", "  }", "}");
        DesignPageSite.Helper.setSite((ObjectInfo)panel, (IDesignPageSite)DesignPageSite.EMPTY);
        Property propertyChangeProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "mouseWheel", "moved");
        EventsPropertyTest.assertEquals((Object)"line 7", (Object)EventsPropertyTest.getPropertyText(propertyChangeProperty));
    }

    @Test
    public void test_understandLambda_doubleColon() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    this.addMouseWheelListener(System.out::println);", "  }", "}");
        DesignPageSite.Helper.setSite((ObjectInfo)panel, (IDesignPageSite)DesignPageSite.EMPTY);
        Property propertyChangeProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "mouseWheel", "moved");
        EventsPropertyTest.assertEquals((Object)"line 7", (Object)EventsPropertyTest.getPropertyText(propertyChangeProperty));
    }

    @Test
    public void test_understandLambda_factory() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    this.addMouseWheelListener(mouseWheelMovedAdapter((event) -> {}));", "  }", "  static MouseWheelListener mouseWheelMovedAdapter(java.util.function.Consumer<MouseWheelEvent> c) {", "    return new MouseAdapter() {", "      @Override", "      public void mouseWheelMoved(MouseWheelEvent e) {", "        c.accept(e);", "      }", "    };", "  }", "}");
        DesignPageSite.Helper.setSite((ObjectInfo)panel, (IDesignPageSite)DesignPageSite.EMPTY);
        Property propertyChangeProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "mouseWheel", "moved");
        EventsPropertyTest.assertEquals((Object)"line 7", (Object)EventsPropertyTest.getPropertyText(propertyChangeProperty));
    }

    @Test
    public void test_contextMenu() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    addKeyListener(new KeyAdapter() {", "      public void keyReleased(KeyEvent e) {", "      }", "    });", "  }", "}");
        DesignPageSite.Helper.setSite((ObjectInfo)panel, (IDesignPageSite)DesignPageSite.EMPTY);
        Property keyPressedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "pressed");
        Property keyReleasedProperty = EventsPropertyTest.getEventsListenerMethod((JavaInfo)panel, "key", "released");
        EventsPropertyTest.assertNull((Object)EventsPropertyTest.getPropertyText(keyPressedProperty));
        EventsPropertyTest.assertEquals((Object)"line 8", (Object)EventsPropertyTest.getPropertyText(keyReleasedProperty));
        MenuManager manager = EventsPropertyTest.getDesignerMenuManager();
        panel.getBroadcastObject().addContextMenu(null, (ObjectInfo)panel, (IMenuManager)manager);
        IAction keyReleasedAction = EventsPropertyTest.findChildAction((IContributionManager)manager, "keyReleased -> line 8");
        EventsPropertyTest.assertNotNull((Object)keyReleasedAction);
        EventsPropertyTest.assertSame((Object)EventsPropertyUtils.LISTENER_METHOD_IMAGE_DESCRIPTOR, (Object)keyReleasedAction.getImageDescriptor());
        String expectedSource = this.m_lastEditor.getSource();
        keyReleasedAction.run();
        EventsPropertyTest.assertEditor(expectedSource, this.m_lastEditor);
        IMenuManager manager2 = EventsPropertyTest.findChildMenuManager((IContributionManager)manager, "Add event handler");
        manager2 = EventsPropertyTest.findChildMenuManager((IContributionManager)manager2, "key");
        EventsPropertyTest.assertSame((Object)EventsPropertyUtils.EXISTING_CLASS_IMAGE, (Object)((MenuManagerEx)manager2).getImage());
        IAction keyPressedAction = EventsPropertyTest.findChildAction((IContributionManager)manager2, "keyPressed");
        EventsPropertyTest.assertNotNull((Object)keyPressedAction);
        keyPressedAction.run();
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    addKeyListener(new KeyAdapter() {", "      public void keyReleased(KeyEvent e) {", "      }", "      @Override", "      public void keyPressed(KeyEvent e) {", "      }", "    });", "  }", "}");
        manager2 = EventsPropertyTest.findChildMenuManager((IContributionManager)manager, "Add event handler");
        EventsPropertyTest.assertSame((Object)EventsPropertyUtils.LISTENER_INTERFACE_IMAGE, (Object)((MenuManagerEx)EventsPropertyTest.findChildMenuManager((IContributionManager)manager2, "ancestor")).getImage());
    }

    @Test
    public void test_deprecatedListenerMethod() throws Exception {
        EventsPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  @Deprecated", "  public void addMyListener(KeyListener listener) {", "  }", "}"));
        EventsPropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        Property listener = EventsPropertyTest.getEventsListener((JavaInfo)panel, "my");
        EventsPropertyTest.assertNotNull((Object)listener);
        EventsPropertyTest.assertSame((Object)PropertyCategory.ADVANCED, (Object)listener.getCategory());
        IMenuManager panelManager = EventsPropertyTest.getContextMenu(new ObjectInfo[]{panel});
        IMenuManager eventManager = EventsPropertyTest.findChildMenuManager((IContributionManager)panelManager, "Add event handler");
        IMenuManager myManager = EventsPropertyTest.findChildMenuManager((IContributionManager)eventManager, "my");
        EventsPropertyTest.assertNull((Object)myManager);
    }

    public static Property[] getEventListeners(JavaInfo javaInfo) throws Exception {
        Property eventsProperty = javaInfo.getPropertyByTitle("Events");
        return EventsPropertyTest.getSubProperties(eventsProperty);
    }

    public static Property getEventsListener(JavaInfo javaInfo, String listener) throws Exception {
        Property[] subProperties = EventsPropertyTest.getEventListeners(javaInfo);
        return EventsPropertyTest.getPropertyByTitle(subProperties, listener);
    }

    public static Property getEventsListenerMethod(JavaInfo javaInfo, String listener, String method) throws Exception {
        Property listenerProperty = EventsPropertyTest.getEventsListener(javaInfo, listener);
        return EventsPropertyTest.getPropertyByTitle(EventsPropertyTest.getSubProperties(listenerProperty), method);
    }

    public static MethodDeclaration ensureListenerMethod(JavaInfo javaInfo, String listener, String method) throws Exception {
        Property property = EventsPropertyTest.getEventsListenerMethod(javaInfo, listener, method);
        return (MethodDeclaration)ReflectionUtils.invokeMethod((Object)property, (String)"ensureListenerMethod()", (Object[])new Object[0]);
    }
}

