/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.variables;

import java.util.List;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.GridLayoutInfo;
import org.eclipse.wb.tests.designer.core.model.variables.AbstractVariableTest;
import org.junit.Test;

public class AbstractSimpleTest
extends AbstractVariableTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_addBadCode_veryBad() throws Exception {
        AbstractSimpleTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "  public MyButton(String s) {", "  }", "}"));
        AbstractSimpleTest.setFileContentSrc("test/MyButton.wbp-component.xml", AbstractSimpleTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[thisIsBAD]]></source>", "  </creation>", "</component>"));
        AbstractSimpleTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        try {
            ComponentInfo newButton = (ComponentInfo)AbstractSimpleTest.createJavaInfo("test.MyButton");
            flowLayout.add(newButton, null);
            AbstractSimpleTest.fail();
        }
        catch (DesignerException e) {
            AbstractSimpleTest.assertEquals((long)207L, (long)e.getCode());
        }
    }

    @Test
    public void test_moveRenameConflict_visible() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "    }", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "    }", "  }", "}");
        ContainerInfo panel_1 = (ContainerInfo)panel.getChildrenComponents().get(0);
        ContainerInfo panel_2 = (ContainerInfo)panel.getChildrenComponents().get(1);
        FlowLayoutInfo flowLayout_1 = (FlowLayoutInfo)panel_1.getLayout();
        flowLayout_1.move((ComponentInfo)panel_2, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      {", "        JPanel panel_1 = new JPanel();", "        panel.add(panel_1);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_moveRenameConflict_visibleChilren() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      JButton button = new JButton();", "      panel.add(button);", "    }", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      JButton button = new JButton();", "      panel.add(button);", "    }", "  }", "}");
        ContainerInfo panel_1 = (ContainerInfo)panel.getChildrenComponents().get(0);
        ContainerInfo panel_2 = (ContainerInfo)panel.getChildrenComponents().get(1);
        FlowLayoutInfo flowLayout_1 = (FlowLayoutInfo)panel_1.getLayout();
        flowLayout_1.move((ComponentInfo)panel_2, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      JButton button = new JButton();", "      panel.add(button);", "      {", "        JPanel panel_1 = new JPanel();", "        panel.add(panel_1);", "        JButton button_1 = new JButton();", "        panel_1.add(button_1);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_moveRenameConflict_visibleChilren2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final JPanel panel2 = new JPanel();", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      JButton button = new JButton();", "      panel.add(button);", "    }", "    {", "      add(panel2);", "      JButton button = new JButton();", "      panel2.add(button);", "    }", "  }", "}");
        ContainerInfo panel_1 = (ContainerInfo)panel.getChildrenComponents().get(0);
        ContainerInfo panel_2 = (ContainerInfo)panel.getChildrenComponents().get(1);
        FlowLayoutInfo flowLayout_1 = (FlowLayoutInfo)panel_1.getLayout();
        flowLayout_1.move((ComponentInfo)panel_2, null);
        this.assertEditor("public class Test extends JPanel {", "  private final JPanel panel2 = new JPanel();", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      JButton button = new JButton();", "      panel.add(button);", "      {", "        JButton button_1 = new JButton();", "        panel.add(panel2);", "        panel2.add(button_1);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_moveRenameConflict_noConflict() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      panel.setEnabled(false);", "    }", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "    }", "  }", "}");
        ContainerInfo panel_1 = (ContainerInfo)panel.getChildrenComponents().get(0);
        ContainerInfo panel_2 = (ContainerInfo)panel.getChildrenComponents().get(1);
        ((FlowLayoutInfo)panel.getLayout()).move((ComponentInfo)panel_2, (ComponentInfo)panel_1);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "    }", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      panel.setEnabled(false);", "    }", "  }", "}");
    }

    @Test
    public void test_moveRenameConflict_shadow_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "    }", "    JPanel panel = new JPanel();", "    add(panel);", "  }", "}");
        ContainerInfo panel_1 = (ContainerInfo)panel.getChildrenComponents().get(0);
        ContainerInfo panel_2 = (ContainerInfo)panel.getChildrenComponents().get(1);
        ((FlowLayoutInfo)panel.getLayout()).move((ComponentInfo)panel_2, (ComponentInfo)panel_1);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JPanel panel_1 = new JPanel();", "    add(panel_1);", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "    }", "  }", "}");
    }

    @Test
    public void test_moveRenameConflict_shadow_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "    }", "    JPanel panel = new JPanel();", "    add(panel);", "    {", "      JButton panel_1 = new JButton();", "      panel.add(panel_1);", "    }", "  }", "}");
        ContainerInfo panel_1 = (ContainerInfo)panel.getChildrenComponents().get(0);
        ContainerInfo panel_2 = (ContainerInfo)panel.getChildrenComponents().get(1);
        ((FlowLayoutInfo)panel.getLayout()).move((ComponentInfo)panel_2, (ComponentInfo)panel_1);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JPanel panel_2 = new JPanel();", "    add(panel_2);", "    {", "      JButton panel_1 = new JButton();", "      panel_2.add(panel_1);", "    }", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "    }", "  }", "}");
    }

    @Test
    public void test_move_noConflict() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel_first = new JPanel();", "      add(panel_first);", "      GridLayout gridLayout_first = new GridLayout();", "      panel_first.setLayout(gridLayout_first);", "    }", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      GridLayout gridLayout = new GridLayout();", "      panel.setLayout(gridLayout);", "    }", "  }", "}");
        ContainerInfo panel_1 = (ContainerInfo)panel.getChildrenComponents().get(0);
        ContainerInfo panel_2 = (ContainerInfo)panel.getChildrenComponents().get(1);
        GridLayoutInfo gridLayout_1 = (GridLayoutInfo)panel_1.getLayout();
        gridLayout_1.move((ComponentInfo)panel_2, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel_first = new JPanel();", "      add(panel_first);", "      GridLayout gridLayout_first = new GridLayout();", "      panel_first.setLayout(gridLayout_first);", "      {", "        JPanel panel = new JPanel();", "        panel_first.add(panel);", "        GridLayout gridLayout = new GridLayout();", "        panel.setLayout(gridLayout);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_ensureInstanceReadyAt() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(true);", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "  }", "}");
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        MethodDeclaration constructor = (MethodDeclaration)panel.getCreationSupport().getNode();
        Statement statement = (Statement)DomGenerics.statements((Block)constructor.getBody()).get(0);
        StatementTarget target = new StatementTarget(statement, true);
        final int[] broadcastInvoked = new int[1];
        panel.addBroadcastListener((Object)new JavaEventListener(){

            public void variable_addStatementsToMove(JavaInfo parent, List<JavaInfo> children) throws Exception {
                broadcastInvoked[0] = broadcastInvoked[0] + 1;
            }
        });
        button_2.getVariableSupport().ensureInstanceReadyAt(target);
        AbstractSimpleTest.assertEquals((long)1L, (long)broadcastInvoked[0]);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "    setEnabled(true);", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "  }", "}");
    }

    @Test
    public void test_ensureInstanceReadyAt_relatedNodeLoosely() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button = new JButton();", "  public Test() {", "    int a;", "    {", "      add(button);", "      button.setEnabled(true);", "    }", "    configure();", "  }", "  private void configure() {", "    button.setEnabled(false);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        StatementTarget target = AbstractSimpleTest.getBlockTarget((JavaInfo)panel, true, new int[0]);
        button.getVariableSupport().ensureInstanceReadyAt(target);
        this.assertEditor("public class Test extends JPanel {", "  private JButton button = new JButton();", "  public Test() {", "    {", "      add(button);", "      button.setEnabled(true);", "    }", "    int a;", "    configure();", "  }", "  private void configure() {", "    button.setEnabled(false);", "  }", "}");
    }
}

