/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls.ui;

import java.util.List;
import javax.swing.JFrame;
import org.apache.commons.lang3.function.FailableBiConsumer;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotRootMenu;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.nls.model.AbstractSource;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.tests.designer.core.nls.ui.AbstractNlsUiTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Test;

public class ContributionItemTest
extends AbstractNlsUiTest {
    @Test
    public void test_localesCombo() throws Exception {
        ContributionItemTest.setFileContentSrc("test/messages.properties", ContributionItemTest.getSourceDQ("frame.title=My JFrame"));
        ContributionItemTest.setFileContentSrc("test/messages_it.properties", ContributionItemTest.getSourceDQ("frame.title=My JFrame IT"));
        ContributionItemTest.waitForAutoBuild();
        this.openContainer("import java.util.ResourceBundle;\npublic class Test extends JFrame {\n\tpublic Test() {\n\t\tsetTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$\n\t}\n}");
        ContributionItemTest.assertEquals((Object)"My JFrame", (Object)((JFrame)this.m_contentJavaInfo.getObject()).getTitle());
        ContributionItemTest.assertNotNull((String)"NLS dialog item not found.", (Object)((Object)this.m_dialogItem));
        new UiContext().executeAndCheck((FailableRunnable<Exception>)((FailableRunnable)() -> {}), (FailableConsumer<SWTBot, Exception>)((FailableConsumer)bot -> {
            SWTBotRootMenu contextMenu = this.m_dialogItem.externalizeMenu();
            String[] requiredLocales = new String[]{"(default)", "it"};
            List availableLocaleItems = contextMenu.menuItems();
            ContributionItemTest.assertEquals((long)requiredLocales.length, (long)availableLocaleItems.size());
            int i = 0;
            while (i < requiredLocales.length) {
                ContributionItemTest.assertEquals((Object)requiredLocales[i], availableLocaleItems.get(i));
                if (i == 1) {
                    contextMenu.menu(new String[]{requiredLocales[i]}).click();
                }
                ++i;
            }
            UIThreadRunnable.syncExec(() -> ((Menu)sWTBotRootMenu.widget).dispose());
        }));
        ContributionItemTest.assertEquals((Object)"My JFrame IT", (Object)((JFrame)this.m_contentJavaInfo.getObject()).getTitle());
        LocaleInfo localeInfo = AbstractSource.getLocaleInfo((JavaInfo)this.m_contentJavaInfo);
        this.m_designPage.refreshGEF();
        ContributionItemTest.assertEquals((Object)localeInfo, (Object)AbstractSource.getLocaleInfo((JavaInfo)this.m_contentJavaInfo));
    }

    @Test
    public void test_defaultPackage() throws Exception {
        String initialSource = ContributionItemTest.getSourceDQ("public class Test extends javax.swing.JFrame {", "  public Test() {", "    setTitle('My JFrame');", "  }", "}");
        this.openDialogNLS("", initialSource, new FailableBiConsumer<UiContext, SWTBot, Exception>(){

            public void accept(UiContext context, SWTBot bot) throws Exception {
                bot.shell("Can't Externalize").bot().button("OK").click();
            }
        });
    }
}

