/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.databinding.rcp.model.context;

import java.util.List;
import org.eclipse.wb.internal.rcp.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.ValueBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.BindingInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.ValueBindingInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.strategies.UpdateStrategyInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.strategies.UpdateValueStrategyInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.strategies.ValidatorInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.SwtObservableInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.databinding.rcp.DatabindingTestUtils;
import org.eclipse.wb.tests.designer.databinding.rcp.model.AbstractBindingTest;
import org.junit.Test;

public class BindValueTest
extends AbstractBindingTest {
    @Test
    public void test_bindValue() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableValue observeValue = BeanProperties.value(\"name\").observe(getClass());", "    IObservableValue observeWidget = WidgetProperties.text().observe(m_shell);", "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindValue(observeWidget, observeValue, null, null);", "    return bindingContext;", "  }", "}"});
        BindValueTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BindValueTest.assertNotNull((Object)bindings);
        BindValueTest.assertEquals((long)1L, (long)bindings.size());
        BindValueTest.assertInstanceOf(ValueBindingInfo.class, bindings.get(0));
        BindingInfo binding = (BindingInfo)bindings.get(0);
        BindValueTest.assertNull((Object)binding.getVariableIdentifier());
        BindValueTest.assertNotNull((Object)binding.getTarget());
        BindValueTest.assertNotNull((Object)binding.getTargetProperty());
        BindValueTest.assertNotNull((Object)binding.getTargetObservable());
        BindValueTest.assertSame((Object)binding.getTarget(), (Object)binding.getTargetObservable().getBindableObject());
        BindValueTest.assertSame((Object)binding.getTargetProperty(), (Object)binding.getTargetObservable().getBindableProperty());
        BindValueTest.assertInstanceOf(SwtObservableInfo.class, (Object)binding.getTargetObservable());
        BindValueTest.assertEquals((Object)"observeWidget", (Object)binding.getTargetObservable().getVariableIdentifier());
        BindValueTest.assertNotNull((Object)binding.getModel());
        BindValueTest.assertNotNull((Object)binding.getModelProperty());
        BindValueTest.assertNotNull((Object)binding.getModelObservable());
        BindValueTest.assertSame((Object)binding.getModel(), (Object)binding.getModelObservable().getBindableObject());
        BindValueTest.assertSame((Object)binding.getModelProperty(), (Object)binding.getModelObservable().getBindableProperty());
        BindValueTest.assertInstanceOf(ValueBeanObservableInfo.class, (Object)binding.getModelObservable());
        BindValueTest.assertEquals((Object)"observeValue", (Object)binding.getModelObservable().getVariableIdentifier());
        this.assertStrategy(binding.getTargetStrategy(), null, UpdateStrategyInfo.StrategyType.Null, UpdateValueStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
        this.assertStrategy(binding.getModelStrategy(), null, UpdateStrategyInfo.StrategyType.Null, UpdateValueStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
    }

    @Test
    public void test_bindValue_variable_1() throws Exception {
        this.bindValue_variable("  //", "    Binding binding = bindingContext.bindValue(observeWidget, observeValue, null, null);", "binding");
    }

    @Test
    public void test_bindValue_variable_2() throws Exception {
        this.bindValue_variable("  Binding m_binding;", "    m_binding = bindingContext.bindValue(observeWidget, observeValue, null, null);", "m_binding");
    }

    private void bindValue_variable(String line0, String line1, String testString) throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"import org.eclipse.core.databinding.Binding;", "public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", line0, "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableValue observeValue = BeanProperties.value(\"name\").observe(getClass());", "    IObservableValue observeWidget = WidgetProperties.text().observe(m_shell);", "    DataBindingContext bindingContext = new DataBindingContext();", line1, "    return bindingContext;", "  }", "}"});
        BindValueTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BindValueTest.assertNotNull((Object)bindings);
        BindValueTest.assertEquals((long)1L, (long)bindings.size());
        BindValueTest.assertInstanceOf(ValueBindingInfo.class, bindings.get(0));
        BindingInfo binding = (BindingInfo)bindings.get(0);
        BindValueTest.assertNotNull((Object)binding.getVariableIdentifier());
        BindValueTest.assertEquals((Object)testString, (Object)binding.getVariableIdentifier());
    }

    @Test
    public void test_strategy_constructors_1() throws Exception {
        this.strategy_constructors("    bindingContext.bindValue(observeWidget, observeValue, new UpdateValueStrategy(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));", UpdateValueStrategyInfo.Value.POLICY_NEVER, "POLICY_NEVER|POLICY_NEVER");
    }

    @Test
    public void test_strategy_constructors_2() throws Exception {
        this.strategy_constructors("    bindingContext.bindValue(observeWidget, observeValue, new UpdateValueStrategy(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));", UpdateValueStrategyInfo.Value.POLICY_ON_REQUEST, "POLICY_ON_REQUEST|POLICY_ON_REQUEST");
    }

    @Test
    public void test_strategy_constructors_3() throws Exception {
        this.strategy_constructors("    bindingContext.bindValue(observeWidget, observeValue, new UpdateValueStrategy(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_CONVERT));", UpdateValueStrategyInfo.Value.POLICY_CONVERT, "POLICY_CONVERT|POLICY_CONVERT");
    }

    @Test
    public void test_strategy_constructors_4() throws Exception {
        this.strategy_constructors("    bindingContext.bindValue(observeWidget, observeValue, new UpdateValueStrategy(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));", UpdateValueStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
    }

    private void strategy_constructors(String line, Object value, String presentation) throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableValue observeValue = BeanProperties.value(\"name\").observe(getClass());", "    IObservableValue observeWidget = WidgetProperties.text().observe(m_shell);", "    DataBindingContext bindingContext = new DataBindingContext();", line, "    return bindingContext;", "  }", "}"});
        BindValueTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BindValueTest.assertNotNull((Object)bindings);
        BindValueTest.assertEquals((long)1L, (long)bindings.size());
        BindValueTest.assertInstanceOf(ValueBindingInfo.class, bindings.get(0));
        BindingInfo binding = (BindingInfo)bindings.get(0);
        this.assertStrategy(binding.getTargetStrategy(), null, UpdateStrategyInfo.StrategyType.DefaultConstructor, UpdateValueStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
        this.assertStrategy(binding.getModelStrategy(), null, UpdateStrategyInfo.StrategyType.IntConstructor, value, presentation);
    }

    @Test
    public void test_strategy_variable() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableValue observeValue = BeanProperties.value(\"name\").observe(getClass());", "    IObservableValue observeWidget = WidgetProperties.text().observe(m_shell);", "    DataBindingContext bindingContext = new DataBindingContext();", "    UpdateValueStrategy strategy0 = new UpdateValueStrategy();", "    UpdateValueStrategy strategy1 = new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER);", "    bindingContext.bindValue(observeWidget, observeValue, strategy0, strategy1);", "    return bindingContext;", "  }", "}"});
        BindValueTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BindValueTest.assertNotNull((Object)bindings);
        BindValueTest.assertEquals((long)1L, (long)bindings.size());
        BindValueTest.assertInstanceOf(ValueBindingInfo.class, bindings.get(0));
        BindingInfo binding = (BindingInfo)bindings.get(0);
        this.assertStrategy(binding.getTargetStrategy(), "strategy0", UpdateStrategyInfo.StrategyType.DefaultConstructor, UpdateValueStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
        this.assertStrategy(binding.getModelStrategy(), "strategy1", UpdateStrategyInfo.StrategyType.IntConstructor, UpdateValueStrategyInfo.Value.POLICY_NEVER, "POLICY_NEVER|POLICY_NEVER");
    }

    @Test
    public void test_strategy_policy_variable() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  int m_policy = UpdateValueStrategy.POLICY_NEVER;", "  private DataBindingContext initDataBindings() {", "    IObservableValue observeValue = BeanProperties.value(\"name\").observe(getClass());", "    IObservableValue observeWidget = WidgetProperties.text().observe(m_shell);", "    DataBindingContext bindingContext = new DataBindingContext();", "    int policy = UpdateValueStrategy.POLICY_UPDATE;", "    UpdateValueStrategy strategy0 = new UpdateValueStrategy(policy);", "    UpdateValueStrategy strategy1 = new UpdateValueStrategy(m_policy);", "    bindingContext.bindValue(observeWidget, observeValue, strategy0, strategy1);", "    return bindingContext;", "  }", "}"});
        BindValueTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BindValueTest.assertNotNull((Object)bindings);
        BindValueTest.assertEquals((long)1L, (long)bindings.size());
        BindValueTest.assertInstanceOf(ValueBindingInfo.class, bindings.get(0));
        BindingInfo binding = (BindingInfo)bindings.get(0);
        this.assertStrategy(binding.getTargetStrategy(), "strategy0", UpdateStrategyInfo.StrategyType.IntConstructor, UpdateValueStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
        this.assertStrategy(binding.getModelStrategy(), "strategy1", UpdateStrategyInfo.StrategyType.IntConstructor, UpdateValueStrategyInfo.Value.POLICY_NEVER, "POLICY_NEVER|POLICY_NEVER");
    }

    @Test
    public void test_strategy_z_extendet() throws Exception {
        this.createModelCompilationUnit("test", "TestStrategy.java", DatabindingTestUtils.getTestSource("public class TestStrategy extends UpdateValueStrategy {", "  public TestStrategy() {", "  }", "}"));
        BindValueTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableValue observeValue = BeanProperties.value(\"name\").observe(getClass());", "    IObservableValue observeWidget = WidgetProperties.text().observe(m_shell);", "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindValue(observeWidget, observeValue, null, new test.TestStrategy());", "    return bindingContext;", "  }", "}"});
        BindValueTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BindValueTest.assertNotNull((Object)bindings);
        BindValueTest.assertEquals((long)1L, (long)bindings.size());
        BindValueTest.assertInstanceOf(ValueBindingInfo.class, bindings.get(0));
        BindingInfo binding = (BindingInfo)bindings.get(0);
        this.assertStrategy(binding.getTargetStrategy(), null, UpdateStrategyInfo.StrategyType.Null, UpdateValueStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
        this.assertStrategy(binding.getModelStrategy(), null, UpdateStrategyInfo.StrategyType.ExtendetClass, "test.TestStrategy", "test.TestStrategy|test.TestStrategy");
    }

    @Test
    public void test_strategy_converter_1() throws Exception {
        this.strategy_converter("    strategy.setConverter(new TestConverter());", "    //", "null|test.TestConverter|TestConverter");
    }

    @Test
    public void test_strategy_converter_2() throws Exception {
        this.strategy_converter("    TestConverter converter = new TestConverter();", "    strategy.setConverter(converter);", "converter|test.TestConverter|TestConverter");
    }

    private void strategy_converter(String line0, String line1, String testString) throws Exception {
        this.createModelCompilationUnit("test", "TestConverter.java", DatabindingTestUtils.getTestSource("public class TestConverter extends Converter {", "  public TestConverter() {", "    super(null, null);", "  }", "  public Object convert(Object fromObject) {", "    return null;", "  }", "}"));
        BindValueTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableValue observeValue = BeanProperties.value(\"name\").observe(getClass());", "    IObservableValue observeWidget = WidgetProperties.text().observe(m_shell);", "    DataBindingContext bindingContext = new DataBindingContext();", "    UpdateValueStrategy strategy = new UpdateValueStrategy();", line0, line1, "    bindingContext.bindValue(observeWidget, observeValue, null, strategy);", "    return bindingContext;", "  }", "}"});
        BindValueTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BindValueTest.assertNotNull((Object)bindings);
        BindValueTest.assertEquals((long)1L, (long)bindings.size());
        BindValueTest.assertInstanceOf(ValueBindingInfo.class, bindings.get(0));
        BindingInfo binding = (BindingInfo)bindings.get(0);
        this.assertStrategy(binding.getTargetStrategy(), null, UpdateStrategyInfo.StrategyType.Null, UpdateValueStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
        this.assertStrategy(binding.getModelStrategy(), "strategy", UpdateStrategyInfo.StrategyType.DefaultConstructor, UpdateValueStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE", testString, null, null, null);
    }

    @Test
    public void test_strategy_AfterConvertValidator_1() throws Exception {
        this.strategy_validator("    strategy.setAfterConvertValidator(new TestValidator());", "    //", "null|test.TestValidator|TestValidator", null, null);
    }

    @Test
    public void test_strategy_AfterConvertValidator_2() throws Exception {
        this.strategy_validator("    TestValidator validator = new TestValidator();", "    strategy.setAfterConvertValidator(validator);", "validator|test.TestValidator|TestValidator", null, null);
    }

    @Test
    public void test_strategy_AfterGetValidator_1() throws Exception {
        this.strategy_validator("    strategy.setAfterGetValidator(new TestValidator());", "    //", null, "null|test.TestValidator|TestValidator", null);
    }

    @Test
    public void test_strategy_AfterGetValidator_2() throws Exception {
        this.strategy_validator("    TestValidator validator = new TestValidator();", "    strategy.setAfterGetValidator(validator);", null, "validator|test.TestValidator|TestValidator", null);
    }

    @Test
    public void test_strategy_BeforeSetValidator_1() throws Exception {
        this.strategy_validator("    strategy.setBeforeSetValidator(new TestValidator());", "    //", null, null, "null|test.TestValidator|TestValidator");
    }

    @Test
    public void test_strategy_BeforeSetValidator_2() throws Exception {
        this.strategy_validator("    TestValidator validator = new TestValidator();", "    strategy.setBeforeSetValidator(validator);", null, null, "validator|test.TestValidator|TestValidator");
    }

    private void strategy_validator(String line0, String line1, String testString0, String testString1, String testString2) throws Exception {
        this.createModelCompilationUnit("test", "TestValidator.java", DatabindingTestUtils.getTestSource("public class TestValidator implements IValidator {", "  public org.eclipse.core.runtime.IStatus validate(Object value) {", "    return null;", "  }", "}"));
        BindValueTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableValue observeValue = BeanProperties.value(\"name\").observe(getClass());", "    IObservableValue observeWidget = WidgetProperties.text().observe(m_shell);", "    DataBindingContext bindingContext = new DataBindingContext();", "    UpdateValueStrategy strategy = new UpdateValueStrategy();", line0, line1, "    bindingContext.bindValue(observeWidget, observeValue, null, strategy);", "    return bindingContext;", "  }", "}"});
        BindValueTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BindValueTest.assertNotNull((Object)bindings);
        BindValueTest.assertEquals((long)1L, (long)bindings.size());
        BindValueTest.assertInstanceOf(ValueBindingInfo.class, bindings.get(0));
        BindingInfo binding = (BindingInfo)bindings.get(0);
        this.assertStrategy(binding.getTargetStrategy(), null, UpdateStrategyInfo.StrategyType.Null, UpdateValueStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
        this.assertStrategy(binding.getModelStrategy(), "strategy", UpdateStrategyInfo.StrategyType.DefaultConstructor, UpdateValueStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE", null, testString0, testString1, testString2);
    }

    private void assertStrategy(Object objectStrategy, String variable, Object type, Object value, String presentation) throws Exception {
        this.assertStrategy(objectStrategy, variable, type, value, presentation, null, null, null, null);
    }

    private void assertStrategy(Object objectStrategy, String variable, Object type, Object value, String presentation, String converter, String validator0, String validator1, String validator2) throws Exception {
        ValidatorInfo validator;
        BindValueTest.assertNotNull((Object)objectStrategy);
        BindValueTest.assertInstanceOf(UpdateValueStrategyInfo.class, objectStrategy);
        UpdateValueStrategyInfo strategy = (UpdateValueStrategyInfo)objectStrategy;
        if (variable == null) {
            BindValueTest.assertNull((Object)strategy.getVariableIdentifier());
        } else {
            BindValueTest.assertEquals((Object)variable, (Object)strategy.getVariableIdentifier());
        }
        BindValueTest.assertEquals((Object)type, (Object)strategy.getStrategyType());
        BindValueTest.assertEquals((Object)value, (Object)strategy.getStrategyValue());
        BindValueTest.assertEquals((Object)presentation, (Object)(strategy.getStringValue() + "|" + strategy.getPresentationText()));
        if (converter == null) {
            BindValueTest.assertNull((Object)strategy.getConverter());
        } else {
            BindValueTest.assertEquals((Object)converter, (Object)(strategy.getConverter().getVariableIdentifier() + "|" + strategy.getConverter().getClassName() + "|" + strategy.getConverter().getPresentationText()));
        }
        if (validator0 == null) {
            BindValueTest.assertNull((Object)strategy.getAfterConvertValidator());
        } else {
            BindValueTest.assertEquals((Object)validator0, (Object)(strategy.getAfterConvertValidator().getVariableIdentifier() + "|" + strategy.getAfterConvertValidator().getClassName() + "|" + strategy.getAfterConvertValidator().getPresentationText()));
            validator = strategy.getValidator("setAfterConvertValidator");
            BindValueTest.assertNotNull((Object)validator);
            BindValueTest.assertEquals((Object)validator0, (Object)(validator.getVariableIdentifier() + "|" + validator.getClassName() + "|" + validator.getPresentationText()));
        }
        if (validator1 == null) {
            BindValueTest.assertNull((Object)strategy.getAfterGetValidator());
        } else {
            BindValueTest.assertEquals((Object)validator1, (Object)(strategy.getAfterGetValidator().getVariableIdentifier() + "|" + strategy.getAfterGetValidator().getClassName() + "|" + strategy.getAfterGetValidator().getPresentationText()));
            validator = strategy.getValidator("setAfterGetValidator");
            BindValueTest.assertNotNull((Object)validator);
            BindValueTest.assertEquals((Object)validator1, (Object)(validator.getVariableIdentifier() + "|" + validator.getClassName() + "|" + validator.getPresentationText()));
        }
        if (validator2 == null) {
            BindValueTest.assertNull((Object)strategy.getBeforeSetValidator());
        } else {
            BindValueTest.assertEquals((Object)validator2, (Object)(strategy.getBeforeSetValidator().getVariableIdentifier() + "|" + strategy.getBeforeSetValidator().getClassName() + "|" + strategy.getBeforeSetValidator().getPresentationText()));
            validator = strategy.getValidator("setBeforeSetValidator");
            BindValueTest.assertNotNull((Object)validator);
            BindValueTest.assertEquals((Object)validator2, (Object)(validator.getVariableIdentifier() + "|" + validator.getClassName() + "|" + validator.getPresentationText()));
        }
    }
}

