/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.jface;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.editor.palette.PaletteEventListener;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.FactoryParentAssociation;
import org.eclipse.wb.core.model.association.UnknownAssociation;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.creation.factory.ImplicitFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.rcp.model.jface.DialogButtonIdPropertyEditor;
import org.eclipse.wb.internal.rcp.model.jface.DialogInfo;
import org.eclipse.wb.internal.rcp.palette.DialogButtonEntryInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.Expectations;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Ignore;
import org.junit.Test;

public class DialogTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Ignore
    @Test
    public void test_0() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected Control createDialogArea(Composite parent) {", "    Composite container = (Composite) super.createDialogArea(parent);", "    {", "      Button button = new Button(container, SWT.NONE);", "    }", "    return container;", "  }", "}");
        DialogTest.assertHierarchy("{this: org.eclipse.jface.dialogs.Dialog} {this} {}", "  {parameter} {parent} {/super.createDialogArea(parent)/}", "    {casted-superInvocation: (Composite)super.createDialogArea(parent)} {local-unique: container} {/(Composite) super.createDialogArea(parent)/ /new Button(container, SWT.NONE)/ /container/}", "      {implicit-layout: org.eclipse.swt.layout.GridLayout} {implicit-layout} {}", "      {new: org.eclipse.swt.widgets.Button} {local-unique: button} {/new Button(container, SWT.NONE)/}", "        {virtual-layout_data: org.eclipse.swt.layout.GridData} {virtual-layout-data} {}");
        CompositeInfo dialogAreaParent = (CompositeInfo)dialog.getChildren(CompositeInfo.class).get(0);
        CompositeInfo dialogAreaSuper = (CompositeInfo)dialogAreaParent.getChildren(CompositeInfo.class).get(0);
        dialog.refresh();
        DialogTest.assertNotNull((Object)dialog.getImage());
        DialogTest.assertEquals((long)450L, (long)dialog.getBounds().width);
        DialogTest.assertEquals((long)300L, (long)dialog.getBounds().height);
        DialogTest.assertFalse((boolean)dialogAreaParent.hasLayout());
        Insets expected = Expectations.get(new Insets(25, 3, 3, 3), new Expectations.InsValue("flanker-windows", new Insets(25, 3, 3, 3)), new Expectations.InsValue("scheglov-win", new Insets(25, 3, 3, 3)));
        DialogTest.assertEquals((Object)expected, (Object)dialog.getClientAreaInsets());
        expected = Expectations.get(new Rectangle(0, 0, 444, 272), new Expectations.RectValue("flanker-windows", new Rectangle(0, 0, 444, 272)), new Expectations.RectValue("scheglov-win", new Rectangle(0, 0, 444, 272)));
        DialogTest.assertEquals((Object)expected, (Object)dialogAreaParent.getModelBounds());
        expected = Expectations.get(new Rectangle(3, 25, 444, 272), new Expectations.RectValue("flanker-windows", new Rectangle(3, 25, 444, 272)), new Expectations.RectValue("scheglov-win", new Rectangle(3, 25, 444, 272)));
        DialogTest.assertEquals((Object)expected, (Object)dialogAreaParent.getBounds());
        DialogTest.assertTrue((boolean)dialogAreaSuper.hasLayout());
        Rectangle bounds = dialogAreaSuper.getModelBounds();
        DialogTest.assertEquals((long)bounds.width, (long)dialogAreaParent.getModelBounds().width);
        Assertions.assertThat((int)bounds.height).isGreaterThan(200);
    }

    @Test
    public void test_1() throws Exception {
        this.parseJavaInfo("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected Control createDialogArea(Composite parent) {", "    Composite container = (Composite) super.createDialogArea(parent);", "    return container;", "  }", "  protected void configureShell(Shell newShell) {", "    super.configureShell(newShell);", "  }", "}");
        DialogTest.assertHierarchy("{this: org.eclipse.jface.dialogs.Dialog} {this} {}", "  {parameter} {newShell} {/super.configureShell(newShell)/}", "    {parameter} {parent} {/super.createDialogArea(parent)/}", "      {casted-superInvocation: (Composite)super.createDialogArea(parent)} {local-unique: container} {/(Composite) super.createDialogArea(parent)/ /container/}", "        {implicit-layout: org.eclipse.swt.layout.GridLayout} {implicit-layout} {}");
    }

    @Test
    public void test_createDialogArea_createButtonBar() throws Exception {
        this.parseJavaInfo("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected Control createDialogArea(Composite parent) {", "    Composite container = (Composite) super.createDialogArea(parent);", "    return container;", "  }", "  protected Control createButtonBar(Composite parent) {", "    return super.createButtonBar(parent);", "  }", "}");
        DialogTest.assertHierarchy("{this: org.eclipse.jface.dialogs.Dialog} {this} {}", "  {parameter} {parent} {/super.createDialogArea(parent)/}", "    {casted-superInvocation: (Composite)super.createDialogArea(parent)} {local-unique: container} {/(Composite) super.createDialogArea(parent)/ /container/}", "      {implicit-layout: org.eclipse.swt.layout.GridLayout} {implicit-layout} {}");
    }

    @Test
    public void test_bad_getInitialSize() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected Point getInitialSize() {", "    return null;", "  }", "}");
        dialog.refresh();
        DialogTest.assertNoErrors((JavaInfo)dialog);
    }

    @Test
    public void test_passNullParentShell() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test() {", "    super((Shell) null);", "  }", "}");
        dialog.refresh();
        DialogTest.assertNoErrors((JavaInfo)dialog);
        Shell dialogShell = (Shell)ReflectionUtils.invokeMethod((Object)dialog, (String)"getShell()", (Object[])new Object[0]);
        DialogTest.assertNotSame((Object)DesignerPlugin.getShell(), (Object)dialogShell.getParent());
    }

    @Test
    public void test_setAbsoluteLayout() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected Control createDialogArea(Composite parent) {", "    Composite container = (Composite) super.createDialogArea(parent);", "    container.setLayout(null);", "    new Button(container, SWT.NONE);", "    return container;", "  }", "}");
        DialogTest.assertHierarchy("{this: org.eclipse.jface.dialogs.Dialog} {this} {}", "  {parameter} {parent} {/super.createDialogArea(parent)/}", "    {casted-superInvocation: (Composite)super.createDialogArea(parent)} {local-unique: container} {/(Composite) super.createDialogArea(parent)/ /container.setLayout(null)/ /new Button(container, SWT.NONE)/ /container/}", "      {new: org.eclipse.swt.widgets.Button} {empty} {/new Button(container, SWT.NONE)/}", "      {null} {absolute} {}");
        dialog.refresh();
        DialogTest.assertNoErrors((JavaInfo)dialog);
    }

    @Test
    public void test_withLocalStaticFactory() throws Exception {
        this.m_waitForAutoBuild = true;
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected Control createDialogArea(Composite parent) {", "    Composite container = (Composite) super.createDialogArea(parent);", "    {", "      Button button = createButton(container);", "      button.setText('A');", "    }", "    {", "      Button button = createButton(container);", "      button.setText('B');", "    }", "    return container;", "  }", "  /**", "  * @wbp.factory", "  */", "  public static Button createButton(Composite parent) {", "    return new Button(parent, SWT.NONE);", "  }", "}");
        DialogTest.assertHierarchy("{this: org.eclipse.jface.dialogs.Dialog} {this} {}", "  {parameter} {parent} {/super.createDialogArea(parent)/}", "    {casted-superInvocation: (Composite)super.createDialogArea(parent)} {local-unique: container} {/(Composite) super.createDialogArea(parent)/ /createButton(container)/ /createButton(container)/ /container/}", "      {implicit-layout: org.eclipse.swt.layout.GridLayout} {implicit-layout} {}", "      {static factory: test.Test createButton(org.eclipse.swt.widgets.Composite)} {local-unique: button} {/createButton(container)/ /button.setText('A')/}", "        {virtual-layout_data: org.eclipse.swt.layout.GridData} {virtual-layout-data} {}", "      {static factory: test.Test createButton(org.eclipse.swt.widgets.Composite)} {local-unique: button} {/createButton(container)/ /button.setText('B')/}", "        {virtual-layout_data: org.eclipse.swt.layout.GridData} {virtual-layout-data} {}");
        dialog.refresh();
        DialogTest.assertNoErrors((JavaInfo)dialog);
        CompositeInfo parent = (CompositeInfo)dialog.getChildren(CompositeInfo.class).get(0);
        CompositeInfo container = (CompositeInfo)parent.getChildren(CompositeInfo.class).get(0);
        Composite containerObject = container.getWidget();
        Assertions.assertThat((Object[])containerObject.getChildren()).hasSize(2);
    }

    @Test
    public void test_buttonBar_buttonOnPalette() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "}");
        CategoryInfo category = new CategoryInfo();
        category.setId("org.eclipse.wb.rcp.jface");
        ArrayList entries = new ArrayList();
        PaletteEventListener listener = (PaletteEventListener)dialog.getBroadcast(PaletteEventListener.class);
        listener.entries(category, entries);
        DialogTest.assertEquals((long)1L, (long)entries.size());
        DialogTest.assertInstanceOf(DialogButtonEntryInfo.class, entries.get(0));
    }

    @Test
    public void test_buttonBar_getButtonBar_0() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "}");
        DialogTest.assertNull((Object)dialog.getButtonBar());
    }

    @Test
    public void test_buttonBar_getButtonBar_1() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected void createButtonsForButtonBar(Composite parent) {", "    createButton(parent, 0, '0', false);", "    createButton(parent, 1, '1', false);", "  }", "}");
        CompositeInfo buttonBar = dialog.getButtonBar();
        DialogTest.assertEquals((long)2L, (long)buttonBar.getChildrenControls().size());
    }

    @Test
    public void test_buttonBar_MOVE() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected void createButtonsForButtonBar(Composite parent) {", "    createButton(parent, 0, '0', false);", "    createButton(parent, 1, '1', false);", "  }", "}");
        DialogTest.assertHierarchy("{this: org.eclipse.jface.dialogs.Dialog} {this} {/createButton(parent, 0, '0', false)/ /createButton(parent, 1, '1', false)/}", "  {parameter} {parent} {/createButton(parent, 0, '0', false)/ /createButton(parent, 1, '1', false)/}", "    {implicit-factory} {empty} {/createButton(parent, 0, '0', false)/}", "    {implicit-factory} {empty} {/createButton(parent, 1, '1', false)/}");
        CompositeInfo buttonBar = (CompositeInfo)dialog.getChildren(CompositeInfo.class).get(0);
        DialogTest.assertFalse((boolean)buttonBar.hasLayout());
        DialogTest.assertInstanceOf(UnknownAssociation.class, (Object)buttonBar.getAssociation());
        DialogTest.assertEquals((long)2L, (long)buttonBar.getChildrenControls().size());
        ControlInfo button_1 = (ControlInfo)buttonBar.getChildrenControls().get(0);
        ControlInfo button_2 = (ControlInfo)buttonBar.getChildrenControls().get(1);
        DialogTest.assertInstanceOf(ImplicitFactoryCreationSupport.class, (Object)button_1.getCreationSupport());
        DialogTest.assertInstanceOf(FactoryParentAssociation.class, (Object)button_1.getAssociation());
        DialogInfo.moveButtonOnButtonBar((ControlInfo)button_2, (ControlInfo)button_1);
        this.assertEditor("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected void createButtonsForButtonBar(Composite parent) {", "    createButton(parent, 1, '1', false);", "    createButton(parent, 0, '0', false);", "  }", "}");
    }

    @Test
    public void test_buttonBar_CREATE() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected Control createDialogArea(Composite parent) {", "    return (Composite) super.createDialogArea(parent);", "  }", "  protected void createButtonsForButtonBar(Composite parent) {", "    createButton(parent, 0, '0', false);", "  }", "}");
        DialogTest.assertHierarchy("{this: org.eclipse.jface.dialogs.Dialog} {this} {/createButton(parent, 0, '0', false)/}", "  {parameter} {parent} {/super.createDialogArea(parent)/}", "    {casted-superInvocation: (Composite)super.createDialogArea(parent)} {empty} {/(Composite) super.createDialogArea(parent)/}", "      {implicit-layout: org.eclipse.swt.layout.GridLayout} {implicit-layout} {}", "    {parameter} {parent} {/createButton(parent, 0, '0', false)/}", "      {implicit-factory} {empty} {/createButton(parent, 0, '0', false)/}");
        CompositeInfo dialogAreaParent = (CompositeInfo)dialog.getChildren(CompositeInfo.class).get(0);
        CompositeInfo dialogAreaSuper = (CompositeInfo)dialogAreaParent.getChildren(CompositeInfo.class).get(0);
        CompositeInfo buttonBar = (CompositeInfo)dialogAreaParent.getChildren(CompositeInfo.class).get(1);
        DialogTest.assertFalse((boolean)DialogInfo.isButtonBar((CompositeInfo)dialogAreaParent));
        DialogTest.assertFalse((boolean)DialogInfo.isButtonBar((CompositeInfo)dialogAreaSuper));
        DialogTest.assertTrue((boolean)DialogInfo.isButtonBar((CompositeInfo)buttonBar));
        ControlInfo newButton = DialogInfo.createButtonOnButtonBar((CompositeInfo)buttonBar, null);
        this.assertEditor("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected Control createDialogArea(Composite parent) {", "    return (Composite) super.createDialogArea(parent);", "  }", "  protected void createButtonsForButtonBar(Composite parent) {", "    createButton(parent, 0, '0', false);", "    createButton(parent, 0, 'New button', false);", "  }", "}");
        DialogTest.check_case40661(newButton);
    }

    private static void check_case40661(ControlInfo newButton) throws Exception {
        ImplicitFactoryCreationSupport creationSupport = (ImplicitFactoryCreationSupport)newButton.getCreationSupport();
        MethodDescription description = creationSupport.getDescription();
        DialogTest.assertNotNull((Object)description);
        DialogTest.assertEquals((Object)"createButton({org.eclipse.swt.widgets.Composite,parent},{int},{java.lang.String},{boolean})", (Object)description.toString());
        Property[] properties = newButton.getProperties();
        Assertions.assertThat((int)properties.length).isGreaterThan(10);
    }

    @Test
    public void test_buttonBarButton_0() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected void createButtonsForButtonBar(Composite parent) {", "    createButton(parent, 0, '0', false);", "  }", "}");
        ControlInfo button = (ControlInfo)dialog.getButtonBar().getChildrenControls().get(0);
        DialogTest.assertNotNull((Object)button.getPropertyByTitle("ID"));
        DialogTest.assertNotNull((Object)button.getPropertyByTitle("Text"));
        DialogTest.assertNotNull((Object)button.getPropertyByTitle("Default"));
        Property idProperty = button.getPropertyByTitle("ID");
        DialogTest.assertSame((Object)idProperty, (Object)button.getPropertyByTitle("ID"));
    }

    @Test
    public void test_buttonBarButton_1() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  private static final int CUSTOM_1 = IDialogConstants.CLIENT_ID + 1;", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected void createButtonsForButtonBar(Composite parent) {", "    createButton(parent, 0, '0', false);", "    createButton(parent, IDialogConstants.YES_ID, '1', false);", "    createButton(parent, CUSTOM_1, '1', false);", "  }", "}");
        List buttons = dialog.getButtonBar().getChildrenControls();
        Property idProperty = ((ControlInfo)buttons.get(0)).getPropertyByTitle("ID");
        DialogTest.assertEquals((Object)"0", (Object)DialogTest.getPropertyText(idProperty));
        idProperty = ((ControlInfo)buttons.get(1)).getPropertyByTitle("ID");
        DialogTest.assertEquals((Object)"YES_ID", (Object)DialogTest.getPropertyText(idProperty));
        idProperty = ((ControlInfo)buttons.get(2)).getPropertyByTitle("ID");
        DialogTest.assertEquals((Object)"CUSTOM_1", (Object)DialogTest.getPropertyText(idProperty));
    }

    @Test
    public void test_getCustomIDs() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  private int NOT_FINAL_STATIC;", "  private static int NOT_FINAL;", "  private final int NOT_STATIC = 0;", "  private static final int TWO = 0, FRAGMENTS = 1;", "  private static final int NOT_INFIX = 0;", "  private static final int NOT_DIALOG_CONSTANTS = 1 + 2;", "  private static final int NOT_CLIENT = IDialogConstants.YES_ID + 2;", "  private static final int NOT_RIGHT_NUMBER = IDialogConstants.CLIENT_ID + (2);", "  private static final int GOOD = IDialogConstants.CLIENT_ID + 2;", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "}");
        List idList = (List)ReflectionUtils.invokeMethod2(DialogButtonIdPropertyEditor.class, (String)"getCustomIDs", GenericProperty.class, (Object)dialog.getPropertyByTitle("blockOnOpen"));
        Assertions.assertThat((List)idList).hasSize(1);
        FieldDeclaration fieldDeclaration = (FieldDeclaration)idList.get(0);
        DialogTest.assertEquals((Object)"GOOD", (Object)((VariableDeclarationFragment)DomGenerics.fragments((FieldDeclaration)fieldDeclaration).get(0)).getName().getIdentifier());
        String nameKey = (String)ReflectionUtils.getFieldObject(DialogButtonIdPropertyEditor.class, (String)"BUTTON_NAME_PROPERTY");
        DialogTest.assertEquals((Object)"GOOD", (Object)fieldDeclaration.getProperty(nameKey));
        String offsetKey = (String)ReflectionUtils.getFieldObject(DialogButtonIdPropertyEditor.class, (String)"BUTTON_OFFSET_PROPERTY");
        DialogTest.assertEquals((Object)2, (Object)fieldDeclaration.getProperty(offsetKey));
    }

    @Test
    public void test_buttonBarButton_noExtraButtonObjects() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected void createButtonsForButtonBar(Composite parent) {", "    createButton(parent, 0, 'btn', false);", "  }", "}");
        dialog.refresh();
        CompositeInfo buttonBar = dialog.getButtonBar();
        Composite buttonBarObject = buttonBar.getWidget();
        Assertions.assertThat((Object[])buttonBarObject.getChildren()).hasSize(1);
    }

    @Test
    public void test_contextMenu_remove_getInitialSize() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected Control createDialogArea(Composite parent) {", "    return (Composite) super.createDialogArea(parent);", "  }", "  protected Point getInitialSize() {", "    return new Point(500, 300);", "  }", "}");
        dialog.refresh();
        IMenuManager contextMenu = DialogTest.getContextMenu(new ObjectInfo[]{dialog});
        IAction action = DialogTest.findChildAction((IContributionManager)contextMenu, "Remove getInitialSize()");
        DialogTest.assertNotNull((Object)action);
        action.run();
        this.assertEditor("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected Control createDialogArea(Composite parent) {", "    return (Composite) super.createDialogArea(parent);", "  }", "}");
    }

    @Test
    public void test_contextMenu_usePreferredSize() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected Control createDialogArea(Composite parent) {", "    return (Composite) super.createDialogArea(parent);", "  }", "}");
        dialog.refresh();
        Dimension preferredSize = dialog.getPreferredSize().getCopy();
        IMenuManager contextMenu = DialogTest.getContextMenu(new ObjectInfo[]{dialog});
        IAction action = DialogTest.findChildAction((IContributionManager)contextMenu, "Set minimal size, as after pack()");
        DialogTest.assertNotNull((Object)action);
        action.run();
        this.assertEditor("import org.eclipse.jface.dialogs.*;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected Control createDialogArea(Composite parent) {", "    return (Composite) super.createDialogArea(parent);", "  }", "  protected Point getInitialSize() {", "    return new Point(" + preferredSize.width + ", " + preferredSize.height + ");", "  }", "}");
    }
}

