/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.jface;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.ConstructorParentAssociation;
import org.eclipse.wb.internal.core.editor.DesignPageSite;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.model.variable.WrapperMethodControlVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.rcp.model.jface.viewers.TableViewerColumnInfo;
import org.eclipse.wb.internal.rcp.model.jface.viewers.TableViewerColumnSorterPropertyEditor;
import org.eclipse.wb.internal.rcp.model.jface.viewers.ViewerColumnInfo;
import org.eclipse.wb.internal.rcp.model.jface.viewers.ViewerColumnWidgetAssociation;
import org.eclipse.wb.internal.rcp.model.jface.viewers.ViewerColumnWidgetCreationSupport;
import org.eclipse.wb.internal.swt.model.jface.viewer.ViewerInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.TableColumnInfo;
import org.eclipse.wb.internal.swt.model.widgets.TableInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class TableViewerColumnTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_setContentProvider_afterTable() throws Exception {
        this.parseComposite("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer = new TableViewer(this, SWT.NONE);", "    Table table = tableViewer.getTable();", "  }", "}");
        ViewerInfo tableViewer = (ViewerInfo)TableViewerColumnTest.getJavaInfoByName("tableViewer");
        tableViewer.addMethodInvocation("setContentProvider(org.eclipse.jface.viewers.IContentProvider)", "null");
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer = new TableViewer(this, SWT.NONE);", "    Table table = tableViewer.getTable();", "    tableViewer.setContentProvider(null);", "  }", "}");
    }

    @Test
    public void test_setLabelProvider_afterTable() throws Exception {
        this.parseComposite("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer = new TableViewer(this, SWT.NONE);", "    Table table = tableViewer.getTable();", "  }", "}");
        ViewerInfo tableViewer = (ViewerInfo)TableViewerColumnTest.getJavaInfoByName("tableViewer");
        tableViewer.addMethodInvocation("setLabelProvider(org.eclipse.jface.viewers.IBaseLabelProvider)", "null");
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer = new TableViewer(this, SWT.NONE);", "    Table table = tableViewer.getTable();", "    tableViewer.setLabelProvider(null);", "  }", "}");
    }

    @Test
    public void test_parseNormalNoColumn() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer = new TableViewer(this, SWT.NONE);", "    {", "      TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        TableViewerColumnTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new TableViewer(this, SWT.NONE)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {viewer: public org.eclipse.swt.widgets.Table org.eclipse.jface.viewers.TableViewer.getTable()} {viewer} {}", "    {new: org.eclipse.jface.viewers.TableViewer} {local-unique: tableViewer} {/new TableViewer(this, SWT.NONE)/ /new TableViewerColumn(tableViewer, SWT.NONE)/}", "    {viewer: public org.eclipse.swt.widgets.TableColumn org.eclipse.jface.viewers.TableViewerColumn.getColumn()} {viewer} {}", "      {new: org.eclipse.jface.viewers.TableViewerColumn} {local-unique: tableViewerColumn} {/new TableViewerColumn(tableViewer, SWT.NONE)/}");
        List tableColumns = table.getColumns();
        Assertions.assertThat((List)tableColumns).hasSize(1);
        TableColumnInfo column = (TableColumnInfo)tableColumns.get(0);
        List tableColumnChildren = column.getChildrenJava();
        Assertions.assertThat((List)tableColumnChildren).hasSize(1);
        ViewerColumnInfo columnViewer = (ViewerColumnInfo)tableColumnChildren.get(0);
        Association association = columnViewer.getAssociation();
        TableViewerColumnTest.assertInstanceOf(ConstructorParentAssociation.class, (Object)association);
        Association association2 = column.getAssociation();
        TableViewerColumnTest.assertInstanceOf(ViewerColumnWidgetAssociation.class, (Object)association2);
        TableViewerColumnTest.assertEquals((Object)"new TableViewerColumn(tableViewer, SWT.NONE)", (Object)association2.getSource());
        TableViewerColumnTest.assertSame((Object)association2.getStatement(), (Object)columnViewer.getAssociation().getStatement());
        VariableSupport variable = column.getVariableSupport();
        TableViewerColumnTest.assertInstanceOf(WrapperMethodControlVariableSupport.class, (Object)variable);
        TableViewerColumnTest.assertEquals((Object)"viewer", (Object)variable.toString());
        TableViewerColumnTest.assertTrue((boolean)variable.isDefault());
        TableViewerColumnTest.assertEquals((Object)"tableViewerColumn.getColumn()", (Object)variable.getTitle());
        CreationSupport creation = column.getCreationSupport();
        TableViewerColumnTest.assertInstanceOf(ViewerColumnWidgetCreationSupport.class, (Object)creation);
        TableViewerColumnTest.assertEquals((Object)"viewer: public org.eclipse.swt.widgets.TableColumn org.eclipse.jface.viewers.TableViewerColumn.getColumn()", (Object)creation.toString());
        TableViewerColumnTest.assertEquals((Object)columnViewer.getCreationSupport().getNode(), (Object)creation.getNode());
        TableViewerColumnTest.assertTrue((boolean)creation.canReorder());
        TableViewerColumnTest.assertTrue((boolean)creation.canReparent());
        ConstructorCreationSupport creationSupport = (ConstructorCreationSupport)columnViewer.getCreationSupport();
        TableViewerColumnTest.assertEquals((Object)"new TableViewerColumn(tableViewer, SWT.NONE)", (Object)this.m_lastEditor.getSource(creationSupport.getNode()));
        TableViewerColumnTest.assertTrue((boolean)column.canDelete());
        column.delete();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer = new TableViewer(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_parseAroundColumn() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer = new TableViewer(this, SWT.NONE);", "    {", "      TableColumn tableColumn = new TableColumn(tableViewer.getTable(), SWT.NONE);", "      TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, tableColumn);", "    }", "  }", "}");
        shell.refresh();
        TableViewerColumnTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new TableViewer(this, SWT.NONE)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {viewer: public org.eclipse.swt.widgets.Table org.eclipse.jface.viewers.TableViewer.getTable()} {viewer} {/new TableColumn(tableViewer.getTable(), SWT.NONE)/}", "    {new: org.eclipse.jface.viewers.TableViewer} {local-unique: tableViewer} {/new TableViewer(this, SWT.NONE)/ /tableViewer.getTable()/ /new TableViewerColumn(tableViewer, tableColumn)/}", "    {new: org.eclipse.swt.widgets.TableColumn} {local-unique: tableColumn} {/new TableColumn(tableViewer.getTable(), SWT.NONE)/ /new TableViewerColumn(tableViewer, tableColumn)/}", "      {new: org.eclipse.jface.viewers.TableViewerColumn} {local-unique: tableViewerColumn} {/new TableViewerColumn(tableViewer, tableColumn)/}");
    }

    @Test
    public void test_normalNoColumn_materialize() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer = new TableViewer(this, SWT.NONE);", "    {", "      TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        TableColumnInfo column = (TableColumnInfo)table.getColumns().get(0);
        column.getPropertyByTitle("resizable").setValue((Object)false);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer = new TableViewer(this, SWT.NONE);", "    {", "      TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);", "      TableColumn tableColumn = tableViewerColumn.getColumn();", "      tableColumn.setResizable(false);", "    }", "  }", "}");
        TableViewerColumnTest.assertInstanceOf(ViewerColumnWidgetCreationSupport.class, (Object)column.getCreationSupport());
        TableViewerColumnTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)column.getVariableSupport());
        MethodInvocation getColumnNode = (MethodInvocation)column.getRelatedNodes().get(0);
        TableViewerColumnTest.assertTrue((boolean)column.isRepresentedBy((ASTNode)getColumnNode));
    }

    @Test
    public void test_normalNoColumn_move() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer = new TableViewer(this, SWT.NONE);", "    {", "      TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(tableViewer, SWT.NONE);", "    }", "    {", "      TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(tableViewer, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        TableColumnInfo column_1 = (TableColumnInfo)table.getColumns().get(0);
        TableColumnInfo column_2 = (TableColumnInfo)table.getColumns().get(1);
        TableViewerColumnTest.flowContainer_MOVE((JavaInfo)table, column_2, column_1);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer = new TableViewer(this, SWT.NONE);", "    {", "      TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(tableViewer, SWT.NONE);", "    }", "    {", "      TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(tableViewer, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_normalNoColumn_reparent() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer_1 = new TableViewer(this, SWT.NONE);", "    {", "      TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer_1, SWT.NONE);", "    }", "    //", "    TableViewer tableViewer_2 = new TableViewer(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        TableInfo table_1 = (TableInfo)shell.getChildrenControls().get(0);
        TableInfo table_2 = (TableInfo)shell.getChildrenControls().get(1);
        TableColumnInfo column = (TableColumnInfo)table_1.getColumns().get(0);
        TableViewerColumnTest.flowContainer_MOVE((JavaInfo)table_2, column, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer_1 = new TableViewer(this, SWT.NONE);", "    //", "    TableViewer tableViewer_2 = new TableViewer(this, SWT.NONE);", "    {", "      TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer_2, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_normalWithColumn_move() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer = new TableViewer(this, SWT.NONE);", "    {", "      TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(tableViewer, SWT.NONE);", "      TableColumn tableColumn_1 = tableViewerColumn_1.getColumn();", "    }", "    {", "      TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(tableViewer, SWT.NONE);", "      TableColumn tableColumn_2 = tableViewerColumn_2.getColumn();", "    }", "  }", "}");
        shell.refresh();
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        TableColumnInfo column_1 = (TableColumnInfo)table.getColumns().get(0);
        TableColumnInfo column_2 = (TableColumnInfo)table.getColumns().get(1);
        TableViewerColumnTest.flowContainer_MOVE((JavaInfo)table, column_2, column_1);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer = new TableViewer(this, SWT.NONE);", "    {", "      TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(tableViewer, SWT.NONE);", "      TableColumn tableColumn_2 = tableViewerColumn_2.getColumn();", "    }", "    {", "      TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(tableViewer, SWT.NONE);", "      TableColumn tableColumn_1 = tableViewerColumn_1.getColumn();", "    }", "  }", "}");
    }

    @Test
    public void test_normalWithColumn_reparent() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer_1 = new TableViewer(this, SWT.NONE);", "    {", "      TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer_1, SWT.NONE);", "      TableColumn tableColumn = tableViewerColumn.getColumn();", "    }", "    //", "    TableViewer tableViewer_2 = new TableViewer(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        TableInfo table_1 = (TableInfo)shell.getChildrenControls().get(0);
        TableInfo table_2 = (TableInfo)shell.getChildrenControls().get(1);
        TableColumnInfo column = (TableColumnInfo)table_1.getColumns().get(0);
        TableViewerColumnTest.flowContainer_MOVE((JavaInfo)table_2, column, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer_1 = new TableViewer(this, SWT.NONE);", "    //", "    TableViewer tableViewer_2 = new TableViewer(this, SWT.NONE);", "    {", "      TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer_2, SWT.NONE);", "      TableColumn tableColumn = tableViewerColumn.getColumn();", "    }", "  }", "}");
    }

    @Ignore
    @Test
    public void test_copyPaste() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer = new TableViewer(this, SWT.NONE);", "    {", "      TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.RIGHT);", "    }", "  }", "}");
        shell.refresh();
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        TableColumnInfo column = (TableColumnInfo)table.getColumns().get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)column);
        TableColumnInfo newColumn = (TableColumnInfo)memento.create((JavaInfo)shell);
        TableViewerColumnTest.flowContainer_CREATE((JavaInfo)table, newColumn, null);
        memento.apply();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer = new TableViewer(this, SWT.NONE);", "    {", "      TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.RIGHT);", "    }", "    {", "      TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.RIGHT);", "      TableColumn tableColumn = tableViewerColumn.getColumn();", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer = new TableViewer(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        ViewerColumnInfo columnViewer = this.createTableViewerColumn();
        TableColumnInfo column = (TableColumnInfo)JavaInfoUtils.getWrapped((JavaInfo)columnViewer);
        TableViewerColumnTest.assertSame((Object)column, (Object)JavaInfoUtils.getWrapped((JavaInfo)column));
        CreationSupport creationSupport = column.getCreationSupport();
        ASTNode node = creationSupport.getNode();
        TableViewerColumnTest.assertNull((Object)node);
        TableViewerColumnTest.assertFalse((boolean)creationSupport.isJavaInfo(null));
        TableViewerColumnTest.assertFalse((boolean)creationSupport.canReorder());
        TableViewerColumnTest.assertFalse((boolean)creationSupport.canReparent());
        TableViewerColumnTest.flowContainer_CREATE((JavaInfo)table, column, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer = new TableViewer(this, SWT.NONE);", "    {", "      TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);", "      TableColumn tableColumn = tableViewerColumn.getColumn();", "      tableColumn.setWidth(100);", "      tableColumn.setText('New Column');", "    }", "  }", "}");
        TableViewerColumnTest.assertSame((Object)table, (Object)column.getParent());
        creationSupport = column.getCreationSupport();
        TableViewerColumnTest.assertInstanceOf(ViewerColumnWidgetCreationSupport.class, (Object)creationSupport);
        TableViewerColumnTest.assertSame((Object)column, (Object)ReflectionUtils.getFieldObject((Object)creationSupport, (String)"m_javaInfo"));
        TableViewerColumnTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)column.getVariableSupport());
        TableViewerColumnTest.assertEquals((Object)"{viewer: public org.eclipse.swt.widgets.TableColumn org.eclipse.jface.viewers.TableViewerColumn.getColumn()} {local-unique: tableColumn} {/tableViewerColumn.getColumn()/ /tableColumn.setText(\"New Column\")/ /tableColumn.setWidth(100)/}", (Object)column.toString());
        TableViewerColumnTest.assertSame((Object)columnViewer, column.getChildrenJava().get(0));
        TableViewerColumnTest.assertInstanceOf(ConstructorCreationSupport.class, (Object)columnViewer.getCreationSupport());
        TableViewerColumnTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)columnViewer.getVariableSupport());
        TableViewerColumnTest.assertEquals((Object)"tableViewerColumn", (Object)columnViewer.getVariableSupport().getName());
        TableViewerColumnTest.assertEquals((Object)"{new: org.eclipse.jface.viewers.TableViewerColumn} {local-unique: tableViewerColumn} {/new TableViewerColumn(tableViewer, SWT.NONE)/ /tableViewerColumn.getColumn()/}", (Object)columnViewer.toString());
        Association viewerAssociation = columnViewer.getAssociation();
        Association columnAssociation = column.getAssociation();
        TableViewerColumnTest.assertInstanceOf(ConstructorParentAssociation.class, (Object)viewerAssociation);
        TableViewerColumnTest.assertEquals((Object)"new TableViewerColumn(tableViewer, SWT.NONE)", (Object)viewerAssociation.getSource());
        TableViewerColumnTest.assertSame((Object)viewerAssociation.getStatement(), (Object)columnAssociation.getStatement());
    }

    private ViewerColumnInfo createTableViewerColumn() throws Exception {
        return (ViewerColumnInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, (String)"org.eclipse.jface.viewers.TableViewerColumn", (CreationSupport)new ConstructorCreationSupport());
    }

    @Test
    public void test_sorterProperty() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer = new TableViewer(this, SWT.NONE);", "    {", "      TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        TableViewerColumnInfo column = (TableViewerColumnInfo)TableViewerColumnTest.getJavaInfoByName("tableViewerColumn");
        Property sorterProperty = column.getPropertyByTitle("sorter");
        TableViewerColumnTest.assertNotNull((Object)sorterProperty);
        TableViewerColumnSorterPropertyEditor sorterEditor = (TableViewerColumnSorterPropertyEditor)sorterProperty.getEditor();
        TableViewerColumnTest.assertNull((Object)sorterProperty.getValue());
        TableViewerColumnTest.assertFalse((boolean)sorterProperty.isModified());
        TableViewerColumnTest.assertEquals((Object)"<double click>", (Object)TableViewerColumnTest.getPropertyText(sorterProperty));
        ArgumentCaptor positionCapture = ArgumentCaptor.forClass(Integer.class);
        IDesignPageSite designerPageSite = (IDesignPageSite)Mockito.mock(IDesignPageSite.class);
        DesignPageSite.Helper.setSite((ObjectInfo)shell, (IDesignPageSite)designerPageSite);
        sorterEditor.doubleClick(sorterProperty, null);
        ((IDesignPageSite)Mockito.verify((Object)designerPageSite)).openSourcePosition(((Integer)positionCapture.capture()).intValue());
        Assertions.assertThat((String)this.m_lastEditor.getSource()).contains(new CharSequence[]{"new TableViewerColumnSorter(tableViewerColumn) {"});
        int position = (Integer)positionCapture.getValue();
        String actual = this.m_lastEditor.getSource(position, 48);
        TableViewerColumnTest.assertEquals((Object)"new TableViewerColumnSorter(tableViewerColumn) {", (Object)actual);
        TableViewerColumnTest.assertEquals((Object)"<exists>", (Object)TableViewerColumnTest.getPropertyText(sorterProperty));
        sorterProperty.setValue(Property.UNKNOWN_VALUE);
        this.assertEditor("import org.eclipse.wb.swt.TableViewerColumnSorter;", "public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer = new TableViewer(this, SWT.NONE);", "    {", "      TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);", "    }", "  }", "}");
        TableViewerColumnTest.assertEquals((Object)"<double click>", (Object)TableViewerColumnTest.getPropertyText(sorterProperty));
    }
}

