/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.property;

import java.util.List;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.order.TabOrderInfo;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipTextProvider;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.property.TabOrderProperty;
import org.eclipse.wb.internal.swt.model.widgets.ButtonInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class TabOrderPropertyTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_common() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        composite.refresh();
        TabOrderProperty property = (TabOrderProperty)composite.getPropertyByTitle("tab order");
        TabOrderPropertyTest.assertNotNull((Object)property);
        TabOrderPropertyTest.assertFalse((boolean)property.isModified());
        TabOrderPropertyTest.assertNull((Object)property.getAdapter(Object.class));
        PropertyTooltipProvider tooltipProvider = (PropertyTooltipProvider)property.getAdapter(PropertyTooltipProvider.class);
        TabOrderPropertyTest.assertInstanceOf(PropertyTooltipTextProvider.class, (Object)tooltipProvider);
        TabOrderPropertyTest.assertNotNull((Object)ReflectionUtils.invokeMethod((Object)tooltipProvider, (String)"getText(org.eclipse.wb.internal.core.model.property.Property)", (Object[])new Object[]{property}));
    }

    @Test
    public void test_noValue_addNewComponent() throws Exception {
        CompositeInfo container = this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('New Button');", "    }", "  }", "}");
        container.refresh();
        ButtonInfo newButton = (ButtonInfo)TabOrderPropertyTest.createJavaInfo("org.eclipse.swt.widgets.Button");
        JavaInfoUtils.add((JavaInfo)newButton, null, (JavaInfo)container, null);
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('New Button');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
    }

    @Test
    public void test_getValue_noValue() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(2, false));", "    new Label(this, SWT.NONE);", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('New Button');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Combo combo_1 = new Combo(this, SWT.NONE);", "    }", "  }", "}");
        composite.refresh();
        TabOrderProperty property = (TabOrderProperty)composite.getPropertyByTitle("tab order");
        TabOrderInfo info = (TabOrderInfo)property.getValue();
        List controls = composite.getChildrenControls();
        ControlInfo button = (ControlInfo)controls.get(1);
        ControlInfo combo = (ControlInfo)controls.get(5);
        TabOrderPropertyTest.assertEquals((long)2L, (long)info.getInfos().size());
        TabOrderPropertyTest.assertSame((Object)button, info.getInfos().get(0));
        TabOrderPropertyTest.assertSame((Object)combo, info.getInfos().get(1));
        TabOrderPropertyTest.assertEquals((long)2L, (long)info.getOrderedInfos().size());
        TabOrderPropertyTest.assertSame((Object)button, info.getOrderedInfos().get(0));
        TabOrderPropertyTest.assertSame((Object)combo, info.getOrderedInfos().get(1));
    }

    @Test
    public void test_getValue() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  private Button button_1;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(2, false));", "    new Label(this, SWT.NONE);", "    {", "      button_1 = new Button(this, SWT.NONE);", "      button_1.setText('New Button');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Combo combo_1 = new Combo(this, SWT.NONE);", "    }", "    setTabList(new Control[]{button_1});", "  }", "}");
        composite.refresh();
        TabOrderProperty property = (TabOrderProperty)composite.getPropertyByTitle("tab order");
        TabOrderInfo info = (TabOrderInfo)property.getValue();
        List controls = composite.getChildrenControls();
        ControlInfo button = (ControlInfo)controls.get(1);
        ControlInfo combo = (ControlInfo)controls.get(5);
        TabOrderPropertyTest.assertEquals((long)2L, (long)info.getInfos().size());
        TabOrderPropertyTest.assertSame((Object)button, info.getInfos().get(0));
        TabOrderPropertyTest.assertSame((Object)combo, info.getInfos().get(1));
        TabOrderPropertyTest.assertEquals((long)1L, (long)info.getOrderedInfos().size());
        TabOrderPropertyTest.assertSame((Object)button, info.getOrderedInfos().get(0));
    }

    @Test
    public void test_setValue_UNKNOWN_VALUE() throws Exception {
        this.test_setValue(new String[]{"public class Test extends Composite {", "  private Button button_1;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(2, false));", "    {", "      button_1 = new Button(this, SWT.NONE);", "      button_1.setText(\"New Button\");", "    }", "    {", "      Combo combo_1 = new Combo(this, SWT.NONE);", "    }", "    setTabList(new Control[]{button_1});", "  }", "}"}, Property.UNKNOWN_VALUE, new String[]{"public class Test extends Composite {", "  private Button button_1;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(2, false));", "    {", "      button_1 = new Button(this, SWT.NONE);", "      button_1.setText(\"New Button\");", "    }", "    {", "      Combo combo_1 = new Combo(this, SWT.NONE);", "    }", "  }", "}"});
    }

    @Test
    public void test_setValue_noValue() throws Exception {
        this.test_setValue(new String[]{"public class Test extends Composite {", "  private Button button_1;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(2, false));", "    {", "      button_1 = new Button(this, SWT.NONE);", "      button_1.setText(\"New Button\");", "    }", "    {", "      Combo combo_1 = new Combo(this, SWT.NONE);", "    }", "    setTabList(new Control[]{button_1});", "  }", "}"}, new TabOrderInfo(), new String[]{"public class Test extends Composite {", "  private Button button_1;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(2, false));", "    {", "      button_1 = new Button(this, SWT.NONE);", "      button_1.setText(\"New Button\");", "    }", "    {", "      Combo combo_1 = new Combo(this, SWT.NONE);", "    }", "  }", "}"});
    }

    private void test_setValue(String[] startSource, Object value, String[] newSource) throws Exception {
        CompositeInfo composite = this.parseComposite(startSource);
        composite.refresh();
        TabOrderProperty property = (TabOrderProperty)composite.getPropertyByTitle("tab order");
        property.setValue(value);
        this.assertEditor(newSource);
    }

    @Test
    public void test_setValue() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    {", "      Combo combo = new Combo(this, SWT.NONE);", "    }", "  }", "}");
        composite.refresh();
        TabOrderProperty property = (TabOrderProperty)composite.getPropertyByTitle("tab order");
        TabOrderInfo newValue = new TabOrderInfo();
        newValue.addOrderedInfo((AbstractComponentInfo)composite.getChildrenControls().get(1));
        property.setValue((Object)newValue);
        this.assertEditor("public class Test extends Composite {", "  private Combo combo;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    {", "      combo = new Combo(this, SWT.NONE);", "    }", "    setTabList(new Control[]{combo});", "  }", "}");
        ControlInfo newControl = (ControlInfo)TabOrderPropertyTest.createJavaInfo("org.eclipse.swt.widgets.Label");
        composite.getLayout().command_CREATE(newControl, null);
        this.assertEditor("public class Test extends Composite {", "  private Combo combo;", "  private Label label;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    {", "      combo = new Combo(this, SWT.NONE);", "    }", "    {", "      label = new Label(this, SWT.NONE);", "      label.setText('New Label');", "    }", "    setTabList(new Control[]{combo, label});", "  }", "}");
    }

    @Test
    public void test_delete() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  private Button button;", "  private Combo combo;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    {", "      button = new Button(this, SWT.NONE);", "    }", "    {", "      combo = new Combo(this, SWT.NONE);", "    }", "    {", "      Combo combo_2 = new Combo(this, SWT.NONE);", "    }", "    setTabList(new Control[]{button, combo});", "  }", "}");
        composite.refresh();
        TabOrderProperty property = (TabOrderProperty)composite.getPropertyByTitle("tab order");
        TabOrderInfo info = (TabOrderInfo)property.getValue();
        List components = composite.getChildrenControls();
        ControlInfo button = (ControlInfo)components.get(0);
        ControlInfo combo = (ControlInfo)components.get(1);
        ControlInfo combo2 = (ControlInfo)components.get(2);
        TabOrderPropertyTest.assertEquals((long)3L, (long)info.getInfos().size());
        TabOrderPropertyTest.assertSame((Object)button, info.getInfos().get(0));
        TabOrderPropertyTest.assertSame((Object)combo, info.getInfos().get(1));
        TabOrderPropertyTest.assertSame((Object)combo2, info.getInfos().get(2));
        TabOrderPropertyTest.assertEquals((long)2L, (long)info.getOrderedInfos().size());
        TabOrderPropertyTest.assertSame((Object)button, info.getOrderedInfos().get(0));
        TabOrderPropertyTest.assertSame((Object)combo, info.getOrderedInfos().get(1));
        combo2.delete();
        this.assertEditor("public class Test extends Composite {", "  private Button button;", "  private Combo combo;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    {", "      button = new Button(this, SWT.NONE);", "    }", "    {", "      combo = new Combo(this, SWT.NONE);", "    }", "    setTabList(new Control[]{button, combo});", "  }", "}");
        combo.delete();
        this.assertEditor("public class Test extends Composite {", "  private Button button;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    {", "      button = new Button(this, SWT.NONE);", "    }", "    setTabList(new Control[]{button});", "  }", "}");
        button.delete();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "  }", "}");
    }

    @Test
    public void test_delete_2() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  private Button button_1;", "  private Combo combo;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    {", "      button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      combo = new Combo(this, SWT.NONE);", "    }", "    {", "      Label label = new Label(this, SWT.NONE);", "    }", "  }", "}");
        composite.refresh();
        TabOrderProperty property = (TabOrderProperty)composite.getPropertyByTitle("tab order");
        TabOrderInfo info = (TabOrderInfo)property.getValue();
        List components = composite.getChildrenControls();
        ControlInfo button = (ControlInfo)components.get(0);
        ControlInfo combo = (ControlInfo)components.get(1);
        ControlInfo label = (ControlInfo)components.get(2);
        TabOrderPropertyTest.assertEquals((long)3L, (long)info.getInfos().size());
        TabOrderPropertyTest.assertSame((Object)button, info.getInfos().get(0));
        TabOrderPropertyTest.assertSame((Object)combo, info.getInfos().get(1));
        TabOrderPropertyTest.assertSame((Object)label, info.getInfos().get(2));
        TabOrderPropertyTest.assertEquals((long)2L, (long)info.getOrderedInfos().size());
        TabOrderPropertyTest.assertSame((Object)button, info.getOrderedInfos().get(0));
        TabOrderPropertyTest.assertSame((Object)combo, info.getOrderedInfos().get(1));
        label.delete();
        this.assertEditor("public class Test extends Composite {", "  private Button button_1;", "  private Combo combo;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    {", "      button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      combo = new Combo(this, SWT.NONE);", "    }", "  }", "}");
        combo.delete();
        this.assertEditor("public class Test extends Composite {", "  private Button button_1;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    {", "      button_1 = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }
}

