/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.draw2d;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.draw2d.border.CompoundBorder;
import org.eclipse.wb.draw2d.border.LineBorder;
import org.eclipse.wb.draw2d.border.MarginBorder;
import org.eclipse.wb.internal.draw2d.Label;
import org.eclipse.wb.tests.draw2d.Draw2dFigureTestCase;
import org.eclipse.wb.tests.draw2d.TestCaseRootFigure;
import org.eclipse.wb.tests.gef.TestLogger;
import org.junit.Test;

public class LabelTest
extends Draw2dFigureTestCase {
    @Test
    public void test_text() throws Exception {
        LabelTest.assertEquals((Object)"", (Object)new Label().getText());
        LabelTest.assertEquals((Object)"Column: 1", (Object)new Label("Column: 1").getText());
        Label label = new Label();
        label.setText("123ZzzzZ");
        LabelTest.assertEquals((Object)"123ZzzzZ", (Object)label.getText());
        label.setText("Row: 0");
        LabelTest.assertEquals((Object)"Row: 0", (Object)label.getText());
        label.setText(null);
        LabelTest.assertEquals((Object)"", (Object)label.getText());
    }

    @Test
    public void test_resetState() throws Exception {
        TestLogger actualLogger = new TestLogger();
        TestCaseRootFigure parentFigure = new TestCaseRootFigure(actualLogger);
        TestLogger expectedLogger = new TestLogger();
        Label label = new Label();
        parentFigure.add((IFigure)label);
        actualLogger.clear();
        label.setText("");
        actualLogger.assertEmpty();
        label.setText(null);
        actualLogger.assertEmpty();
        label.setText("123");
        expectedLogger.log("invalidate");
        expectedLogger.log("repaint(0, 0, 0, 0)");
        actualLogger.assertEquals(expectedLogger);
        label.setText("123");
        actualLogger.assertEmpty();
        label.setText("231");
        expectedLogger.log("invalidate");
        expectedLogger.log("repaint(0, 0, 0, 0)");
        actualLogger.assertEquals(expectedLogger);
        label.setText(null);
        expectedLogger.log("invalidate");
        expectedLogger.log("repaint(0, 0, 0, 0)");
        actualLogger.assertEquals(expectedLogger);
    }

    @Test
    public void test_getPreferredSize() throws Exception {
        Label label = new Label();
        LabelTest.assertTextSize(label);
        Dimension size1 = label.getPreferredSize();
        label.setText("1234");
        Dimension size2 = label.getPreferredSize();
        LabelTest.assertTextSize(label);
        LabelTest.assertNotSame((Object)size1, (Object)size2);
        LabelTest.assertSame((Object)size2, (Object)label.getPreferredSize());
        label.setFont(new Font(null, "", 100, 0));
        LabelTest.assertNotSame((Object)size2, (Object)label.getPreferredSize());
        LabelTest.assertTextSize(label);
        label.setBorder((Border)new CompoundBorder((org.eclipse.wb.draw2d.border.Border)new LineBorder(), (org.eclipse.wb.draw2d.border.Border)new MarginBorder(2)));
        LabelTest.assertTextSize(label);
    }

    private static final void assertTextSize(Label label) throws Exception {
        GC gc = new GC((Drawable)Display.getDefault());
        gc.setFont(label.getFont());
        Point size = gc.textExtent(label.getText());
        gc.dispose();
        Insets insets = label.getInsets();
        Dimension expectedSize = new Dimension(size).expand(insets.getWidth(), insets.getHeight());
        LabelTest.assertEquals((Object)expectedSize, (Object)label.getPreferredSize());
    }
}

