/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.converter;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.converter.BooleanConverter;
import org.eclipse.wb.internal.core.model.property.converter.ExpressionConverter;

public final class BooleanArrayConverter
extends ExpressionConverter {
    public static final BooleanArrayConverter INSTANCE = new BooleanArrayConverter();

    private BooleanArrayConverter() {
    }

    @Override
    public String toJavaSource(JavaInfo javaInfo, Object value) {
        if (value == null) {
            return "(boolean[]) null";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("new boolean[] {");
        boolean[] items = (boolean[])value;
        int i = 0;
        while (i < items.length) {
            boolean item = items[i];
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(BooleanConverter.INSTANCE.toJavaSource(javaInfo, item));
            ++i;
        }
        buffer.append("}");
        return buffer.toString();
    }
}

