/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.beans.PropertyChangeListener;
import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.ScrollPaneSolver;
import org.eclipse.draw2d.UpdateListener;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FigureCanvas
extends Canvas {
    private static final int ACCEPTED_STYLES = 638847744;
    static final int DEFAULT_STYLES = 1311488;
    private static final int REQUIRED_STYLES = 0x100300;
    public static int NEVER = 0;
    public static int AUTOMATIC = 1;
    public static int ALWAYS = 2;
    private int vBarVisibility = AUTOMATIC;
    private int hBarVisibility = AUTOMATIC;
    private Viewport viewport;
    private Font font;
    private int hBarOffset;
    private int vBarOffset;
    private final PropertyChangeListener horizontalChangeListener = event -> {
        RangeModel model = this.getViewport().getHorizontalRangeModel();
        this.hBarOffset = Math.max(0, -model.getMinimum());
        this.getHorizontalBar().setValues(model.getValue() + this.hBarOffset, model.getMinimum() + this.hBarOffset, model.getMaximum() + this.hBarOffset, model.getExtent(), Math.max(1, model.getExtent() / 20), Math.max(1, model.getExtent() * 3 / 4));
    };
    private final PropertyChangeListener verticalChangeListener = event -> {
        RangeModel model = this.getViewport().getVerticalRangeModel();
        this.vBarOffset = Math.max(0, -model.getMinimum());
        this.getVerticalBar().setValues(model.getValue() + this.vBarOffset, model.getMinimum() + this.vBarOffset, model.getMaximum() + this.vBarOffset, model.getExtent(), Math.max(1, model.getExtent() / 20), Math.max(1, model.getExtent() * 3 / 4));
    };
    private final LightweightSystem lws;

    public FigureCanvas(Composite parent) {
        this(parent, 0x20000000, new LightweightSystem());
    }

    public FigureCanvas(Composite parent, int style) {
        this(parent, style, new LightweightSystem());
    }

    public FigureCanvas(int style, Composite parent) {
        this(style, parent, new LightweightSystem());
    }

    public FigureCanvas(Composite parent, LightweightSystem lws) {
        this(parent, 0x20000000, lws);
    }

    public FigureCanvas(int style, Composite parent, LightweightSystem lws) {
        super(parent, FigureCanvas.checkStyle(style));
        this.getHorizontalBar().setVisible(false);
        this.getVerticalBar().setVisible(false);
        this.lws = lws;
        lws.setControl(this);
        this.hook();
    }

    public FigureCanvas(Composite parent, int style, LightweightSystem lws) {
        this(style | 0x140300, parent, lws);
    }

    private static int checkStyle(int style) {
        if ((style & 0x100300) != 0x100300) {
            throw new IllegalArgumentException("Required style missing on FigureCanvas");
        }
        if ((style & 0xD9EBF4FF) != 0) {
            throw new IllegalArgumentException("Invalid style being set on FigureCanvas");
        }
        return style;
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        int borderSize = this.computeTrim((int)0, (int)0, (int)0, (int)0).x * -2;
        if (wHint >= 0) {
            wHint = Math.max(0, wHint - borderSize);
        }
        if (hHint >= 0) {
            hHint = Math.max(0, hHint - borderSize);
        }
        Dimension size = this.getLightweightSystem().getRootFigure().getPreferredSize(wHint, hHint).getExpanded(borderSize, borderSize);
        size.union(new Dimension(wHint, hHint));
        return new org.eclipse.swt.graphics.Point(size.width, size.height);
    }

    public IFigure getContents() {
        return this.getViewport().getContents();
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = super.getFont();
        }
        return this.font;
    }

    public int getHorizontalScrollBarVisibility() {
        return this.hBarVisibility;
    }

    public LightweightSystem getLightweightSystem() {
        return this.lws;
    }

    public int getVerticalScrollBarVisibility() {
        return this.vBarVisibility;
    }

    public Viewport getViewport() {
        if (this.viewport == null) {
            this.setViewport(new Viewport(true));
        }
        return this.viewport;
    }

    private void hook() {
        this.getLightweightSystem().getUpdateManager().addUpdateListener(new UpdateListener(){

            @Override
            public void notifyPainting(Rectangle damage, Map<IFigure, Rectangle> dirtyRegions) {
            }

            @Override
            public void notifyValidating() {
                if (!FigureCanvas.this.isDisposed()) {
                    FigureCanvas.this.layoutViewport();
                }
            }
        });
        this.getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FigureCanvas.this.scrollToX(FigureCanvas.this.getHorizontalBar().getSelection() - FigureCanvas.this.hBarOffset);
            }
        });
        this.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FigureCanvas.this.scrollToY(FigureCanvas.this.getVerticalBar().getSelection() - FigureCanvas.this.vBarOffset);
            }
        });
    }

    private void hookViewport() {
        this.getViewport().getHorizontalRangeModel().addPropertyChangeListener(this.horizontalChangeListener);
        this.getViewport().getVerticalRangeModel().addPropertyChangeListener(this.verticalChangeListener);
    }

    private void unhookViewport() {
        this.getViewport().getHorizontalRangeModel().removePropertyChangeListener(this.horizontalChangeListener);
        this.getViewport().getVerticalRangeModel().removePropertyChangeListener(this.verticalChangeListener);
    }

    private void layoutViewport() {
        int vBarWidth = 0;
        int hBarHeight = 0;
        if ((this.getScrollbarsMode() & 2) == 0) {
            org.eclipse.swt.graphics.Rectangle trim = this.computeTrim(0, 0, 0, 0);
            vBarWidth = trim.width;
            hBarHeight = trim.height;
        }
        ScrollPaneSolver.Result result = ScrollPaneSolver.solve(new Rectangle(this.getBounds()).setLocation(0, 0), this.getViewport(), this.getHorizontalScrollBarVisibility(), this.getVerticalScrollBarVisibility(), vBarWidth, hBarHeight);
        this.getLightweightSystem().setIgnoreResize(true);
        try {
            if (this.getHorizontalBar().getVisible() != result.showH) {
                this.getHorizontalBar().setVisible(result.showH);
            }
            if (this.getVerticalBar().getVisible() != result.showV) {
                this.getVerticalBar().setVisible(result.showV);
            }
            Rectangle r = new Rectangle(result.viewportArea);
            r.setLocation(0, 0);
            this.getLightweightSystem().getRootFigure().setBounds(r);
        }
        finally {
            this.getLightweightSystem().setIgnoreResize(false);
        }
    }

    public void scrollSmoothTo(int x, int y) {
        x = FigureCanvas.verifyScrollBarOffset(this.getViewport().getHorizontalRangeModel(), x);
        y = FigureCanvas.verifyScrollBarOffset(this.getViewport().getVerticalRangeModel(), y);
        int oldX = this.getViewport().getViewLocation().x;
        int oldY = this.getViewport().getViewLocation().y;
        int dx = x - oldX;
        int dy = y - oldY;
        if (dx == 0 && dy == 0) {
            return;
        }
        Dimension viewingArea = this.getViewport().getClientArea().getSize();
        int minFrames = 3;
        int maxFrames = 6;
        if (dx == 0 || dy == 0) {
            minFrames = 6;
            maxFrames = 13;
        }
        int frames = (Math.abs(dx) + Math.abs(dy)) / 15;
        frames = Math.max(frames, minFrames);
        frames = Math.min(frames, maxFrames);
        int stepX = Math.min(dx / frames, viewingArea.width / 3);
        int stepY = Math.min(dy / frames, viewingArea.height / 3);
        int i = 1;
        while (i < frames) {
            this.scrollTo(oldX + i * stepX, oldY + i * stepY);
            this.getViewport().getUpdateManager().performUpdate();
            ++i;
        }
        this.scrollTo(x, y);
    }

    public void scrollTo(int x, int y) {
        int hOffset = FigureCanvas.verifyScrollBarOffset(this.getViewport().getHorizontalRangeModel(), x);
        int vOffset = FigureCanvas.verifyScrollBarOffset(this.getViewport().getVerticalRangeModel(), y);
        this.performScroll(hOffset, vOffset);
    }

    public void scrollToX(int hOffset) {
        int hOffsetOld;
        hOffset = FigureCanvas.verifyScrollBarOffset(this.getViewport().getHorizontalRangeModel(), hOffset);
        if (hOffset == (hOffsetOld = this.getViewport().getViewLocation().x)) {
            return;
        }
        this.performScroll(hOffset, this.getViewport().getViewLocation().y);
    }

    public void scrollToY(int vOffset) {
        int vOffsetOld;
        vOffset = FigureCanvas.verifyScrollBarOffset(this.getViewport().getVerticalRangeModel(), vOffset);
        if (vOffset == (vOffsetOld = this.getViewport().getViewLocation().y)) {
            return;
        }
        this.performScroll(this.getViewport().getViewLocation().x, vOffset);
    }

    private void performScroll(int hOffset, int vOffset) {
        int dx = -hOffset + this.getViewport().getViewLocation().x;
        int dy = -vOffset + this.getViewport().getViewLocation().y;
        Rectangle clientArea = this.getViewport().getBounds().getShrinked(this.getViewport().getInsets());
        Rectangle blit = clientArea.getResized(-Math.abs(dx), -Math.abs(dy));
        Point dest = clientArea.getTopLeft();
        blit.width = Math.max(blit.width, 0);
        blit.height = Math.max(blit.height, 0);
        if (dx < 0) {
            blit.translate(-dx, 0);
        } else {
            dest.x += dx;
        }
        if (dy < 0) {
            blit.translate(0, -dy);
        } else {
            dest.y += dy;
        }
        this.scrollChildren(dx, dy, blit, dest);
        this.getViewport().setIgnoreScroll(true);
        this.getViewport().setHorizontalLocation(hOffset);
        this.getViewport().setVerticalLocation(vOffset);
        this.getViewport().setIgnoreScroll(false);
        this.scrollRedraw(dx, dy, clientArea, blit);
    }

    private void scrollChildren(int dx, int dy, Rectangle blit, Point dest) {
        org.eclipse.swt.graphics.Rectangle bounds;
        Control[] children = this.getChildren();
        boolean[] manualMove = new boolean[children.length];
        int i = 0;
        while (i < children.length) {
            bounds = children[i].getBounds();
            manualMove[i] = blit.width <= 0 || bounds.x > blit.x + blit.width || bounds.y > blit.y + blit.height || bounds.x + bounds.width < blit.x || bounds.y + bounds.height < blit.y;
            ++i;
        }
        this.scroll(dest.x, dest.y, blit.x, blit.y, blit.width, blit.height, true);
        i = 0;
        while (i < children.length) {
            if (!children[i].isDisposed()) {
                bounds = children[i].getBounds();
                if (manualMove[i]) {
                    children[i].setBounds(bounds.x + dx, bounds.y + dy, bounds.width, bounds.height);
                }
            }
            ++i;
        }
    }

    private void scrollRedraw(int dx, int dy, Rectangle clientArea, Rectangle blit) {
        Rectangle expose = clientArea.getCopy();
        if (dx != 0) {
            expose.width = Math.abs(dx);
            if (dx < 0) {
                expose.x += blit.width;
            }
            this.redraw(expose.x, expose.y, expose.width, expose.height, true);
        }
        if (dy != 0) {
            expose.x = clientArea.x;
            expose.width = clientArea.width;
            expose.height = Math.abs(dy);
            if (dy < 0) {
                expose.y += blit.height;
            }
            this.redraw(expose.x, expose.y, expose.width, expose.height, true);
        }
    }

    public void setBorder(Border border) {
        this.getLightweightSystem().getRootFigure().setBorder(border);
    }

    public void setContents(IFigure figure) {
        this.getViewport().setContents(figure);
    }

    public void setFont(Font font) {
        this.font = font;
        super.setFont(font);
    }

    public void setHorizontalScrollBarVisibility(int v) {
        this.hBarVisibility = v;
    }

    public void setScrollBarVisibility(int both) {
        this.setHorizontalScrollBarVisibility(both);
        this.setVerticalScrollBarVisibility(both);
    }

    public void setVerticalScrollBarVisibility(int v) {
        this.vBarVisibility = v;
    }

    public void setViewport(Viewport vp) {
        if (this.viewport != null) {
            this.unhookViewport();
        }
        this.viewport = vp;
        this.lws.setContents(this.viewport);
        this.hookViewport();
    }

    private static int verifyScrollBarOffset(RangeModel model, int value) {
        value = Math.max(model.getMinimum(), value);
        return Math.min(model.getMaximum() - model.getExtent(), value);
    }
}

