/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property;

import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.PropertyManager;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.swing.SwingToolkitDescription;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.AbstractJavaProjectTest;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.designer.tests.common.PropertyWithTitle;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;

public class PropertyManagerTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_unknownProperty() throws Exception {
        PropertyWithTitle property = new PropertyWithTitle("title");
        property.setCategory(PropertyCategory.ADVANCED);
        PropertyManagerTest.assertSame((Object)PropertyCategory.ADVANCED, (Object)PropertyManager.getCategory((Property)property));
        PropertyManager.setCategory((Property)property, (PropertyCategory)PropertyCategory.PREFERRED);
        PropertyManagerTest.assertSame((Object)PropertyCategory.ADVANCED, (Object)PropertyManager.getCategory((Property)property));
    }

    @Test
    public void test_GenericProperty() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Property property = panel.getPropertyByTitle("background");
        PropertyManagerTest.assertSame(null, (Object)PropertyManager.getCategoryForced((Property)property));
        PropertyManagerTest.assertSame((Object)PropertyCategory.NORMAL, (Object)PropertyManager.getCategory((Property)property));
        this.checkCategory(property, PropertyCategory.PREFERRED);
        this.checkCategory(property, PropertyCategory.NORMAL);
        this.checkCategory(property, PropertyCategory.ADVANCED);
        PropertyManager.setCategory((Property)property, null);
        PropertyManagerTest.assertSame((Object)PropertyCategory.NORMAL, (Object)PropertyManager.getCategory((Property)property));
        PropertyManager.setCategory((Property)property, (PropertyCategory)PropertyCategory.PREFERRED);
    }

    private void checkCategory(Property property, PropertyCategory category) {
        PropertyManager.setCategory((Property)property, (PropertyCategory)category);
        PropertyManagerTest.assertSame((Object)category, (Object)PropertyManager.getCategoryForced((Property)property));
        PropertyManagerTest.assertSame((Object)category, (Object)PropertyManager.getCategory((Property)property));
        PropertyManager.flushCache();
        PropertyManagerTest.assertSame((Object)category, (Object)PropertyManager.getCategory((Property)property));
    }

    @Test
    public void test_GenericProperty2() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Property property = panel.getPropertyByTitle("background");
        PropertyManagerTest.assertSame((Object)PropertyCategory.PREFERRED, (Object)PropertyManager.getCategory((Property)property));
    }

    @AfterAll
    public static void tearDownClass() throws Exception {
        AbstractJavaProjectTest.tearDownClass();
        PropertyManager.setCategory((ToolkitDescription)SwingToolkitDescription.INSTANCE, (String)"background", null);
    }
}

