/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.layout;

import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpGefTest;
import org.junit.jupiter.api.Test;

public class StackLayoutGefTest
extends RcpGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_CREATE_onCanvas_empty() throws Exception {
        CompositeInfo shell = this.openComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "  }", "}");
        this.loadCreationTool("org.eclipse.swt.widgets.Button", "empty");
        this.canvas.moveTo((Object)shell, 100, 100).click();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_onCanvas_beforeExisting() throws Exception {
        CompositeInfo shell = this.openComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        ControlInfo button_1 = (ControlInfo)StackLayoutGefTest.getJavaInfoByName("button_1");
        this.canvas.select(shell);
        this.loadCreationTool("org.eclipse.swt.widgets.Button", "empty");
        this.canvas.moveTo((Object)button_1, 2, 100).click();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_onCanvas_afterExisting() throws Exception {
        CompositeInfo shell = this.openComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        ControlInfo button_1 = (ControlInfo)StackLayoutGefTest.getJavaInfoByName("button_1");
        this.canvas.select(shell);
        this.loadCreationTool("org.eclipse.swt.widgets.Button", "empty");
        this.canvas.moveTo((Object)button_1, -2, 100).click();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_inTree_empty() throws Exception {
        CompositeInfo shell = this.openComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "  }", "}");
        this.loadCreationTool("org.eclipse.swt.widgets.Button", "empty");
        this.tree.moveOn(shell);
        this.tree.assertCommandNotNull();
        this.tree.click();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_inTree_beforeExisting() throws Exception {
        this.openComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        ControlInfo button_1 = (ControlInfo)StackLayoutGefTest.getJavaInfoByName("button_1");
        this.loadCreationTool("org.eclipse.swt.widgets.Button", "empty");
        this.tree.moveBefore(button_1).click();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_inTree_afterExisting() throws Exception {
        this.openComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        ControlInfo button_1 = (ControlInfo)StackLayoutGefTest.getJavaInfoByName("button_1");
        this.loadCreationTool("org.eclipse.swt.widgets.Button", "empty");
        this.tree.moveAfter(button_1).click();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_inTree() throws Exception {
        this.openComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button 1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button 2');", "    }", "  }", "}");
        ControlInfo button_1 = (ControlInfo)StackLayoutGefTest.getJavaInfoByName("button_1");
        ControlInfo button_2 = (ControlInfo)StackLayoutGefTest.getJavaInfoByName("button_2");
        this.tree.startDrag(button_2).dragBefore(button_1).endDrag();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button 2');", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button 1');", "    }", "  }", "}");
    }

    @Test
    public void test_navigation_next() throws Exception {
        this.openComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button 1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button 2');", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "      button_3.setText('Button 3');", "    }", "  }", "}");
        ControlInfo button_1 = (ControlInfo)StackLayoutGefTest.getJavaInfoByName("button_1");
        ControlInfo button_2 = (ControlInfo)StackLayoutGefTest.getJavaInfoByName("button_2");
        ControlInfo button_3 = (ControlInfo)StackLayoutGefTest.getJavaInfoByName("button_3");
        this.canvas.assertNotNullEditPart(button_1);
        this.canvas.assertNullEditPart(button_2);
        this.canvas.assertNullEditPart(button_3);
        this.canvas.select(button_1);
        this.navigateNext(button_1);
        this.canvas.assertNullEditPart(button_1);
        this.canvas.assertNotNullEditPart(button_2);
        this.canvas.assertNullEditPart(button_3);
        this.navigateNext(button_2);
        this.canvas.assertNullEditPart(button_1);
        this.canvas.assertNullEditPart(button_2);
        this.canvas.assertNotNullEditPart(button_3);
        this.navigateNext(button_3);
        this.canvas.assertNotNullEditPart(button_1);
        this.canvas.assertNullEditPart(button_2);
        this.canvas.assertNullEditPart(button_3);
    }

    @Test
    public void test_navigation_prev() throws Exception {
        this.openComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button 1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button 2');", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "      button_3.setText('Button 3');", "    }", "  }", "}");
        ControlInfo button_1 = (ControlInfo)StackLayoutGefTest.getJavaInfoByName("button_1");
        ControlInfo button_2 = (ControlInfo)StackLayoutGefTest.getJavaInfoByName("button_2");
        ControlInfo button_3 = (ControlInfo)StackLayoutGefTest.getJavaInfoByName("button_3");
        this.canvas.assertNotNullEditPart(button_1);
        this.canvas.assertNullEditPart(button_2);
        this.canvas.assertNullEditPart(button_3);
        this.canvas.select(button_1);
        this.navigatePrev(button_1);
        this.canvas.assertNullEditPart(button_1);
        this.canvas.assertNullEditPart(button_2);
        this.canvas.assertNotNullEditPart(button_3);
        this.navigatePrev(button_3);
        this.canvas.assertNullEditPart(button_1);
        this.canvas.assertNotNullEditPart(button_2);
        this.canvas.assertNullEditPart(button_3);
        this.navigatePrev(button_2);
        this.canvas.assertNotNullEditPart(button_1);
        this.canvas.assertNullEditPart(button_2);
        this.canvas.assertNullEditPart(button_3);
    }

    private void navigateNext(ControlInfo component) {
        this.canvas.click(component, -4, 0);
    }

    private void navigatePrev(ControlInfo component) {
        this.canvas.click(component, -14, 0);
    }
}

