/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component;

import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.CharacterPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.ObjectPropertyEditor;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.property.editor.DisplayedMnemonicKeyPropertyEditor;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class JLabelTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_displayedMnemonic_property() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JLabel());", "  }", "}");
        ComponentInfo label = (ComponentInfo)panel.getChildrenComponents().get(0);
        GenericPropertyDescription propertyInt = label.getDescription().getProperty("setDisplayedMnemonic(int)");
        GenericPropertyDescription propertyChar = label.getDescription().getProperty("setDisplayedMnemonic(char)");
        JLabelTest.assertNotNull((Object)propertyChar);
        JLabelTest.assertNotNull((Object)propertyInt);
        Property propertyChar2 = label.getPropertyByTitle("displayedMnemonic(char)");
        Property propertyInt2 = label.getPropertyByTitle("displayedMnemonic(int)");
        JLabelTest.assertNotNull((Object)propertyChar2);
        JLabelTest.assertNotNull((Object)propertyInt2);
        JLabelTest.assertSame((Object)PropertyCategory.PREFERRED, (Object)propertyChar2.getCategory());
        JLabelTest.assertSame((Object)PropertyCategory.ADVANCED, (Object)propertyInt2.getCategory());
        JLabelTest.assertInstanceOf(CharacterPropertyEditor.class, (Object)propertyChar2.getEditor());
        JLabelTest.assertInstanceOf(DisplayedMnemonicKeyPropertyEditor.class, (Object)propertyInt2.getEditor());
    }

    @Test
    public void test_displayedMnemonicIndex_location() throws Exception {
        this.dontConvertSingleQuotesToDouble();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JLabel label = new JLabel();", "    label.setDisplayedMnemonic('C');", "    add(label);", "  }", "}");
        ComponentInfo label = (ComponentInfo)panel.getChildrenComponents().get(0);
        label.getPropertyByTitle("displayedMnemonicIndex").setValue((Object)1);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JLabel label = new JLabel();", "    label.setDisplayedMnemonic('C');", "    label.setDisplayedMnemonicIndex(1);", "    add(label);", "  }", "}");
    }

    @Test
    public void test_labelFor_getText_noInvocation() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JLabel label = new JLabel();", "      add(label);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo label = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property labelForProperty = label.getPropertyByTitle("labelFor");
        JLabelTest.assertNotNull((Object)labelForProperty);
        JLabelTest.assertSame((Object)PropertyCategory.PREFERRED, (Object)labelForProperty.getCategory());
        JLabelTest.assertSame((Object)labelForProperty.getEditor(), (Object)ObjectPropertyEditor.INSTANCE);
        JLabelTest.assertFalse((boolean)labelForProperty.isModified());
        JLabelTest.assertNull((Object)JLabelTest.getPropertyText(labelForProperty));
    }

    @Test
    public void test_labelFor_getText_hasInvocation() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final JLabel label = new JLabel();", "  private final JTextField textField = new JTextField();", "  public Test() {", "    add(label);", "    label.setLabelFor(textField);", "    add(textField);", "  }", "}");
        panel.refresh();
        ComponentInfo label = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property labelForProperty = label.getPropertyByTitle("labelFor");
        JLabelTest.assertTrue((boolean)labelForProperty.isModified());
        JLabelTest.assertEquals((Object)"textField", (Object)JLabelTest.getPropertyText(labelForProperty));
    }
}

