/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.Tool;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.graphical.tools.ResizeTracker;
import org.eclipse.wb.tests.gef.RequestTestCase;
import org.eclipse.wb.tests.gef.RequestTestCaseEditPart;
import org.eclipse.wb.tests.gef.RequestsLogger;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ResizeTrackerTest
extends RequestTestCase {
    private int m_direction;
    private Object m_type;
    private RequestsLogger m_actualLogger;
    private RequestTestCaseEditPart m_editPart;
    private Viewport m_viewport;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.m_actualLogger = new RequestsLogger();
        this.m_editPart = new RequestTestCaseEditPart("editPart", this.m_actualLogger);
        this.m_editPart.activate();
        this.m_viewer.select((EditPart)this.m_editPart);
        this.m_viewport = this.m_viewer.getControl().getViewport();
    }

    private void setUp(int direction, Object type) {
        this.m_direction = direction;
        this.m_type = type;
        this.m_domain.setActiveTool((Tool)new ResizeTracker(direction, type));
    }

    private void setUp(RangeModel rangeModel, int min, int extent, int max, int value) {
        rangeModel.setAll(min, extent, max);
        rangeModel.setValue(value);
    }

    private ChangeBoundsRequest createEmptyRequest() {
        ChangeBoundsRequest request = new ChangeBoundsRequest(this.m_type);
        request.setResizeDirection(this.m_direction);
        return request;
    }

    private ChangeBoundsRequest createRequest() {
        ChangeBoundsRequest request = this.createEmptyRequest();
        request.setEditParts((EditPart)this.m_editPart);
        return request;
    }

    private void commonEndTest() throws Exception {
        this.m_sender.startDrag(10, 10, 1);
        this.m_sender.dragTo(20, 20);
        this.m_sender.endDrag();
        this.m_actualLogger.assertEmpty();
        this.m_domain.loadDefaultTool();
        this.m_sender.startDrag(10, 10, 2);
        this.m_sender.dragTo(20, 20);
        this.m_sender.endDrag();
        this.m_actualLogger.assertEmpty();
    }

    @Test
    public void test_Request_from_NORTH() throws Exception {
        this.setUp(1, "__Resize_N_");
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_sender.startDrag(10, 18, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(10, 11);
        ChangeBoundsRequest request = this.createEmptyRequest();
        expectedLogger.log((EditPart)this.m_editPart, "getTargetEditPart", (Request)request);
        request.setEditParts((EditPart)this.m_editPart);
        request.setLocation(new Point(10, 11));
        request.setSizeDelta(new Dimension(0, 7));
        request.setMoveDelta(new Point(0, -7));
        expectedLogger.log((EditPart)this.m_editPart, new String[]{"showSourceFeedback", "getCommand"}, (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.m_sender.dragTo(10, 10);
        request = this.createRequest();
        request.setLocation(new Point(10, 10));
        request.setSizeDelta(new Dimension(0, 8));
        request.setMoveDelta(new Point(0, -8));
        expectedLogger.log((EditPart)this.m_editPart, new String[]{"showSourceFeedback", "getCommand"}, (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.m_sender.dragTo(11, 11);
        request = this.createRequest();
        request.setLocation(new Point(11, 11));
        request.setSizeDelta(new Dimension(0, 7));
        request.setMoveDelta(new Point(0, -7));
        expectedLogger.log((EditPart)this.m_editPart, new String[]{"showSourceFeedback", "getCommand"}, (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.m_sender.endDrag();
        request = this.createRequest();
        request.setLocation(new Point(11, 11));
        request.setSizeDelta(new Dimension(0, 7));
        request.setMoveDelta(new Point(0, -7));
        expectedLogger.log((EditPart)this.m_editPart, "eraseSourceFeedback", (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.commonEndTest();
    }

    @Test
    public void test_Request_from_SOUTH() throws Exception {
        this.setUp(4, "__Resize_S_");
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_sender.startDrag(10, 10, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(10, 17);
        ChangeBoundsRequest request = this.createEmptyRequest();
        expectedLogger.log((EditPart)this.m_editPart, "getTargetEditPart", (Request)request);
        request.setEditParts((EditPart)this.m_editPart);
        request.setLocation(new Point(10, 17));
        request.setSizeDelta(new Dimension(0, 7));
        expectedLogger.log((EditPart)this.m_editPart, new String[]{"showSourceFeedback", "getCommand"}, (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.m_sender.dragTo(10, 18);
        request = this.createRequest();
        request.setLocation(new Point(10, 18));
        request.setSizeDelta(new Dimension(0, 8));
        expectedLogger.log((EditPart)this.m_editPart, new String[]{"showSourceFeedback", "getCommand"}, (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.m_sender.dragTo(11, 17);
        request = this.createRequest();
        request.setLocation(new Point(11, 17));
        request.setSizeDelta(new Dimension(0, 7));
        expectedLogger.log((EditPart)this.m_editPart, new String[]{"showSourceFeedback", "getCommand"}, (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.m_sender.endDrag();
        request = this.createRequest();
        request.setLocation(new Point(11, 17));
        request.setSizeDelta(new Dimension(0, 7));
        expectedLogger.log((EditPart)this.m_editPart, "eraseSourceFeedback", (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.commonEndTest();
    }

    @Test
    public void test_Request_from_WEST() throws Exception {
        this.setUp(8, "__Resize_E_");
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_sender.startDrag(18, 10, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(11, 10);
        ChangeBoundsRequest request = this.createEmptyRequest();
        expectedLogger.log((EditPart)this.m_editPart, "getTargetEditPart", (Request)request);
        request.setEditParts((EditPart)this.m_editPart);
        request.setLocation(new Point(11, 10));
        request.setSizeDelta(new Dimension(7, 0));
        request.setMoveDelta(new Point(-7, 0));
        expectedLogger.log((EditPart)this.m_editPart, new String[]{"showSourceFeedback", "getCommand"}, (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.m_sender.dragTo(10, 10);
        request = this.createRequest();
        request.setLocation(new Point(10, 10));
        request.setSizeDelta(new Dimension(8, 0));
        request.setMoveDelta(new Point(-8, 0));
        expectedLogger.log((EditPart)this.m_editPart, new String[]{"showSourceFeedback", "getCommand"}, (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.m_sender.dragTo(11, 11);
        request = this.createRequest();
        request.setLocation(new Point(11, 11));
        request.setSizeDelta(new Dimension(7, 0));
        request.setMoveDelta(new Point(-7, 0));
        expectedLogger.log((EditPart)this.m_editPart, new String[]{"showSourceFeedback", "getCommand"}, (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.m_sender.endDrag();
        request = this.createRequest();
        request.setLocation(new Point(11, 11));
        request.setSizeDelta(new Dimension(7, 0));
        request.setMoveDelta(new Point(-7, 0));
        expectedLogger.log((EditPart)this.m_editPart, "eraseSourceFeedback", (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.commonEndTest();
    }

    @Test
    public void test_Request_from_EAST() throws Exception {
        this.setUp(16, "__Resize_E_");
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_sender.startDrag(10, 10, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(17, 10);
        ChangeBoundsRequest request = this.createEmptyRequest();
        expectedLogger.log((EditPart)this.m_editPart, "getTargetEditPart", (Request)request);
        request.setEditParts((EditPart)this.m_editPart);
        request.setLocation(new Point(17, 10));
        request.setSizeDelta(new Dimension(7, 0));
        expectedLogger.log((EditPart)this.m_editPart, new String[]{"showSourceFeedback", "getCommand"}, (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.m_sender.dragTo(18, 10);
        request = this.createRequest();
        request.setLocation(new Point(18, 10));
        request.setSizeDelta(new Dimension(8, 0));
        expectedLogger.log((EditPart)this.m_editPart, new String[]{"showSourceFeedback", "getCommand"}, (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.m_sender.dragTo(17, 11);
        request = this.createRequest();
        request.setLocation(new Point(17, 11));
        request.setSizeDelta(new Dimension(7, 0));
        expectedLogger.log((EditPart)this.m_editPart, new String[]{"showSourceFeedback", "getCommand"}, (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.m_sender.endDrag();
        request = this.createRequest();
        request.setLocation(new Point(17, 11));
        request.setSizeDelta(new Dimension(7, 0));
        expectedLogger.log((EditPart)this.m_editPart, "eraseSourceFeedback", (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.commonEndTest();
    }

    @Test
    public void test_Request_from_NORTH_EAST() throws Exception {
        this.setUp(17, "__Resize_NE_");
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_sender.startDrag(18, 18, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(25, 11);
        ChangeBoundsRequest request = this.createEmptyRequest();
        expectedLogger.log((EditPart)this.m_editPart, "getTargetEditPart", (Request)request);
        request.setEditParts((EditPart)this.m_editPart);
        request.setLocation(new Point(25, 11));
        request.setSizeDelta(new Dimension(7, 7));
        request.setMoveDelta(new Point(0, -7));
        expectedLogger.log((EditPart)this.m_editPart, new String[]{"showSourceFeedback", "getCommand"}, (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.m_sender.endDrag();
        request = this.createRequest();
        request.setLocation(new Point(25, 11));
        request.setSizeDelta(new Dimension(7, 7));
        request.setMoveDelta(new Point(0, -7));
        expectedLogger.log((EditPart)this.m_editPart, "eraseSourceFeedback", (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.commonEndTest();
    }

    @Test
    public void test_Request_from_NORTH_WEST() throws Exception {
        this.setUp(9, "__Resize_NW_");
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_sender.startDrag(18, 18, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(11, 11);
        ChangeBoundsRequest request = this.createEmptyRequest();
        expectedLogger.log((EditPart)this.m_editPart, "getTargetEditPart", (Request)request);
        request.setEditParts((EditPart)this.m_editPart);
        request.setLocation(new Point(11, 11));
        request.setSizeDelta(new Dimension(7, 7));
        request.setMoveDelta(new Point(-7, -7));
        expectedLogger.log((EditPart)this.m_editPart, new String[]{"showSourceFeedback", "getCommand"}, (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.m_sender.endDrag();
        request = this.createRequest();
        request.setLocation(new Point(11, 11));
        request.setSizeDelta(new Dimension(7, 7));
        request.setMoveDelta(new Point(-7, -7));
        expectedLogger.log((EditPart)this.m_editPart, "eraseSourceFeedback", (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.commonEndTest();
    }

    @Test
    public void test_Request_from_SOUTH_EAST() throws Exception {
        this.setUp(20, "__Resize_SE_");
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_sender.startDrag(11, 11, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(18, 18);
        ChangeBoundsRequest request = this.createEmptyRequest();
        expectedLogger.log((EditPart)this.m_editPart, "getTargetEditPart", (Request)request);
        request.setEditParts((EditPart)this.m_editPart);
        request.setLocation(new Point(18, 18));
        request.setSizeDelta(new Dimension(7, 7));
        expectedLogger.log((EditPart)this.m_editPart, new String[]{"showSourceFeedback", "getCommand"}, (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.m_sender.endDrag();
        request = this.createRequest();
        request.setLocation(new Point(18, 18));
        request.setSizeDelta(new Dimension(7, 7));
        expectedLogger.log((EditPart)this.m_editPart, "eraseSourceFeedback", (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.commonEndTest();
    }

    @Test
    public void test_Request_from_SOUTH_WEST() throws Exception {
        this.setUp(12, "__Resize_SW_");
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_sender.startDrag(18, 18, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(11, 25);
        ChangeBoundsRequest request = this.createEmptyRequest();
        expectedLogger.log((EditPart)this.m_editPart, "getTargetEditPart", (Request)request);
        request.setEditParts((EditPart)this.m_editPart);
        request.setLocation(new Point(11, 25));
        request.setSizeDelta(new Dimension(7, 7));
        request.setMoveDelta(new Point(-7, 0));
        expectedLogger.log((EditPart)this.m_editPart, new String[]{"showSourceFeedback", "getCommand"}, (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.m_sender.endDrag();
        request = this.createRequest();
        request.setLocation(new Point(11, 25));
        request.setSizeDelta(new Dimension(7, 7));
        request.setMoveDelta(new Point(-7, 0));
        expectedLogger.log((EditPart)this.m_editPart, "eraseSourceFeedback", (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.commonEndTest();
    }

    @Test
    public void test_Request_with_horizontal_scrolling() throws Exception {
        this.setUp(4, "__Resize_S_");
        this.setUp(this.m_viewport.getHorizontalRangeModel(), 0, 100, 500, 100);
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_sender.startDrag(10, 10, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(10, 17);
        ChangeBoundsRequest request = this.createEmptyRequest();
        expectedLogger.log((EditPart)this.m_editPart, "getTargetEditPart", (Request)request);
        request.setEditParts((EditPart)this.m_editPart);
        request.setLocation(new Point(10, 17));
        request.setSizeDelta(new Dimension(0, 7));
        expectedLogger.log((EditPart)this.m_editPart, new String[]{"showSourceFeedback", "getCommand"}, (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
    }

    @Test
    public void test_Request_with_vertical_scrolling() throws Exception {
        this.setUp(1, "__Resize_N_");
        this.setUp(this.m_viewport.getVerticalRangeModel(), 0, 100, 400, 100);
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_sender.startDrag(10, 18, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(10, 11);
        ChangeBoundsRequest request = this.createEmptyRequest();
        expectedLogger.log((EditPart)this.m_editPart, "getTargetEditPart", (Request)request);
        request.setEditParts((EditPart)this.m_editPart);
        request.setLocation(new Point(10, 11));
        request.setSizeDelta(new Dimension(0, 7));
        request.setMoveDelta(new Point(0, -7));
        expectedLogger.log((EditPart)this.m_editPart, new String[]{"showSourceFeedback", "getCommand"}, (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
    }

    @Test
    public void test_not_Request() throws Exception {
        this.setUp(1, "__Resize_N_");
        this.m_sender.startDrag(10, 18, 3);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(10, 11);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(10, 10);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(11, 11);
        this.m_actualLogger.assertEmpty();
        this.m_sender.endDrag();
        this.m_actualLogger.assertEmpty();
    }

    @Test
    public void test_break_Request() throws Exception {
        this.setUp(1, "__Resize_N_");
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_sender.startDrag(10, 18, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(10, 11);
        ChangeBoundsRequest request = this.createEmptyRequest();
        expectedLogger.log((EditPart)this.m_editPart, "getTargetEditPart", (Request)request);
        request.setEditParts((EditPart)this.m_editPart);
        request.setLocation(new Point(10, 11));
        request.setSizeDelta(new Dimension(0, 7));
        request.setMoveDelta(new Point(0, -7));
        expectedLogger.log((EditPart)this.m_editPart, new String[]{"showSourceFeedback", "getCommand"}, (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.m_sender.click(10, 11, 3);
        request = this.createRequest();
        request.setLocation(new Point(10, 11));
        request.setSizeDelta(new Dimension(0, 7));
        request.setMoveDelta(new Point(0, -7));
        expectedLogger.log((EditPart)this.m_editPart, "eraseSourceFeedback", (Request)request);
        ResizeTrackerTest.assertLoggers(expectedLogger, this.m_actualLogger);
        this.m_sender.dragTo(8, 9);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(11, 11);
        this.m_actualLogger.assertEmpty();
        this.m_sender.endDrag();
        this.m_actualLogger.assertEmpty();
    }
}

