/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.lang.reflect.Member;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.burningwave.core.classes.ClassCriteria;
import org.burningwave.core.classes.ClassHunter;
import org.burningwave.core.classes.ClassPathScanner;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.MemberCriteria;
import org.burningwave.core.classes.SearchContext;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.PathHelper;

class ClassHunterImpl
extends ClassPathScanner.Abst<Class<?>, SearchContext, ClassHunter.SearchResult>
implements ClassHunter {
    ClassHunterImpl(PathHelper pathHelper, Object defaultPathScannerClassLoaderOrDefaultPathScannerClassLoaderSupplier, Map<?, ?> config) {
        super(pathHelper, initContext -> SearchContext._create(initContext), context -> new ClassHunter.SearchResult((SearchContext)context), defaultPathScannerClassLoaderOrDefaultPathScannerClassLoaderSupplier, config);
    }

    @Override
    String getNameInConfigProperties() {
        return "class-hunter";
    }

    @Override
    String getDefaultPathScannerClassLoaderNameInConfigProperties() {
        return "class-hunter.default-path-scanner-class-loader";
    }

    @Override
    String getDefaultPathScannerClassLoaderCheckFileOptionsNameInConfigProperties() {
        return "class-hunter.new-isolated-path-scanner-class-loader.search-config.check-file-option";
    }

    @Override
    void addToContext(SearchContext context, ClassCriteria.TestContext criteriaTestContext, String basePath, FileSystemItem fileSystemItem, JavaClass javaClass) {
        context.addItemFound(basePath, fileSystemItem.getAbsolutePath(), (Class)criteriaTestContext.getEntity());
    }

    static class SearchContext
    extends org.burningwave.core.classes.SearchContext<Class<?>> {
        Map<Class<?>, Map<MemberCriteria<?, ?, ?>, Collection<Member>>> membersFound;
        Map<MemberCriteria<?, ?, ?>, Collection<Member>> membersFoundFlatMap;

        static SearchContext _create(SearchContext.InitContext initContext) {
            return new SearchContext(initContext);
        }

        SearchContext(SearchContext.InitContext initContext) {
            super(initContext);
        }

        void addAllMembersFound(Class<?> cls, Map<MemberCriteria<?, ?, ?>, Collection<Member>> membersFound) {
            this.membersFound.put(cls, membersFound);
            this.membersFoundFlatMap.putAll(membersFound);
        }

        Map<Class<?>, Map<MemberCriteria<?, ?, ?>, Collection<Member>>> getMembersFound() {
            if (this.membersFound == null) {
                this.loadMemberMaps();
            }
            return this.membersFound;
        }

        public Map<MemberCriteria<?, ?, ?>, Collection<Member>> getMembersFoundFlatMap() {
            if (this.membersFoundFlatMap == null) {
                this.loadMemberMaps();
            }
            return this.membersFoundFlatMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadMemberMaps() {
            ClassCriteria classCriteria = this.searchConfig.getClassCriteria();
            if (!(classCriteria.memberCriterias.isEmpty() || this.membersFound != null && this.membersFoundFlatMap != null)) {
                SearchContext searchContext = this;
                synchronized (searchContext) {
                    if (this.membersFound == null || this.membersFoundFlatMap == null) {
                        ConcurrentHashMap membersFound = new ConcurrentHashMap();
                        ConcurrentHashMap membersFoundFlatMap = new ConcurrentHashMap();
                        for (Map.Entry pathAndItem : this.itemsFoundFlatMap.entrySet()) {
                            ClassCriteria.TestContext testContext = this.test((Class)pathAndItem.getValue());
                            testContext.getMembersFound();
                            Map<MemberCriteria<?, ?, ?>, Collection<Member>> membersForCriteria = testContext.getMembersFound();
                            membersFound.put((Class)testContext.getEntity(), membersForCriteria);
                            membersForCriteria.forEach((criteria, memberList) -> {
                                CopyOnWriteArrayList coll = (CopyOnWriteArrayList)membersFoundFlatMap.get(criteria);
                                if (coll == null) {
                                    coll = new CopyOnWriteArrayList();
                                    membersFoundFlatMap.put((MemberCriteria<?, ?, ?>)criteria, (Collection<Member>)coll);
                                }
                                coll.addAll(memberList);
                            });
                        }
                        this.membersFound = membersFound;
                        this.membersFoundFlatMap = membersFoundFlatMap;
                    }
                }
            }
        }

        @Override
        public void close() {
            this.membersFound = null;
            this.membersFoundFlatMap = null;
            super.close();
        }
    }
}

