/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.vex;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;
import org.eclipse.xwt.vex.EditorMessages;
import org.eclipse.xwt.vex.ResourceManager;
import org.eclipse.xwt.vex.VEXCodeSynchronizer;
import org.eclipse.xwt.vex.VEXContext;
import org.eclipse.xwt.vex.VEXFileChecker;
import org.eclipse.xwt.vex.VEXFileFormator;
import org.eclipse.xwt.vex.VEXRenderRegistry;
import org.eclipse.xwt.vex.VEXRenderer;
import org.eclipse.xwt.vex.VEXTextEditorHelper;
import org.eclipse.xwt.vex.palette.CustomPalettePage;
import org.eclipse.xwt.vex.palette.PaletteResourceManager;
import org.eclipse.xwt.vex.palette.PaletteViewManager;
import org.eclipse.xwt.vex.palette.customize.CustomizeComponentFactory;
import org.eclipse.xwt.vex.palette.customize.model.CustomizeComponent;
import org.eclipse.xwt.vex.palette.part.DynamicPaletteViewer;
import org.eclipse.xwt.vex.swt.AnimatedImage;
import org.eclipse.xwt.vex.swt.CustomSashForm;
import org.eclipse.xwt.vex.toolpalette.Entry;
import org.eclipse.xwt.vex.toolpalette.ToolPalette;
import org.eclipse.xwt.vex.toolpalette.ToolPaletteFactory;
import org.eclipse.xwt.vex.util.ImageHelper;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class VEXEditor
extends XMLMultiPageEditorPart {
    static boolean toolViewShown = false;
    protected VEXContext context;
    private VEXCodeSynchronizer codeSynchronizer;
    private VEXFileChecker fileChecker;
    protected VEXRenderer render;
    protected Canvas container;
    protected ScrolledComposite scrolledComposite;
    protected SashForm sashForm;
    protected AnimatedImage loadingMessage;
    private StructuredTextEditor fTextEditor;
    private Refresher refresher = new Refresher();
    private PaletteResourceManager tResourceManager;
    private static PalettePage palettePage;
    private IStatusLineManager slManager;
    protected PropertyChangeListener changeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            VEXEditor.this.invokeInputChanged();
        }
    };
    private KeyAdapter keyAdapter = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            super.keyPressed(e);
            VEXEditor.this.handleKeyEvent(e);
        }
    };
    private MouseAdapter mouseAdapter = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            super.mouseDown(e);
            VEXEditor.this.handleMouseEvent(e);
        }
    };
    protected DragSourceListener dragSourceAdapter = new DragSourceListener(){
        private String dragDataText;

        public void dragFinished(DragSourceEvent event) {
            this.dragDataText = null;
        }

        public void dragSetData(DragSourceEvent event) {
            if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                event.data = this.dragDataText;
            }
        }

        public void dragStart(DragSourceEvent event) {
            this.dragDataText = VEXEditor.this.getTextWidget().getSelectionText();
        }
    };

    public void handleMouseEvent(MouseEvent e) {
        this.doDynamicPalette(new Point(e.x, e.y));
    }

    public void handleKeyEvent(KeyEvent e) {
        StyledText control = (StyledText)e.widget;
        Caret caret = control.getCaret();
        if (caret != null) {
            this.doDynamicPalette(caret.getLocation());
        }
    }

    public void doDynamicPalette(Point point) {
        IDOMNode node = this.getDOMNode(point);
        if (palettePage == null) {
            return;
        }
        if (node != null) {
            Object parentNode = null;
            parentNode = node instanceof IDOMText ? node.getParentNode() : node;
            this.tResourceManager = this.getPaletteResourceManager();
            Resource dynamicResource = this.tResourceManager.getDynamicResource();
            Resource resource = this.tResourceManager.getResource();
            ToolPalette toolPalette = (ToolPalette)resource.getContents().get(0);
            EList<Entry> entries = toolPalette.getEntries();
            Entry dynamicEntryRoot = null;
            for (Entry entry : entries) {
                if (!entry.getName().equals(EditorMessages.VEXEditor_Dynamic)) continue;
                dynamicEntryRoot = entry;
                break;
            }
            if (dynamicEntryRoot != null) {
                entries.remove(dynamicEntryRoot);
            }
            dynamicEntryRoot = ToolPaletteFactory.eINSTANCE.createEntry();
            dynamicEntryRoot.setName(EditorMessages.VEXEditor_Dynamic);
            dynamicEntryRoot.setToolTip(EditorMessages.VEXEditor_DynamicCategory);
            entries.add((Object)dynamicEntryRoot);
            PaletteViewer paletteViewer = ((CustomPalettePage)palettePage).getPaletteViewer();
            DynamicPaletteViewer dynamicPaletteViewer = null;
            Object objectPaletteViewer = paletteViewer.getProperty("Dynamic_PaletteViewer");
            if (objectPaletteViewer instanceof DynamicPaletteViewer) {
                dynamicPaletteViewer = (DynamicPaletteViewer)((Object)objectPaletteViewer);
            }
            if (dynamicPaletteViewer == null) {
                return;
            }
            PaletteRoot root = dynamicPaletteViewer.getPaletteRoot();
            List paletteChildren = root.getChildren();
            PaletteGroup dynamicPaletteGroup = null;
            for (Object object : paletteChildren) {
                if (!((PaletteGroup)object).getLabel().equals(EditorMessages.VEXEditor_Dynamic)) continue;
                dynamicPaletteGroup = (PaletteGroup)object;
                break;
            }
            if (dynamicPaletteGroup == null) {
                dynamicPaletteGroup = new PaletteGroup(EditorMessages.VEXEditor_Dynamic);
            }
            List children = dynamicPaletteGroup.getChildren();
            int count = children.size();
            int i = 0;
            while (i < count) {
                dynamicPaletteGroup.remove((PaletteEntry)children.get(0));
                ++i;
            }
            root.remove((PaletteEntry)dynamicPaletteGroup);
            if (parentNode.getLocalName() != null && !parentNode.getLocalName().equals("")) {
                List<Entry> insert = this.getSubEntries((Node)parentNode, (List<Entry>)entries);
                if (insert != null) {
                    for (Entry ent : insert) {
                        if (ent.getScope() == null || !ent.getScope().equals(parentNode.getLocalName())) continue;
                        Entry subEntry = (Entry)EcoreUtil.copy((EObject)ent);
                        dynamicEntryRoot.getEntries().add((Object)subEntry);
                        CombinedTemplateCreationEntry component = new CombinedTemplateCreationEntry(subEntry.getName(), subEntry.getToolTip(), (Object)subEntry, (CreationFactory)new SimpleFactory(dynamicResource.getClass()), ImageHelper.getImageDescriptor(this.tResourceManager, subEntry.getIcon()), ImageHelper.getImageDescriptor(this.tResourceManager, subEntry.getLargeIcon()));
                        dynamicPaletteGroup.add((PaletteEntry)component);
                    }
                }
                List<Entry> customizeComponentList = this.getCustomizeEntries();
                for (Entry entry : customizeComponentList) {
                    if (entry.getScope() == null || !entry.getScope().equals(parentNode.getLocalName())) continue;
                    Entry subEntry = (Entry)EcoreUtil.copy((EObject)entry);
                    dynamicEntryRoot.getEntries().add((Object)subEntry);
                    CombinedTemplateCreationEntry component = new CombinedTemplateCreationEntry(subEntry.getName(), subEntry.getToolTip(), (Object)subEntry, (CreationFactory)new SimpleFactory(dynamicResource.getClass()), ImageHelper.getImageDescriptor(this.tResourceManager, subEntry.getIcon()), ImageHelper.getImageDescriptor(this.tResourceManager, subEntry.getLargeIcon()));
                    dynamicPaletteGroup.add((PaletteEntry)component);
                }
            }
            root.add((PaletteEntry)dynamicPaletteGroup);
            RootEditPart rootEditPart = dynamicPaletteViewer.getRootEditPart();
            this.refreshAllEditParts((EditPart)rootEditPart);
        }
    }

    public List<Entry> getCustomizeEntries() {
        ArrayList<Entry> result = new ArrayList<Entry>();
        List<String> customizeComponentNameList = CustomizeComponentFactory.getCustomizeComponentFactory().getCustomizeComponentNameList();
        if (customizeComponentNameList != null) {
            Entry entry = null;
            int i = 0;
            while (i < customizeComponentNameList.size()) {
                CustomizeComponent customizeComponent = CustomizeComponentFactory.getCustomizeComponentFactory().getCustomizeComponentByName(customizeComponentNameList.get(i));
                if (customizeComponent != null) {
                    entry = ToolPaletteFactory.eINSTANCE.createEntry();
                    entry.setName(customizeComponent.getName());
                    entry.setScope(customizeComponent.getScope());
                    entry.setIcon(customizeComponent.getIcon());
                    entry.setLargeIcon(customizeComponent.getLargeIcon());
                    entry.setToolTip(customizeComponent.getTooptip());
                    entry.setContent(customizeComponent.getContent());
                }
                if (entry != null) {
                    result.add(entry);
                }
                ++i;
            }
        }
        return result;
    }

    private void refreshAllEditParts(EditPart part) {
        part.refresh();
        List children = part.getChildren();
        for (EditPart child : children) {
            this.refreshAllEditParts(child);
        }
    }

    private IDOMNode getDOMNode(Point point) {
        int[] trailing;
        StructuredTextViewer textViewer = this.fTextEditor.getTextViewer();
        StyledText styledText = textViewer.getTextWidget();
        Point absolutePosition = new Point(point.x, point.y);
        int widgetOffset = 0;
        try {
            Method method = StyledText.class.getDeclaredMethod("getOffsetAtPoint", Integer.TYPE, Integer.TYPE, int[].class, Boolean.TYPE);
            method.setAccessible(true);
            trailing = new int[1];
            widgetOffset = (Integer)method.invoke((Object)styledText, absolutePosition.x, absolutePosition.y, trailing, false);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        IDOMNode node = VEXTextEditorHelper.getNode((ITextViewer)textViewer, widgetOffset += trailing[0]);
        return node;
    }

    private List<Entry> getSubEntries(Node node, List<Entry> entries) {
        Object result = null;
        for (Entry entry : entries) {
            if (entry.getName().equalsIgnoreCase(node.getLocalName())) {
                result = entry.getEntries();
            }
            if (result != null) continue;
            result = this.getSubEntries(node, (List<Entry>)entry.getEntries());
        }
        return result;
    }

    public VEXEditor(VEXContext context) {
        this.context = context;
    }

    public IProject getProject() {
        IResource resource = (IResource)this.getEditorInput().getAdapter(IResource.class);
        if (resource != null) {
            return resource.getProject();
        }
        throw new IllegalStateException();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        IWorkbenchPage activePage = this.getSite().getWorkbenchWindow().getActivePage();
        if (activePage != null && !toolViewShown) {
            activePage.showView(this.context.getToolViewID());
            toolViewShown = true;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fileChecker != null) {
            this.fileChecker.deleteMarkers();
        }
        if (this.render != null) {
            this.render.dispose();
        }
    }

    protected Composite createPageContainer(Composite parent) {
        this.sashForm = new CustomSashForm(parent, 512);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.sashForm.setBackgroundMode(1);
        this.scrolledComposite = new ScrolledComposite((Composite)this.sashForm, 2816);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setBackgroundMode(1);
        this.scrolledComposite.setBackground(this.scrolledComposite.getDisplay().getSystemColor(1));
        this.container = new Canvas((Composite)this.scrolledComposite, 768);
        this.container.setBackground(this.container.getDisplay().getSystemColor(1));
        this.container.setBackgroundMode(1);
        this.container.setLayout((Layout)new GridLayout());
        this.loadingMessage = new AnimatedImage((Composite)this.container, 0x1000000);
        this.loadingMessage.setLayoutData(new GridData(1808));
        this.loadingMessage.setHorizontalAlignment(0x1000000);
        this.loadingMessage.setVerticalAlignment(0x1000000);
        this.loadingMessage.setBackgroundMode(1);
        this.loadingMessage.setBackground(this.container.getDisplay().getSystemColor(1));
        this.scrolledComposite.setContent((Control)this.container);
        try {
            this.loadingMessage.setImageFile(ResourceManager.getImageURL(ResourceManager.URL_PATH_BUSY));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Composite composite = super.createPageContainer((Composite)this.sashForm);
        this.render = VEXRenderRegistry.getRender((Composite)this.container);
        if (this.render == null) {
            this.render = this.createRender(this.container);
        }
        this.slManager = this.getEditorSite().getActionBars().getStatusLineManager();
        return composite;
    }

    protected VEXRenderer createRender(Canvas container) {
        return null;
    }

    protected abstract VEXFileChecker createFileChecker();

    public VEXFileChecker getFileChecker() {
        if (this.fileChecker == null) {
            this.fileChecker = this.createFileChecker();
        }
        return this.fileChecker;
    }

    protected void codeAboutToBeChanged() {
        VEXCodeSynchronizer codeSync = this.getCodeSynchronizer();
        if (codeSync != null) {
            codeSync.codeAboutToBeChanged();
        }
    }

    protected void invokeInputChanged() {
        long previous = this.refresher.getTime();
        if (this.fTextEditor.getTextViewer() != null) {
            this.refresher.setDocument(this.fTextEditor.getTextViewer().getDocument());
            if (previous == -1L) {
                Display.getDefault().timerExec(1000, (Runnable)this.refresher);
            }
        }
    }

    public int addPage(IEditorPart editor, IEditorInput input) throws PartInitException {
        if (editor instanceof StructuredTextEditor) {
            this.fTextEditor = (StructuredTextEditor)editor;
        }
        this.sashForm.setWeights(new int[]{60, 40});
        return super.addPage(editor, input);
    }

    protected void createPages() {
        super.createPages();
        if (this.fTextEditor != null) {
            StructuredTextViewer textViewer = this.fTextEditor.getTextViewer();
            textViewer.getTextWidget().addMouseListener((MouseListener)this.mouseAdapter);
            textViewer.getTextWidget().addKeyListener((KeyListener)this.keyAdapter);
            textViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    StructuredTextViewer textViewer = VEXEditor.this.fTextEditor.getTextViewer();
                    StyledText control = textViewer.getTextWidget();
                    Caret caret = control.getCaret();
                    if (caret != null) {
                        Point location = caret.getLocation();
                        VEXEditor.this.doDynamicPalette(location);
                    }
                }
            });
            textViewer.addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    StructuredTextViewer textViewer = VEXEditor.this.fTextEditor.getTextViewer();
                    StyledText control = textViewer.getTextWidget();
                    Caret caret = control.getCaret();
                    if (caret != null) {
                        Point point = caret.getLocation();
                    }
                }
            });
            IDocument document = textViewer.getDocument();
            document.addDocumentListener((IDocumentListener)new DocumentListener());
            this.invokeInputChanged();
            this.initializeDND(this);
            Composite composite = this.getContainer();
            if (composite instanceof CTabFolder) {
                CTabFolder tabFolder = (CTabFolder)composite;
                this.createToolBar(tabFolder);
            }
            int i = 0;
            while (i < this.getPageCount()) {
                if (this.getPageText(i).equals("")) {
                    this.setPageImage(i, ResourceManager.getImage("org.eclipse.xwt.vex.obj16.Element.png"));
                }
                if (this.getPageText(i).equals("")) {
                    this.setPageImage(i, ResourceManager.getImage("org.eclipse.xwt.vex.obj16.Table.gif"));
                }
                ++i;
            }
        }
    }

    public void initializeDND(VEXEditor editor) {
        DragSource dragSource;
        StyledText styledText = this.getTextWidget();
        if (styledText != null && (dragSource = (DragSource)styledText.getData("DragSource")) != null) {
            dragSource.removeDragListener(this.dragSourceAdapter);
        }
        if ((dragSource = (DragSource)styledText.getData("DragSource")) == null) {
            dragSource = new DragSource((Control)styledText, 3);
            Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
            dragSource.setTransfer(types);
        }
        dragSource.addDragListener(this.dragSourceAdapter);
    }

    public Object getAdapter(Class type) {
        if (type == PalettePage.class) {
            return this.getPalettePage();
        }
        if (type == PaletteResourceManager.class) {
            return this.getPaletteResourceManager();
        }
        return super.getAdapter(type);
    }

    public PaletteResourceManager getPaletteResourceManager() {
        if (this.tResourceManager == null) {
            this.tResourceManager = new PaletteResourceManager(this);
        }
        return this.tResourceManager;
    }

    private PalettePage getPalettePage() {
        if (palettePage == null) {
            PaletteViewManager manager = new PaletteViewManager((IEditorPart)this);
            palettePage = new CustomPalettePage(manager.getPaletteViewerProvider());
        }
        return palettePage;
    }

    public PalettePage getVEXEditorPalettePage() {
        return palettePage;
    }

    protected abstract void createToolBar(CTabFolder var1);

    public void doSave(IProgressMonitor monitor) {
        try {
            this.updateCodeManager();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fTextEditor.doSave(monitor);
    }

    protected boolean handleInputChanged(IDocument newInput) {
        block13: {
            boolean handling;
            VEXCodeSynchronizer codeSynchronizer = this.getCodeSynchronizer();
            if (codeSynchronizer != null && !(handling = codeSynchronizer.handleInputChanged(newInput))) {
                return false;
            }
            try {
                ApplicationWindow applicationWindow = (ApplicationWindow)this.getSite().getPage().getWorkbenchWindow();
                MenuManager menuManager = applicationWindow.getMenuBarManager();
                if (menuManager != null) {
                    menuManager.updateAll(true);
                }
                String value = newInput.get();
                IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
                if (this.container.getDisplay() == null) break block13;
                this.container.setCursor(this.container.getDisplay().getSystemCursor(1));
                while (!this.container.getDisplay().readAndDispatch()) {
                }
                if (this.render != null && this.render.updateView(value, file)) {
                    if (this.loadingMessage != null && !this.loadingMessage.isDisposed()) {
                        this.loadingMessage.dispose();
                        this.loadingMessage = null;
                    }
                    return true;
                }
                try {
                    if (this.loadingMessage != null && !this.loadingMessage.isDisposed()) {
                        this.loadingMessage.stop();
                        this.loadingMessage.setText("No window found or an error occurs.");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            finally {
                this.container.setCursor(null);
                if (this.render != null) {
                    this.getFileChecker().doCheck(this.render.getHostClassName());
                }
            }
        }
        return false;
    }

    protected VEXCodeSynchronizer getCodeSynchronizer() {
        if (this.codeSynchronizer == null) {
            this.codeSynchronizer = this.createCodeSynchronizer();
        }
        return this.codeSynchronizer;
    }

    protected abstract VEXCodeSynchronizer createCodeSynchronizer();

    public void generateCLRCodeAction() {
        this.getCodeSynchronizer().generateHandles();
    }

    public void openDefinitionAction() {
        this.getCodeSynchronizer().openDefinition();
    }

    protected void updateCodeManager() {
        StructuredTextViewer textViewer = this.fTextEditor.getTextViewer();
        int offset = textViewer.getTextWidget().getCaretOffset();
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)offset);
        Node root = (Node)treeNode;
        while (root != null && root.getParentNode() != null && !(root.getParentNode() instanceof Document)) {
            root = root.getParentNode();
        }
        this.updateCodeManager((IDOMNode)root);
    }

    protected void updateCodeManager(IDOMNode parentNode) {
        VEXCodeSynchronizer generator = this.getCodeSynchronizer();
        if (generator == null) {
            return;
        }
        generator.update(parentNode);
    }

    public StyledText getTextWidget() {
        if (this.fTextEditor == null || this.fTextEditor.getTextViewer() == null) {
            return null;
        }
        return this.fTextEditor.getTextViewer().getTextWidget();
    }

    private String updateCacheContent(IDocument newInput) {
        StringBuffer buffer = new StringBuffer();
        String content = newInput.get();
        char[] cArray = content.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isWhitespace(c)) {
                buffer.append(c);
            }
            ++n2;
        }
        return buffer.toString();
    }

    public StructuredTextEditor getTextEditor() {
        return this.fTextEditor;
    }

    private void modifyAllRelativeHandlerName(StructuredTextViewer textViewer, int offset, String inputHandler, String oldAttrValue) {
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)offset);
        Node node = (Node)treeNode;
        this.modifyHandlerName(inputHandler, node, oldAttrValue);
    }

    private void modifyHandlerName(String inputHandler, Node node, String oldAttrValue) {
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        IDOMNode domNode = (IDOMNode)node;
        if (node.getNodeType() == 1 && this.context.hasType((Node)domNode)) {
            NamedNodeMap nodeMap = node.getAttributes();
            int j = nodeMap.getLength() - 1;
            while (j >= 0) {
                IDOMAttr attrNode = (IDOMAttr)nodeMap.item(j);
                String attrName = attrNode.getName();
                String attrValue = attrNode.getValue();
                if (this.context.isEventHandle((Node)domNode, attrName) && attrValue.equals(oldAttrValue)) {
                    attrNode.setNodeValue(inputHandler);
                }
                --j;
            }
        }
        NodeList nodes = node.getChildNodes();
        int length = nodes.getLength();
        int i = 0;
        while (i < length) {
            Node childNode = nodes.item(i);
            if (childNode.getNodeType() == 1) {
                this.modifyHandlerName(inputHandler, childNode, oldAttrValue);
            }
            ++i;
        }
    }

    public VEXContext getContext() {
        return this.context;
    }

    public void defaultCreation(Entry entry) {
        StyledText control = this.fTextEditor.getTextViewer().getTextWidget();
        Caret caret = control.getCaret();
        if (caret != null) {
            Point location = caret.getLocation();
            IDOMNode node = this.getDOMNode(location);
            IStructuredDocumentRegion refionDocumentRegion = node.getFirstStructuredDocumentRegion();
            int caretOffset = this.getAddEntryPosition(refionDocumentRegion, location, node, entry);
            if (caretOffset >= 0) {
                this.insertEntry(caretOffset, entry);
                this.updateStatusBarMessage(EditorMessages.VEXEditor_NODE + entry.getName() + EditorMessages.VEXEditor_SUBFIX_OK);
            } else {
                this.updateStatusBarMessage(EditorMessages.VEXEditor_NODE + entry.getName() + EditorMessages.VEXEditor_SUBFIX_FAIL);
            }
            this.adjustAfterDefaultCreation((Node)node);
        }
    }

    public void adjustAfterDefaultCreation(Node node) {
        Point location = this.getCurrentLocation();
        this.doDynamicPalette(location);
    }

    public Point getCurrentLocation() {
        StructuredTextEditor textEditor = this.getTextEditor();
        StructuredTextViewer textViewer = textEditor.getTextViewer();
        StyledText control = textViewer.getTextWidget();
        Caret caret = control.getCaret();
        Point location = caret.getLocation();
        return location;
    }

    protected int getAddEntryPosition(IStructuredDocumentRegion refionDocumentRegion, Point startLocation, IDOMNode addNode, Entry addEntry) {
        StructuredTextEditor textEditor = this.getTextEditor();
        StructuredTextViewer textViewer = textEditor.getTextViewer();
        int cursor = VEXTextEditorHelper.getOffsetAtPoint((ITextViewer)textViewer, startLocation);
        if (addNode.getParentNode() == null) {
            return -1;
        }
        int caretOffset = this.context.findDropPosition((Node)addNode, addEntry, cursor);
        if (caretOffset < 0) {
            IStructuredDocumentRegion refionDocumentRegion2 = refionDocumentRegion.getNext();
            int starat = 0;
            int end = 0;
            if (refionDocumentRegion2 != null) {
                starat = refionDocumentRegion2.getStartOffset();
                end = refionDocumentRegion2.getEndOffset();
            }
            Point point = new Point(starat, end);
            IStructuredDocumentRegion endStructuredDocumentRegion = addNode.getEndStructuredDocumentRegion();
            int insertPosition = -1;
            if (endStructuredDocumentRegion != null) {
                insertPosition = endStructuredDocumentRegion.getEnd();
            } else {
                IStructuredDocumentRegion startStructuredDocumentRegion = addNode.getStartStructuredDocumentRegion();
                if (startStructuredDocumentRegion != null) {
                    insertPosition = startStructuredDocumentRegion.getEnd();
                }
            }
            addNode = (IDOMNode)addNode.getParentNode();
            int firstValue = this.getAddEntryPosition(refionDocumentRegion2, point, addNode, addEntry);
            if (firstValue > insertPosition) {
                return firstValue;
            }
            if (firstValue == -1) {
                return -1;
            }
            return insertPosition;
        }
        return caretOffset;
    }

    private void insertEntry(int caretOffset, Entry addEntry) {
        int length;
        TemplateContextType type;
        DocumentTemplateContext templateContext;
        IDocument document = this.getTextEditor().getTextViewer().getDocument();
        Template template = new Template(addEntry.getName(), "", addEntry.getContext().getName(), addEntry.getContent(), true);
        ContextTypeRegistry registry = XMLUIPlugin.getDefault().getTemplateContextRegistry();
        if (registry != null && (templateContext = new DocumentTemplateContext(type = registry.getContextType(template.getContextTypeId()), document, new Position(caretOffset, length = 0))).canEvaluate(template)) {
            try {
                IRewriteTarget target = null;
                StructuredTextEditor textEditor = this.getTextEditor();
                StructuredTextViewer textViewer = textEditor.getTextViewer();
                if (textViewer instanceof ITextViewerExtension) {
                    StructuredTextViewer extension = textViewer;
                    target = extension.getRewriteTarget();
                }
                if (target != null) {
                    target.beginCompoundChange();
                }
                TemplateBuffer templateBuffer = templateContext.evaluate(template);
                String templateString = templateBuffer.getString();
                document.replace(caretOffset, length, templateString);
                StyledText styledText = this.getTextWidget();
                int position = this.getCursorOffset(templateBuffer) + caretOffset;
                styledText.setCaretOffset(position);
                styledText.setFocus();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        IFile file = (IFile)this.getTextEditor().getEditorInput().getAdapter(IFile.class);
        VEXFileFormator formator = new VEXFileFormator();
        try {
            formator.format(document, file.getContentDescription().getContentType().getId());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private int getCursorOffset(TemplateBuffer buffer) {
        TemplateVariable[] variables = buffer.getVariables();
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            if (variable.getType().equals("cursor")) {
                return variable.getOffsets()[0];
            }
            ++i;
        }
        return buffer.getString().length();
    }

    private void updateStatusBarMessage(String message) {
        if (this.slManager != null) {
            if (this.slManager instanceof SubStatusLineManager) {
                ((SubStatusLineManager)this.slManager).setVisible(true);
            }
            this.slManager.setMessage(message);
        }
    }

    class DocumentListener
    implements IDocumentListener {
        DocumentListener() {
        }

        public void documentChanged(DocumentEvent event) {
            VEXEditor.this.invokeInputChanged();
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            VEXEditor.this.codeAboutToBeChanged();
        }
    }

    class Refresher
    implements Runnable {
        private IDocument document;
        private long time = -1L;

        Refresher() {
        }

        @Override
        public void run() {
            if (System.currentTimeMillis() - this.time < 800L || Display.getDefault().getActiveShell() == null) {
                Display.getDefault().timerExec(1000, (Runnable)this);
                return;
            }
            try {
                VEXEditor.this.handleInputChanged(this.document);
            }
            finally {
                this.document = null;
                this.time = -1L;
            }
        }

        public IDocument getDocument() {
            return this.document;
        }

        public void setDocument(IDocument document) {
            this.document = document;
            this.time = System.currentTimeMillis();
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }
    }
}

