/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.commands;

import org.eclipse.gef.commands.Command;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlDocument;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class AddNewChildCommand
extends Command {
    private XamlNode parent;
    private XamlNode child;
    private int index;

    public AddNewChildCommand(XamlNode parent, XamlNode child) {
        this(parent, child, -1);
    }

    public AddNewChildCommand(XamlNode parent, XamlNode child, int index) {
        this.parent = parent;
        this.child = child;
        this.index = index;
    }

    public boolean canExecute() {
        return this.parent != null && this.child != null;
    }

    public void execute() {
        if (this.child instanceof XamlElement) {
            XamlElement element = (XamlElement)this.child;
            if (this.index >= 0 && this.index < this.parent.getChildNodes().size()) {
                this.parent.getChildNodes().add(this.index, (Object)element);
            } else {
                this.parent.getChildNodes().add((Object)element);
            }
        } else if (this.child instanceof XamlAttribute) {
            XamlAttribute oldAttr;
            XamlAttribute attr = (XamlAttribute)this.child;
            String name = attr.getName();
            String prefix = attr.getPrefix();
            XamlDocument ownerDocument = this.parent.getOwnerDocument();
            String namespace = "http://www.eclipse.org/xwt/presentation";
            if (ownerDocument != null) {
                namespace = ownerDocument.getDeclaredNamespace(prefix);
            }
            if ((oldAttr = this.parent.getAttribute(name, namespace)) != null) {
                this.parent.getAttributes().remove((Object)oldAttr);
            }
            this.parent.getAttributes().add((Object)((XamlAttribute)this.child));
        }
    }

    public boolean canUndo() {
        return this.parent != null && this.child != null;
    }

    public void undo() {
        if (this.child instanceof XamlElement) {
            this.parent.getChildNodes().remove((Object)this.child);
        } else if (this.child instanceof XamlAttribute) {
            this.parent.getAttributes().remove((Object)this.child);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public XamlNode getParent() {
        return this.parent;
    }

    public XamlNode getChild() {
        return this.child;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

