/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.actions;

import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.xwt.metadata.ModelUtils;
import org.eclipse.xwt.tools.ui.designer.dialogs.NewHandlerDialog;
import org.eclipse.xwt.tools.ui.designer.editor.XWTDesigner;
import org.eclipse.xwt.tools.ui.designer.editor.event.EventHandler;
import org.eclipse.xwt.tools.ui.designer.resources.ImageShop;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlFactory;

public class AddEventHandlerAction
extends Action {
    private EditPart editPart;
    private XWTDesigner designer;

    public AddEventHandlerAction(EditPart editpart, XWTDesigner designer, String eventType) {
        this.editPart = editpart;
        this.designer = designer;
        this.setText(eventType);
        this.setImageDescriptor(ImageShop.getImageDescriptor("/icons/full/tools/listener_method.gif"));
    }

    public void run() {
        String newValue;
        EventHandler eventHandler = this.designer.getEventHandler();
        if (eventHandler == null) {
            return;
        }
        XamlElement child = (XamlElement)this.editPart.getModel();
        String attributeName = ModelUtils.normalizePropertyName((String)this.getText());
        Object initialValue = "on" + this.getText();
        String eventName = attributeName + "Event";
        initialValue = eventHandler.suggestDefaultName(child, (String)initialValue);
        XamlAttribute handlerAttr = XamlFactory.eINSTANCE.createAttribute(eventName, "http://www.eclipse.org/xwt/presentation");
        NewHandlerDialog dialog = new NewHandlerDialog(eventHandler, (String)initialValue);
        if (dialog.open() == 0 && (newValue = dialog.getHandlerName()) != "" && newValue != null) {
            handlerAttr.setValue(newValue);
            child.getAttributes().add((Object)handlerAttr);
            eventHandler.createHandler(newValue);
        }
    }
}

