/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.loader;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.Tracking;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.core.IDynamicBinding;
import org.eclipse.xwt.internal.core.Binding;
import org.eclipse.xwt.internal.utils.LoggerManager;
import org.eclipse.xwt.internal.utils.ObjectUtil;
import org.eclipse.xwt.jface.JFacesHelper;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class DataBindingTrack {
    private String bindingError = "";
    private Set<String> errorElements = null;
    private List<XamlElement> widgetList = new ArrayList<XamlElement>();
    private Map<XamlElement, String> bindingMap;

    public DataBindingTrack() {
        this.errorElements = new HashSet<String>();
        this.bindingMap = new HashMap<XamlElement, String>();
    }

    public void addWidgetElement(XamlElement element) {
        this.widgetList.add(element);
    }

    private void addErrorWidgetId(String elementId) {
        this.errorElements.add(elementId);
    }

    private void addBindingMessageToMap(XamlElement element, String bindingMessage) {
        this.bindingMap.put(element, bindingMessage);
    }

    private int validateParentElementError(XamlElement bindingElement) {
        int isError = 0;
        if (!this.bindingError.equals("")) {
            EObject parentObj = bindingElement.eContainer();
            while (parentObj != null) {
                bindingElement = (XamlElement)parentObj;
                if (this.errorElements.contains(bindingElement.getId())) {
                    isError = 1;
                    break;
                }
                parentObj = bindingElement.eContainer();
            }
        }
        return isError;
    }

    private String getCurrentWidgetPosition(XamlElement element) {
        if (element.eContainer() != null) {
            return " " + this.getCurrentWidgetPosition((XamlElement)element.eContainer());
        }
        return "";
    }

    public String getDataBindMessage() {
        StringBuffer message = new StringBuffer("");
        Iterator<XamlElement> widgetIt = this.widgetList.iterator();
        Set<XamlElement> keys = this.bindingMap.keySet();
        while (widgetIt.hasNext()) {
            XamlAttribute nameAttr;
            XamlElement element = widgetIt.next();
            int parentHasError = this.validateParentElementError(element);
            if (parentHasError != 0) continue;
            Object content = this.getCurrentWidgetPosition(element);
            if (!message.toString().equals("")) {
                content = (String)content + "+ ";
            }
            content = (String)content + element.getName();
            if (XWT.isTracking((Tracking)Tracking.NAME) && (nameAttr = element.getAttribute("http://www.eclipse.org/xwt", "Name")) != null) {
                content = (String)content + " <" + nameAttr.getValue() + ">";
            }
            message.append((String)content);
            if (!XWT.isTracking((Tracking)Tracking.DATABINDING)) continue;
            if (keys.contains(element)) {
                message.append(this.bindingMap.get(element));
                continue;
            }
            message.append("\n");
        }
        return message.toString();
    }

    private void setBindingErrorMessage(String bindingError) {
        this.bindingError = bindingError;
    }

    public void tracking(Object swtObject, XamlElement element, Object dataContext) {
        Object bindingMessage = "";
        if (swtObject instanceof IDynamicBinding) {
            String error = "";
            Binding newInstance = (Binding)swtObject;
            String path = null;
            XamlAttribute attr = element.getAttribute("Path", "http://www.eclipse.org/xwt/presentation");
            if (attr == null) {
                attr = element.getAttribute("path", "http://www.eclipse.org/xwt/presentation");
            }
            if (attr != null) {
                path = attr.getValue();
            }
            Object dataContext2 = null;
            try {
                String[] paths;
                dataContext2 = newInstance.getValue(null);
                if (path != null && path.length() > 0 && (paths = path.trim().split("\\.")).length > 1) {
                    String path1 = "";
                    int i = 0;
                    while (i < paths.length - 1) {
                        path1 = paths[i];
                        if (dataContext2 != null) {
                            dataContext2 = DataBindingTrack.getObserveData(dataContext2, path1);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception ex) {
                this.addErrorWidgetId(((XamlNode)element.eContainer().eContainer()).getId());
                this.setBindingErrorMessage("-> Error");
                error = "-> Error";
            }
            if (dataContext2 != null) {
                bindingMessage = " (DataContext=" + dataContext2.getClass().getSimpleName() + ", Path=" + path + ")" + error + "\n";
                this.addBindingMessageToMap((XamlElement)element.eContainer().eContainer(), (String)bindingMessage);
            }
        } else if (swtObject instanceof Widget) {
            this.addWidgetElement(element);
            if (dataContext != null) {
                bindingMessage = " (DataContext=" + dataContext.getClass().getSimpleName() + ")\n";
                this.addBindingMessageToMap(element, (String)bindingMessage);
            }
        } else if (JFacesHelper.isViewer((Object)swtObject)) {
            if (dataContext != null) {
                bindingMessage = " (DataContext=" + dataContext.getClass().getSimpleName() + ")\n";
                this.addBindingMessageToMap(element, (String)bindingMessage);
            }
        } else if (element.attributeNames("http://www.eclipse.org/xwt").size() > 0 && element.eContainer() != null && element.eContainer().eContainer() != null) {
            bindingMessage = " (DataContext=" + element.getName() + ")\n";
            this.addBindingMessageToMap((XamlElement)element.eContainer().eContainer(), (String)bindingMessage);
        }
    }

    public static Object getObserveData(Object dataContext, String path) {
        try {
            Class<?> dataContextClass = dataContext.getClass();
            Method getMethod = ObjectUtil.findGetter(dataContextClass, (String)path, null);
            if (getMethod != null) {
                return getMethod.invoke(dataContext, new Object[0]);
            }
        }
        catch (SecurityException e) {
            LoggerManager.log((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LoggerManager.log((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LoggerManager.log((Throwable)e);
        }
        catch (InvocationTargetException e) {
            LoggerManager.log((Throwable)e);
        }
        return null;
    }
}

