/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.utils;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xwt.ui.XWTUIPlugin;
import org.osgi.framework.Bundle;

public class ImageManager {
    public static final IPath ICONS_PATH = new Path("/icons/full");
    private static final String NAME_PREFIX = XWTUIPlugin.getDefault().getBundle().getSymbolicName() + ".";
    private static final int NAME_PREFIX_LENGTH = NAME_PREFIX.length();
    private static final String T_OBJ = "obj16";
    private static final String T_OVR = "ovr16";
    private static final String T_WIZBAN = "wizban";
    private static final String T_ELCL = "elcl16";
    private static final String T_DLCL = "dlcl16";
    private static final String T_ETOOL = "etool16";
    private static final String T_EVIEW = "eview16";
    public static final String IMG_ELEMENT = NAME_PREFIX + "Element.png";
    public static final String IMG_EVENT = NAME_PREFIX + "Event.png";
    public static final String IMG_RESOURCES = NAME_PREFIX + "Resources.gif";
    public static final String IMG_TRIGGER = NAME_PREFIX + "Trigger.gif";
    public static final String IMG_PREVIEW = NAME_PREFIX + "Preview.png";
    public static final String IMG_TABLE = NAME_PREFIX + "Table.gif";
    public static final ImageDescriptor OBJ_ELEMENT = ImageManager.createManagedFromKey("obj16", IMG_ELEMENT);
    public static final ImageDescriptor OBJ_EVENT = ImageManager.createManagedFromKey("obj16", IMG_EVENT);
    public static final ImageDescriptor OBJ_RESOURCES = ImageManager.createManagedFromKey("obj16", IMG_RESOURCES);
    public static final ImageDescriptor OBJ_TRIGGER = ImageManager.createManagedFromKey("obj16", IMG_TRIGGER);
    public static final ImageDescriptor OBJ_PREVIEW = ImageManager.createManagedFromKey("obj16", IMG_PREVIEW);
    public static final ImageDescriptor OBJ_TABLE = ImageManager.createManagedFromKey("obj16", IMG_TABLE);

    private static ImageDescriptor createManagedFromKey(String prefix, String key) {
        return ImageManager.createManaged(prefix, key.substring(NAME_PREFIX_LENGTH), key);
    }

    private static ImageDescriptor createManaged(String prefix, String name, String key) {
        ImageDescriptor result = ImageManager.create(prefix, name, true);
        JFaceResources.getImageRegistry().put(key, result);
        return result;
    }

    public static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }

    private static ImageDescriptor create(String prefix, String name, boolean useMissingImageDescriptor) {
        IPath path = ICONS_PATH.append(prefix).append(name);
        return ImageManager.createImageDescriptor(XWTUIPlugin.getDefault().getBundle(), path, useMissingImageDescriptor);
    }

    private static ImageDescriptor createUnManaged(String prefix, String name) {
        return ImageManager.create(prefix, name, true);
    }

    public static Image get(String key) {
        return JFaceResources.getImageRegistry().get(key);
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        return (Image)JFaceResources.getResources().get((DeviceResourceDescriptor)imageDescriptor);
    }
}

