#!/usr/bin/python
#
# Tests of pygtk
#

import sys
from Gtkinter import *

def hello(args):
	pass
	
class GMessageBox(GtkWindow):
	info=0
	warning=1
	error=2
	cancel=0
	ok=1	
	def __init__(self, message, cb=None, type=info,title=""):
		GtkWindow.__init__(self, title="")
		self._cb=cb
		self.border_width(3)
		
		self._v1=GtkVBox()
		self._v1.set_spacing(8)
		self._h1=GtkHBox()
		self._h1.set_spacing(4)
		self._h2=GtkHButtonBox()
		self._h2.set_spacing(16)
		if (type==self.info):
			#self._btm=GtkLabel(label="(info) pixmap?")
                        self._btm = GtkPixmap(self, 'question.xpm')
		elif (type==self.warning):
			#self._btm=GtkLabel(label="(warning) pixmap?")
		        self._btm = GtkPixmap(self, 'gnu-animal.xpm')
		elif(type==self.error):
		     	#self._btm=GtkLabel(label="(error) pixmap?")
	                self._btm=GtkPixmap(self, 'bomb.xpm')
		else:
	       		self._btm=GtkLabel(label="(unknown) pixmap?")
		self._msg=GtkLabel(label=message)
		self._b_ok=GtkButton(label='OK')
		self._b_ok.connect('clicked', self.process_ok)
		self._b_cancel=GtkButton(label='Cancel')
		self._b_cancel.connect('clicked', self.process_cancel)

		self._h1.add(self._btm)
		self._btm.show()
		self._h1.add(self._msg)	
		self._msg.show()
		self._v1.add(self._h1)
		self._h1.show()
		self._h2.add(self._b_ok)
		self._b_ok.show()
		self._h2.add(self._b_cancel)
		self._b_cancel.show()
		self._v1.add(self._h2)
		self._h2.show()
		self._v1.show()
		self.add(self._v1)
		
	def process_ok(self, button):
		if(self._cb!=None):
			self._cb(self.ok)
		self.destroy()
	def process_cancel(self, button):
		if(self._cb!=None):
			self._cb(self.cancel)
		self.destroy()
		
		
class GFileSelection(GtkFileSelection):
	def __init__(self, cb=None):
		GtkFileSelection.__init__(self)
		self._cb=cb	
		self.ok_button.connect('clicked', self.process_ok)
		self.cancel_button.connect('clicked', self.process_cancel)
		self.help_button.connect('clicked', self.process_help)
	
	def process_ok(self, button):
		if(self._cb!=None):
			self._cb(self.get_filename())
		self.destroy()
					
	def process_cancel(self, button):
		self.destroy()

	def process_help(self, button):
		print "GFileSelection: help"
				
class Application:		
	def __init__(self, argv):
		self.w_window=GtkWindow(title="Test Application")
		self.w_window.border_width(10)		
		self.w_vbox=GtkVBox()

		self.init_menu()
		self.init_text()
		
		self.w_window.add(self.w_vbox)
		self.w_vbox.show()
		self.w_window.show()		
		
	def mainloop(self):
		mainloop()

	def init_menu(self):
		self.w_menubar=GtkMenuBar()
		
		# file menu
		self.w_filemenu=GtkMenu()
		accelerator=GtkAcceleratorTable()
		
		filemenu=GtkMenuItem('File')
		filemenu.set_submenu(self.w_filemenu)
		filemenu.show()
				
		item=GtkMenuItem('New'); self.w_filemenu.append(item)
		item.connect('activate', self.process_file_new); item.show()
		
		item=GtkMenuItem('Open...'); self.w_filemenu.append(item)
		item.connect('activate', self.process_file_open); item.show()
		CONTROL_MASK = 1 << 2
		accelerator.install(item, 'activate', ord('o'), CONTROL_MASK)
		self.w_filemenu.set_accelerator_table(accelerator)
		
		item=GtkMenuItem('Save'); self.w_filemenu.append(item)
		item.connect('activate', self.process_file_save); item.show()
		item=GtkMenuItem('Save As...'); self.w_filemenu.append(item)
		item.connect('activate', self.process_file_save_as); item.show()
		item=GtkMenuItem('Close'); self.w_filemenu.append(item)
		item.connect('activate', self.process_file_close); item.show()
		item=GtkMenuItem('Exit'); self.w_filemenu.append(item)
		item.connect('activate', self.process_file_exit); item.show()	

		# edit menu
		self.w_editmenu=GtkMenu()
		editmenu=GtkMenuItem('Edit')
		editmenu.set_submenu(self.w_editmenu)
		editmenu.show()
		
		item=GtkMenuItem('Cut'); self.w_editmenu.append(item)
		item.connect('activate', self.process_edit_cut); item.show()
		item=GtkMenuItem('Copy'); self.w_editmenu.append(item)
		item.connect('activate', self.process_edit_copy); item.show()
		item=GtkMenuItem('Paste'); self.w_editmenu.append(item)
		item.connect('activate', self.process_edit_paste); item.show()
		
		self.w_menubar.append(filemenu)
		self.w_menubar.append(editmenu)
		self.w_vbox.pack_start(self.w_menubar, expand=FALSE)
		self.w_menubar.show()
		

	def init_text(self):		
		self.w_table=GtkTable(2,2,0)
		self.w_table.show()
		
		self.w_text=GtkText()
		self.w_text.set_usize(350,250)
		## Note: editable text is disable in gtk+-971109
		self.w_text.set_editable(1)
		self.w_table.attach(self.w_text,0,1,0,1,xpadding=1,ypadding=1)
		self.w_text.show()

		self.w_hscrollbar=GtkHScrollbar(self.w_text.get_hadjustment())
		self.w_table.attach(self.w_hscrollbar,0,1,1,2,yoptions=FILL)
		self.w_hscrollbar.show()
		
		self.w_vscrollbar=GtkVScrollbar(self.w_text.get_vadjustment())
		self.w_table.attach(self.w_vscrollbar,1,2,0,1,xoptions=FILL)
		self.w_vscrollbar.show()
				
		self.w_vbox.pack_start(self.w_table)
					
	def process_file_new(self, mi):
		print "process_file_new"
		self.w_text.freeze()
		self.w_text.set_point(0)
		self.w_text.insert_defaults("*new file*")
		self.w_text.thaw()
		#self.w_text.queueDraw()
		
	def process_file_open(self, mi):
		print "process_file_open"
		fs=GFileSelection(self.process_file_open_finalize)
		fs.show()

	def process_file_open_finalize(self, file_name):
		print "process_file_open_finalize", file_name
		
		try:
			f=open(file_name, "r")
		except IOError:
			return
		self.w_text.freeze()
		while(1):
			line=f.readline()
			if(line==""):
				break
			self.w_text.insert_defaults(line)
		self.w_text.thaw()
				
		
	def process_file_save(self, mi):
		print "process_file_save"
		dlg=GMessageBox("Not implemented", type=GMessageBox.error)
		dlg.show()
				
	def process_file_save_as(self, mi):
		print "process_file_save_as"
		fs=GFileSelection(self.process_file_save_as_finalize)
		fs.show()

	def process_file_save_as_finalize(self, file_name):
		print "process_file_save_as_finalize", file_name
				
	def process_file_close(self, mi):
		print "process_file_close"

	def process_file_exit(self, mi):
		mainquit()
		
	def process_edit_cut(self, mi):
		print "process_edit_cut"
		
	def process_edit_copy(self, mi):
		print "process_edit_copy"
		
	def process_edit_paste(self, mi):
		print "process_edit_paste"

	def process_character(self, *args):
		print "process_character"
	def process_button(self, *args):
		print "process_button"
			
if(__name__=="__main__"):
	use_defaults=1
	for arg in sys.argv:
		if(arg=="-d"):
			import pdb
			pdb.set_trace()

		if(arg=="-n"):
			use_defaults=0
			
#	if(use_defaults==1):
#		Gtkrc_parse("defaults.rc")
	
	app=Application(sys.argv)
	app.mainloop()
	
