/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Controller;

import java.util.Vector;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.Panel.ChooseComponents;
import org.openoffice.setup.PanelController;
import org.openoffice.setup.ResourceManager;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.SetupData.SetupDataProvider;
import org.openoffice.setup.Util.Calculator;
import org.openoffice.setup.Util.Dumper;
import org.openoffice.setup.Util.Informer;
import org.openoffice.setup.Util.ModuleCtrl;
import org.openoffice.setup.Util.PackageCollector;

public class ChooseComponentsCtrl
extends PanelController {
    private String helpFile = "String_Helpfile_ChooseComponents";

    public ChooseComponentsCtrl() {
        super("ChooseComponents", new ChooseComponents());
    }

    public String getNext() {
        return new String("InstallationImminent");
    }

    public String getPrevious() {
        InstallData data = InstallData.getInstance();
        if (data.isRootInstallation()) {
            if (data.sameVersionExists()) {
                if (data.hideEula()) {
                    return new String("Prologue");
                }
                return new String("AcceptLicense");
            }
            return new String("ChooseInstallationType");
        }
        if (data.sameVersionExists()) {
            return new String("ChooseDirectory");
        }
        return new String("ChooseInstallationType");
    }

    public final String getHelpFileName() {
        return this.helpFile;
    }

    public void beforeShow() {
        InstallData data = InstallData.getInstance();
        if (!data.moduleSizeSet()) {
            PackageDescription packageData = SetupDataProvider.getPackageDescription();
            ModuleCtrl.setModuleSize(packageData);
            data.setModuleSizeSet(true);
        }
        if (data.sameVersionExists()) {
            ChooseComponents panel = (ChooseComponents)this.getPanel();
            String dialogTitle = ResourceManager.getString("String_ChooseComponents1_Maintain");
            panel.setTitleText(dialogTitle);
        }
    }

    public boolean afterShow(boolean nextButtonPressed) {
        boolean repeatDialog = false;
        InstallData data = InstallData.getInstance();
        PackageDescription packageData = SetupDataProvider.getPackageDescription();
        if (nextButtonPressed) {
            data.setVisibleModulesChecked(false);
            ModuleCtrl.checkVisibleModulesInstall(packageData, data);
            if (data.visibleModulesChecked()) {
                boolean applicationSelected = false;
                if (data.olderVersionExists() || data.sameVersionExists()) {
                    applicationSelected = true;
                } else {
                    data.setApplicationModulesChecked(false);
                    ModuleCtrl.checkApplicationSelection(packageData, data);
                    applicationSelected = data.applicationModulesChecked();
                }
                if (applicationSelected) {
                    boolean languageSelected = false;
                    if (data.olderVersionExists() || data.sameVersionExists() || !data.isMultiLingual()) {
                        languageSelected = true;
                    } else {
                        data.setLanguageModulesChecked(false);
                        ModuleCtrl.checkLanguageSelection(packageData, data);
                        languageSelected = data.languageModulesChecked();
                    }
                    if (languageSelected) {
                        if (data.logModuleStates()) {
                            Dumper.logModuleStates(packageData, "ChooseComponentsCtrl: Before setHiddenModuleSettingsInstall");
                        }
                        ModuleCtrl.setHiddenModuleSettingsInstall(packageData);
                        if (data.logModuleStates()) {
                            Dumper.logModuleStates(packageData, "ChooseComponentsCtrl: After setHiddenModuleSettingsInstall");
                        }
                        Vector installPackages = new Vector();
                        PackageCollector.collectInstallPackages(packageData, installPackages);
                        data.setInstallPackages(installPackages);
                        if (Calculator.notEnoughDiscSpace(data)) {
                            repeatDialog = true;
                            System.err.println("Not enough disc space");
                        }
                    } else {
                        String message = ResourceManager.getString("String_No_Language_Selected_1") + "\n" + ResourceManager.getString("String_No_Language_Selected_2");
                        String title = ResourceManager.getString("String_Change_Selection");
                        Informer.showInfoMessage(message, title);
                        repeatDialog = true;
                    }
                } else {
                    String message = ResourceManager.getString("String_No_Application_Selected_1") + "\n" + ResourceManager.getString("String_No_Application_Selected_2");
                    String title = ResourceManager.getString("String_Change_Selection");
                    Informer.showInfoMessage(message, title);
                    repeatDialog = true;
                }
            } else {
                String message = ResourceManager.getString("String_No_Components_Selected_1") + "\n" + ResourceManager.getString("String_No_Components_Selected_2");
                String title = ResourceManager.getString("String_Nothing_To_Install");
                Informer.showInfoMessage(message, title);
                repeatDialog = true;
            }
        } else {
            ModuleCtrl.saveCustomSelectionStates(packageData);
            data.setCustomSelectionStateSaved(true);
        }
        return repeatDialog;
    }
}

