/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.util.StringTokenizer;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.FrameView;
import javax.swing.text.html.HTML;

class FrameSetView
extends BoxView {
    String[] children = null;
    int[] percentChildren;
    int[] absoluteChildren;
    int[] relativeChildren;
    int percentTotals;
    int absoluteTotals;
    int relativeTotals;

    public FrameSetView(Element element, int n) {
        super(element, n);
    }

    private String[] parseRowColSpec(HTML.Attribute attribute) {
        int n;
        AttributeSet attributeSet = this.getElement().getAttributes();
        String string = "*";
        if (attributeSet != null && attributeSet.getAttribute(attribute) != null) {
            string = (String)attributeSet.getAttribute(attribute);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = stringTokenizer.countTokens();
        int n3 = this.getViewCount();
        String[] stringArray = new String[Math.max(n2, n3)];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = stringTokenizer.nextToken().trim();
            if (!stringArray[n].equals("100%")) continue;
            stringArray[n] = "*";
        }
        while (n < stringArray.length) {
            stringArray[n] = "*";
            ++n;
        }
        return stringArray;
    }

    private void init() {
        int n;
        this.children = this.getAxis() == 1 ? this.parseRowColSpec(HTML.Attribute.ROWS) : this.parseRowColSpec(HTML.Attribute.COLS);
        this.percentChildren = new int[this.children.length];
        this.relativeChildren = new int[this.children.length];
        this.absoluteChildren = new int[this.children.length];
        for (n = 0; n < this.children.length; ++n) {
            this.percentChildren[n] = -1;
            this.relativeChildren[n] = -1;
            this.absoluteChildren[n] = -1;
            if (this.children[n].endsWith("*")) {
                if (this.children[n].length() > 1) {
                    this.relativeChildren[n] = Integer.parseInt(this.children[n].substring(0, this.children[n].length() - 1));
                    this.relativeTotals += this.relativeChildren[n];
                    continue;
                }
                this.relativeChildren[n] = 1;
                ++this.relativeTotals;
                continue;
            }
            if (this.children[n].indexOf(37) != -1) {
                this.percentChildren[n] = this.parseDigits(this.children[n]);
                this.percentTotals += this.percentChildren[n];
                continue;
            }
            this.absoluteChildren[n] = Integer.parseInt(this.children[n]);
        }
        if (this.percentTotals > 100) {
            for (n = 0; n < this.percentChildren.length; ++n) {
                if (this.percentChildren[n] <= 0) continue;
                this.percentChildren[n] = this.percentChildren[n] * 100 / this.percentTotals;
            }
            this.percentTotals = 100;
        }
    }

    protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        if (this.children == null) {
            this.init();
        }
        SizeRequirements.calculateTiledPositions(n, null, this.getChildRequests(n, n2), nArray, nArray2);
    }

    protected SizeRequirements[] getChildRequests(int n, int n2) {
        int[] nArray = new int[this.children.length];
        this.spread(n, nArray);
        int n3 = this.getViewCount();
        SizeRequirements[] sizeRequirementsArray = new SizeRequirements[n3];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            View view = this.getView(i);
            if (view instanceof FrameView || view instanceof FrameSetView) {
                sizeRequirementsArray[i] = new SizeRequirements((int)view.getMinimumSpan(n2), nArray[n4], (int)view.getMaximumSpan(n2), 0.5f);
                ++n4;
                continue;
            }
            int n5 = (int)view.getMinimumSpan(n2);
            int n6 = (int)view.getPreferredSpan(n2);
            int n7 = (int)view.getMaximumSpan(n2);
            float f = view.getAlignment(n2);
            sizeRequirementsArray[i] = new SizeRequirements(n5, n6, n7, f);
        }
        return sizeRequirementsArray;
    }

    private void spread(int n, int[] nArray) {
        block10: {
            int n2;
            int n3;
            block9: {
                int n4;
                if (n == 0) {
                    return;
                }
                int n5 = 0;
                n3 = n;
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    if (this.absoluteChildren[n4] <= 0) continue;
                    nArray[n4] = this.absoluteChildren[n4];
                    n3 -= nArray[n4];
                }
                n5 = n3;
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    if (this.percentChildren[n4] > 0 && n5 > 0) {
                        nArray[n4] = this.percentChildren[n4] * n5 / 100;
                        n3 -= nArray[n4];
                        continue;
                    }
                    if (this.percentChildren[n4] <= 0 || n5 > 0) continue;
                    nArray[n4] = n / nArray.length;
                    n3 -= nArray[n4];
                }
                if (n3 <= 0 || this.relativeTotals <= 0) break block9;
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    if (this.relativeChildren[n4] <= 0) continue;
                    nArray[n4] = n3 * this.relativeChildren[n4] / this.relativeTotals;
                }
                break block10;
            }
            if (n3 <= 0) break block10;
            float f = n - n3;
            float[] fArray = new float[nArray.length];
            n3 = n;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                fArray[n2] = (float)nArray[n2] / f * 100.0f;
                nArray[n2] = (int)((float)n * fArray[n2] / 100.0f);
                n3 -= nArray[n2];
            }
            n2 = 0;
            while (n3 != 0) {
                if (n3 < 0) {
                    int n6 = n2++;
                    nArray[n6] = nArray[n6] - 1;
                    ++n3;
                } else {
                    int n7 = n2++;
                    nArray[n7] = nArray[n7] + 1;
                    --n3;
                }
                if (n2 != nArray.length) continue;
                n2 = 0;
            }
        }
    }

    private int parseDigits(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isDigit(c)) continue;
            n = n * 10 + Character.digit(c, 10);
        }
        return n;
    }
}

