.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XDrawText 3X11 "Release 5" "X Version 11" "XLIB FUNCTIONS"
.SH NAME
XDrawText, XDrawText16, XTextItem, XTextItem16 \- draw polytext text and text drawing structures
.SH SYNTAX
.\" $Header: XPolyText.f,v 1.1 88/02/26 10:01:57 mento Exp $
XDrawText\^(\^\fIdisplay\fP, \fId\fP\^, \fIgc\fP\^, \fIx\fP\^, \fIy\fP\^, \fIitems\fP\^, \fInitems\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Drawable \fId\fP\^;
.br
      GC \fIgc\fP\^;
.br
      int \fIx\fP\^, \fIy\fP\^;
.br
      XTextItem *\fIitems\fP\^;
.br
      int \fInitems\fP\^;
.LP
.\" $Header: XPolyText16.f,v 1.1 88/02/26 10:01:59 mento Exp $
XDrawText16\^(\^\fIdisplay\fP, \fId\fP\^, \fIgc\fP\^, \fIx\fP\^, \fIy\fP\^, \fIitems\fP\^, \fInitems\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Drawable \fId\fP\^;
.br
      GC \fIgc\fP\^;
.br
      int \fIx\fP\^, \fIy\fP\^;
.br
      XTextItem16 *\fIitems\fP\^;
.br
      int \fInitems\fP\^;
.SH ARGUMENTS
.\" $Header: d.a,v 1.1 88/02/26 10:04:25 mento Exp $
.IP \fId\fP 1i
Specifies the drawable. 
.\" $Header: display.a,v 1.1 88/02/26 10:26:29 mento Exp $
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.\" $Header: gc.a,v 1.2 88/05/09 11:20:34 mento Exp $
.IP \fIgc\fP 1i
Specifies the GC.
.\" $Header: items.a,v 1.1 88/02/26 10:28:21 mento Exp $
.IP \fIitems\fP 1i
Specifies an array of text items.
.\" $Header: nitems.a,v 1.1 88/02/26 10:29:33 mento Exp $
.IP \fInitems\fP 1i
Specifies the number of text items in the array.
.ds Xy , which are relative to the origin of the specified drawable \
and define the origin of the first character
.\" $Header: xy_gen.a,v 1.2 88/08/04 11:22:37 mento Exp $
.IP \fIx\fP 1i
.br
.ns
.IP \fIy\fP 1i
Specify the x and y coordinates\*(Xy.
.SH DESCRIPTION
.\" $Header: XPolyText.d,v 1.2 88/06/11 07:52:25 mento Exp $
The
.ZN XDrawText16
function is similar to
.ZN XDrawText 
except that it uses 2-byte or 16-bit characters.
Both functions allow complex spacing and font shifts between counted strings.
.LP
Each text item is processed in turn.
A font member other than 
.ZN None
in an item causes the font to be stored in the GC
and used for subsequent text.  
A text element delta specifies an additional change
in the position along the x axis before the string is drawn. 
The delta is always added to the character origin
and is not dependent on any characteristics of the font.
Each character image, as defined by the font in the GC, is treated as an
additional mask for a fill operation on the drawable.
The drawable is modified only where the font character has a bit set to 1.
If a text item generates a
.ZN BadFont
error, the previous text items may have been drawn.
.LP
For fonts defined with linear indexing rather than 2-byte matrix indexing,
each 
.ZN XChar2b
structure is interpreted as a 16-bit number with byte1 as the 
most-significant byte.
.LP
Both functions use these GC components:
function, plane-mask, fill-style, font, subwindow-mode, 
clip-x-origin, clip-y-origin, and clip-mask.
They also use these GC mode-dependent components: 
foreground, background, tile, stipple, tile-stipple-x-origin, 
and tile-stipple-y-origin.
.LP
.ZN XDrawText
and
.ZN XDrawText16
can generate
.ZN BadDrawable ,
.ZN BadFont ,
.ZN BadGC ,
and
.ZN BadMatch 
errors.
.SH STRUCTURES
The
.ZN XTextItem
and
.ZN XTextItem16
structures contain:
.LP
.Ds 0
.TA .5i 3i
.ta .5i 3i
typedef struct {
	char *chars;	/* pointer to string */
	int nchars;	/* number of characters */
	int delta;	/* delta between strings */
	Font font;	/* Font to print it in, None don't change */
} XTextItem;
.De
.LP
.Ds 0
.TA .5i 3i
.ta .5i 3i
typedef struct {
	XChar2b *chars;	/* pointer to two-byte characters */
	int nchars;	/* number of characters */
	int delta;	/* delta between strings */
	Font font;	/* font to print it in, None don't change */
} XTextItem16;
.De
.LP
If the font member is not
.ZN None ,
the font is changed before printing and also is stored in the GC.
If an error was generated during text drawing,
the previous items may have been drawn.
The baseline of the characters are drawn starting at the x and y
coordinates that you pass in the text drawing functions.
.LP
For example, consider the background rectangle drawn by
.ZN XDrawImageString .
If you want the upper-left corner of the background rectangle
to be at pixel coordinate (x,y), pass the (x,y + ascent)
as the baseline origin coordinates to the text functions.
The ascent is the font ascent, as given in the
.ZN XFontStruct
structure.
If you want the lower-left corner of the background rectangle
to be at pixel coordinate (x,y), pass the (x,y \- descent + 1)
as the baseline origin coordinates to the text functions.
The descent is the font descent, as given in the
.ZN XFontStruct
structure.
.SH DIAGNOSTICS
.\" $Header: baddrawable.e,v 1.1 87/09/04 08:22:59 mento Exp $
.TP 1i
.ZN BadDrawable
A value for a Drawable argument does not name a defined Window or Pixmap.
.\" $Header: badfont.e,v 1.2 87/09/09 18:08:11 mento Exp $
.TP 1i
.ZN BadFont
A value for a Font or GContext argument does not name a defined Font.
.\" $Header: badgc.e,v 1.1 87/09/04 08:23:02 mento Locked $
.TP 1i
.ZN BadGC
A value for a GContext argument does not name a defined GContext.
.\" $Header: badmatch1.e,v 1.3 87/09/09 18:18:54 mento Exp $
.TP 1i
.ZN BadMatch
An
.ZN InputOnly
window is used as a Drawable.
.SH "SEE ALSO"
XDrawImageString(3X11),
XDrawString(3X11),
XLoadFont(3X11)
.br
\fI\*(xL\fP
