.\" $XFree86: mit/server/ddx/x386/XF86_SVGA.man,v 2.10 1994/03/06 13:04:17 dawes Exp $
.\" $XConsortium: X386.man,v 1.3 91/08/26 15:31:19 gildea Exp $
.TH XF86_SVGA 1 "Version 2.1"  "XFree86"
.SH NAME
XF86_SVGA - 8 bit non-accelerated X Window System servers for UNIX on 
x86 platforms
.SH SYNOPSIS
.B XF86_SVGA
[:displaynumber] [ option ] ...
.SH DESCRIPTION
.I XFree86
is a package of bug-fixes, enhancements, and ports of X11R5 to new OSs,
for Intel Unix-like OSs.  See the XFree86(1) manpage for details.
.PP
.I XF86_SVGA
is an 8-bit PseudoColor server for Super-VGA cards.  It is derived from
the
.I X386
server provided with X11R5.
.PP
The
.I XFree86
servers support all MIT-supplied extensions except the X Input Extension.
.I PEX
is supported, but does not function well on the class of hardware supported.
.SH CONFIGURATIONS
.PP
The
.I XF86_SVGA
server supports the following popular SuperVGA chipsets in 256 color mode.
Virtual resolutions up to (approximately) 1152x900 are supported, using
(up to) 1Mb of display memory.  Some of the Cirrus chipsets support
up to 2Mb of display memory and virtual resolutions of 1280x1024 and higher.
.RS .5i
.TP 4
Tseng:
ET3000, ET4000, ET4000/W32
.TP 4
Western Digital:
PVGA1, WD90C00, WD90C10, WD90C11, WD90C30, WD90C31
.TP 4
Genoa:
GVGA
.TP 4
Trident:
TVGA8800CS, TVGA8900B, TVGA8900C, TVGA8900CL, TVGA9000
.TP 4
ATI:
28800-4, 28800-5, 28800-a
.TP 4
NCR:
77C22, 77C22E
.TP 4
Cirrus Logic:
CLGD5420, CLGD5422, CLGD5424, CLGD5426, CLGD5428, CLGD6205,
CLGD6215, CLGD6225, CLGD6235
.TP 4
Compaq:
AVGA
.TP 4
Oak:
OTI067, OTI077
.RE
.PP
Accelerated support is included for most of the Cirrus chipsets, and for
the Western Digital WD90C31 chipsets.  Accelerated support for the
ET4000/W32 is NOT yet implemented.  Users of boards based on ATI's
Mach8 and Mach32 chipsets should refer to the \fIXF86_Mach8(1)\fP and
\fIXF86_Mach32(1)\fP manual pages, respectively.
.SH OPTIONS
In addition to the normal server options described in the \fIXserver(1)\fP
manual page, \fIXF86_SVGA\fP accepts some more command line switches,
as described in the 
.I XFree86(1) 
manpage.
.SH "KEYBOARD"
\fIXFree86\fP provides several capabilities for easing the use of international
keyboards, and generating non-ASCII Latin-1 keysyms.  Refer to the
.I XFree86kbd(1)
manual page for more information.
.SH SETUP
.I XFree86
uses a configuration file called \fBXconfig\fP for its initial setup.  
See the 
.I Xconfig(4/5) 
manpage for general details. Here only the
.I XF86_SVGA
specific parts are explained.
The \fBGRAPHICS DRIVER SETUP\fP section for the colour server starts with
the keyword \fBvga256\fP.  
After this keyword a variety of options may be specified:
.br
.ne 3i
.TP 8
.B chipset \fI"name"\fP
specifies a chipset so the correct driver can be used.  Possible chipsets
are:
.sp
.RS 1.5i
.TP 4
Tseng:
et3000, et4000
.TP 4
Western Digital:
pvga1, wd90c00, wd90c10, wd90c30, wd90c31
.TP 4
Genoa:
gvga
.TP 4
Trident:
tvga8800cs, tvga8900b, tvga8900c, tvga8900cl, tvga9000 
.TP 4
ATI:
ati
.TP 4
NCR:
ncr77c22, ncr77c22e
.TP 4
Cirrus Logic:
clgd5420, clgd5422, clgd5424, clgd5426, clgd5428, clgd6205,
clgd6215, clgd6225, clgd6235
.TP 4
Compaq:
cpq_avga
.TP 4
OAK:
oti067, oti077
.RE
.TP 8
.B clocks \fIclock\fP  ...
specifies the dotclocks that are on your graphics board.  The clocks are
in MHz, and may be specified as a floating point number.  The value is
stored internally to the nearest kHz.  The ordering of the clocks
is important.  It must match the order in which they are selected on the
graphics board.  Multiple \fBclocks\fP lines may be specified.
.TP 8
.B option \fI"optionstring"\fP
allows the user to select certain options provided by the drivers.  Currently 
the following strings are recognized:
.sp
\fBlegend\fP - for Sigma Legend ET4000-based boards.  This option enables
a special clock-selection algorithm used on Legend boards, and MUST be
specified for these boards to function correctly.
.sp
\fBswap_hibit\fP - for Western Digital/PVGA1 chipsets.  Some Western Digital
based boards require the high-order clock-select lead to be inverted.  It
is not possible for the server to determine this information at run-time.
If the 9th clock in the list of clocks detected by the server is less than
30Mhz, this option likely needs to be set.
.sp
\fBhibit_low\fP, \fBhibit_high\fP - for Tseng ET4000 chipsets.  With
some ET4000 cards, the server has difficulty getting the state of the
high-order clocks select bit right when started from a high-resolution text
mode.  These options allow the correct initial state of that bit to be
specified.  To find out what the correct initial state is, start the server
from an 80x25 text mode.  This option is only needed if the clocks reported
by the server when started from a high-resolution text mode differ from
those reported when it is started from an 80x25 text mode.
.sp
\fB8clocks\fP - for the PVGA1 chipset the default is 4 clocks.  Some
cards with this chipset may support 8 clocks.  Specifying this option
will allow the driver to detect and use the extra clocks.
.sp
\fB16clocks\fP - for Trident TVGA8900B and 8900C chipsets.  Some newer boards
using 8900B and 8900C chipsets actually support 16 clocks rather than the
standard 8 clocks.  Such boards will have a "TCK9002" or "TCK9004" chip
on them.  Specifying this option will allow the driver to detect and use
the extra 8 clocks.
.sp
\fBprobe_clocks\fP - for Cirrus chipsets.  The Cirrus driver has a fixed
set of clocks that are normally used.  Specifying this option will force
the driver to probe for clocks instead of reporting the built-in defaults.
This option is for debugging purposes only.
.sp
\fBnoaccel\fP - for Cirrus and WD chipsets.  This option disables the
accelerated features for the clgd5426, clgd5428 and wd90c31 chipsets.
.sp
\fBfifo_conservative\fP - for Cirrus chipsets.  This option sets the CRT
FIFO threshold to a conservative value for dot clocks above 65MHz.  This
reduces performance, but may help in eliminating problems with ``streaks''
on the screen during BitBLT operations
.sp
\fBfifo_aggressive\fP - for Cirrus chipsets.  This option sets the CRT
FIFO threshold to an aggressive value for dot clocks above 65MHz.  This
increases performance, and is probably only appropriate for the clgd5434
chip.
.sp
\fBno_2mb_banksel\fP - for Cirrus chipsets.  This option is required for
Cirrus cards with 2MB of videoram which is in the form of 512kx8 DRAMs
(4 chips) rather than 256kx4 DRAMs (16 chips).
.ig
intern_disp (use internal display for laptops -- WD90C2x)
extern_disp (use external display for laptops -- WD90C2x)
..
.TP 8
.B speedup \fI"selection"\fP
sets the selection of SpeedUps to use.  The optional selection string can
take the following values:
.sp
.in 20
.nf
none
all
.fi
.IP
If the selection string is omitted, or if the \fBspeedup\fP option is omitted,
the selection defaults to "all".
Some of the SpeedUps can only be used with the ET4000 and WD90C31 chipsets and
others requires a virtual resolution with a xdim of 1024.  SpeedUps that
won't work with a given configuration are automatically disabled.
.TP 8
.B nospeedup
disables the SpeedUp code.  This is equivalent to \fBspeedup "none"\fP.
.PP
Note that \fIXFree86\fP has some internal capabilities to determine
what hardware
it is running on. Thus normally the keywords \fIchipset\fP, \fIclocks\fP,
and \fIvideoram\fP don't have to be specified.  But there
may be occasions when this autodetection mechanism fails, (for example, too
high of load on the machine when you start the server).  For cases like this,
one should first run \fIXF86_SVGA\fP on an unloaded machine, look at the
results of the autodetection (that are printed out during server startup)
and then explicitly specify these parameters in the configuration file.
\fBIt is recommended that all parameters, especially Clock values,
be specified in the Xconfig file.\fP
.PP
The last section is the \fBTABLE OF VIDEO MODES\fP which starts with the
keyword \fBmodedb\fP.   This is covered in the
.I Xconfig(4/5) 
manpage. For details on how to build your own video modes please refer
to the tutorial written by Eric Raymond.
.SH FILES
.TP 30
/usr/X386/bin/XF86_SVGA
The 8-bit color X server
.TP 30
/usr/X386/lib/X11/Xconfig
Server configuration file
.SH "SEE ALSO"
X(1), Xserver(1), XFree86kbd(1), XFree86(1), Xconfig(4/5), xdm(1), xinit(1)
.SH BUGS
.PP
There are no known bugs at this time, although we welcome reports emailed
to the address listed below.  In particular, the Cirrus and Western
Digital accelerated support is new, and may not be completely debugged.
.SH CONTACT INFO
\fIXFree86\fP source is available from the FTP servers 
\fIftp.physics.su.oz.au\fP and \fIftp.x.org\fP.  Send email to
\fIXFree86@physics.su.oz.au\fP for details.
.SH AUTHORS
.PP
Refer to the
.I XFree86(1)
manual page.
