divert(-1)
# AnotherLevel - A FVWM2 Configuration
# Copyright (C) 1996, 1997 Red Hat Software, Inc
#
#	$Id: fvwm2rc.m4,v 1.3 1998/05/01 22:35:41 gafton Exp $	
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# This work is derived from:
#       TheNextLevel
#       Copyright 1996 By Greg J. Badros <gjb@cs.duke.edu>
# distributed under GNU General Public License.
#
divert

###########################################################################
# Look at /tmp/fvwm* output to see what fvwm is defining things
# to be on your platform
#
# Need to muddle with comment characters so these lines don't get ignored by m4,
# but this needs to get passed through fvwm w/o wreaking havoc
changecom(%%%)
#FVWM-M4-Defines
#`SERVERHOST'=SERVERHOST
#`CLIENTHOST'=CLIENTHOST
#`HOSTNAME'=HOSTNAME
#`OSTYPE'=OSTYPE
#`USER'=USER
#`VERSION'=VERSION
#`VENDOR'=VENDOR
#`RELEASE'=RELEASE
#`WIDTH'=WIDTH
#`HEIGHT'=HEIGHT
#`X_RESOLUTION'=X_RESOLUTION
#`Y_RESOLUTION'=Y_RESOLUTION
#`PLANES'=PLANES
#`CLASS'=CLASS
#`COLOR'=COLOR
#`FVWM_VERSION'=FVWM_VERSION
#`OPTIONS'=OPTIONS
#`FVWMDIR'=FVWMDIR
#
#`XRELEASE'=RELEASE
changecom(#)

# Get the user options.  This is the only file the casual user needs
# to worry about.
# define(`FVWM_USER_MODULE_PATH',`.')

define(`ANOTHERLEVEL', `/etc/X11/AnotherLevel')

define(`readFile', `dnl
syscmd(`test -f $HOME'/.$1)dnl
ifelse(sysval,0,`sinclude(esyscmd(`echo -n $HOME')/.$1)',
`sinclude(ANOTHERLEVEL/$1.m4)')')dnl

# To keep .fvwm2rc.defines clean, we define default values as necessary 
# through a separate file
readFile(`fvwm2rc.defaults')
readFile(`fvwm2rc.defines')
# Now read the user options
readFile(`fvwm2rc.options')

# Now read in some interesting macros...
readFile(`fvwm2rc.macros')

###############################################################################
# Set our all-important paths.
# Note that your "executables" path (the one your shell uses to search for
# programs it tries to exec) is set *before* fvwm starts.  Usually it is
# set by .xinitrc or .xsession, which hopefully sources some environment
# settings files like /etc/env, /etc/profile, ~/.env, ~/.profile, etc.#
ModulePath FVWMDIR/
PixmapPath USER_PIXMAP_PATH
IconPath   USER_ICON_PATH

# This is the real magic of AnotherLevel - decorations...
# To date it is supposed to work for Win95, Mwm, and Afterstep
TraceForErrors(`Including_decors...')
readFile(`fvwm2rc.decors')

###########################################################################
#
# Set up the basic colors
#

###########################################################################
# Stuff to do at start-up
# User initialization is done in .fvwm2rc.init, included at bottom.
##########

AddToFunc "InitFunction"
+ "I" SetupFunction
+ "I" StartupFunction
+ "I" EndSetupFunction

AddToFunc "RestartFunction"
+ "I" SetupFunction
+ "I" EndSetupFunction

###########################################################################
# Set the decoration styles and window options for specific apps
# Order does matter... if compatible styles are set for a single window
# in multiple Style commands, then the styles are ORed together. If
# conflicting styles are set, the last one specified is used.

###########################################################################
#
# Include all the other support files
#

# Various complex functions
TraceForErrors(`Including_complex functions...')
readFile(`fvwm2rc.functions')

# Various key bindings
TraceForErrors(`Including_key bindings...')
readFile(`fvwm2rc.keys')

# Creation of the menus
TraceForErrors(`Including_menus...')
readFile(`fvwm2rc.menus')

# These commands should command before any menus or functions are defined,
# and before the internal pager is started.
TraceForErrors(`Including_defstyles...')
readFile(`fvwm2rc.defstyles')

# Module settings
TraceForErrors(`Including_modules...')
readFile(`fvwm2rc.modules')

# User initialization
TraceForErrors(`Including_init...')
readFile(`fvwm2rc.init')

###########################################################################
# Local Variables:
# rm-trailing-spaces: t
# page-delimiter: "^#####"
# End:
TraceForErrors(`Done')


