/**************************************************************************

Copyright 1998-1999 Precision Insight, Inc., Cedar Park, Texas.
All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sub license, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice (including the
next paragraph) shall be included in all copies or substantial portions
of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
IN NO EVENT SHALL PRECISION INSIGHT AND/OR ITS SUPPLIERS BE LIABLE FOR
ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

**************************************************************************/
/* $XFree86: xc/lib/GL/mesa/src/drv/mga/mga_xmesa.c,v 1.4 2000/06/22 16:59:24 tsi Exp $ */

/*
 * Authors:
 *   Keith Whitwell <keithw@precisioninsight.com>
 *
 */

#ifdef GLX_DIRECT_RENDERING

#include <X11/Xlibint.h>
#include <stdio.h>

#include "drm.h"
#include "mga_xmesa.h"
#include "context.h"
#include "vbxform.h"
#include "matrix.h"
#include "mmath.h"
#include "simple_list.h"

#include "mgadd.h"
#include "mgastate.h"
#include "mgatex.h"
#include "mgaspan.h"
#include "mgadepth.h"
#include "mgatris.h"
#include "mgapipeline.h"
#include "mgabuffers.h"

#include "xf86dri.h"
#include "mga_xmesa.h"

#include "mga_dri.h"





#ifndef MGA_DEBUG
int MGA_DEBUG = (0
/*  		  | DEBUG_ALWAYS_SYNC */
/*  		  | DEBUG_VERBOSE_MSG */
/*   		  | DEBUG_VERBOSE_LRU */
/*  		  | DEBUG_VERBOSE_DRI */
/*  		  | DEBUG_VERBOSE_IOCTL */
/*   		  | DEBUG_VERBOSE_2D */
		  );
#endif


static mgaContextPtr      mgaCtx = 0;

mgaGlx_t	mgaglx;

/* These functions are accessed externally to the driver:
 *
 * XMesaInitDriver
 * XMesaResetDriver
 * XMesaCreateVisual
 * XMesaDestroyVisual
 * XMesaCreateContext 
 * XMesaDestroyContext
 * XMesaCreateWindowBuffer
 * XMesaCreatePixmapBuffer
 * XMesaDestroyBuffer
 * XMesaSwapBuffers
 * XMesaMakeCurrent
 *
 */

GLboolean XMesaInitDriver(__DRIscreenPrivate *sPriv)
{
   mgaScreenPrivate *mgaScreen;
   MGADRIPtr         serverInfo = (MGADRIPtr)sPriv->pDevPriv;

   /* Check the DRI version */
   {
      int major, minor, patch;
      if (XF86DRIQueryVersion(sPriv->display, &major, &minor, &patch)) {
         if (major != 3 || minor != 0 || patch < 0) {
            char msg[1000];
            sprintf(msg, "MGA DRI driver expected DRI version 3.0.x but got version %d.%d.%d", major, minor, patch);
            __driMesaMessage(msg);
            return GL_FALSE;
         }
      }
   }

   /* Check that the DDX driver version is compatible */
   if (sPriv->ddxMajor != 1 ||
       sPriv->ddxMinor != 0 ||
       sPriv->ddxPatch < 0) {
      char msg[1000];
      sprintf(msg, "MGA DRI driver expected DDX driver version 1.0.x but got version %d.%d.%d", sPriv->ddxMajor, sPriv->ddxMinor, sPriv->ddxPatch);
      __driMesaMessage(msg);
      return GL_FALSE;
   }

   /* Check that the DRM driver version is compatible */
   if (sPriv->drmMajor != 1 ||
       sPriv->drmMinor != 0 ||
       sPriv->drmPatch < 0) {
      char msg[1000];
      sprintf(msg, "MGA DRI driver expected DRM driver version 1.0.x but got version %d.%d.%d", sPriv->drmMajor, sPriv->drmMinor, sPriv->drmPatch);
      __driMesaMessage(msg);
      return GL_FALSE;
   }

   /* Allocate the private area */
   mgaScreen = (mgaScreenPrivate *)Xmalloc(sizeof(mgaScreenPrivate));
   if (!mgaScreen)
      return GL_FALSE;

   mgaScreen->sPriv = sPriv;
   sPriv->private = (void *)mgaScreen;

   /*
   fprintf(stderr, "serverInfo->chipset: %d\n", serverInfo->chipset);
   */

   if (serverInfo->chipset != MGA_CARD_TYPE_G200 &&
       serverInfo->chipset != MGA_CARD_TYPE_G400) {
      XFree(mgaScreen);
      sPriv->private = NULL;
      return GL_FALSE;
   }

   
   mgaScreen->chipset = serverInfo->chipset;
   mgaScreen->width = serverInfo->width;
   mgaScreen->height = serverInfo->height;
   mgaScreen->mem = serverInfo->mem;
   mgaScreen->cpp = serverInfo->cpp;
   mgaScreen->frontPitch = serverInfo->frontPitch;
   mgaScreen->frontOffset = serverInfo->frontOffset;
   mgaScreen->backOffset = serverInfo->backOffset; 
   mgaScreen->backPitch  =  serverInfo->backPitch;
   mgaScreen->depthOffset = serverInfo->depthOffset;
   mgaScreen->depthPitch  =  serverInfo->depthPitch;


   mgaScreen->agp.handle = serverInfo->agp;
   mgaScreen->agp.size = serverInfo->agpSize;

   if (drmMap(sPriv->fd, 
	      mgaScreen->agp.handle, 
	      mgaScreen->agp.size, 
	      (drmAddress *)&mgaScreen->agp.map) != 0) 
   {
      Xfree(mgaScreen);
      sPriv->private = NULL;
      return GL_FALSE;
   }

   mgaScreen->textureOffset[MGA_CARD_HEAP] = serverInfo->textureOffset;
   mgaScreen->textureOffset[MGA_AGP_HEAP] = (serverInfo->agpTextureOffset |
					     PDEA_pagpxfer_enable | 1);

   /*
   fprintf(stderr, "CARD texture size %x, granul %d --> %x\n", 
	   serverInfo->textureSize, serverInfo->logTextureGranularity,
	   1<<serverInfo->logTextureGranularity);
   */

   mgaScreen->textureSize[MGA_CARD_HEAP] = serverInfo->textureSize;
   mgaScreen->textureSize[MGA_AGP_HEAP] = serverInfo->agpTextureSize;

   mgaScreen->logTextureGranularity[MGA_CARD_HEAP] = 
      serverInfo->logTextureGranularity;
   mgaScreen->logTextureGranularity[MGA_AGP_HEAP] = 
      serverInfo->logAgpTextureGranularity;

   mgaScreen->texVirtual[MGA_CARD_HEAP] = (char *)(mgaScreen->sPriv->pFB + 
					   serverInfo->textureOffset);
   mgaScreen->texVirtual[MGA_AGP_HEAP] = (mgaScreen->agp.map + 
					  serverInfo->agpTextureOffset);

   mgaScreen->mAccess = serverInfo->mAccess;


   /* For calculating setupdma addresses.
    */
   mgaScreen->dmaOffset = serverInfo->agpBufferOffset;   
   
   /*
   fprintf(stderr, "\n\n\nbackOffset: %x pitch %x\n", 
	   mgaScreen->backOffset,
	   mgaScreen->backPitch);
   */

   mgaScreen->Attrib = MGA_PF_565;
   mgaScreen->bufs = drmMapBufs(sPriv->fd);
   if (!mgaScreen->bufs) {
      /*drmUnmap(mgaScreen->agp_tex.map, mgaScreen->agp_tex.size);*/
      XFree(mgaScreen);
      sPriv->private = NULL;
      return GL_FALSE;
   }

   /* Other mgaglx stuff, too??
    */
   memset(&mgaglx, 0, sizeof(mgaglx));

   mgaDDFastPathInit();
   mgaDDEltPathInit();
   mgaDDTrifuncInit();
   mgaDDSetupInit();

   return GL_TRUE;
}


/* Accessed by dlsym from dri_mesa_init.c
 */
void XMesaResetDriver(__DRIscreenPrivate *sPriv)
{
   mgaScreenPrivate *mgaScreen = (mgaScreenPrivate *) sPriv->private;
   /*drmUnmap(mgaScreen->agp_tex.map, mgaScreen->agp_tex.size);*/
   Xfree(mgaScreen);
   sPriv->private = NULL;
}


GLvisual *XMesaCreateVisual(Display *dpy,
                            __DRIscreenPrivate *driScrnPriv,
                            const XVisualInfo *visinfo,
                            const __GLXvisualConfig *config)
{
   /* Drivers may change the args to _mesa_create_visual() in order to
    * setup special visuals.
    */
   return _mesa_create_visual( config->rgba,
                               config->doubleBuffer,
                               config->stereo,
                               _mesa_bitcount(visinfo->red_mask),
                               _mesa_bitcount(visinfo->green_mask),
                               _mesa_bitcount(visinfo->blue_mask),
                               config->alphaSize,
                               0, /* index bits */
                               config->depthSize,
                               config->stencilSize,
                               config->accumRedSize,
                               config->accumGreenSize,
                               config->accumBlueSize,
                               config->accumAlphaSize,
                               0 /* num samples */ );
}


GLboolean XMesaCreateContext( Display *dpy, GLvisual *mesaVis,
                              __DRIcontextPrivate *driContextPriv )
{
   int i;
   GLcontext *ctx;
   mgaContextPtr mmesa;
   __DRIscreenPrivate *sPriv = driContextPriv->driScreenPriv;
   mgaScreenPrivate *mgaScreen = (mgaScreenPrivate *)sPriv->private;
   drm_mga_sarea_t *saPriv=(drm_mga_sarea_t*)(((char*)sPriv->pSAREA)+
					      sizeof(XF86DRISAREARec));
   /*fprintf(stderr, "XMesaCreateContext\n");*/

   mmesa = (mgaContextPtr)Xcalloc(sizeof(mgaContext), 1);
   if (!mmesa) {
      return GL_FALSE;
   }

   ctx = driContextPriv->mesaContext;

   mmesa->display = dpy;
   mmesa->hHWContext = driContextPriv->hHWContext;
   mmesa->driFd = sPriv->fd;
   mmesa->driHwLock = &sPriv->pSAREA->lock;

   mmesa->mgaScreen = mgaScreen;
   mmesa->driScreen = sPriv;
   mmesa->sarea = saPriv;
   mmesa->glBuffer = NULL;

   make_empty_list(&mmesa->SwappedOut);

   mmesa->lastTexHeap = mgaScreen->texVirtual[MGA_AGP_HEAP] ? 2 : 1;

   for (i = 0 ; i < mmesa->lastTexHeap ; i++) {
      mmesa->texHeap[i] = mmInit( 0, mgaScreen->textureSize[i]);
      make_empty_list(&mmesa->TexObjList[i]);
   }

   mmesa->renderindex = -1;		/* impossible value */
   mmesa->new_state = ~0;
   mmesa->dirty = ~0;
   mmesa->warp_pipe = 0;   
   mmesa->CurrentTexObj[0] = 0;
   mmesa->CurrentTexObj[1] = 0;
   
   mmesa->texAge[0] = 0;
   mmesa->texAge[1] = 0;
   
   ctx->DriverCtx = (void *) mmesa;
   mmesa->glCtx = ctx;

   mgaDDExtensionsInit( ctx );

   mgaDDInitStateFuncs( ctx );
   mgaDDInitTextureFuncs( ctx );
   mgaDDInitSpanFuncs( ctx );
   mgaDDInitDriverFuncs( ctx );
   mgaDDInitIoctlFuncs( ctx );


   ctx->Driver.TriangleCaps = (DD_TRI_CULL|
			       DD_TRI_LIGHT_TWOSIDE|
			       DD_TRI_STIPPLE|
			       DD_TRI_OFFSET);

   /* Ask mesa to clip fog coordinates for us.
    */
   ctx->TriangleCaps |= DD_CLIP_FOG_COORD;

   ctx->Shared->DefaultD[2][0].DriverData = 0;
   ctx->Shared->DefaultD[2][1].DriverData = 0;

   if (ctx->VB) 
      mgaDDRegisterVB( ctx->VB );

   if (ctx->NrPipelineStages)
      ctx->NrPipelineStages =
	 mgaDDRegisterPipelineStages(ctx->PipelineStage,
				      ctx->PipelineStage,
				      ctx->NrPipelineStages);

   mgaInitState( mmesa );

   driContextPriv->driverPrivate = (void *) mmesa;

   return GL_TRUE;
}

void XMesaDestroyContext(__DRIcontextPrivate *driContextPriv)
{
   mgaContextPtr mmesa = (mgaContextPtr) driContextPriv->driverPrivate;

   if (mmesa) {
/*        mgaTextureObjectPtr next_t, t; */

/*        foreach_s (t, next_t, &(mmesa->TexObjList)) */
/*  	 mgaDestroyTexObj(mmesa, t); */

/*        foreach_s (t, next_t, &(mmesa->SwappedOut)) */
/*  	 mgaDestroyTexObj(mmesa, t); */

      Xfree(mmesa);

      driContextPriv->driverPrivate = NULL;
   }
}


GLframebuffer *XMesaCreateWindowBuffer( Display *dpy,
                                        __DRIscreenPrivate *driScrnPriv,
                                        __DRIdrawablePrivate *driDrawPriv,
                                        GLvisual *mesaVis)
{
   return gl_create_framebuffer(mesaVis,
                                GL_FALSE,  /* software depth buffer? */
                                mesaVis->StencilBits > 0,
                                mesaVis->AccumRedBits > 0,
                                mesaVis->AlphaBits > 0
                                );
}


GLframebuffer *XMesaCreatePixmapBuffer( Display *dpy,
                                        __DRIscreenPrivate *driScrnPriv,
                                        __DRIdrawablePrivate *driDrawPriv,
                                        GLvisual *mesaVis)
{
#if 0
   /* Different drivers may have different combinations of hardware and
    * software ancillary buffers.
    */
   return gl_create_framebuffer(mesaVis,
                                GL_FALSE,  /* software depth buffer? */
                                mesaVis->StencilBits > 0,
                                mesaVis->AccumRedBits > 0,
                                mesaVis->AlphaBits > 0
                                );
#else
   return NULL;  /* not implemented yet */
#endif
}


void XMesaSwapBuffers(__DRIdrawablePrivate *driDrawPriv)
{
   /* XXX should do swap according to the buffer, not the context! */
   mgaContextPtr mmesa = mgaCtx;    
   FLUSH_VB( mmesa->glCtx, "swap buffers" );
   mgaSwapBuffers(mmesa);
}


GLboolean XMesaUnbindContext(__DRIcontextPrivate *driContextPriv)
{
   mgaContextPtr mmesa = (mgaContextPtr) driContextPriv->driverPrivate;
   if (mmesa)
      mmesa->dirty = ~0;

   return GL_TRUE;
}


/* This looks buggy to me - the 'b' variable isn't used anywhere...
 * Hmm - It seems that the drawable is already hooked in to
 * driDrawablePriv.  
 *
 * But why are we doing context initialization here???
 */
GLboolean XMesaMakeCurrent(__DRIcontextPrivate *driContextPriv,
                           __DRIdrawablePrivate *driDrawPriv,
                           __DRIdrawablePrivate *driReadPriv)
{
   if (driContextPriv) {
      mgaCtx = (mgaContextPtr) driContextPriv->driverPrivate;

      gl_make_current2(mgaCtx->glCtx, driDrawPriv->mesaBuffer, driReadPriv->mesaBuffer);

      mgaCtx->driDrawable = driDrawPriv;
      mgaCtx->dirty = ~0;
      mgaCtx->dirty_cliprects = (MGA_FRONT|MGA_BACK);

      if (!mgaCtx->glCtx->Viewport.Width)
	 gl_Viewport(mgaCtx->glCtx, 0, 0, driDrawPriv->w, driDrawPriv->h);

   }
   else {
      gl_make_current(0,0);
      mgaCtx = NULL;
   }

   return GL_TRUE;
}


void mgaGetLock( mgaContextPtr mmesa, GLuint flags ) 
{
   __DRIdrawablePrivate *dPriv = mmesa->driDrawable;
   drm_mga_sarea_t *sarea = mmesa->sarea;
   int me = mmesa->hHWContext;
   int i;

   drmGetLock(mmesa->driFd, mmesa->hHWContext, flags);	

   if (*(dPriv->pStamp) != dPriv->lastStamp) { 
      mmesa->setupdone = 0;
      mmesa->dirty_cliprects = (MGA_FRONT|MGA_BACK);
      mgaUpdateRects( mmesa, (MGA_FRONT|MGA_BACK) );
   }

   mmesa->dirty |= MGA_UPLOAD_CTX | MGA_UPLOAD_CLIPRECTS;

    mmesa->sarea->dirty |= MGA_UPLOAD_CTX; 

   if (sarea->ctxOwner != me) {
      mmesa->dirty |= (MGA_UPLOAD_CTX | MGA_UPLOAD_TEX0 | 
		       MGA_UPLOAD_TEX1 | MGA_UPLOAD_PIPE);
      sarea->ctxOwner=me;
   }

   for (i = 0 ; i < mmesa->lastTexHeap ; i++)
      if (sarea->texAge[i] != mmesa->texAge[i])
	 mgaAgeTextures( mmesa, i );

   sarea->last_quiescent = -1;	/* just kill it for now */
}



#endif
