/*
 * Copyright 2000-2001 by Alan Hourihane, Sychdyn, North Wales, UK.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Alan Hourihane not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Alan Hourihane makes no representations
 * about the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 * ALAN HOURIHANE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL ALAN HOURIHANE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors:  Alan Hourihane, <alanh@fairlite.demon.co.uk>
 */
/* $XFree86: xc/programs/Xserver/hw/xfree86/drivers/glint/glint_dga.c,v 1.6 2004/12/07 15:59:19 tsi Exp $ */

#include "xf86.h"
#include "xf86_OSproc.h"
#include "xf86_ansic.h"
#include "xf86Pci.h"
#include "xf86PciInfo.h"
#include "xaa.h"
#include "glint.h"
#include "glint_regs.h"
#include "dgaproc.h"

static Bool GLINT_OpenFramebuffer(ScrnInfoPtr, char **, unsigned int *, 
				  unsigned int *, unsigned int *,
				  unsigned int *);
static Bool GLINT_SetMode(ScrnInfoPtr, DGAModePtr);
static void GLINT_Sync(ScrnInfoPtr);
static int  GLINT_GetViewport(ScrnInfoPtr);
static void GLINT_SetViewport(ScrnInfoPtr, int, int, int);
static void GLINT_FillRect(ScrnInfoPtr, int, int, int, int, unsigned long);
static void GLINT_BlitRect(ScrnInfoPtr, int, int, int, int, int, int);

static
DGAFunctionRec GLINTDGAFuncs = {
   GLINT_OpenFramebuffer,
   NULL,
   GLINT_SetMode,
   GLINT_SetViewport,
   GLINT_GetViewport,
   GLINT_Sync,
   GLINT_FillRect,
   GLINT_BlitRect,
   NULL
};

Bool
GLINTDGAInit(ScreenPtr pScreen)
{   
   ScrnInfoPtr pScrn = xf86Screens[pScreen->myNum];
   GLINTPtr pGlint = GLINTPTR(pScrn);
   DGAModePtr modes = NULL, newmodes = NULL, currentMode;
   DisplayModePtr pMode, firstMode;
   int Bpp = pScrn->bitsPerPixel >> 3;
   int num = 0;
   Bool oneMore;

   pMode = firstMode = pScrn->modes;

   while(pMode) {

	if(0 /*pScrn->displayWidth != pMode->HDisplay*/) {
	    newmodes = xrealloc(modes, (num + 2) * sizeof(DGAModeRec));
	    oneMore = TRUE;
	} else {
	    newmodes = xrealloc(modes, (num + 1) * sizeof(DGAModeRec));
	    oneMore = FALSE;
	}

	if(!newmodes) {
	   xfree(modes);
	   return FALSE;
	}
	modes = newmodes;

SECOND_PASS:

	currentMode = modes + num;
	num++;

	currentMode->mode = pMode;
	currentMode->flags = DGA_CONCURRENT_ACCESS | DGA_PIXMAP_AVAILABLE;
	if(!pGlint->NoAccel)
	   currentMode->flags |= DGA_FILL_RECT | DGA_BLIT_RECT;
	if(pMode->Flags & V_DBLSCAN)
	   currentMode->flags |= DGA_DOUBLESCAN;
	if(pMode->Flags & V_INTERLACE)
	   currentMode->flags |= DGA_INTERLACED;
	currentMode->byteOrder = pScrn->imageByteOrder;
	currentMode->depth = pScrn->depth;
	currentMode->bitsPerPixel = pScrn->bitsPerPixel;
	currentMode->red_mask = pScrn->mask.red;
	currentMode->green_mask = pScrn->mask.green;
	currentMode->blue_mask = pScrn->mask.blue;
	currentMode->visualClass = (Bpp == 1) ? PseudoColor : TrueColor;
	currentMode->viewportWidth = pMode->HDisplay;
	currentMode->viewportHeight = pMode->VDisplay;
	currentMode->xViewportStep = 1;
	currentMode->yViewportStep = 1;
	currentMode->viewportFlags = DGA_FLIP_RETRACE;
	currentMode->offset = 0;
	currentMode->address = pGlint->FbBase;

	if(oneMore) { /* first one is narrow width */
	    currentMode->bytesPerScanline = ((pMode->HDisplay * Bpp) + 3) & ~3L;
	    currentMode->imageWidth = pMode->HDisplay;
	    currentMode->imageHeight =  pMode->VDisplay;
	    currentMode->pixmapWidth = currentMode->imageWidth;
	    currentMode->pixmapHeight = currentMode->imageHeight;
	    currentMode->maxViewportX = currentMode->imageWidth - 
					currentMode->viewportWidth;
	    /* this might need to get clamped to some maximum */
	    currentMode->maxViewportY = currentMode->imageHeight -
					currentMode->viewportHeight;
	    oneMore = FALSE;
	    goto SECOND_PASS;
	} else {
	    currentMode->bytesPerScanline = 
			((pScrn->displayWidth * Bpp) + 3) & ~3L;
	    currentMode->imageWidth = pScrn->displayWidth;
	    currentMode->imageHeight =  pMode->VDisplay;
	    currentMode->pixmapWidth = currentMode->imageWidth;
	    currentMode->pixmapHeight = currentMode->imageHeight;
	    currentMode->maxViewportX = currentMode->imageWidth - 
					currentMode->viewportWidth;
	    /* this might need to get clamped to some maximum */
	    currentMode->maxViewportY = currentMode->imageHeight -
					currentMode->viewportHeight;
	}	    

	pMode = pMode->next;
	if(pMode == firstMode)
	   break;
   }

   pGlint->numDGAModes = num;
   pGlint->DGAModes = modes;

   return DGAInit(pScreen, &GLINTDGAFuncs, modes, num);  
}


static Bool
GLINT_SetMode(
   ScrnInfoPtr pScrn,
   DGAModePtr pMode
){
   static int OldDisplayWidth[MAXSCREENS];
   int index = pScrn->pScreen->myNum;
   GLINTPtr pGlint = GLINTPTR(pScrn);

   if(!pMode) { /* restore the original mode */
	/* put the ScreenParameters back */
	
	pScrn->displayWidth = OldDisplayWidth[index];
	
        GLINTSwitchMode(index, pScrn->currentMode, 0);
	pGlint->DGAactive = FALSE;
   } else {
	if(!pGlint->DGAactive) {  /* save the old parameters */
	    OldDisplayWidth[index] = pScrn->displayWidth;

	    pGlint->DGAactive = TRUE;
	}

	pScrn->displayWidth = pMode->bytesPerScanline / 
			      (pMode->bitsPerPixel >> 3);

        GLINTSwitchMode(index, pMode->mode, 0);
   }
   
   return TRUE;
}

static int  
GLINT_GetViewport(
  ScrnInfoPtr pScrn
){
    GLINTPtr pGlint = GLINTPTR(pScrn);

    return pGlint->DGAViewportStatus;
}

static void 
GLINT_SetViewport(
   ScrnInfoPtr pScrn, 
   int x, int y, 
   int flags
){
   GLINTPtr pGlint = GLINTPTR(pScrn);

   GLINTAdjustFrame(pScrn->pScreen->myNum, x, y, flags);
   pGlint->DGAViewportStatus = 0;  /* GLINTAdjustFrame loops until finished */
}

static void 
GLINT_FillRect (
   ScrnInfoPtr pScrn, 
   int x, int y, int w, int h, 
   unsigned long color
){
    GLINTPtr pGlint = GLINTPTR(pScrn);

    if(pGlint->AccelInfoRec) {
	(*pGlint->AccelInfoRec->SetupForSolidFill)(pScrn, color, GXcopy, ~0);
	(*pGlint->AccelInfoRec->SubsequentSolidFillRect)(pScrn, x, y, w, h);
	SET_SYNC_FLAG(pGlint->AccelInfoRec);
    }
}

static void 
GLINT_Sync(
   ScrnInfoPtr pScrn
){
    GLINTPtr pGlint = GLINTPTR(pScrn);

    if(pGlint->AccelInfoRec) {
	(*pGlint->AccelInfoRec->Sync)(pScrn);
    }
}

static void 
GLINT_BlitRect(
   ScrnInfoPtr pScrn, 
   int srcx, int srcy, 
   int w, int h, 
   int dstx, int dsty
){
    GLINTPtr pGlint = GLINTPTR(pScrn);

    if(pGlint->AccelInfoRec) {
	int xdir = ((srcx < dstx) && (srcy == dsty)) ? -1 : 1;
	int ydir = (srcy < dsty) ? -1 : 1;

	(*pGlint->AccelInfoRec->SetupForScreenToScreenCopy)(
		pScrn, xdir, ydir, GXcopy, ~0, -1);
	(*pGlint->AccelInfoRec->SubsequentScreenToScreenCopy)(
		pScrn, srcx, srcy, dstx, dsty, w, h);
	SET_SYNC_FLAG(pGlint->AccelInfoRec);
    }
}

static Bool 
GLINT_OpenFramebuffer(
   ScrnInfoPtr pScrn, 
   char **name,
   unsigned int *mem,
   unsigned int *size,
   unsigned int *offset,
   unsigned int *flags
){
    GLINTPtr pGlint = GLINTPTR(pScrn);

    *name = NULL; 		/* no special device */
    *mem = pGlint->FbAddress;
    *size = pGlint->FbMapSize;
    *offset = 0;
    *flags = 0;

    return TRUE;
}
