.\" Copyright (c) 1994  X Consortium
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" $XFree86: xc/programs/listres/listres.man,v 1.6 2006/01/09 15:00:47 dawes Exp $
.\"
.TH LISTRES 1 __vendorversion__
.SH NAME
listres - list resources in widgets
.SH SYNOPSIS
.B "listres"
[-option ...]
.SH DESCRIPTION
.PP
The \fIlistres\fP program generates a list of a widget's resource database.  
The class in which each resource is first defined, the instance and class
name, and the type of each resource is listed.  If no specific widgets
or the \fI-all\fP switch are given, a two-column list of widget names and
their class hierarchies is printed.
.SH OPTIONS
\fIListres\fP accepts all of the standard toolkit command line options along
with those listed below:
.TP 8
.B \-all
This option indicates that \fIlistres\fP should print information for all
known widgets and objects. 
.TP 8
.B \-nosuper
This option indicates that resources that are inherited from a superclass
should not be listed.  This is useful for determining which resources are
new to a subclass.
.TP 8
.B \-variable
This option indicates that widgets should be identified by the names of the
class record variables rather than the class name given in the variable.  This
is useful for distinguishing subclasses that have the same class name as their
superclasses.
.TP 8
.B \-top \fIname\fP
This option specifies the name of the widget to be treated as the top of the
hierarchy.  Case is not significant, and the name may match either the class
variable name or the class name.  The default is ``core''.
.TP 8
.B \-format \fIprintf\-string\fP
This option specifies the \fIprintf\fP-style format string to be used to print
out the name, instance, class, and type of each resource.
.SH "X DEFAULTS"
To be written.
.SH "SEE ALSO"
X(__miscmansuffix__), xrdb(1), appropriate widget documents
.SH "BUGS"
On operating systems that do not support dynamic linking of run-time routines,
this program must have all of its known widgets compiled in.  The sources
provide several tools for automating this process for various widget sets.
.SH COPYRIGHT
Copyright 1994 X Consortium
.br
See \fIX(__miscmansuffix__)\fP for a full statement of rights and permissions.
.SH AUTHOR
Jim Fulton, MIT X Consortium
