/* $XFree86: test/xsuite/xtest/tset/XFree86/fllrctngl/fllrctngl.m,v 1.1 2000/03/31 17:22:42 dawes Exp $ */
/*
 
Copyright (c) 1990, 1991  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

 *
 * Copyright 1990, 1991 by UniSoft Group Limited.
 * 
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of UniSoft not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  UniSoft
 * makes no representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * $XConsortium: fllrctngl.m,v 1.6 94/04/17 21:05:28 rws Exp $

 *
 * Original files: CH06/fllrctngl/fllrctngl.m and lib/gc/ts-x-orig
 * Modified Wed Oct 20 14:35:04 1999:
 *     by Rickard E. (Rik) Faith <faith@precisioninsight.com>
 *     added tests for XAA's 8x8 support
 *
 
 */
>>TITLE XFillRectangle CH06
void

Display	*display = Dsp;
Drawable d;
GC		gc;
int             x = 20;
int             y = 30;
unsigned int 	width = 70;
unsigned int 	height = 30;
>>EXTERN

#define stipple0_width 8
#define stipple0_height 8
static unsigned char stipple0_bits[] = {
    0xff,			/* ........ */
    0xc1,			/* ..     . */
    0xa1,			/* . .    . */
    0x99,			/* .  ..  . */
    0x99,			/* .  ..  . */
    0x81,			/* .      . */
    0x81,			/* .      . */
    0xff };			/* ........ */
#define stipple1_width 8
#define stipple1_height 8
static unsigned char stipple1_bits[] = {
    0xff,			/* ........ ........ */
    0x81,			/* .      . ..     . */
    0x9d,			/* .  ... . . .... . */
    0xa6,			/* . .  . . . .... . */
    0xa6,			/* . .  . . . .... . */
    0xbd,			/* . .... . . .... . */
    0x81,			/* .      . .      . */
    0xff };			/* ........ ........ */

>>ASSERTION Good A
When
.M fill_style
is
.S FillOpaqueStipple ,
then on a call to xname the source for the drawing operation is
.M foreground
masked by
the stipple pattern tiled in a single plane.
This tests non-transparecy with XFree86 XAA 8x8PatternColorExpand
and and even window location.
>>STRATEGY
Create stipple
Set fill-style to FillSolid.
Do drawing. 
Pixmap verify.
>>CODE
XVisualInfo	*vp;
Pixmap	fsstip;

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
	    A_DRAWABLE = makewin(A_DISPLAY, vp);
	    A_GC = makegc(A_DISPLAY, A_DRAWABLE);

	    fsstip = XCreateBitmapFromData(A_DISPLAY,
					   A_DRAWABLE,
					   (char*)stipple0_bits,
					   stipple0_width,
					   stipple0_height);
	    
	    XSetStipple(A_DISPLAY, A_GC, fsstip);
	    XSetFillStyle(A_DISPLAY, A_GC, FillOpaqueStippled);
	    XSetBackground(A_DISPLAY, A_GC, W_BG);
	    
	    XCALL;

	    PIXCHECK(A_DISPLAY, A_DRAWABLE);
	    
	    XFreePixmap(A_DISPLAY, fsstip);

	}

	CHECKPASS(nvinf());

>>ASSERTION Good A
When
.M fill_style
is
.S FillStippled ,
then on a call to xname the source for the drawing operation is
.M foreground
masked by
the stipple pattern tiled in a single plane.
This tests transparecy with XFree86 XAA 8x8PatternColorExpand
and an even window location.
>>STRATEGY
Create stipple
Set fill-style to FillStippled.
Set background to foreground pixel to verify it is not affecting things.
Do drawing. 
Pixmap verify.
>>CODE
XVisualInfo	*vp;
Pixmap	fsstip0;
Pixmap	fsstip1;

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
	    A_DRAWABLE = makewin(A_DISPLAY, vp);
	    A_GC = makegc(A_DISPLAY, A_DRAWABLE);

	    fsstip0 = XCreateBitmapFromData(A_DISPLAY,
					    A_DRAWABLE,
					    (char*)stipple0_bits,
					    stipple0_width,
					    stipple0_height);
	    fsstip1 = XCreateBitmapFromData(A_DISPLAY,
					    A_DRAWABLE,
					    (char*)stipple1_bits,
					    stipple1_width,
					    stipple1_height);
		
	    XSetStipple(A_DISPLAY, A_GC, fsstip0);
	    XSetFillStyle(A_DISPLAY, A_GC, FillOpaqueStippled);
	    XSetBackground(A_DISPLAY, A_GC, W_BG);
	    XCALL;
		
	    XSetStipple(A_DISPLAY, A_GC, fsstip1);
	    XSetFillStyle(A_DISPLAY, A_GC, FillStippled);
	    XSetBackground(A_DISPLAY, A_GC, W_FG); /* no effect */
	    XCALL;

	    PIXCHECK(A_DISPLAY, A_DRAWABLE);

	    XFreePixmap(A_DISPLAY, fsstip0);
	    XFreePixmap(A_DISPLAY, fsstip1);

	}

	CHECKPASS(nvinf());

>>ASSERTION Good A
When
.M fill_style
is
.S FillOpaqueStippled ,
the stipple origin coordinates
.M ts-x-origin
and
.M ts-y-origin
are interpreted relative to the
origin of the destination drawable specified in the graphics
operation.
>>STRATEGY
Create a stipple pixmap.
Set stipple component of GC to pixmap using XSetStipple.
For various stipple origins:
	Set stipple origin using XSetTSOrigin.
	Clear drawable.
	Set fill-style to FillOpaqueStippled using XSetFillStyle.
	Do graphics operation.
	Pixmap verify.
>>CODE
XVisualInfo	*vp;
Pixmap	tsostip;

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
	    A_DRAWABLE = makewin(A_DISPLAY, vp);
	    A_GC = makegc(A_DISPLAY, A_DRAWABLE);

	    tsostip = XCreateBitmapFromData(A_DISPLAY,
					    A_DRAWABLE,
					    (char*)stipple0_bits,
					    stipple0_width,
					    stipple0_height);
		
	    XSetTSOrigin(A_DISPLAY, A_GC, 9, 17);
	    dclear(A_DISPLAY, A_DRAWABLE);
	    XSetStipple(A_DISPLAY, A_GC, tsostip );
	    XSetFillStyle(A_DISPLAY, A_GC, FillOpaqueStippled);
	    XCALL;
	    PIXCHECK(A_DISPLAY, A_DRAWABLE);
	    
	    XFreePixmap(A_DISPLAY, tsostip);
	}

	CHECKPASS(nvinf());

>>ASSERTION Good A
When
.M fill_style
is
.S FillOpaqueStippled ,
the stipple origin coordinates
.M ts-x-origin
and
.M ts-y-origin
are interpreted relative to the
origin of the destination drawable specified in the graphics
operation.
>>STRATEGY
Create a stipple pixmap.
Set stipple component of GC to pixmap using XSetStipple.
For various stipple origins:
	Set stipple origin using XSetTSOrigin.
	Clear drawable.
	Set fill-style to FillOpaqueStippled using XSetFillStyle.
	Do graphics operation.
	Pixmap verify.
>>CODE
XVisualInfo	*vp;
Pixmap	tsostip;

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
	    A_DRAWABLE = makewin(A_DISPLAY, vp);
	    A_GC = makegc(A_DISPLAY, A_DRAWABLE);

	    tsostip = XCreateBitmapFromData(A_DISPLAY,
					    A_DRAWABLE,
					    (char*)stipple0_bits,
					    stipple0_width,
					    stipple0_height);
		
	    XSetTSOrigin(A_DISPLAY, A_GC, 0xd8f2, 0x4321);
	    dclear(A_DISPLAY, A_DRAWABLE);
	    XSetStipple(A_DISPLAY, A_GC, tsostip);
	    XSetFillStyle(A_DISPLAY, A_GC, FillOpaqueStippled);
	    XCALL;
	    PIXCHECK(A_DISPLAY, A_DRAWABLE);
	    
	    XFreePixmap(A_DISPLAY, tsostip);
	}

	CHECKPASS(nvinf());

>>ASSERTION Good A
When
.M fill_style
is
.S FillOpaqueStippled ,
the stipple origin coordinates
.M ts-x-origin
and
.M ts-y-origin
are interpreted relative to the
origin of the destination drawable specified in the graphics
operation.
>>STRATEGY
Create a stipple pixmap.
Set stipple component of GC to pixmap using XSetStipple.
For various stipple origins:
	Set stipple origin using XSetTSOrigin.
	Clear drawable.
	Set fill-style to FillOpaqueStippled using XSetFillStyle.
	Do graphics operation.
	Pixmap verify.
>>CODE
XVisualInfo	*vp;
Pixmap	tsostip;

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
	    A_DRAWABLE = makewin(A_DISPLAY, vp);
	    A_GC = makegc(A_DISPLAY, A_DRAWABLE);

	    tsostip = XCreateBitmapFromData(A_DISPLAY,
					    A_DRAWABLE,
					    (char*)stipple0_bits,
					    stipple0_width,
					    stipple0_height);
		
	    XSetTSOrigin(A_DISPLAY, A_GC, -3, 7);
	    dclear(A_DISPLAY, A_DRAWABLE);
	    XSetStipple(A_DISPLAY, A_GC, tsostip);
	    XSetFillStyle(A_DISPLAY, A_GC, FillOpaqueStippled);
	    XCALL;
	    PIXCHECK(A_DISPLAY, A_DRAWABLE);
	    
	    XFreePixmap(A_DISPLAY, tsostip);
	}

	CHECKPASS(nvinf());

>>ASSERTION Good A
When
.M fill_style
is
.S FillStippled ,
the stipple origin coordinates
.M ts-x-origin
and
.M ts-y-origin
are interpreted relative to the
origin of the destination drawable specified in the graphics
operation.
>>STRATEGY
Create a stipple pixmap.
Set stipple component of GC to pixmap using XSetStipple.
For various stipple origins:
	Set stipple origin using XSetTSOrigin.
	Clear drawable and fill with known opaque stipple.
	Set fill-style to FillStippled using XSetFillStyle.
	Do graphics operation.
	Pixmap verify.
>>CODE
XVisualInfo	*vp;
Pixmap	tsostip0;
Pixmap	tsostip1;

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
	    A_DRAWABLE = makewin(A_DISPLAY, vp);
	    A_GC = makegc(A_DISPLAY, A_DRAWABLE);

	    tsostip0 = XCreateBitmapFromData(A_DISPLAY,
					     A_DRAWABLE,
					     (char*)stipple0_bits,
					     stipple0_width,
					     stipple0_height);
	    tsostip1 = XCreateBitmapFromData(A_DISPLAY,
					     A_DRAWABLE,
					     (char*)stipple1_bits,
					     stipple1_width,
					     stipple1_height);
		
	    XSetTSOrigin(A_DISPLAY, A_GC, 9, 17);
	    dclear(A_DISPLAY, A_DRAWABLE);
	    XSetStipple(A_DISPLAY, A_GC, tsostip0);
	    XSetFillStyle(A_DISPLAY, A_GC, FillOpaqueStippled);
	    XCALL;
	    XSetStipple(A_DISPLAY, A_GC, tsostip1);
	    XSetFillStyle(A_DISPLAY, A_GC, FillStippled);
	    XCALL;
	    PIXCHECK(A_DISPLAY, A_DRAWABLE);
	    
	    XFreePixmap(A_DISPLAY, tsostip0);
	    XFreePixmap(A_DISPLAY, tsostip1);
	}

	CHECKPASS(nvinf());

>>ASSERTION Good A
When
.M fill_style
is
.S FillStippled ,
the stipple origin coordinates
.M ts-x-origin
and
.M ts-y-origin
are interpreted relative to the
origin of the destination drawable specified in the graphics
operation.
>>STRATEGY
Create a stipple pixmap.
Set stipple component of GC to pixmap using XSetStipple.
For various stipple origins:
	Set stipple origin using XSetTSOrigin.
	Clear drawable and fill with known opaque stipple.
	Set fill-style to FillStippled using XSetFillStyle.
	Do graphics operation.
	Pixmap verify.
>>CODE
XVisualInfo	*vp;
Pixmap	tsostip0;
Pixmap	tsostip1;

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
	    A_DRAWABLE = makewin(A_DISPLAY, vp);
	    A_GC = makegc(A_DISPLAY, A_DRAWABLE);

	    tsostip0 = XCreateBitmapFromData(A_DISPLAY,
					     A_DRAWABLE,
					     (char*)stipple0_bits,
					     stipple0_width,
					     stipple0_height);
	    tsostip1 = XCreateBitmapFromData(A_DISPLAY,
					     A_DRAWABLE,
					     (char*)stipple1_bits,
					     stipple1_width,
					     stipple1_height);
		
	    XSetTSOrigin(A_DISPLAY, A_GC, 0xd8f2, 0x4321);
	    dclear(A_DISPLAY, A_DRAWABLE);
	    XSetStipple(A_DISPLAY, A_GC, tsostip0);
	    XSetFillStyle(A_DISPLAY, A_GC, FillOpaqueStippled);
	    XCALL;
	    XSetStipple(A_DISPLAY, A_GC, tsostip1);
	    XSetFillStyle(A_DISPLAY, A_GC, FillStippled);
	    XCALL;
	    PIXCHECK(A_DISPLAY, A_DRAWABLE);
	    
	    XFreePixmap(A_DISPLAY, tsostip0);
	    XFreePixmap(A_DISPLAY, tsostip1);
	}

	CHECKPASS(nvinf());

>>ASSERTION Good A
When
.M fill_style
is
.S FillStippled ,
the stipple origin coordinates
.M ts-x-origin
and
.M ts-y-origin
are interpreted relative to the
origin of the destination drawable specified in the graphics
operation.
>>STRATEGY
Create a stipple pixmap.
Set stipple component of GC to pixmap using XSetStipple.
For various stipple origins:
	Set stipple origin using XSetTSOrigin.
	Clear drawable and fill with known opaque stipple.
	Set fill-style to FillStippled using XSetFillStyle.
	Do graphics operation.
	Pixmap verify.
>>CODE
XVisualInfo	*vp;
Pixmap	tsostip0;
Pixmap	tsostip1;

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
	    A_DRAWABLE = makewin(A_DISPLAY, vp);
	    A_GC = makegc(A_DISPLAY, A_DRAWABLE);

	    tsostip0 = XCreateBitmapFromData(A_DISPLAY,
					     A_DRAWABLE,
					     (char*)stipple0_bits,
					     stipple0_width,
					     stipple0_height);
	    tsostip1 = XCreateBitmapFromData(A_DISPLAY,
					     A_DRAWABLE,
					     (char*)stipple1_bits,
					     stipple1_width,
					     stipple1_height);
	    
	    XSetTSOrigin(A_DISPLAY, A_GC, -3, 7);
	    dclear(A_DISPLAY, A_DRAWABLE);
	    XSetStipple(A_DISPLAY, A_GC, tsostip0);
	    XSetFillStyle(A_DISPLAY, A_GC, FillOpaqueStippled);
	    XCALL;
	    XSetStipple(A_DISPLAY, A_GC, tsostip1);
	    XSetFillStyle(A_DISPLAY, A_GC, FillStippled);
	    XCALL;
	    PIXCHECK(A_DISPLAY, A_DRAWABLE);
	    
	    XFreePixmap(A_DISPLAY, tsostip0);
	    XFreePixmap(A_DISPLAY, tsostip1);
	}

	CHECKPASS(nvinf());
