#ifndef _INTERNALSENSORS_h
#define _INTERNALSENSORS_h

#include "BMP180.h"


class InternalSensors {
public: 
  InternalSensors(unsigned long interval = 60);	// interval in s
  bool TryInitializeBMP180();
  bool HasBMP180();
  bool TryHandleData();
  int GetAltitudeAboveSeaLevel();
  void SetAltitudeAboveSeaLevel(int altitude = 0);
  unsigned long GetInterval();
  void SetInterval(unsigned long interval);

protected:
  struct Frame {
    byte  ID;
    bool  NewBatteryFlag;
    bool  LowBatteryFlag;

    float Temperature;    // C 
    int  Pressure;        // hPa
  };

  bool m_hasBMP180;
  BMP180 m_bmp;
  unsigned long m_lastMeasurement;
  unsigned long m_interval;
  String BuildFhemDataString(struct InternalSensors::Frame *frame);
  String GetFhemDataString();
};


#endif

