# Citing SUNDIALS

We ask users of SUNDIALS to cite the following paper in any publications reporting work done with SUNDIALS:

```bibtex
@article{hindmarsh2005sundials,
    title     = {{SUNDIALS}: Suite of nonlinear and differential/algebraic equation solvers},
    author    = {Hindmarsh, Alan C and Brown, Peter N and Grant, Keith E and Lee, Steven L and Serban, Radu and Shumaker, Dan E and Woodward, Carol S},
    journal   = {ACM Transactions on Mathematical Software (TOMS)},
    volume    = {31},
    number    = {3},
    pages     = {363--396},
    year      = {2005},
    publisher = {ACM}
}
```

If any GPU features of SUNDIALS were utilized, please also cite:

```bibtex
@article{balos2021enabling,
  title     = {{Enabling GPU accelerated computing in the SUNDIALS time integration library}},
  author    = {Balos, Cody J and Gardner, David J and Woodward, Carol S and Reynolds, Daniel R},
  journal   = {Parallel Computing},
  volume    = {108},
  pages     = {102836},
  year      = {2021},
  publisher = {Elsevier}
}
```

We also ask that users cite the documentation for the package that they are using
rather than the combined SUNDIALS online guide:

```bibtex
@Misc{arkodeDocumentation,
  author = {Daniel R. Reynolds and David J. Gardner and Carol S. Woodward and Cody J. Balos},
  title  = {User Documentation for ARKODE},
  year   = {2022},
  note   = {v5.2.0}
}
```

```bibtex
@Misc{cvodeDocumentation,
  author = {Alan C. Hindmarsh and Radu Serban and Cody J. Balos and David J. Gardner and Daniel R. Reynolds and Carol S. Woodward},
  title  = {User Documentation for CVODE},
  year   = {2022},
  note   = {v6.2.0}
}
```

```bibtex
@Misc{cvodesDocumentation,
  author = {Alan C. Hindmarsh and Radu Serban and Cody J. Balos and David J. Gardner and Daniel R. Reynolds and Carol S. Woodward},
  title  = {User Documentation for CVODES},
  year   = {2022},
  note   = {v6.2.0}
}
```

```bibtex
@Misc{idaDocumentation,
  author = {Alan C. Hindmarsh and Radu Serban and Cody J. Balos and David J. Gardner and Daniel R. Reynolds and Carol S. Woodward},
  title  = {User Documentation for IDA},
  year   = {2022},
  note   = {v6.2.0}
}
```

```bibtex
@Misc{idasDocumentation,
  author = {Radu Serban and Cosmin Petra and Alan C. Hindmarsh and Cody J. Balos and David J. Gardner and Daniel R. Reynolds and Carol S. Woodward},
  title  = {User Documentation for IDAS},
  year   = {2022},
  note   = {v5.2.0}
}
```

```bibtex
@Misc{kinsolDocumentation,
  author = {Alan C. Hindmarsh and Radu Serban and Cody J. Balos and David J. Gardner and Daniel R. Reynolds and Carol S. Woodward},
  title  = {User Documentation for KINSOL},
  year   = {2022},
  note   = {v6.2.0}
}
```
