+++
dep = 3
title = "Draft Pack Format"
authors = [ "Matt Fisher <matt.fisher@microsoft.com>" ]
created = 2017-10-18
+++

# Introduction

Packs consist of a Dockerfile and a Helm Chart that demonstrates best practices for deploying applications of a given language. For example:

```shell
$ draft create
--> Draft detected the primary language as Python with 97.267760% certainty.
--> Ready to sail
```

# Motivation

Draft Packs allows `draft create` to bootstrap an application from a defined pack in their local filesystem. Without language packs available to bootstrap applications, users will need to create applications from scratch. This eases the development workflow down to `draft create` for preparing an application, ready to deploy to Kubernetes.

# The Pack Structure

A pack is organized inside a directory in `$(draft home)/packs`. Inside the pack's
directory, there will be a template `chart/` and a `Dockerfile` that will be injected into the
application when the pack is requested.

Inside this directory, Draft will expect a structure like this:

```shell
python/               # the name of the directory is the name of the pack
  charts/
    Chart.yaml        # A YAML file containing information about the chart
    LICENSE           # OPTIONAL: A plain text file containing the license for the chart
    README.md         # OPTIONAL: A human-readable README file
    values.yaml       # The default configuration values for this chart
    charts/           # OPTIONAL: A directory containing any charts upon which this chart depends.
    templates/        # OPTIONAL: A directory of templates that, when combined with values,
                      # will generate valid Kubernetes manifest files.
  Dockerfile          # A Dockerfile for building the application
```

We could then run `draft create` with this pack like so:

```shell
$ draft create --pack=python
--> Draft detected the primary language as Python with 97.267760% certainty.
--> Ready to sail
```

The easiest way to create and work with a pack is with the following commands:

```shell
$ cd $(draft home)/packs
$ mkdir python
$ cd python
$ helm create chart
Creating chart
$ echo "FROM python:onbuild" > Dockerfile
```

Plans and ideas to improve the pack creation workflow can be found in [issue 287][#287].

You can optionally define a set of tasks to run at different points while using draft to build and deploy your application in a [`tasks.toml`](dep-008.md) file inside of a draft pack. The `tasks.toml` file will get copied to `.draft-tasks.toml` inside of your application's root directory. If no `tasks.toml` is provided in the pack, `draft create` will generate an empty `.draft-tasks.toml`.

## Pack Detection

When `draft create` is executed on an application, Draft performs a deep search on the current directory to determine the language. It displays language percentages based on the files present in the current directory and subdirectories. The percentages are calculated based on the bytes of code for each language as reported by a [Naive Bayesian Classifier](https://en.wikipedia.org/wiki/Naive_Bayes_classifier), which is trained on files provided by [github/linguist](https://github.com/github/linguist). Draft then starts iterating through the packs available in `$(draft home)/packs`. If it finds a pack that matches the language description, it will then use that pack to bootstrap the application.

Draft's smart pack detection can be overridden with the `--pack` flag. The detection logic will not be run and Draft will bootstrap the app with the specified pack, no questions asked.

[#287]: https://github.com/Azure/draft/issues/287
