#
# tiers2ns.awk -- converter from tiers format to ns 2.0 Tcl format
#
#
#  Tcl format:
#
#   proc create_net {} {
#       global ns_
#       global nodes_
#       global rt_
#
#       set ns_ [new Simulator]
#
#       set i 0
#       while {$i < <num>} {
#           set nodes_($i) [$ns_ node]
#           incr i
#       }
#
#       $ns_ duplex-link <from-node> <to-node> <speed> <delay> <type>
#       ...
#
#       $ns_ compute-routes 
#       set rt_ [$ns_ get-routelogic ]
#   }
#
#
# "tiers" was written by Mattew B. Doar (mdoar@nexen.com) and is available
# from ftp://ftp.nexen.com/pub/papers
#
# This converter was written for tiers1.1 file format and require some
# small modifications to tiers_config and the source code, so a random
# generator ID can be used from the command line (the original code always
# uses the current time)
#
# Send email to pavlin@catarina.usc.edu if you need the patches
#
# Pavlin Ivanov Radoslavov (pavlin@catarina.usc.edu)
# Wed Feb  4 15:22:00 PST 1998
#

BEGIN {
	for (getline; $2 != "Parameters"; getline)
		;
	ModelId = $7;
	for (getline; $4 != "number"; getline)
		;
	NW = $2; getline;
	NM = $2; getline;
	NL = $2; getline;
	SW = $2; getline;
	SM = $2; getline;
	SL = $2; getline;
	RW = $2; getline;
	RM = $2; getline;
	RL = $2; getline;
	RMW = $2; getline;
	RLM = $2; getline;
		getline;
	Grid_size = $2; getline;
	Grid_unit_WAN = $2; getline;
	Grid_init_MAN = $2; getline;
	Grid_unit_LAN = $2; getline;
		getline;
	Prox_test_WAN = $2; getline;
	Prox_test_MAN = $2; getline;
	Prox_test_LAN = $2; getline;
		getline;
	undirected = $2; getline;
	nodes_number = $8;

	for (getline; $2 != "EDGES"; getline)
		;

	print "#";
	print "# Created using Matthew B. Doar's `tiers` topology generator with parameters:";
	printf("#   tiers %d %d %d %d %d %d %d %d %d %d %d %d\n", \
		NW, NM, NL, SW, SM, SL, RW, RM, RL, RMW, RLM, ModelId);
	print "#";
	print "#";
	print "proc create_net {} {"
	print "\tglobal ns_"
	print "\tglobal nodes_"
	print "\tglobal rt_"
	print ""
	print "\tset ns_ [new Simulator]"
	print ""
	print "\tset i 0"
	print "\twhile {$i < " nodes_number "} {"
	print "\t\tset nodes_($i) [$ns_ node]"
	print "\t\tincr i"
	print "\t}"
	print ""
}

{
	if ($1 != "#")
		if (undirected == 1)
			printf("\t$ns_ duplex-link $nodes_(%d) $nodes_(%d) %dMb %dms DropTail\n", $1, $2, $4, $3/100);
		else
			printf("\t$ns_ simplex-link $nodes_(%d) $nodes_(%d) %dMb %dms DropTail\n", $1, $2, $4, $3/100);
}

END {
	print ""
	print "\t$ns_ compute-routes"
	print "\tset rt_ [$ns_ get-routelogic]"
	print ""
	print "}"
}

