/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.async.impl;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.InvocationHandler;
import org.apache.aries.async.impl.AsyncService;
import org.apache.aries.async.impl.MethodCall;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

class TrackingInvocationHandler
implements java.lang.reflect.InvocationHandler,
InvocationHandler {
    private static final Map<Class<?>, Object> RETURN_VALUES;
    private final AsyncService asyncService;
    private final ServiceTracker<LogService, LogService> logServiceTracker;
    private final Bundle clientBundle;
    private final ServiceReference<?> ref;
    private final Object delegate;

    public TrackingInvocationHandler(AsyncService asyncService, Bundle clientBundle, ServiceTracker<LogService, LogService> logServiceTracker, ServiceReference<?> ref) {
        this.asyncService = asyncService;
        this.logServiceTracker = logServiceTracker;
        this.clientBundle = clientBundle;
        this.ref = ref;
        this.delegate = null;
    }

    public TrackingInvocationHandler(AsyncService asyncService, Bundle clientBundle, ServiceTracker<LogService, LogService> logServiceTracker, Object service) {
        this.asyncService = asyncService;
        this.logServiceTracker = logServiceTracker;
        this.clientBundle = clientBundle;
        this.delegate = service;
        this.ref = null;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.asyncService.registerInvocation(new MethodCall(this.clientBundle, this.logServiceTracker, this.ref, this.delegate, method, args));
        Class<?> returnType = method.getReturnType();
        return RETURN_VALUES.get(returnType);
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>> map = new HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>>();
        map.put(Boolean.TYPE, Boolean.FALSE);
        map.put(Byte.TYPE, Byte.valueOf((byte)0));
        map.put(Short.TYPE, Short.valueOf((short)0));
        map.put(Character.TYPE, Character.valueOf('\u0000'));
        map.put(Integer.TYPE, Integer.valueOf(0));
        map.put(Float.TYPE, Float.valueOf(0.0f));
        map.put(Long.TYPE, Long.valueOf(0L));
        map.put(Double.TYPE, Double.valueOf(0.0));
        RETURN_VALUES = Collections.unmodifiableMap(map);
    }
}

