/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

abstract class AbstractReflector {
    AbstractReflector() {
    }

    protected Object invokeMethod(Object object, String methodName, Class[] params, Object[] args) {
        Class<?> clazz;
        if (object instanceof Class) {
            clazz = (Class<?>)object;
            object = null;
        } else {
            clazz = object.getClass();
        }
        Method method = this.getMethod(clazz, methodName, params);
        try {
            return method.invoke(object, args);
        }
        catch (IllegalAccessException e) {
            this.reflectionException(e);
        }
        catch (InvocationTargetException e) {
            this.reflectionException(e);
        }
        return null;
    }

    private Method getMethod(Class clazz, String methodName, Class[] params) {
        NoSuchMethodException exception = null;
        while (clazz != null) {
            try {
                Method method = clazz.getDeclaredMethod(methodName, params);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException e) {
                exception = e;
                clazz = clazz.getSuperclass();
            }
        }
        this.reflectionException(exception);
        return null;
    }

    protected abstract void reflectionException(Exception var1);
}

