/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import net.jini.core.lookup.ServiceID;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

public class ConfigUtil {
    private ConfigUtil() {
        throw new AssertionError((Object)"com.sun.jini.config.ConfigUtil cannot be instantiated");
    }

    public static String concat(Object[] objects) {
        if (objects.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(String.valueOf(objects[0]));
        for (int i = 1; i < objects.length; ++i) {
            buf.append(objects[i]);
        }
        return buf.toString();
    }

    public static String getHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    public static String getHostAddress() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public static String stringLiteral(String string) {
        StringBuffer sb = new StringBuffer(string.length() + 2);
        sb.append('\"');
        char[] ca = string.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            char c = ca[i];
            if (c == '\\' || c == '\"') {
                sb.append("\\").append(c);
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c == '\f') {
                sb.append("\\f");
                continue;
            }
            if (c == '\b') {
                sb.append("\\b");
                continue;
            }
            if (c < ' ') {
                sb.append("\\").append(Integer.toOctalString(c));
                continue;
            }
            sb.append(c);
        }
        return sb.append('\"').toString();
    }

    public static ServiceID createServiceID(String s) {
        Uuid uuid = UuidFactory.create(s);
        return new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }
}

