/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import com.sun.jini.jeri.internal.runtime.DgcServer;
import com.sun.jini.jeri.internal.runtime.ImplRefManager;
import com.sun.jini.jeri.internal.runtime.Jeri;
import com.sun.jini.logging.Levels;
import com.sun.jini.thread.NewThreadAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.rmi.server.Unreferenced;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.export.ServerContext;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.io.MarshalInputStream;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.BasicInvocationDispatcher;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.InvocationDispatcher;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.ServerCapabilities;
import net.jini.security.Security;
import net.jini.security.SecurityContext;

final class ObjectTable {
    private static final Logger logger;
    private static final Collection dgcDispatcherMethods;
    private static final ServerCapabilities dgcServerCapabilities;
    private final Object requestDispatchersLock = new Object();
    private final ImplRefManager implRefManager = new ImplRefManager();
    private final Object keepAliveLock = new Object();
    private int keepAliveCount = 0;
    private Thread keeper = null;
    private final Map leaseTable = new HashMap();
    private Thread leaseChecker = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    ObjectTable() {
    }

    RequestDispatcher createRequestDispatcher(Unreferenced unrefCallback) {
        return new RD(unrefCallback);
    }

    boolean isReferenced(RequestDispatcher requestDispatcher) {
        return this.getRD(requestDispatcher).isReferenced();
    }

    Target export(Remote impl, RequestDispatcher[] requestDispatchers, boolean allowDGC, boolean keepAlive, Uuid id) throws ExportException {
        RD[] rds = new RD[requestDispatchers.length];
        for (int i = 0; i < requestDispatchers.length; ++i) {
            rds[i] = this.getRD(requestDispatchers[i]);
        }
        return new Target(impl, id, rds, allowDGC, keepAlive);
    }

    private RD getRD(RequestDispatcher requestDispatcher) {
        RD rd = (RD)requestDispatcher;
        if (!rd.forTable(this)) {
            throw new IllegalArgumentException("request dispatcher for different object table");
        }
        return rd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementKeepAliveCount() {
        Object object = this.keepAliveLock;
        synchronized (object) {
            ++this.keepAliveCount;
            if (this.keeper == null) {
                this.keeper = (Thread)AccessController.doPrivileged(new NewThreadAction(new Runnable(){

                    public void run() {
                        try {
                            while (true) {
                                Thread.sleep(Long.MAX_VALUE);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                }, "KeepAlive", false));
                this.keeper.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementKeepAliveCount() {
        Object object = this.keepAliveLock;
        synchronized (object) {
            --this.keepAliveCount;
            if (this.keepAliveCount == 0) {
                if (!$assertionsDisabled && this.keeper == null) {
                    throw new AssertionError();
                }
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ObjectTable.this.keeper.interrupt();
                        return null;
                    }
                });
                this.keeper = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerTarget(Target target, Uuid clientID) {
        Map map = this.leaseTable;
        synchronized (map) {
            Lease lease = (Lease)this.leaseTable.get(clientID);
            if (lease == null) {
                target.leaseExpired(clientID);
            } else {
                Set set = lease.notifySet;
                synchronized (set) {
                    lease.notifySet.add(target);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterTarget(Target target, Uuid clientID) {
        Map map = this.leaseTable;
        synchronized (map) {
            Lease lease = (Lease)this.leaseTable.get(clientID);
            if (lease != null) {
                Set set = lease.notifySet;
                synchronized (set) {
                    lease.notifySet.remove(target);
                }
            }
        }
    }

    static {
        $assertionsDisabled = !ObjectTable.class.desiredAssertionStatus();
        logger = Logger.getLogger("net.jini.jeri.BasicJeriExporter");
        dgcDispatcherMethods = new ArrayList(2);
        Method[] methods = DgcServer.class.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            final Method m = methods[i];
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    m.setAccessible(true);
                    return null;
                }
            });
            dgcDispatcherMethods.add(m);
        }
        dgcServerCapabilities = new ServerCapabilities(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public InvocationConstraints checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
                if (!$assertionsDisabled && !constraints.equals(InvocationConstraints.EMPTY)) {
                    throw new AssertionError();
                }
                return InvocationConstraints.EMPTY;
            }

            static {
                $assertionsDisabled = !(class$com$sun$jini$jeri$internal$runtime$ObjectTable == null ? (class$com$sun$jini$jeri$internal$runtime$ObjectTable = ObjectTable.class$("com.sun.jini.jeri.internal.runtime.ObjectTable")) : class$com$sun$jini$jeri$internal$runtime$ObjectTable).desiredAssertionStatus();
            }
        };
    }

    private static class NoSuchObject
    extends Exception {
        private NoSuchObject() {
        }
    }

    private static class Lease {
        private final Uuid clientID;
        final Set notifySet = new HashSet(3);
        private long expiration;

        Lease(Uuid clientID, long duration) {
            this.clientID = clientID;
            this.expiration = System.currentTimeMillis() + duration;
        }

        Uuid getClientID() {
            return this.clientID;
        }

        void renew(long duration) {
            long newExpiration = System.currentTimeMillis() + duration;
            if (newExpiration > this.expiration) {
                this.expiration = newExpiration;
            }
        }

        boolean hasExpired(long now) {
            return this.expiration < now;
        }
    }

    private class LeaseChecker
    implements Runnable {
        private LeaseChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean done = false;
            do {
                try {
                    Thread.sleep(Jeri.leaseCheckInterval);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long now = System.currentTimeMillis();
                ArrayList<Lease> expiredLeases = new ArrayList<Lease>();
                Map map = ObjectTable.this.leaseTable;
                synchronized (map) {
                    Iterator i = ObjectTable.this.leaseTable.values().iterator();
                    while (i.hasNext()) {
                        Lease lease = (Lease)i.next();
                        if (!lease.hasExpired(now)) continue;
                        expiredLeases.add(lease);
                        i.remove();
                    }
                    if (ObjectTable.this.leaseTable.isEmpty()) {
                        ObjectTable.this.leaseChecker = null;
                        done = true;
                    }
                }
                if (expiredLeases.isEmpty()) continue;
                Iterator i = expiredLeases.iterator();
                while (i.hasNext()) {
                    Lease lease = (Lease)i.next();
                    if (lease.notifySet.isEmpty()) continue;
                    Iterator i2 = lease.notifySet.iterator();
                    while (i2.hasNext()) {
                        Target target = (Target)i2.next();
                        target.leaseExpired(lease.getClientID());
                    }
                }
            } while (!done);
        }
    }

    private class RD
    implements RequestDispatcher {
        private final Unreferenced unrefCallback;
        private final Map idTable = new HashMap();
        private int dgcEnabledCount = 0;
        private final InvocationDispatcher dgcDispatcher;
        private final DgcServerImpl dgcServerImpl;
        static final /* synthetic */ boolean $assertionsDisabled;

        RD(Unreferenced unrefCallback) {
            this.unrefCallback = unrefCallback;
            try {
                this.dgcDispatcher = new BasicInvocationDispatcher(dgcDispatcherMethods, dgcServerCapabilities, null, null, this.getClass().getClassLoader()){

                    protected ObjectInputStream createMarshalInputStream(Object impl, InboundRequest request, boolean integrity, Collection context) throws IOException {
                        ClassLoader loader = this.getClassLoader();
                        return new MarshalInputStream(request.getRequestInputStream(), loader, integrity, loader, Collections.unmodifiableCollection(context));
                    }
                };
            }
            catch (ExportException e) {
                throw new AssertionError();
            }
            this.dgcServerImpl = new DgcServerImpl();
        }

        boolean forTable(ObjectTable table) {
            return ObjectTable.this == table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isReferenced() {
            Map map = this.idTable;
            synchronized (map) {
                return !this.idTable.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Target get(Uuid id) {
            Map map = this.idTable;
            synchronized (map) {
                return (Target)this.idTable.get(id);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(Target target) throws ExportException {
            Map map = this.idTable;
            synchronized (map) {
                Uuid id = target.getObjectIdentifier();
                if (id.equals(Jeri.DGC_ID)) {
                    throw new ExportException("object identifier reserved for DGC");
                }
                if (this.idTable.containsKey(id)) {
                    throw new ExportException("object identifier already in use");
                }
                this.idTable.put(id, target);
                if (target.getEnableDGC()) {
                    ++this.dgcEnabledCount;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(Target target, boolean gc) {
            boolean empty = false;
            Map map = this.idTable;
            synchronized (map) {
                Uuid id = target.getObjectIdentifier();
                if (!$assertionsDisabled && this.idTable.get(id) != target) {
                    throw new AssertionError();
                }
                this.idTable.remove(id);
                if (target.getEnableDGC()) {
                    --this.dgcEnabledCount;
                    if (!$assertionsDisabled && this.dgcEnabledCount < 0) {
                        throw new AssertionError();
                    }
                }
                if (this.idTable.isEmpty()) {
                    empty = true;
                }
            }
            if (gc && empty) {
                this.unrefCallback.unreferenced();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean hasDgcEnabledTargets() {
            Map map = this.idTable;
            synchronized (map) {
                return this.dgcEnabledCount > 0;
            }
        }

        public void dispatch(InboundRequest request) {
            block8: {
                try {
                    InputStream in = request.getRequestInputStream();
                    Uuid id = UuidFactory.read(in);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "id={0}", id);
                    }
                    try {
                        if (id.equals(Jeri.DGC_ID)) {
                            this.dispatchDgcRequest(request);
                            return;
                        }
                        Target target = this.get(id);
                        if (target == null) {
                            logger.log(Level.FINEST, "id not in table");
                            throw new NoSuchObject();
                        }
                        target.dispatch(request);
                    }
                    catch (NoSuchObject e) {
                        in.close();
                        OutputStream out = request.getResponseOutputStream();
                        out.write(0);
                        out.close();
                        if (logger.isLoggable(Levels.FAILED)) {
                            logger.log(Levels.FAILED, "no such object: {0}", id);
                        }
                    }
                }
                catch (IOException e) {
                    request.abort();
                    if (!logger.isLoggable(Levels.FAILED)) break block8;
                    logger.log(Levels.FAILED, "I/O exception dispatching request", e);
                }
            }
        }

        private void dispatchDgcRequest(final InboundRequest request) throws IOException, NoSuchObject {
            if (!this.hasDgcEnabledTargets()) {
                logger.log(Level.FINEST, "no DGC-enabled targets");
                throw new NoSuchObject();
            }
            OutputStream out = request.getResponseOutputStream();
            out.write(1);
            final ArrayList context = new ArrayList(5);
            request.populateContext(context);
            ServerContext.doWithServerContext(new Runnable(){

                public void run() {
                    RD.this.dgcDispatcher.dispatch(RD.this.dgcServerImpl, request, context);
                }
            }, Collections.unmodifiableCollection(context));
        }

        static {
            $assertionsDisabled = !(class$com$sun$jini$jeri$internal$runtime$ObjectTable == null ? (class$com$sun$jini$jeri$internal$runtime$ObjectTable = ObjectTable.class$("com.sun.jini.jeri.internal.runtime.ObjectTable")) : class$com$sun$jini$jeri$internal$runtime$ObjectTable).desiredAssertionStatus();
        }

        private class DgcServerImpl
        implements DgcServer {
            private DgcServerImpl() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long dirty(Uuid clientID, long sequenceNum, Uuid[] ids) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "clientID={0}, sequenceNum={1}, ids={2}", new Object[]{clientID, new Long(sequenceNum), Arrays.asList(ids)});
                }
                long duration = Jeri.leaseValue;
                Map map = ObjectTable.this.leaseTable;
                synchronized (map) {
                    Lease lease = (Lease)ObjectTable.this.leaseTable.get(clientID);
                    if (lease == null) {
                        ObjectTable.this.leaseTable.put(clientID, new Lease(clientID, duration));
                        if (ObjectTable.this.leaseChecker == null) {
                            ObjectTable.this.leaseChecker = (Thread)AccessController.doPrivileged(new NewThreadAction(new LeaseChecker(), "DGC Lease Checker", true));
                            ObjectTable.this.leaseChecker.start();
                        }
                    } else {
                        lease.renew(duration);
                    }
                }
                for (int i = 0; i < ids.length; ++i) {
                    Target target = RD.this.get(ids[i]);
                    if (target == null) continue;
                    target.referenced(clientID, sequenceNum);
                }
                return duration;
            }

            public void clean(Uuid clientID, long sequenceNum, Uuid[] ids, boolean strong) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "clientID={0}, sequenceNum={1}, ids={2}, strong={3}", new Object[]{clientID, new Long(sequenceNum), Arrays.asList(ids), strong});
                }
                for (int i = 0; i < ids.length; ++i) {
                    Target target = RD.this.get(ids[i]);
                    if (target == null) continue;
                    target.unreferenced(clientID, sequenceNum, strong);
                }
            }
        }
    }

    private static final class SequenceEntry {
        long sequenceNum;
        boolean keep;

        SequenceEntry(long sequenceNum) {
            this.sequenceNum = sequenceNum;
        }
    }

    final class Target {
        private final ImplRefManager.ImplRef implRef;
        private final Uuid id;
        private final RD[] requestDispatchers;
        private final boolean allowDGC;
        private final boolean keepAlive;
        private final SecurityContext securityContext;
        private final ClassLoader ccl;
        private final Object lock;
        private InvocationDispatcher invocationDispatcher;
        private boolean exported;
        private int callsInProgress;
        private final Set referencedSet;
        private final Map sequenceTable;
        static final /* synthetic */ boolean $assertionsDisabled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Target(Remote impl, Uuid id, RD[] requestDispatchers, boolean allowDGC, boolean keepAlive) throws ExportException {
            Object object;
            block12: {
                this.lock = new Object();
                this.exported = false;
                this.callsInProgress = 0;
                this.id = id;
                this.requestDispatchers = requestDispatchers;
                this.allowDGC = allowDGC;
                this.keepAlive = keepAlive;
                this.securityContext = Security.getContext();
                this.ccl = Thread.currentThread().getContextClassLoader();
                object = ObjectTable.this.requestDispatchersLock;
                synchronized (object) {
                    boolean success = false;
                    int i = 0;
                    try {
                        for (i = 0; i < requestDispatchers.length; ++i) {
                            requestDispatchers[i].put(this);
                        }
                        success = true;
                        Object var11_10 = null;
                        if (success) break block12;
                    }
                    catch (Throwable throwable) {
                        Object var11_11 = null;
                        if (success) throw throwable;
                        int j = 0;
                        while (j < i) {
                            requestDispatchers[i].remove(this, false);
                            ++j;
                        }
                        throw throwable;
                    }
                    for (int j = 0; j < i; ++j) {
                        requestDispatchers[i].remove(this, false);
                    }
                }
            }
            this.implRef = ObjectTable.this.implRefManager.getImplRef(impl, this);
            if (allowDGC) {
                this.referencedSet = new HashSet(3);
                this.sequenceTable = new HashMap(3);
            } else {
                this.referencedSet = null;
                this.sequenceTable = null;
            }
            if (keepAlive) {
                ObjectTable.this.incrementKeepAliveCount();
            }
            object = this.lock;
            synchronized (object) {
                this.exported = true;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setInvocationDispatcher(InvocationDispatcher id) {
            if (!$assertionsDisabled && id == null) {
                throw new AssertionError();
            }
            Object object = this.lock;
            synchronized (object) {
                if (!$assertionsDisabled && this.invocationDispatcher != null) {
                    throw new AssertionError();
                }
                this.invocationDispatcher = id;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean unexport(boolean force) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.exported) {
                    return true;
                }
                if (!force && this.callsInProgress > 0) {
                    return false;
                }
                this.exported = false;
                if (this.keepAlive && this.callsInProgress == 0) {
                    ObjectTable.this.decrementKeepAliveCount();
                }
                if (this.allowDGC) {
                    if (!this.referencedSet.isEmpty()) {
                        Iterator i = this.referencedSet.iterator();
                        while (i.hasNext()) {
                            Uuid clientID = (Uuid)i.next();
                            ObjectTable.this.unregisterTarget(this, clientID);
                        }
                        this.referencedSet.clear();
                    }
                    this.sequenceTable.clear();
                }
            }
            this.implRef.release(this);
            for (int i = 0; i < this.requestDispatchers.length; ++i) {
                this.requestDispatchers[i].remove(this, false);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void collect() {
            Object object = this.lock;
            synchronized (object) {
                if (!this.exported) {
                    return;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "garbage collection of object with id {0}", this.id);
                }
                this.exported = false;
                if (this.keepAlive && this.callsInProgress == 0) {
                    ObjectTable.this.decrementKeepAliveCount();
                }
                if (this.allowDGC) {
                    if (!$assertionsDisabled && !this.referencedSet.isEmpty()) {
                        throw new AssertionError();
                    }
                    this.sequenceTable.clear();
                }
            }
            for (int i = 0; i < this.requestDispatchers.length; ++i) {
                this.requestDispatchers[i].remove(this, true);
            }
        }

        Uuid getObjectIdentifier() {
            return this.id;
        }

        boolean getEnableDGC() {
            return this.allowDGC;
        }

        SecurityContext getSecurityContext() {
            return this.securityContext;
        }

        ClassLoader getContextClassLoader() {
            return this.ccl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void referenced(Uuid clientID, long sequenceNum) {
            if (!this.allowDGC) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                SequenceEntry entry;
                if (!this.exported) {
                    return;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "this={0}, clientID={1}, sequenceNum={2}", new Object[]{this, clientID, new Long(sequenceNum)});
                }
                if ((entry = (SequenceEntry)this.sequenceTable.get(clientID)) == null) {
                    entry = new SequenceEntry(sequenceNum);
                    this.sequenceTable.put(clientID, entry);
                } else {
                    if (sequenceNum < entry.sequenceNum) {
                        return;
                    }
                    entry.sequenceNum = sequenceNum;
                }
                if (!this.referencedSet.contains(clientID)) {
                    if (this.referencedSet.isEmpty()) {
                        Remote impl = this.implRef.getImpl();
                        if (impl == null) {
                            return;
                        }
                        this.implRef.pin(this);
                    }
                    this.referencedSet.add(clientID);
                    ObjectTable.this.registerTarget(this, clientID);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unreferenced(Uuid clientID, long sequenceNum, boolean strong) {
            if (!this.allowDGC) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                SequenceEntry entry;
                if (!this.exported) {
                    return;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "this={0}, clientID={1}, sequenceNum={2}, strong={3}", new Object[]{this, clientID, new Long(sequenceNum), strong});
                }
                if ((entry = (SequenceEntry)this.sequenceTable.get(clientID)) == null) {
                    if (strong) {
                        entry = new SequenceEntry(sequenceNum);
                        this.sequenceTable.put(clientID, entry);
                        entry.keep = true;
                    }
                } else {
                    if (sequenceNum < entry.sequenceNum) {
                        return;
                    }
                    if (strong) {
                        entry.sequenceNum = sequenceNum;
                        entry.keep = true;
                    } else if (!entry.keep) {
                        this.sequenceTable.remove(clientID);
                    }
                }
                ObjectTable.this.unregisterTarget(this, clientID);
                if (this.referencedSet.remove(clientID) && this.referencedSet.isEmpty()) {
                    this.implRef.unpin(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void leaseExpired(Uuid clientID) {
            if (!$assertionsDisabled && !this.allowDGC) {
                throw new AssertionError();
            }
            Object object = this.lock;
            synchronized (object) {
                SequenceEntry entry;
                if (!this.exported) {
                    return;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "this={0}, clientID={1}", new Object[]{this, clientID});
                }
                if ((entry = (SequenceEntry)this.sequenceTable.get(clientID)) != null && !entry.keep) {
                    this.sequenceTable.remove(clientID);
                }
                if (this.referencedSet.remove(clientID) && this.referencedSet.isEmpty()) {
                    this.implRef.unpin(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatch(InboundRequest request) throws IOException, NoSuchObject {
            Object object;
            InvocationDispatcher id;
            Object object2 = this.lock;
            synchronized (object2) {
                if (!this.exported || this.invocationDispatcher == null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "this={0}, not exported", this);
                    }
                    throw new NoSuchObject();
                }
                id = this.invocationDispatcher;
                ++this.callsInProgress;
            }
            try {
                Remote impl = this.implRef.getImpl();
                if (impl == null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "this={0}, garbage collected", this);
                    }
                    throw new NoSuchObject();
                }
                this.dispatch(request, id, impl);
                Object var6_5 = null;
                object = this.lock;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                Object object3 = this.lock;
                synchronized (object3) {
                    if (!$assertionsDisabled && this.callsInProgress <= 0) {
                        throw new AssertionError();
                    }
                    --this.callsInProgress;
                    if (this.keepAlive && !this.exported && this.callsInProgress == 0) {
                        ObjectTable.this.decrementKeepAliveCount();
                    }
                }
                throw throwable;
            }
            synchronized (object) {
                if (!$assertionsDisabled && this.callsInProgress <= 0) {
                    throw new AssertionError();
                }
                --this.callsInProgress;
                if (this.keepAlive && !this.exported && this.callsInProgress == 0) {
                    ObjectTable.this.decrementKeepAliveCount();
                }
            }
        }

        private void dispatch(final InboundRequest request, final InvocationDispatcher id, final Remote impl) throws IOException, NoSuchObject {
            Thread t = Thread.currentThread();
            ClassLoader savedCcl = t.getContextClassLoader();
            try {
                try {
                    if (this.ccl != savedCcl) {
                        t.setContextClassLoader(this.ccl);
                    }
                    AccessController.doPrivileged(this.securityContext.wrap(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            Target.this.dispatch0(request, id, impl);
                            return null;
                        }
                    }), this.securityContext.getAccessControlContext());
                }
                catch (PrivilegedActionException e) {
                    throw (IOException)e.getException();
                }
                Object var8_6 = null;
                if (this.ccl != savedCcl || savedCcl != t.getContextClassLoader()) {
                    t.setContextClassLoader(savedCcl);
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (this.ccl != savedCcl || savedCcl != t.getContextClassLoader()) {
                    t.setContextClassLoader(savedCcl);
                }
                throw throwable;
            }
        }

        private void dispatch0(final InboundRequest request, final InvocationDispatcher id, final Remote impl) throws IOException {
            request.checkPermissions();
            OutputStream out = request.getResponseOutputStream();
            out.write(1);
            final ArrayList context = new ArrayList(5);
            request.populateContext(context);
            ServerContext.doWithServerContext(new Runnable(){

                public void run() {
                    id.dispatch(impl, request, context);
                }
            }, Collections.unmodifiableCollection(context));
        }

        public String toString() {
            return "Target@" + Integer.toHexString(this.hashCode()) + "[" + this.id + "]";
        }

        static {
            $assertionsDisabled = !(class$com$sun$jini$jeri$internal$runtime$ObjectTable == null ? (class$com$sun$jini$jeri$internal$runtime$ObjectTable = ObjectTable.class$("com.sun.jini.jeri.internal.runtime.ObjectTable")) : class$com$sun$jini$jeri$internal$runtime$ObjectTable).desiredAssertionStatus();
        }
    }
}

