/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.logging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;

public class Levels {
    public static final Level FAILED = Levels.createLevel("FAILED", 600, null);
    public static final Level HANDLED = Levels.createLevel("HANDLED", 550, null);

    private Levels() {
        throw new AssertionError((Object)"This class cannot be instantiated");
    }

    private static Level createLevel(String name, int value, String resourceBundleName) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ClassReplacingObjectOutputStream out = new ClassReplacingObjectOutputStream(bytes, LevelData.class, Level.class);
            out.writeObject(new LevelData(name, value, resourceBundleName));
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));
            Level result = (Level)in.readObject();
            in.close();
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    private static final class ClassReplacingObjectOutputStream
    extends ObjectOutputStream {
        private final ObjectStreamClass from;
        private final ObjectStreamClass to;

        ClassReplacingObjectOutputStream(OutputStream out, Class from, Class to) throws IOException {
            super(out);
            this.from = ObjectStreamClass.lookup(from);
            this.to = ObjectStreamClass.lookup(to);
        }

        protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
            if (this.from.equals(desc)) {
                desc = this.to;
            }
            super.writeClassDescriptor(desc);
        }
    }

    private static final class LevelData
    implements Serializable {
        private static final ObjectStreamField[] serialPersistentFields = ObjectStreamClass.lookup(class$java$util$logging$Level == null ? (class$java$util$logging$Level = Levels.class$("java.util.logging.Level")) : class$java$util$logging$Level).getFields();
        private static final long serialVersionUID = -8176160795706313070L;
        private final transient String name;
        private final transient int value;
        private final transient String resourceBundleName;

        LevelData(String name, int value, String resourceBundleName) {
            this.name = name;
            this.value = value;
            this.resourceBundleName = resourceBundleName;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            ObjectOutputStream.PutField putFields = out.putFields();
            for (int i = 0; i < serialPersistentFields.length; ++i) {
                ObjectStreamField field = serialPersistentFields[i];
                if (field.getName().equals("name")) {
                    putFields.put(field.getName(), this.name);
                    continue;
                }
                if (field.getName().equals("resourceBundleName")) {
                    putFields.put(field.getName(), this.resourceBundleName);
                    continue;
                }
                if (!field.getName().equals("value")) continue;
                putFields.put(field.getName(), this.value);
            }
            out.writeFields();
        }
    }
}

