/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.examples;

import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.Weekday;
import org.jquantlib.util.Date;
import org.jquantlib.util.DefaultDate;
import org.jquantlib.util.Month;
import org.jquantlib.util.StopClock;
import org.jquantlib.util.Updatable;

public class Dates {
    public static void main(String[] args) {
        System.out.println("\n\n::::: " + Dates.class.getSimpleName() + " :::::");
        StopClock clock = new StopClock();
        clock.startClock();
        Date dateToday = DefaultDate.JQLibDateUtil.getFactory().getTodaysDate();
        System.out.println("Today's date is = " + dateToday);
        Month month = dateToday.getMonthEnum();
        int integerEquivalentOfMonth = dateToday.getMonth();
        System.out.println("The month of today's date is = " + (Object)((Object)month));
        System.out.println("The integer equivalent of this month as obtained from the date is = " + integerEquivalentOfMonth);
        System.out.println("The integer equivalent of the date as obtained from the Month is also = " + month.toInteger());
        Weekday weekDayOfThisDate = dateToday.getWeekday();
        System.out.println("The weekday of this date is = " + (Object)((Object)weekDayOfThisDate));
        System.out.println("The day of the date as a day in this date's month(1-31) is = " + dateToday.getDayOfMonth());
        System.out.println("The day of the date as day in it's year(1-366) is = " + dateToday.getDayOfYear());
        if (dateToday.isLeap()) {
            System.out.println("Today's date belong to leap year");
        }
        Date nextWeekdayDate = dateToday.getNextWeekday(Weekday.TUESDAY);
        System.out.println("The date of the next weekday is = " + nextWeekdayDate);
        Date fourthWeekdayDate = dateToday.getNthWeekday(4, Weekday.TUESDAY);
        System.out.println("The fourthWeekdayDate which is TUESDAY is = " + fourthWeekdayDate);
        Date dateEndOfMonth = dateToday.getEndOfMonth();
        int dayOfEndOfMonth = dateEndOfMonth.getDayOfMonth();
        Date dateStartOfMonth = dateEndOfMonth.getDateAfter(-dayOfEndOfMonth + 1);
        System.out.println("The first date of the month to which todays date belong to is = " + dateStartOfMonth);
        Period period = new Period(-dateToday.getDayOfMonth() + 1, TimeUnit.DAYS);
        Date dateStartOfMonthUsingPeriod = dateToday.getDateAfter(period);
        System.out.println("The first date of the month to which today's date belong to using period is = " + dateStartOfMonthUsingPeriod);
        dateStartOfMonthUsingPeriod = dateToday.adjust(period);
        System.out.println("The first date of the month to which today's date belong to using adjustment of period is = " + dateStartOfMonthUsingPeriod);
        if (dateStartOfMonthUsingPeriod.le(dateEndOfMonth)) {
            System.out.println("Start date is less than end date?");
        }
        if (dateEndOfMonth.ge(dateStartOfMonthUsingPeriod)) {
            System.out.println("End date is greater than start date");
        }
        Date date = dateToday;
        while (!date.eq(dateEndOfMonth)) {
            date.increment();
        }
        System.out.println("The date variable has been incrmented to endOfMonth and is = " + date);
        date = dateToday;
        while (!date.eq(dateStartOfMonth)) {
            date.decrement();
        }
        System.out.println("The date variable has been decremented to startOfMonth and is = " + date);
        dateToday = DefaultDate.JQLibDateUtil.getFactory().getTodaysDate();
        Updatable<Date> updatableDate = dateToday.getUpdatable();
        updatableDate.update(dateToday.getDateAfter(1));
        System.out.println("Today's date dateToday has been updated to = " + dateToday);
        updatableDate.update(dateToday.getDateAfter(-1));
        System.out.println("Today's date dateToday has been updated to = " + dateToday);
        clock.stopClock();
        clock.log();
    }
}

