/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.providedservice;

import java.lang.reflect.Field;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.PrimitiveHandler;
import org.apache.felix.ipojo.architecture.ComponentTypeDescription;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.architecture.PropertyDescription;
import org.apache.felix.ipojo.handlers.dependency.Dependency;
import org.apache.felix.ipojo.handlers.dependency.DependencyHandler;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedService;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceDescription;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceHandlerDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.FieldMetadata;
import org.apache.felix.ipojo.parser.ManifestMetadataParser;
import org.apache.felix.ipojo.parser.ParseException;
import org.apache.felix.ipojo.parser.ParseUtils;
import org.apache.felix.ipojo.parser.PojoMetadata;
import org.apache.felix.ipojo.util.Property;
import org.osgi.framework.Bundle;

public class ProvidedServiceHandler
extends PrimitiveHandler
implements Pojo {
    private InstanceManager __IM;
    private boolean __Fm_providedServices;
    private ProvidedService[] m_providedServices;
    private boolean __MaddProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService;
    private boolean __MgetProvidedService;
    private boolean __Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary;
    private boolean __McomputeInterfaces$java_lang_String__$java_lang_String$org_osgi_framework_Bundle;
    private boolean __McollectInterfaces$java_lang_Class$java_util_Set$org_osgi_framework_Bundle;
    private boolean __McollectInterfacesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle;
    private boolean __McheckProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService;
    private boolean __MgetAttachedDependency$org_apache_felix_ipojo_metadata_Element;
    private boolean __MisDependencyCorrect$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_metadata_Element;
    private boolean __Mstop;
    private boolean __Mstart;
    private boolean __MonSet$java_lang_Object$java_lang_String$java_lang_Object;
    private boolean __MonGet$java_lang_Object$java_lang_String$java_lang_Object;
    private boolean __MstateChanged$int;
    private boolean __MaddProperties$java_util_Dictionary;
    private boolean __MremoveProperties$java_util_Dictionary;
    private boolean __MgetDescription;
    private boolean __Mreconfigure$java_util_Dictionary;
    private boolean __MinitializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element;

    ProvidedService[] __getm_providedServices() {
        if (!this.__Fm_providedServices) {
            return this.m_providedServices;
        }
        return (ProvidedService[])this.__IM.onGet(this, "m_providedServices");
    }

    void __setm_providedServices(ProvidedService[] providedServiceArray) {
        if (!this.__Fm_providedServices) {
            this.m_providedServices = providedServiceArray;
            return;
        }
        this.__IM.onSet(this, "m_providedServices", providedServiceArray);
    }

    public ProvidedServiceHandler() {
        this(null);
    }

    private ProvidedServiceHandler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setm_providedServices(new ProvidedService[0]);
    }

    private void addProvidedService(ProvidedService providedService) {
        if (!this.__MaddProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService) {
            this.__addProvidedService(providedService);
            return;
        }
        try {
            this.__IM.onEntry(this, "addProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService", new Object[]{providedService});
            this.__addProvidedService(providedService);
            this.__IM.onExit(this, "addProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "addProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService", throwable);
            throw throwable;
        }
    }

    private void __addProvidedService(ProvidedService svc) {
        for (int i = 0; this.__getm_providedServices() != null && i < this.__getm_providedServices().length; ++i) {
            if (this.__getm_providedServices()[i] != svc) continue;
            return;
        }
        if (this.__getm_providedServices() != null && this.__getm_providedServices().length > 0) {
            ProvidedService[] newPS = new ProvidedService[this.__getm_providedServices().length + 1];
            System.arraycopy(this.__getm_providedServices(), 0, newPS, 0, this.__getm_providedServices().length);
            newPS[this.__getm_providedServices().length] = svc;
            this.__setm_providedServices(newPS);
        } else {
            this.__setm_providedServices(new ProvidedService[]{svc});
        }
    }

    public ProvidedService[] getProvidedService() {
        ProvidedService[] providedServiceArray;
        if (!this.__MgetProvidedService) {
            return this.__getProvidedService();
        }
        try {
            this.__IM.onEntry(this, "getProvidedService", new Object[0]);
            providedServiceArray = this.__getProvidedService();
            this.__IM.onExit(this, "getProvidedService", providedServiceArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "getProvidedService", throwable);
            throw throwable;
        }
        return providedServiceArray;
    }

    private ProvidedService[] __getProvidedService() {
        return this.__getm_providedServices();
    }

    public void configure(Element element, Dictionary dictionary) throws ConfigurationException {
        if (!this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary) {
            this.__configure(element, dictionary);
            return;
        }
        try {
            this.__IM.onEntry(this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", new Object[]{element, dictionary});
            this.__configure(element, dictionary);
            this.__IM.onExit(this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __configure(Element componentMetadata, Dictionary configuration) throws ConfigurationException {
        this.__setm_providedServices(new ProvidedService[0]);
        Element[] providedServices = componentMetadata.getElements("Provides");
        for (int i = 0; i < providedServices.length; ++i) {
            int j;
            String[] serviceSpecifications = ParseUtils.parseArrays(providedServices[i].getAttribute("interface"));
            int factory = 0;
            String fact = providedServices[i].getAttribute("factory");
            if (fact != null && "service".equalsIgnoreCase(fact)) {
                factory = 1;
            }
            if (fact != null && "method".equalsIgnoreCase(fact)) {
                factory = 2;
            }
            ProvidedService svc = new ProvidedService(this, serviceSpecifications, factory);
            Element[] props = providedServices[i].getElements("Property");
            if (props != null) {
                Property[] properties = new Property[props.length];
                for (j = 0; j < props.length; ++j) {
                    Property prop;
                    String name = props[j].getAttribute("name");
                    String value = props[j].getAttribute("value");
                    String type = props[j].getAttribute("type");
                    String field = props[j].getAttribute("field");
                    properties[j] = prop = new Property(name, field, null, value, type, this.getInstanceManager(), this);
                    Object object = configuration.get(prop.getName());
                    if (object != null) {
                        prop.setValue(object);
                    }
                    if (field == null) continue;
                    this.getInstanceManager().register(new FieldMetadata(field, type), this);
                }
                svc.setProperties(properties);
            }
            if (!this.checkProvidedService(svc)) {
                StringBuffer itfs = new StringBuffer();
                for (j = 0; j < serviceSpecifications.length; ++j) {
                    itfs.append(' ');
                    itfs.append(serviceSpecifications[j]);
                }
                throw new ConfigurationException("The provided service" + itfs + " is not valid");
            }
            this.addProvidedService(svc);
        }
    }

    private Set computeInterfaces(String[] stringArray, String string, Bundle bundle) throws ClassNotFoundException {
        Set set;
        if (!this.__McomputeInterfaces$java_lang_String__$java_lang_String$org_osgi_framework_Bundle) {
            return this.__computeInterfaces(stringArray, string, bundle);
        }
        try {
            this.__IM.onEntry(this, "computeInterfaces$java_lang_String__$java_lang_String$org_osgi_framework_Bundle", new Object[]{stringArray, string, bundle});
            set = this.__computeInterfaces(stringArray, string, bundle);
            this.__IM.onExit(this, "computeInterfaces$java_lang_String__$java_lang_String$org_osgi_framework_Bundle", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "computeInterfaces$java_lang_String__$java_lang_String$org_osgi_framework_Bundle", throwable);
            throw throwable;
        }
        return set;
    }

    private Set __computeInterfaces(String[] specs, String parent, Bundle bundle) throws ClassNotFoundException {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < specs.length; ++i) {
            result.add(specs[i]);
            Class clazz = bundle.loadClass(specs[i]);
            this.collectInterfaces(clazz, result, bundle);
        }
        if (parent != null) {
            Class clazz = bundle.loadClass(parent);
            this.collectInterfacesFromClass(clazz, result, bundle);
        }
        return result;
    }

    private void collectInterfaces(Class clazz, Set set, Bundle bundle) throws ClassNotFoundException {
        if (!this.__McollectInterfaces$java_lang_Class$java_util_Set$org_osgi_framework_Bundle) {
            this.__collectInterfaces(clazz, set, bundle);
            return;
        }
        try {
            this.__IM.onEntry(this, "collectInterfaces$java_lang_Class$java_util_Set$org_osgi_framework_Bundle", new Object[]{clazz, set, bundle});
            this.__collectInterfaces(clazz, set, bundle);
            this.__IM.onExit(this, "collectInterfaces$java_lang_Class$java_util_Set$org_osgi_framework_Bundle", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "collectInterfaces$java_lang_Class$java_util_Set$org_osgi_framework_Bundle", throwable);
            throw throwable;
        }
    }

    private void __collectInterfaces(Class clazz, Set acc, Bundle bundle) throws ClassNotFoundException {
        Class<?>[] clazzes = clazz.getInterfaces();
        for (int i = 0; i < clazzes.length; ++i) {
            acc.add(clazzes[i].getName());
            this.collectInterfaces(clazzes[i], acc, bundle);
        }
    }

    private void collectInterfacesFromClass(Class clazz, Set set, Bundle bundle) throws ClassNotFoundException {
        if (!this.__McollectInterfacesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle) {
            this.__collectInterfacesFromClass(clazz, set, bundle);
            return;
        }
        try {
            this.__IM.onEntry(this, "collectInterfacesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle", new Object[]{clazz, set, bundle});
            this.__collectInterfacesFromClass(clazz, set, bundle);
            this.__IM.onExit(this, "collectInterfacesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "collectInterfacesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle", throwable);
            throw throwable;
        }
    }

    private void __collectInterfacesFromClass(Class clazz, Set acc, Bundle bundle) throws ClassNotFoundException {
        Class<?>[] clazzes = clazz.getInterfaces();
        for (int i = 0; i < clazzes.length; ++i) {
            acc.add(clazzes[i].getName());
            this.collectInterfaces(clazzes[i], acc, bundle);
        }
        Class sup = clazz.getSuperclass();
        if (sup != null) {
            this.collectInterfacesFromClass(sup, acc, bundle);
        }
    }

    private boolean checkProvidedService(ProvidedService providedService) throws ConfigurationException {
        boolean bl;
        if (!this.__McheckProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService) {
            return this.__checkProvidedService(providedService);
        }
        try {
            this.__IM.onEntry(this, "checkProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService", new Object[]{providedService});
            bl = this.__checkProvidedService(providedService);
            this.__IM.onExit(this, "checkProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService", new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "checkProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __checkProvidedService(ProvidedService svc) throws ConfigurationException {
        for (int i = 0; i < svc.getServiceSpecification().length; ++i) {
            String specName = svc.getServiceSpecification()[i];
            try {
                Class spec = this.getInstanceManager().getFactory().loadClass(specName);
                Field specField = spec.getField("specification");
                Object specif = specField.get(null);
                if (specif instanceof String) {
                    Element specification = ManifestMetadataParser.parse((String)specif);
                    Element[] deps = specification.getElements("requires");
                    for (int j = 0; deps != null && j < deps.length; ++j) {
                        Dependency dep = this.getAttachedDependency(deps[j]);
                        if (dep != null) {
                            dep.setServiceLevelDependency();
                        }
                        this.isDependencyCorrect(dep, deps[j]);
                    }
                    continue;
                }
                throw new ConfigurationException("Service Providing: The specification field of the service specification " + svc.getServiceSpecification()[i] + " needs to be a String");
            }
            catch (NoSuchFieldException e) {
                return true;
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Service Providing: The service specification " + svc.getServiceSpecification()[i] + " cannot be load");
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Service Providing: The field 'specification' of the service specification " + svc.getServiceSpecification()[i] + " is not accessible : " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Service Providing: The field 'specification' of the service specification " + svc.getServiceSpecification()[i] + " is not accessible : " + e.getMessage());
            }
            catch (ParseException e) {
                throw new ConfigurationException("Service Providing: The field 'specification' of the service specification " + svc.getServiceSpecification()[i] + " does not contain a valid String : " + e.getMessage());
            }
        }
        return true;
    }

    private Dependency getAttachedDependency(Element element) {
        Dependency dependency;
        if (!this.__MgetAttachedDependency$org_apache_felix_ipojo_metadata_Element) {
            return this.__getAttachedDependency(element);
        }
        try {
            this.__IM.onEntry(this, "getAttachedDependency$org_apache_felix_ipojo_metadata_Element", new Object[]{element});
            dependency = this.__getAttachedDependency(element);
            this.__IM.onExit(this, "getAttachedDependency$org_apache_felix_ipojo_metadata_Element", dependency);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "getAttachedDependency$org_apache_felix_ipojo_metadata_Element", throwable);
            throw throwable;
        }
        return dependency;
    }

    private Dependency __getAttachedDependency(Element element) {
        DependencyHandler handler = (DependencyHandler)this.getHandler("org.apache.felix.ipojo:requires");
        if (handler == null) {
            return null;
        }
        String identity = element.getAttribute("id");
        if (identity != null) {
            for (int i = 0; i < handler.getDependencies().length; ++i) {
                if (!handler.getDependencies()[i].getId().equals(identity)) continue;
                return handler.getDependencies()[i];
            }
        }
        String requirement = element.getAttribute("specification");
        for (int i = 0; i < handler.getDependencies().length; ++i) {
            if (!handler.getDependencies()[i].getSpecification().equals(requirement)) continue;
            return handler.getDependencies()[i];
        }
        return null;
    }

    private void isDependencyCorrect(Dependency dependency, Element element) throws ConfigurationException {
        if (!this.__MisDependencyCorrect$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_metadata_Element) {
            this.__isDependencyCorrect(dependency, element);
            return;
        }
        try {
            this.__IM.onEntry(this, "isDependencyCorrect$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_metadata_Element", new Object[]{dependency, element});
            this.__isDependencyCorrect(dependency, element);
            this.__IM.onExit(this, "isDependencyCorrect$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_metadata_Element", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "isDependencyCorrect$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_metadata_Element", throwable);
            throw throwable;
        }
    }

    private void __isDependencyCorrect(Dependency dep, Element elem) throws ConfigurationException {
        String filter2;
        boolean agg;
        String optional = elem.getAttribute("optional");
        boolean opt = optional != null && optional.equalsIgnoreCase("true");
        String aggregate = elem.getAttribute("aggregate");
        boolean bl = agg = aggregate != null && aggregate.equalsIgnoreCase("true");
        if (dep == null && !opt) {
            throw new ConfigurationException("Service Providing: The requirement " + elem.getAttribute("specification") + " is not present in the implementation and is declared as a mandatory service-level requirement");
        }
        if (dep != null && dep.isAggregate() && !agg) {
            throw new ConfigurationException("Service Providing: The requirement " + elem.getAttribute("specification") + " is aggregate in the implementation and is declared as a simple service-level requirement");
        }
        String filter = elem.getAttribute("filter");
        if (!(dep == null || filter == null || (filter2 = dep.getFilter()) != null && filter2.equalsIgnoreCase(filter))) {
            throw new ConfigurationException("Service Providing: The specification requirement " + elem.getAttribute("specification") + " has not the same filter as declared in the service-level requirement");
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry(this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit(this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "stop", throwable);
            throw throwable;
        }
    }

    private void __stop() {
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry(this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit(this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "start", throwable);
            throw throwable;
        }
    }

    private void __start() {
    }

    public void onSet(Object object, String string, Object object2) {
        if (!this.__MonSet$java_lang_Object$java_lang_String$java_lang_Object) {
            this.__onSet(object, string, object2);
            return;
        }
        try {
            this.__IM.onEntry(this, "onSet$java_lang_Object$java_lang_String$java_lang_Object", new Object[]{object, string, object2});
            this.__onSet(object, string, object2);
            this.__IM.onExit(this, "onSet$java_lang_Object$java_lang_String$java_lang_Object", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "onSet$java_lang_Object$java_lang_String$java_lang_Object", throwable);
            throw throwable;
        }
    }

    private void __onSet(Object pojo, String fieldName, Object value) {
        for (int i = 0; i < this.__getm_providedServices().length; ++i) {
            ProvidedService svc = this.__getm_providedServices()[i];
            boolean update = false;
            for (int j = 0; j < svc.getProperties().length; ++j) {
                Property prop = svc.getProperties()[j];
                if (!fieldName.equals(prop.getField()) || prop.getValue().equals(value)) continue;
                prop.setValue(value);
                update = true;
            }
            if (!update) continue;
            svc.update();
        }
    }

    public Object onGet(Object object, String string, Object object2) {
        Object object3;
        if (!this.__MonGet$java_lang_Object$java_lang_String$java_lang_Object) {
            return this.__onGet(object, string, object2);
        }
        try {
            this.__IM.onEntry(this, "onGet$java_lang_Object$java_lang_String$java_lang_Object", new Object[]{object, string, object2});
            object3 = this.__onGet(object, string, object2);
            this.__IM.onExit(this, "onGet$java_lang_Object$java_lang_String$java_lang_Object", object3);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "onGet$java_lang_Object$java_lang_String$java_lang_Object", throwable);
            throw throwable;
        }
        return object3;
    }

    private Object __onGet(Object pojo, String fieldName, Object value) {
        for (int i = 0; i < this.__getm_providedServices().length; ++i) {
            ProvidedService svc = this.__getm_providedServices()[i];
            for (int j = 0; j < svc.getProperties().length; ++j) {
                Property prop = svc.getProperties()[j];
                if (!fieldName.equals(prop.getField())) continue;
                return prop.getValue();
            }
        }
        return value;
    }

    public void stateChanged(int n) {
        if (!this.__MstateChanged$int) {
            this.__stateChanged(n);
            return;
        }
        try {
            this.__IM.onEntry(this, "stateChanged$int", new Object[]{new Integer(n)});
            this.__stateChanged(n);
            this.__IM.onExit(this, "stateChanged$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "stateChanged$int", throwable);
            throw throwable;
        }
    }

    private void __stateChanged(int state) {
        if (state == 1) {
            for (int i = 0; i < this.__getm_providedServices().length; ++i) {
                this.__getm_providedServices()[i].unregisterService();
            }
            return;
        }
        if (state == 2) {
            for (int i = 0; i < this.__getm_providedServices().length; ++i) {
                this.__getm_providedServices()[i].registerService();
            }
            return;
        }
    }

    public void addProperties(Dictionary dictionary) {
        if (!this.__MaddProperties$java_util_Dictionary) {
            this.__addProperties(dictionary);
            return;
        }
        try {
            this.__IM.onEntry(this, "addProperties$java_util_Dictionary", new Object[]{dictionary});
            this.__addProperties(dictionary);
            this.__IM.onExit(this, "addProperties$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "addProperties$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __addProperties(Dictionary dict) {
        for (int i = 0; i < this.__getm_providedServices().length; ++i) {
            this.__getm_providedServices()[i].addProperties(dict);
            this.__getm_providedServices()[i].update();
        }
    }

    public void removeProperties(Dictionary dictionary) {
        if (!this.__MremoveProperties$java_util_Dictionary) {
            this.__removeProperties(dictionary);
            return;
        }
        try {
            this.__IM.onEntry(this, "removeProperties$java_util_Dictionary", new Object[]{dictionary});
            this.__removeProperties(dictionary);
            this.__IM.onExit(this, "removeProperties$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "removeProperties$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __removeProperties(Dictionary dict) {
        for (int i = 0; i < this.__getm_providedServices().length; ++i) {
            this.__getm_providedServices()[i].deleteProperties(dict);
            this.__getm_providedServices()[i].update();
        }
    }

    public HandlerDescription getDescription() {
        HandlerDescription handlerDescription;
        if (!this.__MgetDescription) {
            return this.__getDescription();
        }
        try {
            this.__IM.onEntry(this, "getDescription", new Object[0]);
            handlerDescription = this.__getDescription();
            this.__IM.onExit(this, "getDescription", handlerDescription);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "getDescription", throwable);
            throw throwable;
        }
        return handlerDescription;
    }

    private HandlerDescription __getDescription() {
        ProvidedServiceHandlerDescription pshd = new ProvidedServiceHandlerDescription(this);
        for (int j = 0; j < this.getProvidedService().length; ++j) {
            ProvidedService svc = this.getProvidedService()[j];
            ProvidedServiceDescription psd = new ProvidedServiceDescription(svc.getServiceSpecification(), svc.getState(), svc.getServiceReference());
            Properties props = new Properties();
            for (int k = 0; k < svc.getProperties().length; ++k) {
                Property prop = svc.getProperties()[k];
                if (prop.getValue() == null) continue;
                props.put(prop.getName(), prop.getValue().toString());
            }
            psd.setProperty(props);
            pshd.addProvidedService(psd);
        }
        return pshd;
    }

    public void reconfigure(Dictionary dictionary) {
        if (!this.__Mreconfigure$java_util_Dictionary) {
            this.__reconfigure(dictionary);
            return;
        }
        try {
            this.__IM.onEntry(this, "reconfigure$java_util_Dictionary", new Object[]{dictionary});
            this.__reconfigure(dictionary);
            this.__IM.onExit(this, "reconfigure$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "reconfigure$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __reconfigure(Dictionary dict) {
        for (int j = 0; j < this.getProvidedService().length; ++j) {
            ProvidedService svc = this.getProvidedService()[j];
            Property[] props = svc.getProperties();
            boolean update = false;
            for (int k = 0; k < props.length; ++k) {
                if (dict.get(props[k].getName()) == null) continue;
                update = true;
                props[k].setValue(dict.get(props[k].getName()));
            }
            if (!update) continue;
            svc.update();
        }
    }

    public void initializeComponentFactory(ComponentTypeDescription componentTypeDescription, Element element) throws ConfigurationException {
        if (!this.__MinitializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element) {
            this.__initializeComponentFactory(componentTypeDescription, element);
            return;
        }
        try {
            this.__IM.onEntry(this, "initializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element", new Object[]{componentTypeDescription, element});
            this.__initializeComponentFactory(componentTypeDescription, element);
            this.__IM.onExit(this, "initializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "initializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element", throwable);
            throw throwable;
        }
    }

    private void __initializeComponentFactory(ComponentTypeDescription desc, Element metadata) throws ConfigurationException {
        Element[] provides = metadata.getElements("provides");
        PojoMetadata manipulation = this.getFactory().getPojoMetadata();
        for (int i = 0; i < provides.length; ++i) {
            String[] serviceSpecification = manipulation.getInterfaces();
            String parent = manipulation.getSuperClass();
            HashSet all = null;
            try {
                all = this.computeInterfaces(serviceSpecification, parent, desc.getBundleContext().getBundle());
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("An interface cannot be loaded : " + e.getMessage());
            }
            String serviceSpecificationStr = provides[i].getAttribute("interface");
            if (serviceSpecificationStr != null) {
                List itfs = ParseUtils.parseArraysAsList(serviceSpecificationStr);
                for (int j = 0; j < itfs.size(); ++j) {
                    if (all.contains(itfs.get(j))) continue;
                    throw new ConfigurationException("The specification " + itfs.get(j) + " is not implemented by " + desc.getClassName());
                }
                all = new HashSet(itfs);
            }
            if (all.isEmpty()) {
                throw new ConfigurationException("Service Providing: Cannot instantiate a provided service : no specifications found (no interfaces implemented by the pojo)");
            }
            StringBuffer specs = null;
            HashSet set = new HashSet(all);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String spec = (String)iterator.next();
                desc.addProvidedServiceSpecification(spec);
                if (specs == null) {
                    specs = new StringBuffer("{");
                    specs.append(spec);
                    continue;
                }
                specs.append(',');
                specs.append(spec);
            }
            specs.append('}');
            provides[i].addAttribute(new Attribute("interface", specs.toString()));
            Element[] props = provides[i].getElements("property");
            for (int j = 0; props != null && j < props.length; ++j) {
                String name = props[j].getAttribute("name");
                String value = props[j].getAttribute("value");
                String type = props[j].getAttribute("type");
                String field = props[j].getAttribute("field");
                if (field != null && name == null) {
                    name = field;
                }
                if (type == null) {
                    if (field == null) {
                        throw new ConfigurationException("The property " + name + " has neither type nor field.");
                    }
                    FieldMetadata fieldMeta = manipulation.getField(field);
                    if (fieldMeta == null) {
                        throw new ConfigurationException("A declared property was not found in the implementation class : " + field);
                    }
                    type = fieldMeta.getFieldType();
                    props[j].addAttribute(new Attribute("type", type));
                }
                boolean immutable = false;
                String imm = props[j].getAttribute("immutable");
                if (imm != null && imm.equalsIgnoreCase("true")) {
                    immutable = true;
                }
                desc.addProperty(new PropertyDescription(name, type, value, immutable));
            }
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("m_providedServices")) {
            this.__Fm_providedServices = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("addProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService")) {
                this.__MaddProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService = true;
            }
            if (set.contains("getProvidedService")) {
                this.__MgetProvidedService = true;
            }
            if (set.contains("configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary")) {
                this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary = true;
            }
            if (set.contains("computeInterfaces$java_lang_String__$java_lang_String$org_osgi_framework_Bundle")) {
                this.__McomputeInterfaces$java_lang_String__$java_lang_String$org_osgi_framework_Bundle = true;
            }
            if (set.contains("collectInterfaces$java_lang_Class$java_util_Set$org_osgi_framework_Bundle")) {
                this.__McollectInterfaces$java_lang_Class$java_util_Set$org_osgi_framework_Bundle = true;
            }
            if (set.contains("collectInterfacesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle")) {
                this.__McollectInterfacesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle = true;
            }
            if (set.contains("checkProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService")) {
                this.__McheckProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService = true;
            }
            if (set.contains("getAttachedDependency$org_apache_felix_ipojo_metadata_Element")) {
                this.__MgetAttachedDependency$org_apache_felix_ipojo_metadata_Element = true;
            }
            if (set.contains("isDependencyCorrect$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_metadata_Element")) {
                this.__MisDependencyCorrect$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_metadata_Element = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("onSet$java_lang_Object$java_lang_String$java_lang_Object")) {
                this.__MonSet$java_lang_Object$java_lang_String$java_lang_Object = true;
            }
            if (set.contains("onGet$java_lang_Object$java_lang_String$java_lang_Object")) {
                this.__MonGet$java_lang_Object$java_lang_String$java_lang_Object = true;
            }
            if (set.contains("stateChanged$int")) {
                this.__MstateChanged$int = true;
            }
            if (set.contains("addProperties$java_util_Dictionary")) {
                this.__MaddProperties$java_util_Dictionary = true;
            }
            if (set.contains("removeProperties$java_util_Dictionary")) {
                this.__MremoveProperties$java_util_Dictionary = true;
            }
            if (set.contains("getDescription")) {
                this.__MgetDescription = true;
            }
            if (set.contains("reconfigure$java_util_Dictionary")) {
                this.__Mreconfigure$java_util_Dictionary = true;
            }
            if (set.contains("initializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element")) {
                this.__MinitializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

