/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IMatchQuery;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;

public class CompoundQueryable
implements IQueryable {
    private IQueryable[] queryables;

    public CompoundQueryable(IQueryable[] queryables) {
        this.queryables = queryables;
    }

    public Collector query(Query query, Collector collector, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        boolean isMatchQuery = query instanceof IMatchQuery;
        Collector results = collector;
        int totalWork = isMatchQuery ? this.queryables.length : this.queryables.length + 1;
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(totalWork * 10));
            if (!isMatchQuery) {
                results = new ListCollector();
            }
            int i = 0;
            while (i < this.queryables.length) {
                if (subMonitor.isCanceled()) break;
                results = this.queryables[i].query(query, results, (IProgressMonitor)subMonitor.newChild(10));
                ++i;
            }
            collector = !isMatchQuery ? results.query(query, collector, (IProgressMonitor)subMonitor.newChild(10)) : results;
        }
        finally {
            monitor.done();
        }
        return collector;
    }

    private class ListCollector
    extends Collector {
        private List collected;

        public boolean accept(Object object) {
            if (this.collected == null) {
                this.collected = new ArrayList();
            }
            this.collected.add(object);
            return true;
        }

        public Collection toCollection() {
            return this.collected == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.collected);
        }

        public Iterator iterator() {
            return this.collected == null ? Collections.EMPTY_LIST.iterator() : this.collected.iterator();
        }

        public int size() {
            return this.collected == null ? 0 : this.collected.size();
        }
    }
}

